/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMIUtilImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.ServiceType;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceAttributeInterface;
import com.sas.services.ServiceConfiguration;
import com.sas.services.ServiceConfigurationInterface;
import com.sas.services.ServiceException;
import com.sas.services.ServiceInitializationObject;
import com.sas.services.deployment.DeployableServiceFactory;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceConfiguration;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceConfigFactoryInterface;
import com.sas.services.discovery.IsRemotelyAccessibleAttribute;
import com.sas.services.discovery.NameValueAttribute;
import com.sas.services.discovery.ServiceComponentAttribute;
import com.sas.services.discovery.ServiceDeploymentAttribute;
import com.sas.services.discovery.ServiceDiscoveryConfiguration;
import com.sas.services.discovery.ServiceDiscoveryConfigurationInterface;
import com.sas.services.discovery.ServiceGroupAttribute;
import com.sas.services.util.GetPropertyAction;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractServiceConfigFactory
implements ServiceConfigFactoryInterface {
    public static final String PROPERTYNAME_INITDATA = "INIT_DATA";
    public static final String PROPERTYROLE_INITIALIZATION = "initialization";
    private static final int NUM_ATTRIBUTES = 10;
    private MdObjectStore _mdObjectStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractServiceConfigFactory(IOMI omi) throws ServiceException {
        block9: {
            Throwable exception = null;
            MdFactoryImpl mdFactory = null;
            try {
                mdFactory = new MdFactoryImpl();
                if (omi != null) {
                    mdFactory.getConnection().setCMRHandle(omi);
                }
                this._mdObjectStore = mdFactory.createObjectStore(null, this.getClass().getName());
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block9;
                if (mdFactory != null) {
                    AbstractServiceConfigFactory.destroyMdFactory((MdFactory)mdFactory);
                }
                throw new ServiceException(exception, RB.getStringResource("AbstractMetadataSource.getObjectStore.ex.txt"));
            }
        }
    }

    @Override
    public abstract ServiceConfigurationInterface createConfigForService(String var1, String var2, String var3, MetadataSourceInterface var4, boolean var5) throws ServiceException;

    protected final MdObjectStore getMdObjectStore() throws IllegalStateException {
        if (this._mdObjectStore == null) {
            throw new IllegalStateException(RB.getStringResource("IllegalState.destroyed.ex.txt"));
        }
        return this._mdObjectStore;
    }

    protected final MdFactory getMdFactory() throws ServiceException {
        MdFactory mdFactory = null;
        try {
            mdFactory = this.getMdObjectStore().getFactory();
        }
        catch (RemoteException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractServiceConfigFactory.getMdFactory.ex.txt"));
        }
        return mdFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceConfigurationInterface createServiceConfig(String metadataXML, String softwareComponentName, String treeName, String serviceComponentName, MetadataSourceInterface metadataSource, boolean isRMIExportEnabled) throws ServiceException {
        ServiceConfigurationInterface serviceConfig;
        block12: {
            serviceConfig = null;
            Throwable exception = null;
            try {
                MdObjectStore mdObjectStore = this.getMdObjectStore();
                MdOMIUtil mdOMIUtil = this.getMdFactory().getOMIUtil();
                ((MdOMIUtilImpl)mdOMIUtil).populateStoreFromString((MdStore)mdObjectStore, metadataXML, 1, false);
                for (CMetadata cMetadata : mdObjectStore.getDetailObjectMap().values()) {
                    ServiceComponent serviceComponent;
                    if (!(cMetadata instanceof ServiceComponent) || !serviceComponentName.equals((serviceComponent = (ServiceComponent)cMetadata).getName())) continue;
                    for (Tree tree : serviceComponent.getTrees()) {
                        if (!treeName.equals(tree.getName())) continue;
                        for (SoftwareComponent softwareComponent : tree.getSoftwareComponents()) {
                            if (!softwareComponentName.equals(softwareComponent.getName())) continue;
                            serviceConfig = AbstractServiceConfigFactory.createServiceConfiguration(serviceComponent, softwareComponent, isRMIExportEnabled);
                            AbstractServiceConfigFactory.addMetadataSourceConfiguration(serviceConfig, metadataSource);
                            break block12;
                        }
                        break block12;
                    }
                    break;
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            catch (ClassCastException e) {
                exception = e;
                return exception;
            }
            finally {
                if (serviceConfig != null) break block12;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"ServiceConfigurationFactory.queryConfig.ex.fmt.txt", (Object)serviceComponentName, (Object)treeName, (Object)softwareComponentName));
            }
        }
        return serviceConfig;
    }

    private static void addMetadataSourceConfiguration(ServiceConfigurationInterface serviceConfig, MetadataSourceInterface metadataSource) throws ServiceException {
        serviceConfig.addServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_METADATA_SOURCE, new MetadataSourceConfiguration(metadataSource));
    }

    public void destroy() {
        if (this._mdObjectStore != null) {
            try {
                AbstractServiceConfigFactory.destroyMdFactory(this.getMdFactory());
            }
            catch (ServiceException e) {
                LogManager.getLogger(this.getClass()).error(RB.getStringResource("AbstractServiceConfigFactory.destroy.ext.txt"), (Throwable)((Object)e));
            }
            finally {
                this._mdObjectStore = null;
            }
        }
    }

    private static void destroyMdFactory(MdFactory mdFactory) {
        if (mdFactory != null) {
            try {
                MdOMRConnection connection = mdFactory.getConnection();
                if (connection != null) {
                    connection.setCMRHandle(null);
                }
                mdFactory.dispose();
            }
            catch (RemoteException e) {
                LogManager.getLogger(AbstractServiceConfigFactory.class).error(RB.getStringResource("ServiceConfigurationFactory.disposeFactory.ex.log"), (Throwable)e);
            }
        }
    }

    static ServiceConfigurationInterface createServiceConfiguration(ServiceComponent serviceComponent, SoftwareComponent softwareComponent, boolean isRMIExportEnabled) throws ServiceException {
        ServiceConfigurationInterface serviceConfig = AbstractServiceConfigFactory.createServiceConfiguration(serviceComponent, isRMIExportEnabled);
        AbstractServiceConfigFactory.initializeConfiguration(serviceConfig, serviceComponent, softwareComponent);
        return serviceConfig;
    }

    static ServiceConfigurationInterface createServiceConfiguration(ServiceComponent serviceComponent, boolean isRMIExportEnabled) throws ServiceException {
        return AbstractServiceConfigFactory.createServiceConfigurationForEnvironment(serviceComponent, null, isRMIExportEnabled);
    }

    static ServiceConfigurationInterface createServiceConfigurationForEnvironment(ServiceComponent serviceComponent, Environment environment, boolean isRMIExportEnabled) throws ServiceException {
        if (serviceComponent == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyServiceComponent.ex.txt"));
        }
        ServiceConfiguration serviceConfiguration = new ServiceConfiguration(new ServiceInitializationObject());
        Environment env = environment != null ? environment : new Environment();
        serviceConfiguration.setEnvironment(env);
        Logger logger = LogManager.getLogger(AbstractServiceConfigFactory.class);
        try {
            ServiceDiscoveryConfiguration serviceDiscoveryConfiguration = new ServiceDiscoveryConfiguration();
            serviceDiscoveryConfiguration.setEnvironment(environment);
            serviceConfiguration.addServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY, serviceDiscoveryConfiguration);
            Class[] serviceTypes = AbstractServiceConfigFactory.getServiceTypes(serviceComponent);
            serviceDiscoveryConfiguration.setServiceTypes(serviceTypes);
            String repositoryId = serviceComponent.getFQID();
            serviceDiscoveryConfiguration.setRepositoryId(repositoryId);
            String serviceFactory = serviceComponent.getFactoryClassName();
            serviceDiscoveryConfiguration.setServiceFactory(serviceFactory);
            int isRemoteEnabled = serviceComponent.getIsRemotelyAccessible();
            boolean isRemotelyAccessible = isRemoteEnabled == 1;
            serviceDiscoveryConfiguration.setDelegateRegistrationEnabled(isRMIExportEnabled && isRemotelyAccessible);
            if (logger.isDebugEnabled()) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceComponentNameId.fmt.txt", (Object)serviceComponent.getName(), (Object)serviceComponent.getFQID()));
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceComponentFactoryClass.fmt.txt", (Object)serviceFactory));
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceComponentIsRemotelyAccessible.fmt.txt", (Object)isRemoteEnabled));
            }
        }
        catch (RemoteException e) {
            throw new ServiceException(e, e.getLocalizedMessage());
        }
        return serviceConfiguration;
    }

    static void initializeConfiguration(ServiceConfigurationInterface serviceConfiguration, ServiceComponent serviceComponent, SoftwareComponent softwareComponent) throws ServiceException {
        Logger logger = LogManager.getLogger(AbstractServiceConfigFactory.class);
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            ServiceDiscoveryConfigurationInterface sdc;
            if (isDebugEnabled) {
                logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.processingProperties.fmt.txt", (Object)serviceComponent.getName()));
            }
            if ((sdc = (ServiceDiscoveryConfigurationInterface)((Object)serviceConfiguration.getServiceConfiguration(ServiceConfigurationInterface.CONFIGURATION_SERVICE_DISCOVERY))) == null) {
                String msg = RB.getStringResource("DeployableServiceFactory.serviceDiscoveryConfigurationNotDefined.ex.txt");
                logger.warn(msg);
                throw new ServiceException(msg);
            }
            AbstractServiceConfigFactory.addInitializationDataToConfiguration(serviceComponent, serviceConfiguration);
            AbstractServiceConfigFactory.addServiceAttributes(serviceComponent, softwareComponent, sdc);
        }
        catch (RemoteException e) {
            String msg = RB.getStringResource("DeployableServiceFactory.unableToInitializeServiceConfigurationUsingProperties.ex.txt");
            logger.error(msg, (Throwable)e);
            throw new ServiceException(e, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class[] getServiceTypes(ServiceComponent serviceComponent) throws ServiceException {
        Logger logger = LogManager.getLogger(DeployableServiceFactory.class);
        boolean isDebugEnabled = logger.isDebugEnabled();
        Class[] serviceTypes = null;
        Throwable exception = null;
        try {
            AssociationList serviceTypeList;
            int numServiceTypes;
            if (serviceComponent != null && (numServiceTypes = (serviceTypeList = serviceComponent.getServiceTypes(false)).size()) > 0) {
                ClassLoader classLoader = DeployableServiceFactory.class.getClassLoader();
                serviceTypes = new Class[numServiceTypes];
                for (ServiceType serviceType : serviceTypeList) {
                    String serviceClass = serviceType.getInterfaceName();
                    if (isDebugEnabled) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceTypeClass.fmt.txt", (Object)serviceClass));
                    }
                    if (serviceClass.equals("com.sas.services.logging.LoggingServiceInterface")) continue;
                    serviceTypes[--numServiceTypes] = classLoader.loadClass(serviceClass);
                }
            }
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (ClassCastException e) {
            exception = e;
        }
        catch (MdException e) {
            exception = e;
        }
        catch (RemoteException e) {
            exception = e;
        }
        finally {
            if (exception != null) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.unableToDetermineServiceTypes.ex.fmt.txt", (Object)serviceComponent);
                if (logger.isDebugEnabled()) {
                    logger.debug(msg, exception);
                }
                throw new ServiceException(exception, msg);
            }
            if (isDebugEnabled && (serviceTypes == null || serviceTypes.length == 0)) {
                logger.debug(RB.getStringResource("DeployableServiceFactory.serviceTypesNone.txt"));
            }
        }
        return serviceTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addInitializationDataToConfiguration(ServiceComponent serviceComponent, ServiceConfigurationInterface serviceConfiguration) throws ServiceException {
        Logger logger;
        boolean hasInitDataProperty;
        block14: {
            hasInitDataProperty = false;
            Throwable exception = null;
            logger = LogManager.getLogger(AbstractServiceConfigFactory.class);
            boolean isDebugLogEnabled = logger.isDebugEnabled();
            try {
                String lineSeparator = isDebugLogEnabled ? AccessController.doPrivileged(new GetPropertyAction("line.separator")) : null;
                AssociationList properties = serviceComponent.getProperties(false);
                ServiceInitializationObject serviceInitializationObject = (ServiceInitializationObject)serviceConfiguration.getInitializationObject();
                for (Property property : properties) {
                    TextStore textStore;
                    String propertyName = property.getPropertyName();
                    if (!PROPERTYNAME_INITDATA.equals(propertyName) || (textStore = (TextStore)property.getStoredConfiguration()) == null) continue;
                    String configXML = textStore.getStoredText();
                    serviceInitializationObject.addConfiguration(property.getName(), configXML);
                    hasInitDataProperty = true;
                    if (!isDebugLogEnabled) continue;
                    String metadataUpdated = textStore.getMetadataUpdated();
                    if (metadataUpdated != null && metadataUpdated.trim().length() > 0) {
                        logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.metadaUpdated.fmt.txt", (Object)metadataUpdated));
                    }
                    logger.debug(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceInitData.fmt.txt", (Object)lineSeparator, (Object)configXML));
                }
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ClassCastException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block14;
                String msg = RB.getStringResource("DeployableServiceFactory.unableToInitializeServiceConfigurationUsingProperties.ex.txt");
                logger.error(msg, exception);
                throw new ServiceException(exception, msg);
            }
        }
        if (!hasInitDataProperty) {
            try {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceHasNoConfiguration.ex.fmt.txt", (Object)serviceComponent.getName()));
            }
            catch (RemoteException e) {
                logger.warn(Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.serviceHasNoConfiguration.ex.fmt.txt", (Object)serviceComponent));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addServiceAttributes(ServiceComponent serviceComponent, SoftwareComponent softwareComponent, ServiceDiscoveryConfigurationInterface serviceDiscoveryConfiguration) throws ServiceException {
        block14: {
            Throwable exception = null;
            try {
                ArrayList<ServiceAttributeInterface> attributes = new ArrayList<ServiceAttributeInterface>(10);
                serviceDiscoveryConfiguration.setServiceComponentAttribute(new ServiceComponentAttribute(serviceComponent));
                boolean isRemotelyAccessible = serviceDiscoveryConfiguration.isDelegateRegistrationEnabled();
                attributes.add(new IsRemotelyAccessibleAttribute(isRemotelyAccessible));
                AbstractServiceConfigFactory.addKeywordAttributes(attributes, (Root)serviceComponent);
                if (softwareComponent != null) {
                    serviceDiscoveryConfiguration.setServiceDeploymentAttribute(new ServiceDeploymentAttribute(softwareComponent));
                    AbstractServiceConfigFactory.addKeywordAttributes(attributes, (Root)softwareComponent);
                }
                Iterator iter = serviceComponent.getTrees(false).iterator();
                Tree tree = null;
                if (iter.hasNext()) {
                    tree = (Tree)iter.next();
                    String groupName = tree.getName();
                    serviceDiscoveryConfiguration.setServiceGroup(groupName);
                    serviceDiscoveryConfiguration.addServiceAttribute(new ServiceGroupAttribute(groupName));
                    AbstractServiceConfigFactory.addKeywordAttributes(attributes, (Root)tree);
                }
                while (iter.hasNext()) {
                    tree = (Tree)iter.next();
                    AbstractServiceConfigFactory.addKeywordAttributes(attributes, (Root)tree);
                }
                serviceDiscoveryConfiguration.addServiceAttributes(attributes);
            }
            catch (MdException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            catch (ClassCastException e) {
                exception = e;
            }
            catch (IllegalArgumentException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block14;
                throw new ServiceException(exception, RB.getStringResource("DeployableServiceFactory.addServiceAttributes.ex.txt"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addKeywordAttributes(List<ServiceAttributeInterface> attributes, Root root) throws ServiceException {
        block11: {
            if (root != null) {
                Throwable ex = null;
                String name = "";
                try {
                    name = root.getName();
                    for (Keyword keyword : root.getKeywords()) {
                        attributes.add(new NameValueAttribute(keyword.getName(), keyword.getDesc()));
                    }
                }
                catch (MdException e) {
                    ex = e;
                }
                catch (RemoteException e) {
                    ex = e;
                }
                catch (ClassCastException e) {
                    ex = e;
                }
                finally {
                    if (ex == null) break block11;
                    throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"DeployableServiceFactory.addKeywordAttributes.ex.fmt.txt", (Object)name));
                }
            }
        }
    }
}

