/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Tree;
import com.sas.services.InitializationException;
import com.sas.services.RemoteServiceInterface;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionResources;
import com.sas.services.deployment.CLIOptionsMeta;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.RMIBinding;
import com.sas.services.deployment.RMIConfiguration;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.discovery.FindServiceInterface;
import com.sas.services.util.GetPropertyAction;
import com.sas.services.util.IOUtil;
import com.sas.text.Message;
import com.sas.util.Strings;
import java.io.InputStream;
import java.io.Serializable;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractMetadataSource
implements MetadataSourceInterface {
    private static final long serialVersionUID = 1388424401615764532L;
    private static final int HASH_CODE_PRIME_NUMBER = 7;
    private String _softwareComponentName;
    private final Set<String> _serviceGroups;
    private transient RMIClientSocketFactory _rmiClientSocketFactory;
    private transient RMIServerSocketFactory _rmiServerSocketFactory;
    private final List<RMIBinding> _rmiBindings;
    private transient MdObjectStore _mdObjectStore;
    private transient Properties _properties;

    protected AbstractMetadataSource() throws IllegalArgumentException {
        block7: {
            this._serviceGroups = new HashSet<String>(0);
            this._rmiBindings = new ArrayList<RMIBinding>(5);
            Throwable exception = null;
            try {
                this._mdObjectStore = new MdFactoryImpl(false).createObjectStore(null, this.getClass().getName());
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block7;
                LogManager.getLogger(AbstractMetadataSource.class).error(RB.getStringResource("AbstractMetadataSource.getObjectStore.ex.txt"), exception);
                throw new IllegalArgumentException(exception.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MdStore createMdStore(boolean isRemotelyAccessible, Map<String, String> metaOptions, Environment environment) throws ServiceException {
        MdObjectStore mdStore;
        block9: {
            mdStore = null;
            Throwable exception = null;
            try {
                mdStore = new MdFactoryImpl(isRemotelyAccessible).createObjectStore(null, AbstractMetadataSource.class.getName());
                MdFactory mdFactory = mdStore.getFactory();
                MdOMRConnection mdOMRConnection = mdFactory.getConnection();
                mdOMRConnection.setConnectionResources((ConnectionResources)(environment == null ? new Environment() : environment));
                CLIOptionsMeta cliOptionsMeta = new CLIOptionsMeta();
                String metaHost = metaOptions.get(cliOptionsMeta.getNameOfOptionServer());
                String metaPort = metaOptions.get(cliOptionsMeta.getNameOfOptionPort());
                if (metaOptions.containsKey(cliOptionsMeta.getNameOfOptionSecPackageList())) {
                    mdOMRConnection.makeOMRConnectionUsingSecurityPackage(metaHost, metaPort, metaOptions.get(cliOptionsMeta.getNameOfOptionSecPackageList()), metaOptions.get(cliOptionsMeta.getNameOfOptionSPN()));
                } else {
                    mdOMRConnection.makeOMRConnection(metaHost, metaPort, metaOptions.get(cliOptionsMeta.getNameOfOptionUser()), metaOptions.get(cliOptionsMeta.getNameOfOptionPassword()));
                }
            }
            catch (MdException e) {
                exception = e;
                return exception;
            }
            catch (RemoteException e) {
                exception = e;
                return exception;
            }
            finally {
                if (exception == null) break block9;
                LogManager.getLogger(AbstractMetadataSource.class).error(RB.getStringResource("AbstractMetadataSource.getObjectStore.ex.txt"), exception);
                throw new ServiceException(exception);
            }
        }
        return mdStore;
    }

    public AbstractMetadataSource(String softwareComponentName, Set<String> serviceGroupNames) throws InitializationException {
        this();
        this.setSoftwareComponentName(softwareComponentName);
        this.setServiceDeploymentNames(serviceGroupNames);
    }

    protected AbstractMetadataSource(Set<String> serviceGroupNames) throws InitializationException {
        this();
        this.setServiceDeploymentNames(serviceGroupNames);
    }

    public AbstractMetadataSource(String softwareComponentName, String serviceGroupName) throws InitializationException {
        this();
        this.setSoftwareComponentName(softwareComponentName);
        this.addServiceDeploymentName(serviceGroupName);
    }

    @Override
    public Properties getProperties() {
        return this._properties == null ? new Properties() : this._properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public final boolean isServiceDeploymentDeployable(String applicationServiceDeployment) {
        return Strings.equal((String)applicationServiceDeployment, (String)this._softwareComponentName, (boolean)false, (boolean)false);
    }

    @Override
    public final boolean isServiceDeploymentDeployable(String applicationServiceDeployment, Tree serviceGroup) {
        boolean isOkToDeploy = this.isServiceDeploymentDeployable(applicationServiceDeployment);
        try {
            if (isOkToDeploy) {
                if (serviceGroup != null) {
                    String serviceGroupName = serviceGroup.getName();
                    if (this._serviceGroups.size() > 0 && !this._serviceGroups.contains(serviceGroupName)) {
                        isOkToDeploy = false;
                    }
                } else {
                    isOkToDeploy = false;
                }
            }
        }
        catch (RemoteException e) {
            isOkToDeploy = false;
        }
        return isOkToDeploy;
    }

    public final String getSoftwareComponentName() {
        return this._softwareComponentName;
    }

    @Override
    public final void setApplicationServiceDeployment(String softwareComponentName) {
        this._softwareComponentName = softwareComponentName;
    }

    @Override
    public final Set<String> getServiceDeploymentNames() {
        return this._serviceGroups;
    }

    public final void setServiceDeploymentNames(Set<String> serviceGroupNames) {
        this._serviceGroups.clear();
        if (serviceGroupNames != null) {
            this._serviceGroups.addAll(serviceGroupNames);
        }
    }

    protected final void setSoftwareComponentName(String softwareComponentName) throws InitializationException {
        if (softwareComponentName == null) {
            throw new InitializationException(RB.getStringResource("AbstractMetadataSource.nonNullSoftwareComponentNameRequired.ex.txt"));
        }
        this._softwareComponentName = softwareComponentName;
    }

    public final void addServiceDeploymentName(String serviceDeploymentGroup) throws InitializationException {
        if (serviceDeploymentGroup == null || serviceDeploymentGroup.trim().length() == 0) {
            throw new InitializationException(RB.getStringResource("AbstractMetadataSource.nonNullServiceDeploymentNameRequired.ex.txt"));
        }
        this.getServiceDeploymentNames().add(serviceDeploymentGroup);
    }

    public final void removeServiceDeploymentName(String serviceDeploymentGroup) {
        if (serviceDeploymentGroup != null) {
            Set<String> serviceDeploymentGroups = this.getServiceDeploymentNames();
            serviceDeploymentGroups.remove(serviceDeploymentGroup);
        }
    }

    @Override
    public abstract String getMetadata() throws ServiceException;

    @Override
    public final String getApplicationServiceDeployment() {
        return this._softwareComponentName;
    }

    protected static final String getStringFromInputSource(InputStream inputStream) throws ServiceException {
        String string = IOUtil.getStringUsingEncoding(inputStream, "utf-8");
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        return string;
    }

    public final RMIClientSocketFactory getRMIClientSocketFactory() {
        return this._rmiClientSocketFactory;
    }

    public final RMIServerSocketFactory getRMIServerSocketFactory() {
        return this._rmiServerSocketFactory;
    }

    public final void setRMIClientSocketFactory(RMIClientSocketFactory socketFactory) {
        this._rmiClientSocketFactory = socketFactory;
    }

    public final void setRMIServerSocketFactory(RMIServerSocketFactory socketFactory) {
        this._rmiServerSocketFactory = socketFactory;
    }

    @Override
    public final MdObjectStore getMdObjectStore() throws IllegalStateException {
        if (this._mdObjectStore == null) {
            throw new IllegalStateException(RB.getStringResource("AbstractMetadataSource.getObjectStore.ex.txt"));
        }
        return this._mdObjectStore;
    }

    @Override
    public void destroy() {
        this._properties = null;
        MdObjectStore mdObjectStore = this._mdObjectStore;
        if (mdObjectStore != null) {
            this._mdObjectStore = null;
            try {
                MdFactory factory = mdObjectStore.getFactory();
                if (factory != null) {
                    factory.dispose();
                } else {
                    mdObjectStore.dispose();
                }
            }
            catch (RemoteException e) {
                LogManager.getLogger(AbstractMetadataSource.class).error(RB.getStringResource("AbstractMetadataSource.destroy.ex.log"), (Throwable)e);
            }
        }
    }

    public final boolean addRMIBinding(RMIBinding rmiBinding) {
        boolean wasAdded = this._rmiBindings.contains(rmiBinding);
        if (!wasAdded) {
            wasAdded = this._rmiBindings.add(rmiBinding);
        }
        return wasAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<RemoteServiceInterface> lookupServices(DiscoveryServiceInterface discoveryService) {
        ArrayList<RemoteServiceInterface> services = new ArrayList<RemoteServiceInterface>(5);
        Registry registry = null;
        RemoteServiceInterface rmtService = null;
        Serializable exception = null;
        HashMap<String, Registry> rmiRegistryMap = new HashMap<String, Registry>(5);
        RMIConfiguration rmiConfiguration = null;
        String registryURL = null;
        ArrayList<RMIBinding> rmiBindings = new ArrayList<RMIBinding>(this._rmiBindings);
        for (RMIBinding rmiBinding : rmiBindings) {
            exception = null;
            try {
                rmiConfiguration = rmiBinding.getRMIConfiguration();
                registryURL = rmiConfiguration.getUrl();
                registry = (Registry)rmiRegistryMap.get(registryURL);
                if (registry == null) {
                    registry = rmiBinding.getRMIConfiguration().getRMIRegistry(false);
                    rmiRegistryMap.put(registryURL, registry);
                }
                rmtService = (RemoteServiceInterface)registry.lookup(rmiBinding.getBindName());
                rmtService.getEntityKey();
                if (!(rmtService instanceof FindServiceInterface)) continue;
                discoveryService.addDiscoveryDelegate((FindServiceInterface)((Object)rmtService));
                services.add(rmtService);
            }
            catch (ServiceException e) {
                exception = e;
            }
            catch (AccessException e) {
                exception = e;
            }
            catch (NotBoundException e) {
                exception = e;
            }
            catch (RemoteException e) {
                exception = e;
            }
            finally {
                if (exception == null) continue;
                LogManager.getLogger(AbstractMetadataSource.class).error(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractMetadataSource.lookupService.ex.fmt.txt", (Object)rmiBinding), (Throwable)exception);
            }
        }
        return services;
    }

    protected String getDeployFailureMessage() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ServiceLoader.unableToObtainServicesFromMetadata.ex.fmt.txt", (Object)this);
    }

    public String toString() {
        int numGroups;
        String newLine = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        StringBuilder sb = new StringBuilder(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractMetadataSource.toStringSoftwareComponent.fmt.txt", (Object)this._softwareComponentName, (Object)newLine));
        int n = numGroups = this._serviceGroups != null ? this._serviceGroups.size() : 0;
        if (numGroups > 0) {
            for (String group : this._serviceGroups) {
                sb.append(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractMetadataSource.toStringGroup.fmt.txt", (Object)group, (Object)newLine));
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int hashCode = 7;
        if (this._softwareComponentName != null) {
            hashCode ^= this._softwareComponentName.hashCode();
        }
        if (this._serviceGroups != null && this._serviceGroups.size() > 0) {
            for (String groupName : new HashSet<String>(this._serviceGroups)) {
                hashCode ^= groupName.hashCode();
            }
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        boolean isEqual;
        block4: {
            isEqual = false;
            if (other != null) {
                try {
                    AbstractMetadataSource another = (AbstractMetadataSource)other;
                    isEqual = Strings.equal((String)this._softwareComponentName, (String)another._softwareComponentName, (boolean)false, (boolean)false);
                    if (this._serviceGroups == null || this._serviceGroups.size() <= 0) break block4;
                    HashSet<String> groupNames = new HashSet<String>(this._serviceGroups);
                    HashSet<String> otherGroupNames = new HashSet<String>(another.getServiceDeploymentNames());
                    for (String groupName : groupNames) {
                        if (otherGroupNames.contains(groupName)) continue;
                        isEqual = false;
                        break;
                    }
                }
                catch (ClassCastException e) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }
}

