/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.ServiceException;
import com.sas.services.deployment.NameNotUniqueImportException;
import com.sas.services.deployment.OperationMonitorInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentImportException;
import com.sas.services.deployment.ServiceDeploymentImportFile;
import com.sas.services.deployment.ServiceDeploymentImporter;
import com.sas.services.util.IOUtil;
import com.sas.services.util.XMLUtil;
import java.io.Serializable;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
abstract class AbstractImporter {
    private static final Object SYNC_OBJECT = new Object();
    private static final int BUFFER_LENGTH = 500;
    private String _repositoryId;
    private ServiceDeploymentImportFile _serviceDeploymentImportFile;
    private OperationMonitorInterface _operationMonitor;

    AbstractImporter(String repositoryId, ServiceDeploymentImportFile serviceDeploymentImportFile, OperationMonitorInterface operationMonitor) throws IllegalArgumentException {
        if (serviceDeploymentImportFile == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentImporter.mustSpecifyImportFile.ex.txt"));
        }
        this.setRepositoryId(repositoryId);
        this._operationMonitor = operationMonitor;
        this._serviceDeploymentImportFile = serviceDeploymentImportFile;
    }

    abstract void importServiceDeployment(String var1) throws ServiceDeploymentImportException;

    abstract boolean isServiceDeploymentNameUnique(String var1) throws ServiceException;

    public final void importServiceDeployment() {
        try {
            this.importServiceDeployment(this._serviceDeploymentImportFile);
        }
        catch (ServiceDeploymentImportException e) {
            if (this._operationMonitor != null) {
                this._operationMonitor.addThrowable((Throwable)((Object)e));
            }
        }
        finally {
            if (this._operationMonitor != null) {
                this._operationMonitor.setOperationCompleted();
                Thread monitorThread = new Thread((Runnable)this._operationMonitor, this._operationMonitor.getClass().getName());
                monitorThread.setPriority(5);
                monitorThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void importServiceDeployment(ServiceDeploymentImportFile serviceDeploymentImportFile) throws ServiceDeploymentImportException {
        String serviceDeploymentName = serviceDeploymentImportFile.getServiceDeploymentName();
        try {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                this.verifyDeploymentIsImportable(serviceDeploymentName);
                this.importServiceDeployment(AbstractImporter.getMetadataToImport(serviceDeploymentImportFile, this.getRepositoryId()));
            }
        }
        catch (ServiceDeploymentImportException e) {
            LogManager.getLogger(this.getClass()).warn(e.getLocalizedMessage(), (Throwable)((Object)e));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getMetadataToImport(ServiceDeploymentImportFile serviceDeploymentImportFile, String repositoryId) throws ServiceDeploymentImportException {
        StringBuilder sb;
        block10: {
            sb = new StringBuilder(500);
            Serializable ex = null;
            try {
                sb.append("<AddMetadata>");
                sb.append(XMLUtil.applyXSL(serviceDeploymentImportFile.getMetadata(), IOUtil.getStringFromResourceUsingEncoding(ServiceDeploymentImporter.class, "XSL_updateRepositoryIds.xsl", "utf-8")));
                sb.append("<ReposId>");
                sb.append(repositoryId);
                sb.append("</ReposId><NS>SAS</NS><Flags>268435456</Flags><Options/></AddMetadata>");
            }
            catch (TransformerException e) {
                ex = e;
                return ex;
            }
            catch (ServiceDeploymentImportException e) {
                throw e;
            }
            catch (ServiceException e) {
                ex = e;
                return ex;
            }
            catch (IllegalArgumentException e) {
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) break block10;
                throw new ServiceDeploymentImportException((Throwable)ex);
            }
        }
        return sb.toString();
    }

    final void verifyDeploymentIsImportable(String serviceDeploymentName) throws ServiceDeploymentImportException {
        if (serviceDeploymentName == null || serviceDeploymentName.trim().length() == 0) {
            throw new ServiceDeploymentImportException(RB.getStringResource("ServiceDeploymentImporter.mustSpecifyName.ex.txt"));
        }
        try {
            if (!this.isServiceDeploymentNameUnique(XMLUtil.normalize(serviceDeploymentName))) {
                throw new NameNotUniqueImportException(serviceDeploymentName);
            }
        }
        catch (ServiceDeploymentImportException e) {
            throw e;
        }
        catch (ServiceException e) {
            throw new ServiceDeploymentImportException((Throwable)((Object)e));
        }
    }

    final String getRepositoryId() {
        return this._repositoryId;
    }

    private final void setRepositoryId(String repositoryId) {
        if (repositoryId == null) {
            throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.repositoryID.ex.txt"));
        }
        this._repositoryId = repositoryId;
    }

    void destroy() {
    }
}

