/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.XMLUtil;
import com.sas.services.ServiceException;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.ServiceDeploymentExporter;
import com.sas.services.util.IOUtil;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
abstract class AbstractExporter {
    private static final String XMLTEMPLATE_WITHUSINGCOMPONENTS = "XMLTemplate_SoftwareComponent_WithUsingComponents.xml";
    private static final String XSLT_STRIP_METADATA_UPDATED = "XSL_stripMetadataUpdated.xsl";
    private static final String XSLT_CREATE_EXPORT_XML = "XSL_createExportXML.xsl";
    private static final int METADATA_QUERY_FLAGS = 2948;
    protected static final String REPOSITORY_ID_PREFIX = "A0000001.";
    private static final char ALIAS_PREFIX = '$';
    private File _exportDestinationFile;
    private boolean _isOKToOverwriteFile;
    private boolean _isBeautifyingXML = true;

    AbstractExporter(File exportDestinationFile, boolean isOKToOverwriteFile) {
        this.setIsOKToOverwriteFile(isOKToOverwriteFile);
        this.setExportDestinationFile(exportDestinationFile);
    }

    final void setIsBeautifyingXML(boolean isBeautifyingXML) {
        this._isBeautifyingXML = isBeautifyingXML;
    }

    final void setIsOKToOverwriteFile(boolean isOKToOverwriteFile) {
        this._isOKToOverwriteFile = isOKToOverwriteFile;
    }

    abstract String getServiceDeploymentXML() throws ServiceException;

    abstract String getSoftwareComponentFQID() throws ServiceException;

    final void setExportDestinationFile(File exportDestinationFile) throws IllegalArgumentException {
        if (exportDestinationFile == null) {
            throw new IllegalArgumentException(RB.getStringResource("ServiceDeploymentExporter.nonNullExportFileRequired.ex.txt"));
        }
        if (exportDestinationFile.exists()) {
            if (!this._isOKToOverwriteFile) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentExporter.exportFileExists.ex.fmt.txt", (Object)exportDestinationFile.getAbsolutePath()));
            }
            if (!exportDestinationFile.canWrite()) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"ServiceDeploymentExporter.exportFileIsNotWritable.ex.fmt.txt", (Object)exportDestinationFile.getAbsolutePath()));
            }
        }
        this._exportDestinationFile = exportDestinationFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void export() throws ServiceException {
        block17: {
            BufferedWriter bufferedWriter = null;
            Exception exception = null;
            try {
                if (this._exportDestinationFile.exists()) {
                    this._exportDestinationFile.delete();
                }
                String exportXML = this.getServiceDeploymentXML();
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._exportDestinationFile), "utf-8"));
                bufferedWriter.write(exportXML);
                bufferedWriter.flush();
            }
            catch (SecurityException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(this.getClass()).error((Object)e);
                    }
                }
                if (exception == null) break block17;
                throw new ServiceException(exception, Message.format((ResourceBundle)RB.getResources(), (String)"AbstractExporter.export.ex.fmt.txt", (Object)this._exportDestinationFile.getAbsolutePath()));
            }
        }
    }

    static final String getAliasForID(String id) {
        int dotIndex = id.indexOf(46) + 1;
        return id.substring(0, dotIndex) + '$' + id.substring(dotIndex);
    }

    static final int getMetadataQueryFlags() {
        return 2948;
    }

    static final String getXMLQuery(String softwareComponentFQID) throws ServiceException {
        return "<XMLSelect Search=\"*" + AbstractExporter.getXMLSelect(softwareComponentFQID) + "\"/>" + AbstractExporter.getQueryTemplate();
    }

    private static final String getQueryTemplate() throws ServiceException {
        String xmlTemplate = "";
        try {
            xmlTemplate = IOUtil.getStringFromResourceUsingEncoding(AbstractExporter.class, XMLTEMPLATE_WITHUSINGCOMPONENTS, "utf-8");
            xmlTemplate = com.sas.services.util.XMLUtil.applyXSL(xmlTemplate, AbstractExporter.getXSLToStripMetadataUpdated(true));
        }
        catch (TransformerException e) {
            throw new ServiceException(e, RB.getStringResource("ServiceDeploymentExporter.unableToProcessServiceDeployment.ex.txt"));
        }
        return xmlTemplate;
    }

    static final String getRepositoryID(String repositoryIDSuffix) {
        return REPOSITORY_ID_PREFIX + repositoryIDSuffix;
    }

    static final String getXMLSelect(String softwareComponentFQID) throws ServiceException {
        return "[@ClassIdentifier='ABC1234567890' and @Id='" + softwareComponentFQID + "']";
    }

    private static final String getXSLToStripMetadataUpdated(boolean isOmittingXMLDeclaration) throws ServiceException {
        String xsl = IOUtil.getStringFromResourceUsingEncoding(ServiceDeploymentExporter.class, XSLT_STRIP_METADATA_UPDATED, "utf-8");
        return Message.format((String)xsl, (Object)(isOmittingXMLDeclaration ? "yes" : "no"));
    }

    final String createExportXMLDocument(String docXML) throws ServiceException {
        String metadataXML = "<Metadata>" + docXML + "</Metadata>";
        try {
            String xsl = IOUtil.getStringFromResourceUsingEncoding(ServiceDeploymentExporter.class, XSLT_CREATE_EXPORT_XML, "utf-8");
            metadataXML = com.sas.services.util.XMLUtil.applyXSL(metadataXML, xsl);
            if (this._isBeautifyingXML) {
                metadataXML = XMLUtil.formatXML((String)metadataXML);
            }
        }
        catch (TransformerException e) {
            throw new ServiceException(e, RB.getStringResource("AbstractExporter.createXMLDocument.ex.txt"));
        }
        return metadataXML;
    }
}

