/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.deployment;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServiceComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.services.ServiceException;
import com.sas.services.ServiceFactoryInterface;
import com.sas.services.deployment.AbstractServiceDeployment;
import com.sas.services.deployment.DeploymentStrategyInterface;
import com.sas.services.deployment.RB;
import com.sas.services.deployment.SAXErrorHandler;
import com.sas.services.discovery.DiscoveryService;
import com.sas.services.discovery.RegistryDiscoveryService;
import com.sas.services.util.IOUtil;
import com.sas.services.util.TransformerFactoryFactory;
import com.sas.services.util.XMLUtil;
import com.sas.text.Message;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractDeploymentStrategy
implements DeploymentStrategyInterface {
    private Properties _properties;

    public AbstractDeploymentStrategy(Properties properties) {
        this._properties = new Properties(properties);
    }

    public Document createDocument(SoftwareComponent softwareComponent, Map configProperties) throws ServiceException {
        Document document = this.createDocument();
        this.createDiscoveryServiceBean(document);
        this.createServiceConfigFactory(document);
        this.createServiceBeans(document, softwareComponent, configProperties);
        return document;
    }

    protected Document createDocument() throws ServiceException {
        Document document = null;
        try {
            DocumentBuilderFactory factory = TransformerFactoryFactory.newDocumentBuilderFactory();
            this.configureDocumentBuilderFactory(factory);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.configureBuilder(builder);
            document = this.createDocument(builder);
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException(e, RB.getStringResource("DeploymentStrategy.createDocument.ex.txt"));
        }
        return document;
    }

    @Override
    public void createFile(SoftwareComponent softwareComponent, File file) throws ServiceException {
        this.createDeploymentFile(softwareComponent, file);
    }

    @Override
    public void createFiles(SoftwareComponent softwareComponent, File file, File clientFile) throws ServiceException {
        Map configProperties = this.createDeploymentFile(softwareComponent, file);
        if (clientFile != null && configProperties.size() > 0) {
            this.createClientFile(clientFile, configProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reconfigure(Properties properties, File inputFile, File outputFile) throws ServiceException {
        Throwable throwable = null;
        try {
            this.writeFile(outputFile, XMLUtil.applyXSL(IOUtil.getString(new FileInputStream(inputFile)), this.getReconfigurationXSLT(), properties));
            if (throwable == null) return;
        }
        catch (IOException e) {
            IOException iOException = e;
            if (iOException == null) return;
            throw new ServiceException(iOException, Message.format((ResourceBundle)RB.getResources(), (String)"DeploymentStrategy.reconfigure.ex.fmt.txt", (Object)(inputFile == null ? null : inputFile.getAbsolutePath())));
        }
        catch (TransformerException e2) {
            TransformerException transformerException = e2;
            if (transformerException == null) return;
            {
                catch (Throwable throwable2) {
                    if (throwable == null) throw throwable2;
                    throw new ServiceException(throwable, Message.format((ResourceBundle)RB.getResources(), (String)"DeploymentStrategy.reconfigure.ex.fmt.txt", (Object)(inputFile == null ? null : inputFile.getAbsolutePath())));
                }
            }
            throw new ServiceException(transformerException, Message.format((ResourceBundle)RB.getResources(), (String)"DeploymentStrategy.reconfigure.ex.fmt.txt", (Object)(inputFile == null ? null : inputFile.getAbsolutePath())));
        }
        throw new ServiceException(throwable, Message.format((ResourceBundle)RB.getResources(), (String)"DeploymentStrategy.reconfigure.ex.fmt.txt", (Object)(inputFile == null ? null : inputFile.getAbsolutePath())));
    }

    protected Properties getOutputFormatProperties(Document document) {
        Properties properties = new Properties();
        properties.put("indent", "yes");
        return properties;
    }

    protected final Properties getProperties() {
        return this._properties;
    }

    public final void setProperty(String key, String value) {
        if (key != null) {
            if (value != null) {
                this._properties.setProperty(key, value);
            } else {
                this._properties.remove(key);
            }
        }
    }

    public final String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void writeFile(File file, String xml) throws ServiceException {
        block18: {
            if (file == null) {
                throw new IllegalArgumentException(RB.getStringResource("IllegalArgument.specifyFile.ex.txt"));
            }
            BufferedWriter bufferedWriter = null;
            Exception ex = null;
            try {
                if (file.exists()) {
                    file.delete();
                }
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
                bufferedWriter.write(xml);
                bufferedWriter.flush();
            }
            catch (SecurityException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
            finally {
                if (bufferedWriter != null) {
                    try {
                        bufferedWriter.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(this.getClass()).error((Object)e);
                    }
                }
                if (ex == null) break block18;
                throw new ServiceException(ex, Message.format((ResourceBundle)RB.getResources(), (String)"DeploymentDescriptorStrategy.writeFile.ex.fmt.txt", (Object)file.getAbsolutePath()));
            }
        }
    }

    private final File createClientFile(File outputFile, Map configProperties) throws ServiceException {
        Document clientDocument = this.createClientDocument(configProperties);
        if (clientDocument != null) {
            this.writeFile(outputFile, XMLUtil.convertNodeToString((Node)clientDocument, this.getOutputFormatProperties(clientDocument)));
        }
        return outputFile;
    }

    protected Document createClientDocument(Map configProperties) throws ServiceException {
        return null;
    }

    protected static String getBeanNameConnectionFactory() {
        return "ConnectionFactory";
    }

    protected static final String getBeanNameConnection() {
        return "Connection";
    }

    protected String getBeanNameServiceConfigFactory() {
        return "ServiceConfigFactory";
    }

    protected String getBeanNameServiceMetadataFactory() {
        return "ServiceMetadataFactory";
    }

    protected String getBeanNameMetadataSourceProperties() {
        return "MetadataSourceProperties";
    }

    protected String getBeanNameMetadataSource() {
        return "MetadataSource";
    }

    protected static final String getBeanNameSSLRMISocketFactories() {
        return "SSLRMISocketFactories";
    }

    protected static final String getBeanNameRMIConfiguration() {
        return "RMIConfiguration";
    }

    protected static final String getBeanNameRMIRegistry() {
        return "RMIRegistry";
    }

    protected static final String getBeanNameDiscoveryService() {
        return DiscoveryService.class.getName();
    }

    protected static final String getMethodNameGetInstance() {
        return "getInstance";
    }

    protected static final String getMethodNameCreateService() {
        return "createService";
    }

    protected static final String getMethodNameGetRMIRegistry() {
        return "getRMIRegistry";
    }

    protected static final String getBeanNameRMIRegistryDiscoveryService() {
        return RegistryDiscoveryService.class.getName();
    }

    protected String getBeanIdService(CMetadata cMetadata) throws ServiceException {
        String id = null;
        try {
            if (cMetadata instanceof ServiceComponent) {
                ServiceComponent serviceComponent = (ServiceComponent)cMetadata;
                ServiceFactoryInterface serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName());
                id = serviceFactory.getServiceProfile().getBeanIdForService(cMetadata);
            } else {
                id = cMetadata.getFQID();
            }
        }
        catch (MdException e) {
            throw new ServiceException(e);
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return id;
    }

    protected String getBeanNameService(CMetadata cMetadata) throws ServiceException {
        String name = null;
        try {
            name = cMetadata.getName();
            ServiceComponent serviceComponent = (ServiceComponent)cMetadata;
            ServiceFactoryInterface serviceFactory = AbstractServiceDeployment.getServiceFactory(serviceComponent.getFactoryClassName());
            name = serviceFactory.getServiceProfile().getServiceImplementationClass();
        }
        catch (RemoteException e) {
            throw new ServiceException(e);
        }
        return name;
    }

    protected void configureBuilder(DocumentBuilder builder) {
        builder.setErrorHandler(new SAXErrorHandler(LogManager.getLogger(AbstractDeploymentStrategy.class)));
    }

    private Map createDeploymentFile(SoftwareComponent softwareComponent, File file) throws ServiceException {
        HashMap configProperties = new HashMap(5);
        Document document = this.createDocument(softwareComponent, configProperties);
        this.writeFile(file, XMLUtil.convertNodeToString((Node)document, this.getOutputFormatProperties(document)));
        return configProperties;
    }

    protected abstract void setServiceDependencies(Document var1, Element var2, ServiceComponent var3) throws ServiceException;

    protected String getReconfigurationXSLT() {
        return null;
    }

    protected abstract void configureDocumentBuilderFactory(DocumentBuilderFactory var1) throws ServiceException;

    protected abstract Document createDocument(DocumentBuilder var1) throws ServiceException;

    protected abstract Element createDiscoveryServiceBean(Document var1) throws ServiceException;

    protected abstract void createServiceConfigFactory(Document var1) throws ServiceException;

    protected abstract void createServiceBeans(Document var1, SoftwareComponent var2, Map var3) throws ServiceException;
}

