/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.swing.visuals.tableview.SortHeaderRenderer;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.table.SortException;
import com.sas.table.SortableInterface;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PromotionTable
extends TableView
implements ListSelectionListener {
    private SortableInterface si;

    public PromotionTable() {
    }

    public PromotionTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public PromotionTable(TableModel dm) {
        super(dm);
    }

    public PromotionTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public PromotionTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public PromotionTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public PromotionTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    protected boolean processKeyBinding(KeyStroke stroke, KeyEvent evt, int condition, boolean pressed) {
        Component cellEditorComp = this.getEditorComponent();
        if (cellEditorComp != null && cellEditorComp instanceof JComboBox && evt.getKeyCode() == 40) {
            JComboBox combo = (JComboBox)cellEditorComp;
            if (!combo.isPopupVisible()) {
                combo.showPopup();
            }
            return false;
        }
        return super.processKeyBinding(stroke, evt, condition, pressed);
    }

    public void processComponentKeyEvent(KeyEvent e) {
    }

    public void initializeLocalVars() {
        super.initializeLocalVars();
        this.setAutoResizeMode(2);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeaderVisible(false);
        this.setCellSelectionEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getRowModel().getSelectionModel().setSelectionMode(0);
        this.getRowModel().getSelectionModel().addListSelectionListener(this);
        this.setPopupMenuEnabled(false);
        this.getSelectionModel().addListSelectionListener(this);
        SortHeaderRenderer headerRenderer = new SortHeaderRenderer();
        headerRenderer.setHorizontalAlignment(2);
        this.getTableHeader().setDefaultRenderer((TableCellRenderer)headerRenderer);
        this.getSelectionModel().setSelectionMode(0);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Point p = event.getPoint();
                int hitColumnIndex = PromotionTable.this.columnAtPoint(p);
                int hitRowIndex = PromotionTable.this.rowAtPoint(p);
                if (hitColumnIndex != -1 && hitRowIndex != -1) {
                    Object obj = PromotionTable.this.getValueAt(PromotionTable.this.convertRowIndexToModel(hitRowIndex), PromotionTable.this.convertColumnIndexToModel(hitColumnIndex));
                    String tip = null;
                    if (obj != null) {
                        tip = obj.toString();
                    }
                    PromotionTable.this.setToolTipText(tip);
                }
            }
        });
    }

    public void setModel(TableModel newModel) {
        super.setModel(newModel);
        if (newModel instanceof SortableInterface) {
            this.si = (SortableInterface)newModel;
            try {
                this.si.sort(new String[]{newModel.getColumnName(0)}, new int[]{0});
            }
            catch (SortException sortException) {
                // empty catch block
            }
            MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
                boolean pressOk = false;

                @Override
                public void mouseDragged(MouseEvent event) {
                    this.pressOk = false;
                }

                @Override
                public void mousePressed(MouseEvent event) {
                    this.pressOk = PromotionTable.this.getTableHeader().getCursor() == Cursor.getDefaultCursor();
                }

                @Override
                public void mouseReleased(MouseEvent event) {
                    if (SwingUtilities.isLeftMouseButton(event) && this.pressOk) {
                        int col = PromotionTable.this.convertColumnIndexToModel(PromotionTable.this.getTableHeader().columnAtPoint(event.getPoint()));
                        String columnName = TableViewUtil.getColumnName((TableModel)PromotionTable.this.getModel(), (int)col);
                        if (PromotionTable.this.si.isSortAllowed() && PromotionTable.this.si.isColumnSortable(columnName)) {
                            String[] columns = PromotionTable.this.si.getSortedColumns();
                            int[] directions = PromotionTable.this.si.getSortedDirections();
                            int direction = 0;
                            if (columnName != null && columns != null && directions != null && columns.length == directions.length) {
                                for (int i = 0; i < columns.length; ++i) {
                                    if (!columnName.equals(columns[i])) continue;
                                    if (directions[i] != 0) break;
                                    direction = 1;
                                    break;
                                }
                            }
                            ArrayList<String> newColumns = new ArrayList<String>();
                            ArrayList<Integer> newDirections = new ArrayList<Integer>();
                            newColumns.add(columnName);
                            newDirections.add(new Integer(direction));
                            int size = newDirections.size();
                            int[] ndirections = new int[size];
                            for (int i = 0; i < size; ++i) {
                                ndirections[i] = (Integer)newDirections.get(i);
                            }
                            try {
                                PromotionTable.this.si.sort(newColumns.toArray(new String[0]), ndirections);
                            }
                            catch (SortException ex) {
                                ex.printStackTrace();
                            }
                            PromotionTable.this.getTableHeader().repaint();
                        }
                    }
                }
            };
            this.getTableHeader().addMouseMotionListener(mouseAdapter);
            this.getTableHeader().addMouseListener(mouseAdapter);
        }
    }

    public void setModel2(TableModel newModel) {
        super.setModel(newModel);
        if (newModel instanceof SortableInterface) {
            this.si = (SortableInterface)newModel;
            try {
                this.si.sort(new String[]{newModel.getColumnName(0)}, new int[]{0});
            }
            catch (SortException sortException) {
                // empty catch block
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        int firstIndex = e.getFirstIndex();
        if (this.getSelectedRow() == -1 && this.getRowCount() > firstIndex) {
            this.setRowSelectionInterval(firstIndex, firstIndex);
        }
    }

    protected void validateCurrentCell() {
        super.validateCurrentCell();
        if (this.getColumnCount() > 1 && this.getCurrentColumn() == 0) {
            this.setCurrentColumn(1);
        }
    }

    protected void repaintCurrentCell() {
        super.repaintCurrentCell();
        if (this.getCurrentRow() >= 0 && this.getCurrentColumn() >= 0) {
            this.repaint(this.getCellRect(this.getCurrentRow(), 0, false));
        }
    }
}

