/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.DependentObjectsProviderInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.TreeUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class DependentObjectsComponent
extends AbstractPromotionPanel {
    private JTree _tree;
    private JScrollPane _scrollPane;
    private DefaultMutableTreeNode _root;

    public DependentObjectsComponent(ImportWizardInterface wizard) {
        this.initialize();
        this.layoutWidgets();
    }

    public DependentObjectsComponent() {
        this.initialize();
        this.layoutWidgets();
    }

    private void initialize() {
        this._tree = new JTree();
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new TreeNodeRenderer());
        DefaultTreeModel model = new DefaultTreeModel(null);
        this._tree.setModel(model);
        this._scrollPane = new JScrollPane(this._tree);
    }

    private void layoutWidgets() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.insets = LayoutConstants.EMPTY_INSETS;
        gbl.setConstraints(this._scrollPane, gbc);
        this.add(this._scrollPane);
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("DependentObjectsComponent.Label.txt");
    }

    @Override
    public void loadComponent(Object sourceData, Object targetData) {
        if (sourceData instanceof DependentObjectsProviderInterface) {
            DependentObjectsProviderInterface dopi = (DependentObjectsProviderInterface)sourceData;
            List<ImportItemInterface> topLevelObjects = dopi.getDependentObjects();
            DefaultTreeModel model = new DefaultTreeModel(this.createTree(topLevelObjects));
            this._tree.setRootVisible(false);
            this._tree.setModel(model);
            TreeUtil.expandAllNodes((JTree)this._tree);
        }
    }

    private TreeNode createTree(List<ImportItemInterface> importItems) {
        this._root = new DefaultMutableTreeNode();
        int size = importItems.size();
        if (size > 0) {
            Comparator<ImportItemInterface> sorter = new Comparator<ImportItemInterface>(){

                @Override
                public int compare(ImportItemInterface object1, ImportItemInterface object2) {
                    if (object1 == null) {
                        return -1;
                    }
                    if (object2 == null) {
                        return 1;
                    }
                    return object1.getDisplayName().compareToIgnoreCase(object2.getDisplayName());
                }
            };
            Collections.sort(importItems, sorter);
            for (int index = 0; index < size; ++index) {
                String[] path;
                ImportItemInterface importItem = importItems.get(index);
                if (importItem == null || (path = importItem.getTargetPath()) == null || path.length <= 0) continue;
                boolean isFolder = BIPTreeUtil.isFolder(importItem);
                if (!isFolder && importItem.getImportState() != 0) {
                    DefaultMutableTreeNode parent = this.getParentFolder(path);
                    DefaultMutableTreeNode child = new DefaultMutableTreeNode(importItem);
                    parent.add(child);
                    continue;
                }
                if (!isFolder || importItem.getImportState() == 0) continue;
                this.getParentFolder(path);
            }
        }
        return this._root;
    }

    private DefaultMutableTreeNode getParentFolder(String[] path) {
        DefaultMutableTreeNode parent = this._root;
        for (String treeName : path) {
            boolean exists = false;
            Enumeration<TreeNode> children = parent.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode folder = (DefaultMutableTreeNode)children.nextElement();
                if (!treeName.equals(folder.getUserObject())) continue;
                parent = folder;
                exists = true;
                break;
            }
            if (exists) continue;
            DefaultMutableTreeNode childFolder = new DefaultMutableTreeNode(treeName);
            parent.add(childFolder);
            parent = childFolder;
        }
        return parent;
    }

    class TreeNodeRenderer
    extends DefaultTreeCellRenderer {
        TreeNodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
            Object userObject;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, cellHasFocus);
            if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof ImportItemInterface) {
                ImportItemInterface importItem = (ImportItemInterface)userObject;
                TypeInterface type = importItem.getTypeInterface();
                this.setText(importItem.getDisplayName());
                if (type != null) {
                    this.setIcon(type.getIcon(1));
                }
                return this;
            }
            this.setIcon(Images.getFolderIcon());
            return this;
        }
    }
}

