/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionPropertiesInterface;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.promotion.visuals.connections.AbstractPromptingPanel;
import com.sas.metadata.promotion.visuals.connections.ConnectionPropertiesComponent;
import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.metadata.promotion.visuals.connections.SubstitutionPanelInterface;
import com.sas.metadata.promotion.visuals.connections.SubstitutionPropertiesTableModel;
import com.sas.text.Message;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractSubstitutionPanel
extends AbstractPromptingPanel
implements SubstitutionPanelInterface {
    public static final int SELECTION_TYPE_TEXTFIELD = 0;
    public static final int SELECTION_TYPE_COMBOBOX = 1;
    public static final int SELECTION_TYPE_CUSTOM = 2;
    protected List _substitutions;
    protected SubstitutionTypeInterface _substitutionType;
    protected ConnectionPropertiesComponent _propertiesComponent = null;
    private Map _targetMapping;

    public AbstractSubstitutionPanel(ImportOperationInterface operation, SubstitutionTypeInterface type, List substitutions) {
        super(operation, type);
        this._substitutionType = type;
        this._substitutions = substitutions;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public abstract String getHelpTopicSuffix();

    @Override
    public abstract String getPanelDescription();

    @Override
    public abstract String getPanelTitle();

    @Override
    public abstract String getPanelBorderLabel();

    @Override
    public abstract String getDefaultSelectionValue();

    @Override
    public final SubstitutionTypeInterface getSubstitutionType() {
        return this._substitutionType;
    }

    @Override
    public final List getSubstitutions() {
        return this._substitutions;
    }

    @Override
    public void populatePanel() {
        if (this._substitutionType instanceof SubstitutionPropertiesInterface) {
            SubstitutionPropertiesTableModel model = new SubstitutionPropertiesTableModel((SubstitutionPropertiesInterface)((Object)this._substitutionType));
            this._propertiesComponent = new ConnectionPropertiesComponent(model);
            this.addInformativeComponent(this._propertiesComponent);
        }
        super.populatePanel();
    }

    public boolean validateData() {
        if (this._mappingTable.isEditing()) {
            this._mappingTable.getCellEditor().stopCellEditing();
        }
        try {
            if (this._targetMapping != null) {
                for (SubstitutionInterface substitution : this._targetMapping.keySet()) {
                    String target;
                    Object targetValue = this._targetMapping.get(substitution);
                    if (targetValue == null || targetValue instanceof String && ((String)targetValue).length() == 0) {
                        if (this._substitutionType.isSubstitutionRequired(substitution)) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.SelectTarget.fmt.txt", (Object)this._substitutionType.getLocalizedTypeName());
                            this.displayErrorMessage(msg);
                            return false;
                        }
                        if (targetValue instanceof String) {
                            target = (String)targetValue;
                            substitution.setTargetValue(target);
                        }
                    } else if (targetValue instanceof String) {
                        target = (String)targetValue;
                        substitution.setTargetValue(target);
                    }
                    ValidationResponse response = new ValidationResponse();
                    this._substitutionType.validate(response, this._importOperation, substitution);
                    boolean result = true;
                    switch (response.getReturnCode()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this._importOperation.getLogger().warn(response.getMessage());
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"AbstractConnectionPanel.WarningWithContinue.fmt.txt", (Object)response.getMessage());
                            result = this.displayValidationWarningMessage(msg);
                            if (result) break;
                            return result;
                        }
                        case 2: {
                            this._importOperation.getLogger().error(response.getMessage());
                            result = this.displayErrorMessage(response.getMessage());
                            return result;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.displayErrorMessage(e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    @Override
    public Map getMappingsForTarget() {
        if (this._targetMapping == null) {
            this._targetMapping = new LinkedHashMap();
            if (this._substitutions != null) {
                for (Object obj : this._substitutions) {
                    if (!(obj instanceof SubstitutionInterface)) continue;
                    SubstitutionInterface sub = (SubstitutionInterface)obj;
                    this._targetMapping.put(sub, null);
                }
            }
        }
        return this._targetMapping;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.configureCellEditors();
    }

    private void configureCellEditors() {
        int selectionType = this.getSelectionType();
        if (selectionType == 1) {
            this.configureComboBox();
        } else if (selectionType == 0) {
            this._tableRenderer = null;
            this._cellEditor = null;
        } else if (selectionType == 2) {
            this._tableRenderer = this.getTableCellRenderer();
            this._cellEditor = this.getTableCellEditor();
        }
    }

    public int getSelectionType() {
        return 0;
    }

    @Override
    public void setTableSelectionType() {
        int selectionType = this.getSelectionType();
        if (selectionType != 0) {
            if (this.getSelectionType() == 1) {
                if (this._tableRenderer != null) {
                    this._mappingTable.setCellRenderer(-1, -1, this._tableRenderer);
                }
                if (this._cellEditor != null) {
                    this._mappingTable.setCellEditor(-1, 2, this._cellEditor);
                }
            } else if (this.getSelectionType() == 2) {
                TableCellEditor editor;
                TableCellRenderer renderer = this.getTableCellRenderer();
                if (renderer != null) {
                    this._mappingTable.setCellRenderer(-1, 2, renderer);
                }
                if ((editor = this.getTableCellEditor()) != null) {
                    this._mappingTable.setCellEditor(-1, 2, editor);
                }
            } else {
                throw new IllegalArgumentException("Invalid target selection type");
            }
        }
    }

    @Override
    public void updateMap(Map mapping) {
        if (mapping != null) {
            Set keys = mapping.keySet();
            for (Object sourceValue : keys) {
                Object targetValue = mapping.get(sourceValue);
                if (targetValue != null || !(sourceValue instanceof SubstitutionInterface)) continue;
                SubstitutionInterface sub = (SubstitutionInterface)sourceValue;
                mapping.put(sourceValue, sub.getSourceValue());
            }
        }
    }

    @Override
    protected List getTargetValuesList(Object sourceKey) {
        return new ArrayList();
    }
}

