/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals.connections;

import com.sas.metadata.promotion.visuals.connections.RB;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPropertiesTableModel
extends WsAbstractTableModel {
    public static final int ATTRIBUTE_COLUMN = 0;
    public static final int SOURCE_COLUMN = 1;
    public static final int TARGET_COLUMN = 2;
    protected static final int TOTAL_COLUMNS = 3;
    private boolean _initialized = false;
    protected Map _propertyEntries = new LinkedHashMap(5);

    public AbstractPropertiesTableModel() {
        this.initializeColumns();
    }

    protected abstract void initializeProperties();

    protected abstract void setSourceProperties(Object var1) throws MdException, RemoteException;

    protected abstract void setTargetProperties(Object var1) throws MdException, RemoteException;

    protected void initializeColumns() {
        this.m_aColumns = new WsAbstractTableColumn[3];
        this.m_aColumns[0] = new WsStringTableColumn(0, " ", 100);
        this.m_aColumns[1] = new WsStringTableColumn(1, RB.getStringResource("AbstractPropertiesTableModel.SourceColumn.txt"), 175);
        this.m_aColumns[2] = new WsStringTableColumn(2, RB.getStringResource("AbstractPropertiesTableModel.TargetColumn.txt"), 175);
    }

    public int getColumnCount() {
        return 3;
    }

    public void populateStore() throws MdException {
    }

    public void setPropertyData(Object source, Object target) {
        if (!this._initialized) {
            this.initializeProperties();
        }
        this.clear();
        try {
            this.setSourceProperties(source);
            this.setTargetProperties(target);
            for (Map.Entry me : this._propertyEntries.entrySet()) {
                PropertyEntry entry = (PropertyEntry)me.getValue();
                ArrayList<String> row = new ArrayList<String>(3);
                row.add(entry.getAttributeName());
                row.add(entry.getSourceValue());
                row.add(entry.getTargetValue());
                this.m_lData.add(row);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fireTableModelPopulated();
    }

    public void clear() {
        for (Map.Entry me : this._propertyEntries.entrySet()) {
            PropertyEntry entry = (PropertyEntry)me.getValue();
            entry.setSourceValue("");
            entry.setTargetValue("");
        }
        super.clear();
    }

    public void moveDataToModel() throws MdException {
    }

    public void moveDataToStore() throws MdException {
    }

    public String getToolTipAt(int iRow, int iCol) {
        Object obj = ((List)this.m_lData.get(iRow)).get(iCol);
        if (obj == null || !(obj instanceof String)) {
            return null;
        }
        String tip = (String)obj;
        if (tip.length() == 0) {
            return null;
        }
        return tip;
    }

    public class PropertyEntry {
        String _attr;
        String _source;
        String _target;
        boolean _visible;

        public PropertyEntry(String attr) {
            this._attr = attr;
        }

        public PropertyEntry(String attr, String source, String target) {
            this._attr = attr;
            this._source = source;
            this._target = target;
        }

        public void setSourceValue(String source) {
            this._source = source;
        }

        public void setTargetValue(String target) {
            this._target = target;
        }

        public String getAttributeName() {
            return this._attr;
        }

        public void setVisible(boolean visible) {
            this._visible = visible;
        }

        public boolean isVisible() {
            return this._visible;
        }

        public String getSourceValue() {
            return this._source;
        }

        public String getTargetValue() {
            return this._target;
        }
    }
}

