/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.LabelView;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public abstract class PromotionFinishPanel
extends WsDescriptionWizardTab
implements WizardPanelInterface {
    public static final String PANEL_NAME = "FinishPanel";
    protected PromotionWizardInterface _wizard;
    protected PromotionInterface _operation;
    protected JPanel _finishPanel;
    protected JButton _logButton;
    protected LabelView _detailsLabel;

    public PromotionFinishPanel(PromotionWizardInterface wizard, PromotionInterface operation) {
        this._wizard = wizard;
        this._operation = operation;
    }

    public abstract String getPanelDescription();

    public abstract String getHelpTopic();

    public abstract String getLogTitle();

    public abstract String getSuccessMessage();

    public abstract String getWarningMessage();

    public abstract String getErrorMessage();

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void initialize() {
        this.setDescription(this.getPanelDescription());
        this.setHelpProduct("promotion");
        this.setHelpTopic(this.getHelpTopic());
        this._finishPanel = new JPanel();
        this._finishPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this._detailsLabel = new LabelView();
        this._detailsLabel.setLineWrap(true);
        this._detailsLabel.setWrapStyleWord(true);
        this._logButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._logButton, (String)RB.getStringResource("Common.ViewLog.txt"));
        this._logButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualsUtil.displayPromotionLog((Dialog)((WAWizardDialog)PromotionFinishPanel.this._wizard), PromotionFinishPanel.this._operation, PromotionFinishPanel.this.getLogTitle());
            }
        });
    }

    public void layoutWidgets() {
        this._finishPanel.setLayout(new GridBagLayout());
        this._finishPanel.add((Component)this._detailsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0));
        this._finishPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 0, 0, 1.0, 1.0, 18, 1, new Insets(12, 12, 12, 12), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this._finishPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.add(this._logButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException {
        if (!bSaveToModel) {
            this.initialize();
            this.layoutWidgets();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PromotionFinishPanel.this._wizard.getCancelButton().setEnabled(false);
                    PromotionFinishPanel.this._wizard.getHelpButton().setEnabled(true);
                    PromotionFinishPanel.this._wizard.getBackButton().setEnabled(false);
                    PromotionFinishPanel.this._wizard.setCloseable(true);
                }
            });
            Integer success = (Integer)this._wizard.getWizardData("STATUS");
            if (success != null) {
                Font fnt = this._detailsLabel.getFont();
                fnt = new Font("Monospaced", fnt.getStyle(), fnt.getSize());
                this._detailsLabel.setFont(fnt);
                String text = null;
                text = success == 0 ? this.getSuccessMessage() : (success == 4 ? this.getWarningMessage() : this.getErrorMessage());
                this._detailsLabel.setText(text);
            }
        }
        return true;
    }
}

