/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MessageListener;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.DetailsMessageDialog;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.workspace.OpRequestUI;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JDialog;

public abstract class ProgressBarLauncher
implements MessageListener {
    protected PromotionInterface _promotionHandler;
    protected Log _log;
    protected PromotionWizardInterface _wizard;
    protected OpRequestUI _request;
    protected Dimension _preferredSize = new Dimension(340, 20);
    protected ProgressReturnCode _rc;
    protected int _waitTime = 1500;

    public ProgressBarLauncher(PromotionWizardInterface wizard, PromotionInterface handler) {
        this._promotionHandler = handler;
        this._log = handler.getLogger();
        this._wizard = wizard;
    }

    public void setPromotionHandler(PromotionInterface handler) {
        this._promotionHandler = handler;
    }

    public PromotionInterface getPromotionHandler() {
        return this._promotionHandler;
    }

    public void setPreferredSize(Dimension preferredSize) {
        this._preferredSize = preferredSize;
    }

    public ProgressReturnCode getReturnCode() {
        return this._rc;
    }

    public abstract String getMessage();

    public abstract String getTitle();

    public boolean getDisplayCancelButton() {
        return false;
    }

    public void setWaitTime(int waitTime) {
        this._waitTime = waitTime;
    }

    public void launch(Runnable runnable) {
        this.initialize();
        try {
            if (this.getDisplayCancelButton()) {
                this._request.executeWithCancel(runnable);
            } else {
                this._request.execute(runnable);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.removeMessageListeners();
            this.displayMessage(null);
        }
    }

    protected String getMessagePrefix() {
        return null;
    }

    @Override
    public void displayMessage(String message) {
        if (message == null) {
            this._request.setMessage("");
            return;
        }
        String prefix = this.getMessagePrefix();
        this._request.setMessage(prefix == null ? message : prefix + message);
    }

    protected boolean displayDetailsMessage(String message) {
        int type;
        String title;
        int option;
        int status = this.getReturnCode().getReturnCode();
        return (status & 4) <= 0 && (status & 8) <= 0 || (option = DetailsMessageDialog.displayDialog(this._promotionHandler, message, title = status == 4 ? RB.getStringResource("Common.Warning.txt") : RB.getStringResource("Common.Error.txt"), type = status == 4 ? 2 : 0)) == 0;
    }

    private void initialize() {
        this._request = new OpRequestUI((JDialog)((Object)((AbstractPromotionWizard)this._wizard)), this.getMessage(), this.getTitle());
        this._rc = new ProgressReturnCode();
        this._rc.setReturnCode(0);
        this._request.setMessage(this.getMessage());
        this._request.setDelayBeforeProgressCancelDialog(this._waitTime);
        this._request.setProgressShownOnStatusBar(false);
        this._request.setMessagePreferredSize(this._preferredSize);
        this.addMessageListeners();
    }

    public void addMessageListeners() {
        this.setMessageListeners(true);
    }

    public void removeMessageListeners() {
        this.setMessageListeners(false);
    }

    private void setMessageListeners(boolean add) {
        Map<String, TypeInterface> types = this._promotionHandler.getTypes();
        for (Map.Entry<String, TypeInterface> entry : types.entrySet()) {
            TypeInterface pt = entry.getValue();
            if (!(pt instanceof TransportableTypeInterface)) continue;
            Object obj = null;
            if (this._promotionHandler instanceof ExportOperationInterface) {
                obj = ((TransportableTypeInterface)pt).getExportListener();
            } else if (this._promotionHandler instanceof ImportOperationInterface) {
                obj = ((TransportableTypeInterface)pt).getImportListener();
            }
            if (obj == null || !(obj instanceof AbstractPromotionListener)) continue;
            AbstractPromotionListener listener = (AbstractPromotionListener)obj;
            if (add) {
                listener.addMessageListener(this);
                continue;
            }
            listener.removeMessageListener(this);
        }
    }
}

