/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportSummaryInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.ConnectionTransitionHandler;
import com.sas.metadata.promotion.visuals.CopyPasteUtil;
import com.sas.metadata.promotion.visuals.DependencyAnalyzer;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.ImportConnectionIntroPanel;
import com.sas.metadata.promotion.visuals.ImportExecutePanel;
import com.sas.metadata.promotion.visuals.ImportFinishPanel;
import com.sas.metadata.promotion.visuals.ImportSummaryPanel;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.PasteSpecialTreePanel;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public class PasteSpecialWizard
extends AbstractPromotionWizard
implements ExportWizardInterface,
ImportWizardInterface {
    private com.sas.metadata.logical.FolderInterface _targetFolder;
    private SimpleLogicalObjectInterface[] _logicalObjects;
    private PublicObjectContainerInterface _targetContainer;
    private List<PublicObjectInterface> _publicObjects;
    private boolean _initialized = false;
    private String _tempReposID;
    private ExportHandler _exportHandler;
    private ImportHandler _importHandler;
    private ImportSummaryInterface _importSummary;
    private ConnectionTransitionHandler _connectionHandler;
    private ImportFinishPanel _finishPanel;
    protected Map<String, String> _targetIDMap;

    public PasteSpecialWizard(PublicObjectContainerInterface container, List<PublicObjectInterface> publicObjects, List<String> supportedTypes, String title) {
        super(supportedTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("PasteSpecialWizard.Title.txt");
        }
        this.setTitle(this._title);
        this._targetContainer = container;
        this._publicObjects = publicObjects;
        this.initializePanels();
    }

    private PasteSpecialWizard(TypeInterface[] availableTypes, String title) {
        super(availableTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("PasteSpecialWizard.Title.txt");
        }
        this.setTitle(this._title);
    }

    public PasteSpecialWizard(com.sas.metadata.logical.FolderInterface targetFolder, SimpleLogicalObjectInterface[] logicalObjects, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._targetFolder = targetFolder;
        this._logicalObjects = logicalObjects;
        this.initializePanels();
    }

    @Override
    protected void initializePanels() {
        Workspace workspace = Workspace.getWorkspace();
        try {
            if (this._isOldStylePromotion) {
                this.convertToPublicObjectModel();
            }
            this._exportHandler = new ExportHandler(this._publicObjects, (List<String>)this._supportedTypes, 3);
            File packageFile = File.createTempFile("CopyPasteSpecial", ".spk");
            this._exportHandler.setExportFile(packageFile);
            this._exportHandler.setSessionContext(workspace.getSessionContext(), true);
            if (this._targetContainer == null) {
                return;
            }
            this._importHandler = new ImportHandler(this._targetContainer, this._supportedTypes, 3);
            this._importHandler.getPropertiesManager().setPromptForSubstitutions(true);
            this._importHandler.setSessionContext(workspace.getSessionContext(), true);
            this._log = Log.getInstance(PasteSpecialWizard.class.getName());
            this._logFileName = this._log.getLogFileName();
            this.addWizardData("LOGFILE", this._logFileName);
            if (this._log.isInfoEnabled()) {
                this._log.info(RB.getStringResource("CopyPasteUtil.BeginSpecial.txt"));
            }
        }
        catch (ServiceException e) {
            String msg = e.getLocalizedMessage();
            if (this._log != null && this._log.isErrorEnabled()) {
                this._log.error(msg);
            }
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            return;
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (this._log != null && this._log.isErrorEnabled()) {
                this._log.error(msg);
            }
            CopyPasteUtil.displayErrorDialogNoDetails(msg, 0);
            return;
        }
        PasteSpecialTreePanel treePanel = new PasteSpecialTreePanel(this);
        this.addTab(treePanel.getPanelTitle(), "TreePanel", (WAPropertyTab)treePanel, false);
        ImportConnectionIntroPanel connectionPanel = new ImportConnectionIntroPanel(this);
        this.addTab(connectionPanel.getPanelTitle(), "ConnectionIntroPanel", (WAPropertyTab)new ImportConnectionIntroPanel(this), false);
        ImportSummaryPanel summaryPanel = new ImportSummaryPanel(this);
        this.addTab(summaryPanel.getPanelTitle(), "ImportSummary", (WAPropertyTab)new ImportSummaryPanel(this), false);
        ImportExecutePanel executePanel = new ImportExecutePanel(this);
        this.addTab(executePanel.getPanelTitle(), "ExecutePanel", (WAPropertyTab)executePanel, false);
        this._finishPanel = new ImportFinishPanel(this);
        this.addTab(this._finishPanel.getPanelTitle(), "FinishPanel", (WAPropertyTab)this._finishPanel, true);
        this.setupTransitions();
        this._initialized = true;
    }

    private void convertToPublicObjectModel() throws ServiceException, RemoteException {
        Workspace workspace = Workspace.getWorkspace();
        OMIServer server = workspace.getConnectionManager().getMetadataServer();
        ObjectConverter converter = ObjectConverter.getInstance();
        if (this._logicalObjects != null) {
            PublicObjectInterface[] objects = converter.convertToPublicObjects(this._logicalObjects, (ServerInterface)server);
            this._publicObjects = Arrays.asList(objects);
        }
        if (this._targetFolder != null) {
            String key = this._targetFolder.getID() + "/" + this._targetFolder.getTypeInterface().getMetadataType();
            FolderInterface folder = (FolderInterface)server.fetch(key, true);
            if (folder == null) {
                throw new ServiceException("Unable to retrieve folder from the server.");
            }
            this._targetContainer = folder;
        }
    }

    @Override
    protected void setupTransitions() {
        String[][] transitions = new String[][]{{"TreePanel", "NEXT", ""}, {"TreePanel", "CONNECTIONS", "ConnectionIntroPanel"}, {"TreePanel", "FINISH", "ImportSummary"}, {"ImportSummary", "NEXT", "ExecutePanel"}, {"ExecutePanel", "NEXT", "FinishPanel"}};
        this._model.addTransitions(transitions);
    }

    @Override
    protected WAPanel getFinishPanel() {
        return this._finishPanel;
    }

    @Override
    protected void cleanUp(boolean cancelling) {
        if (cancelling) {
            this._log.info(RB.getStringResource("PasteSpecialWizard.Cancel.Log.txt"));
        } else if (this._importHandler != null) {
            this._importSummary = this._importHandler.getImportSummary();
            this._targetIDMap = this._importHandler.getTargetObjectIDs();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        File packageFile = this._exportHandler.getExportFile();
        if (packageFile != null) {
            packageFile.delete();
        }
        if (this._exportHandler != null) {
            this._exportHandler.dispose();
        }
        if (this._importHandler != null) {
            this._importHandler.dispose();
        }
        this._connectionHandler = null;
        this.m_wizardData.clear();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void changeRepositoryID(String repositoryID) {
        if (repositoryID != null && this._importHandler != null) {
            this._importHandler.changeRepositoryID(repositoryID);
        }
    }

    @Override
    public ExportHandler getExportHandler() {
        return this._exportHandler;
    }

    @Override
    public ImportHandler getImportHandler() {
        return this._importHandler;
    }

    public void setImportHandler(ImportHandler handler) {
        this._importHandler = handler;
        if (this._tempReposID != null) {
            this._importHandler.changeRepositoryID(this._tempReposID);
        }
    }

    public ImportSummaryInterface getCopySummary() {
        return this._importSummary;
    }

    public Map<String, String> getTargetObjectIDs() {
        return this._targetIDMap;
    }

    public boolean objectsWerePasted() {
        return this._importSummary != null && this._importSummary.getTotalImportedItemsCount() > 0;
    }

    @Override
    public ConnectionTransitionHandler getConnectionHandler() {
        if (this._connectionHandler == null) {
            this._connectionHandler = new ConnectionTransitionHandler(this);
        }
        return this._connectionHandler;
    }

    public void show() {
        if (this._exportHandler == null || !this._initialized) {
            return;
        }
        if (this.getDescription() == null) {
            this.setDescription(RB.getStringResource("PasteSpecialWizard.Desc.txt"));
        }
        super.show();
    }

    protected static int showDetailsMessageDialog(int status, String fileToDisplay) {
        int type;
        String msg;
        if (status == 4) {
            msg = RB.getStringResource("ImportWizard.WarningsBeforeImport.txt");
            type = 2;
        } else {
            msg = RB.getStringResource("ImportWizard.ErrorsBeforeImport.txt");
            type = 0;
        }
        WATextArea textArea = new WATextArea();
        textArea.setEditable(false);
        textArea.setAutoSelect(false);
        textArea.setMargin(new Insets(5, 5, 5, 5));
        textArea.setBehavior(0);
        Font fnt = textArea.getFont();
        fnt = new Font("Courier", fnt.getStyle(), fnt.getSize());
        textArea.setFont(fnt);
        JScrollPane scrollPane = new JScrollPane((Component)textArea);
        scrollPane.setPreferredSize(new Dimension(375, 300));
        try {
            if (fileToDisplay != null) {
                String details = PromotionUtil.readFile(fileToDisplay);
                textArea.setText(details);
                textArea.setCaretPosition(details.length());
            }
        }
        catch (IOException e) {
            textArea.setText(Message.format((ResourceBundle)RB.getResources(), (String)"ImportWizard.ReadLogFileFail.txt", (Object)e.getMessage()));
        }
        return MessageUtil.displayDetailsMessage((String)msg, (String)RB.getStringResource("PasteSpecialWizard.Title.txt"), (int)type, (int)0, (JComponent)scrollPane);
    }

    @Override
    public DependencyAnalyzer getDependencyAnalyzer() {
        return null;
    }
}

