/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.visuals.AbstractExportTreePanel;
import com.sas.metadata.promotion.visuals.ConnectionTransitionHandler;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModel;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.PasteSpecialProcessor;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.List;

public class PasteSpecialTreePanel
extends AbstractExportTreePanel
implements WizardPanelInterface {
    public static final String PANEL_NAME = "TreePanel";
    public static final String PANEL_TITLE = RB.getStringResource("PasteSpecialTreePanel.Title.txt");
    private FolderNode _rootNode;

    public PasteSpecialTreePanel(ExportWizardInterface wizard) {
        super(wizard);
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    @Override
    public void initialize() {
        this._log = Log.getInstance(PasteSpecialTreePanel.class.getName());
        this.setHelpProduct("promotion");
        this.setHelpTopic("pastespec_copyobjectswin");
        this.setDescription(RB.getStringResource("PasteSpecialTreePanel.Description.txt"));
        super.initialize();
    }

    public boolean validateData() {
        PasteSpecialProcessor ps;
        boolean success;
        Component comp;
        if (!this._canClickNext) {
            return false;
        }
        if (this._depPanels != null) {
            for (int i = 0; i < this._depPanels.length; ++i) {
                this._depPanels[i].stopProcessing();
            }
        }
        Component component = comp = this.isDetailsVisible() ? this._detailsPane.getSelectedComponent() : null;
        if (this._optionsPanel != null && comp == this._optionsPanel) {
            List<TreeNodeInterface> nodes = this.getSelectedNodes();
            this._optionsPanel.saveSettings(nodes.toArray(new TreeNodeInterface[0]));
        }
        if (!(success = (ps = new PasteSpecialProcessor((PasteSpecialWizard)this._wizard)).startPaste((ExportTree)this._tree))) {
            return false;
        }
        ConnectionTransitionHandler connHandler = ((PasteSpecialWizard)this._wizard).getConnectionHandler();
        connHandler.setStartingPanel(this);
        connHandler.setTransitions();
        return true;
    }

    @Override
    protected boolean isPopulatingTree() {
        return true;
    }

    @Override
    protected String getRootNodeName() {
        return RB.getStringResource("PasteSpecialTreePanel.NodeName.txt");
    }

    @Override
    protected ExportTreeModelInterface createTreeModel() throws ServiceException, RemoteException {
        this._rootNode = new FolderNode(this.getRootNodeName());
        ExportFolderModelInterface exportModel = ModelFactory.createExportFolderModel(this._handler);
        ExportModelConfiguration config = (ExportModelConfiguration)exportModel.getConfiguration();
        config.setDisplayEmptyFolders(true);
        config.setAllowFolderExport(false);
        config.setDisplayUnknownObjects(false);
        ExportTreeModel model = new ExportTreeModel(exportModel);
        this.populateModel(model);
        this._duplicateObjects = exportModel.getDuplicateObjects();
        return model;
    }

    private void populateModel(ExportTreeModelInterface model) throws ServiceException, RemoteException {
        ExportHandler operation = ((PasteSpecialWizard)this._wizard).getExportHandler();
        List<PublicObjectInterface> publicObjectList = operation.getExportedObjects();
        if (publicObjectList != null) {
            ExportFolderModelInterface exportModel = model.getExportModel();
            PublicObjectInterface[] publicObjects = publicObjectList.toArray(new PublicObjectInterface[publicObjectList.size()]);
            exportModel.populateModel(publicObjects);
            List<PublicObjectNodeInterface> exportedNodes = exportModel.getExportedNodes();
            if (exportedNodes != null && exportedNodes.size() > 0) {
                for (PublicObjectNodeInterface node : exportedNodes) {
                    ExportTreeNodeInterface visualNode = model.createNode(node);
                    model.addChildren(visualNode, true);
                    this._rootNode.add(visualNode);
                }
            }
        }
        ((ExportTreeModel)model).setRoot(this._rootNode);
    }
}

