/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.visuals.ErrorTrackingManager;
import com.sas.metadata.promotion.visuals.FindDialog;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextPane;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsComponentPrinter;
import com.sas.workspace.WsComponentPrinterFactory;
import com.sas.workspace.WsTitledPageFormat;
import com.sas.workspace.WsUIUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class LogViewerDialog
extends WAStandardDialog {
    private static final long serialVersionUID = -4600822944957959477L;
    private static final Insets BUTTON_MARGIN = new Insets(2, 2, 2, 2);
    private static final String NEW_LINE = "\n";
    private String _title;
    private String _logFileName;
    private File _logFile;
    protected WATextPane _textArea;
    protected JScrollPane _scrollPane;
    private boolean _editable = false;
    protected JToolBar _toolBar;
    protected JButton _saveButton;
    protected JButton _printButton;
    protected JButton _findButton;
    protected JButton _errorDownButton;
    protected JButton _errorUpButton;
    protected JLabel _errorCountLabel;
    private boolean _savingSupported = true;
    private boolean _printingSupported = true;
    private boolean _errorTrackingSupported = true;
    private boolean _searchingSupported = true;
    private PageFormat _pageFormat = null;
    private ErrorTrackingManager _errorTracking;

    public LogViewerDialog(String title, String fileName, Dialog parent) {
        super(parent, true);
        this._title = title;
        this._logFileName = fileName;
        this._errorTracking = new ErrorTrackingManager();
    }

    public LogViewerDialog(String title, File logFile, Dialog parent) {
        this(title, logFile.getName(), parent);
        this._logFile = logFile;
    }

    public LogViewerDialog(String title, String fileName, Frame parent) {
        super(parent, true);
        this._title = title;
        this._logFileName = fileName;
        this._errorTracking = new ErrorTrackingManager();
    }

    public LogViewerDialog(String title, File logFile, Frame parent) {
        this(title, logFile.getName(), parent);
        this._logFile = logFile;
    }

    public void setTextEditable(boolean editable) {
        if (editable != this._editable) {
            this._editable = editable;
            this._textArea.setEditable(this._editable);
        }
    }

    public boolean isTextEditable() {
        return this._editable;
    }

    public boolean isErrorTrackingSupported() {
        return this._errorTrackingSupported;
    }

    public boolean isPrintingSupported() {
        return this._printingSupported;
    }

    public boolean isSavingSupported() {
        return this._savingSupported;
    }

    public boolean isSearchingSupported() {
        return this._searchingSupported;
    }

    public void setPrintingSupported(boolean printing) {
        this._printingSupported = printing;
    }

    public void setSavingSupported(boolean saving) {
        this._savingSupported = saving;
    }

    public void setSearchingSupported(boolean searching) {
        this._searchingSupported = searching;
    }

    public void setErrorTrackingSupported(boolean tracking) {
        this._errorTrackingSupported = tracking;
    }

    public ErrorTrackingManager getErrorTrackingManager() {
        return this._errorTracking;
    }

    private boolean isToolBarDisplayable() {
        return this.isSavingSupported() || this.isPrintingSupported() || this.isSearchingSupported() || this.isErrorTrackingSupported();
    }

    public void setPrintingPageFormat(PageFormat format) {
        this._pageFormat = format;
    }

    protected void initialize() {
        this.setTitle(this._title);
        this.setResizable(true);
        this.setCloseButtonVisible(true);
        this.setHelpButtonVisible(false);
        this.setOKButtonVisible(false);
        this.setCancelButtonVisible(false);
        super.initialize();
        this._textArea = new WATextPane();
        this._textArea.setBehavior(0);
        this._textArea.setAutoSelect(false);
        this._textArea.setEditable(this._editable);
        this._textArea.setMargin(new Insets(5, 5, 5, 5));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        textPanel.add((Component)this._textArea);
        this._scrollPane = new JScrollPane(textPanel);
        this._scrollPane.setPreferredSize(new Dimension(500, 350));
        if (this.isToolBarDisplayable()) {
            WsAbstractAction act;
            this._toolBar = new JToolBar();
            this._toolBar.setFloatable(false);
            this._toolBar.setRollover(true);
            if (this.isSavingSupported()) {
                act = new SaveAsAction();
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(83, 2), "save");
                this._textArea.getActionMap().put("save", (Action)act);
                this._saveButton = WsUIUtilities.createFlatToolButton((WsAbstractAction)act);
                ImageIcon saveIcon = Resources.getImageIcon((String)RB.getStringResource("LogViewer.Save.image"), (int)16);
                this.configureButton(this._saveButton, saveIcon, RB.getStringResource("LogViewer.Save.txt"), null);
                this._toolBar.add(this._saveButton);
            }
            if (this.isPrintingSupported()) {
                act = new PrintAction();
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(80, 2), "print");
                this._textArea.getActionMap().put("print", (Action)act);
                this._printButton = WsUIUtilities.createFlatToolButton((WsAbstractAction)act);
                ImageIcon printIcon = Resources.getImageIcon((String)RB.getStringResource("LogViewer.Print.image"), (int)16);
                this.configureButton(this._printButton, printIcon, RB.getStringResource("LogViewer.Print.txt"), null);
                this._toolBar.add(this._printButton);
            }
            if (this.isSearchingSupported()) {
                if (this._toolBar.getComponentCount() > 0) {
                    this._toolBar.addSeparator();
                }
                act = new FindAction();
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(70, 2), "find");
                this._textArea.getActionMap().put("find", (Action)act);
                this._findButton = WsUIUtilities.createFlatToolButton((WsAbstractAction)new FindAction());
                ImageIcon findIcon = Resources.getImageIcon((String)RB.getStringResource("LogViewer.Find.image"), (int)16);
                this.configureButton(this._findButton, findIcon, RB.getStringResource("LogViewer.Find.txt"), null);
                this._toolBar.add(this._findButton);
            }
            if (this.isErrorTrackingSupported()) {
                ErrorTrackingAction nextAct = new ErrorTrackingAction(ErrorTrackingManager.Direction.DOWN);
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(160, 2), "find_next");
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(46, 2), "find_next");
                this._textArea.getActionMap().put("find_next", (Action)((Object)nextAct));
                this._errorDownButton = WsUIUtilities.createFlatToolButton((WsAbstractAction)nextAct);
                ImageIcon downIcon = Resources.getImageIcon((String)RB.getStringResource("LogViewer.ErrorDown.image"), (int)16);
                this.configureButton(this._errorDownButton, downIcon, RB.getStringResource("LogViewer.ErrorDown.Tooltip.txt"), null);
                this._toolBar.add(this._errorDownButton);
                ErrorTrackingAction prevAct = new ErrorTrackingAction(ErrorTrackingManager.Direction.UP);
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(153, 2), "find_prev");
                this._textArea.getInputMap().put(KeyStroke.getKeyStroke(44, 2), "find_prev");
                this._textArea.getActionMap().put("find_prev", (Action)((Object)prevAct));
                this._errorUpButton = WsUIUtilities.createFlatToolButton((WsAbstractAction)prevAct);
                ImageIcon upIcon = Resources.getImageIcon((String)RB.getStringResource("LogViewer.ErrorUp.image"), (int)16);
                this.configureButton(this._errorUpButton, upIcon, RB.getStringResource("LogViewer.ErrorUp.Tooltip.txt"), null);
                this._toolBar.add(this._errorUpButton);
                this._errorCountLabel = new JLabel();
                this._errorCountLabel.setBorder(new EmptyBorder(0, 2, 0, 0));
                this._errorCountLabel.setVisible(false);
                this._toolBar.addSeparator();
                this._toolBar.add(this._errorCountLabel);
            }
        }
    }

    private void configureButton(AbstractButton button, Icon icon, String tooltip, String name) {
        button.setIcon(icon);
        button.setFocusable(false);
        button.setMargin(BUTTON_MARGIN);
        if (tooltip != null && tooltip.length() > 0) {
            button.setToolTipText(tooltip);
        }
        if (name != null) {
            Util.configureMnemonicForButton((AbstractButton)button, (String)name);
        }
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        int row = 0;
        if (this.isToolBarDisplayable()) {
            panel.add((Component)this._toolBar, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, LayoutConstants.EMPTY_INSETS, 0, 0));
            row = 1;
        }
        panel.add((Component)this._scrollPane, (Object)new GridBagConstraints(0, row + 1, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
        this.setMainPanel(panel);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LogViewerDialog.this.readLogFile();
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLogFile() {
        BufferedReader br = null;
        try {
            String in;
            StyledDocument doc = this._textArea.getStyledDocument();
            this.initializeStyles(doc);
            Style regStyle = doc.getStyle("regular");
            Style errorStyle = doc.getStyle("error");
            Style warnStyle = doc.getStyle("warning");
            Style currentStyle = regStyle;
            FileReader fr = null;
            if (this._logFile != null) {
                fr = new FileReader(this._logFile);
            } else if (this._logFileName != null) {
                fr = new FileReader(this._logFileName);
            }
            br = new BufferedReader(fr);
            int pos = 0;
            while ((in = br.readLine()) != null) {
                pos = doc.getLength();
                StringBuilder builder = new StringBuilder();
                builder.append(in);
                builder.append(NEW_LINE);
                if (this.isErrorTrackingSupported()) {
                    currentStyle = this._errorTracking.isErrorMessage(in, pos) ? errorStyle : (this._errorTracking.isWarningMessage(in, pos) ? warnStyle : regStyle);
                }
                doc.insertString(pos, builder.toString(), currentStyle);
                pos += builder.length();
            }
            this._textArea.setCaretPosition(0);
            this._textArea.getDocument().putProperty("__EndOfLine__", NEW_LINE);
            if (this.isErrorTrackingSupported()) {
                int count = this._errorTracking.getTotalCount();
                if (count > 0) {
                    this._errorCountLabel.setText(Message.format((ResourceBundle)RB.getResources(), (String)"LogViewer.ErrorCount.fmt.txt", (Object)count));
                    this._errorCountLabel.setVisible(true);
                } else {
                    this._errorUpButton.setEnabled(false);
                    this._errorDownButton.setEnabled(false);
                }
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage(), (String)RB.getStringResource("Common.Error.txt"), (int)0, (int)-1);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void initializeStyles(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "Courier New");
        StyleConstants.setFontSize(regular, 13);
        Style s = doc.addStyle("error", regular);
        StyleConstants.setForeground(s, Color.RED);
        s = doc.addStyle("warning", regular);
        StyleConstants.setForeground(s, Color.BLUE);
    }

    private void saveFile() {
        if (this._logFileName == null) {
            return;
        }
        String PROP_KEY = "PartialPromotionWizards.LogFilePath";
        String startDir = Workspace.getWorkspace().getAppDefaultsFile().getPropertyString("PartialPromotionWizards.LogFilePath", System.getProperty("user.home"));
        String fileName = null;
        String sep = System.getProperty("file.separator");
        fileName = this._logFileName.indexOf(sep) > -1 ? this._logFileName.substring(this._logFileName.lastIndexOf(sep) + 1) : this._logFileName;
        FileDialog fd = new FileDialog((Dialog)((Object)this), RB.getStringResource("LogViewer.Save.txt"), 1);
        fd.setFile(fileName);
        fd.setDirectory(startDir);
        WsUIUtilities.center((Dialog)fd);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return;
        }
        String dir = fd.getDirectory();
        if (!dir.endsWith(sep)) {
            dir = dir + sep;
        }
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyString("PartialPromotionWizards.LogFilePath", dir);
        String newFileName = dir + fd.getFile();
        this.writeFile(newFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String fileName) {
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int bytesRead;
            inStream = new FileInputStream(this._logFileName);
            outStream = new FileOutputStream(fileName);
            byte[] buffer = new byte[4096];
            while ((bytesRead = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            MessageUtil.displayMessage((String)Message.format((ResourceBundle)RB.getResources(), (String)"LogViewer.SaveError.fmt.txt", (Object)ex.getMessage()), (String)RB.getStringResource("Common.Error.txt"), (int)0);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void printFile() {
        try {
            JTextArea txtPrint = new JTextArea();
            txtPrint.setLineWrap(true);
            txtPrint.setWrapStyleWord(true);
            txtPrint.setText(this._textArea.getText());
            Font fnt = this._textArea.getFont();
            Font newFnt = new Font(fnt.getName(), fnt.getStyle(), 10);
            txtPrint.setFont(newFnt);
            txtPrint.setDocument(this._textArea.getDocument());
            PageFormat pf = null;
            pf = this._pageFormat != null ? this._pageFormat : new WsTitledPageFormat(this._title, newFnt);
            WsComponentPrinter printer = WsComponentPrinterFactory.createComponentPrinter((JComponent)txtPrint, (PageFormat)pf);
            PrinterJob printJob = PrinterJob.getPrinterJob();
            if (!Workspace.getWorkspace().isPrinterConnected(printJob)) {
                return;
            }
            printJob.setPrintable((Printable)printer);
            printJob.setPageable((Pageable)printer);
            if (printJob.printDialog()) {
                printJob.print();
            }
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getMessage(), (String)RB.getStringResource("Common.Error.txt"), (int)0, (int)-1);
        }
    }

    private void find() {
        FindDialog dlg = FindDialog.createDialog((Component)((Object)this), (JTextComponent)this._textArea);
        dlg.setVisible(true);
    }

    class SaveAsAction
    extends WsAbstractAction {
        public SaveAsAction() {
            this.setText(null);
        }

        public void actionPerformed(ActionEvent e) {
            LogViewerDialog.this.saveFile();
        }
    }

    class PrintAction
    extends WsAbstractAction {
        public PrintAction() {
            this.setText(null);
        }

        public void actionPerformed(ActionEvent e) {
            LogViewerDialog.this.printFile();
        }
    }

    class FindAction
    extends WsAbstractAction {
        public FindAction() {
            this.setText(null);
        }

        public void actionPerformed(ActionEvent e) {
            LogViewerDialog.this.find();
        }
    }

    class ErrorTrackingAction
    extends WsAbstractAction {
        private ErrorTrackingManager.Direction _dir;

        public ErrorTrackingAction(ErrorTrackingManager.Direction dir) {
            this._dir = dir;
        }

        public void actionPerformed(ActionEvent e) {
            int index = -1;
            int currentPosition = LogViewerDialog.this._textArea.getCaretPosition();
            switch (this._dir) {
                case UP: {
                    index = LogViewerDialog.this._errorTracking.getPreviousErrorOrWarning(currentPosition);
                    break;
                }
                case DOWN: {
                    index = LogViewerDialog.this._errorTracking.getNextErrorOrWarning(currentPosition);
                }
            }
            if (index != -1) {
                LogViewerDialog.this._textArea.setCaretPosition(index);
            }
        }
    }
}

