/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.visuals.FolderNode;
import com.sas.metadata.promotion.visuals.ImportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ImportTreeNode;
import com.sas.metadata.promotion.visuals.ImportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;

public class ImportTreeModel
extends DefaultTreeModel
implements ImportTreeModelInterface {
    protected Map<String, ImportTreeNodeInterface> _nodeCache;
    protected ImportFolderModelInterface _model;
    protected List<ImportTreeNodeInterface> _disabledNodesList;

    public ImportTreeModel(ImportFolderModelInterface model) throws ServiceException, RemoteException {
        super(null, true);
        this._model = model;
        this._nodeCache = new LinkedHashMap<String, ImportTreeNodeInterface>();
    }

    @Override
    public ImportFolderModelInterface getImportModel() {
        return this._model;
    }

    @Override
    public List<ImportTreeNodeInterface> getDisabledNodes() {
        return this._disabledNodesList;
    }

    @Override
    public ImportTreeNodeInterface createNode(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        ImportTreeNode visualNode = new ImportTreeNode(node);
        visualNode.setTreeModel(this);
        this._nodeCache.put(node.getIdentifier(), visualNode);
        return visualNode;
    }

    public void addChild(ImportTreeNodeInterface parent, ImportTreeNodeInterface child) {
        int index = parent.getChildCount();
        this.insertNodeInto(child, parent, index);
    }

    @Override
    public void addChildren() throws ServiceException, RemoteException {
        FolderNodeInterface rootFolder = this._model.getRootFolder();
        FolderNode rootNode = new FolderNode(RB.getStringResource("ImportTreeModel.RootFolder.txt"), true);
        List children = rootFolder.getChildren();
        for (PublicObjectNodeInterface child : children) {
            ImportTreeNodeInterface targetNode = this.createNode(child);
            this.addChildren(targetNode);
            rootNode.add(targetNode);
        }
        this.setRoot(rootNode);
    }

    private void addChildren(ImportTreeNodeInterface parent) throws ServiceException, RemoteException {
        PublicObjectNodeInterface parentNode = parent.getPublicObjectNode();
        if (parentNode == null) {
            return;
        }
        List children = ((ContainerNodeInterface)parentNode).getChildren();
        for (PublicObjectNodeInterface childNode : children) {
            ImportTreeNodeInterface visualChildNode = this.createNode(childNode);
            this.addChild(parent, visualChildNode);
            ImportElementInterface importElement = this._model.getImportElement((PublicObjectInterface)childNode);
            if (importElement != null && !importElement.isValid()) {
                if (this._disabledNodesList == null) {
                    this._disabledNodesList = new ArrayList<ImportTreeNodeInterface>();
                }
                this._disabledNodesList.add(visualChildNode);
            }
            if (!(childNode instanceof ContainerNodeInterface)) continue;
            this.addChildren(visualChildNode);
        }
    }

    @Override
    public boolean containsImportNode(String id) {
        return this._nodeCache.containsKey(id);
    }

    @Override
    public ImportTreeNodeInterface getImportNode(String id) {
        return this._nodeCache.get(id);
    }
}

