/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.visuals.AbstractObjectOptionsPanel;
import com.sas.metadata.promotion.visuals.ImportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ImportObjectOptionsPanel
extends AbstractObjectOptionsPanel {
    private ImportOperationInterface _importOperation;

    public ImportObjectOptionsPanel(ImportOperationInterface operation) {
        this._importOperation = operation;
    }

    @Override
    public PromotionOptionsInterface getOptionsInterface(String publicType) {
        TransportableTypeInterface type = this._importOperation.getTransportableType(publicType);
        ImportListener listener = (ImportListener)type.getImportListener();
        if (listener instanceof PromotionOptionsInterface) {
            return (PromotionOptionsInterface)((Object)listener);
        }
        return null;
    }

    private List<ImportItemInterface> getPromotionItems(TreeNodeInterface[] nodes) throws ServiceException, RemoteException {
        ArrayList<ImportItemInterface> importItems = new ArrayList<ImportItemInterface>();
        for (int index = 0; index < nodes.length; ++index) {
            ImportItemInterface importItem;
            ImportElementInterface importNode;
            PublicObjectNodeInterface poNode;
            TreeNodeInterface treeNode = nodes[index];
            if (!(treeNode instanceof ImportTreeNodeInterface) || (poNode = ((ImportTreeNodeInterface)treeNode).getPublicObjectNode()) == null || (importNode = (ImportElementInterface)poNode.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface")) == null || (importItem = importNode.getImportItem()) == null) continue;
            importItems.add(importItem);
        }
        return importItems;
    }

    @Override
    public JPanel getOptionsPanel(PromotionOptionsInterface options, TreeNodeInterface[] nodes) throws ServiceException, RemoteException {
        List<ImportItemInterface> items = this.getPromotionItems(nodes);
        if (items == null || items.isEmpty()) {
            return null;
        }
        ImportItemInterface[] importItems = items.toArray(new ImportItemInterface[items.size()]);
        return options.getOptionsPanel(importItems, this._importOperation);
    }
}

