/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.PromptingTypeInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.swing.visuals.LabelView;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImportConnectionIntroPanel
extends WsDescriptionWizardTab
implements WizardPanelInterface {
    public static final String PANEL_NAME = "ConnectionIntroPanel";
    private static final String PANEL_TITLE = RB.getStringResource("ImportConnectionIntroPanel.Title.txt");
    private static final String BEGINNING_DASH = RB.getStringResource("ImportConnectionIntroPanel.BeginningDash.txt");
    private ImportWizardInterface _wizard;
    private LabelView _introLabel;
    private LabelView _selectionsLabel;
    private JPanel _connectionPanel;

    public ImportConnectionIntroPanel(ImportWizardInterface wizard) {
        this._wizard = wizard;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public String getPanelName() {
        return PANEL_NAME;
    }

    public void initialize() {
        String guideLabel;
        String panelLabel;
        this.setHelpProduct("promotion");
        this.setDescription(RB.getStringResource("ImportConnectionIntroPanel.Desc.txt"));
        if (this._wizard instanceof PasteSpecialWizard) {
            this.setHelpTopic("pastespec_aboutmetadatawin");
            panelLabel = RB.getStringResource("ImportConnectionIntroPanel.PastePanelsDisplayed.txt");
            guideLabel = RB.getStringResource("ImportConnectionIntroPanel.PasteGuide.txt");
        } else {
            this.setHelpTopic("imp_aboutmetadatawin");
            panelLabel = RB.getStringResource("ImportConnectionIntroPanel.ImportPanelsDisplayed.txt");
            guideLabel = RB.getStringResource("ImportConnectionIntroPanel.ImportGuide.txt");
        }
        Dimension dim = new Dimension(400, -1);
        this._connectionPanel = new JPanel();
        this._introLabel = new LabelView();
        this._introLabel.setLineWrap(true);
        this._introLabel.setWrapStyleWord(true);
        this._introLabel.setPreferredSpanSize(dim);
        this._introLabel.setHorizontalTextPosition(2);
        this._introLabel.setVerticalTextPosition(1);
        this._introLabel.setText(panelLabel);
        this._selectionsLabel = new LabelView();
        this._selectionsLabel.setLineWrap(true);
        this._selectionsLabel.setWrapStyleWord(true);
        this._selectionsLabel.setPreferredSpanSize(dim);
        this._selectionsLabel.setHorizontalTextPosition(2);
        this._selectionsLabel.setVerticalTextPosition(1);
        this._selectionsLabel.setText(guideLabel);
    }

    public void layoutWidgets() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 10, true, true, true);
        this.setLayout((LayoutManager)layout);
        this.add((Component)this._introLabel);
        AutoSizingGridLayout connectionLayout = new AutoSizingGridLayout(0, 1, 0, 0, true, true, true);
        this._connectionPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        this._connectionPanel.setLayout((LayoutManager)connectionLayout);
        this.add(this._connectionPanel);
        this.add((Component)this._selectionsLabel);
        this.add(new JPanel());
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this._connectionPanel.removeAll();
            List promptingTypes = (List)((AbstractPromotionWizard)((Object)this._wizard)).getWizardData("CONNECTION_PANELS");
            int size = promptingTypes == null ? 0 : promptingTypes.size();
            for (int i = 0; i < size; ++i) {
                ConnectionTypeInterface dependentType;
                PromptingTypeInterface promptingType = (PromptingTypeInterface)promptingTypes.get(i);
                String typeName = promptingType.getLocalizedTypeName();
                if (typeName == null || typeName.length() <= 0) continue;
                if (promptingType instanceof DependentConnectionTypeInterface && (dependentType = ((DependentConnectionTypeInterface)promptingType).getDependentType()) != null) {
                    typeName = Message.format((ResourceBundle)RB.getResources(), (String)"ImportConnectionIntroPanel.DependsOn.fmt.txt", (Object)typeName, (Object)dependentType.getLocalizedTypeName());
                }
                this._connectionPanel.add(new JLabel(BEGINNING_DASH + typeName));
            }
        }
        return true;
    }
}

