/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.LoggingUtil;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.visuals.AbstractPromotionWizard;
import com.sas.metadata.promotion.visuals.ExportExecutePanel;
import com.sas.metadata.promotion.visuals.ExportFilePanel;
import com.sas.metadata.promotion.visuals.ExportFinishPanel;
import com.sas.metadata.promotion.visuals.ExportSummaryPanel;
import com.sas.metadata.promotion.visuals.ExportTreePanel;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.Images;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;

public class ExportWizard
extends AbstractPromotionWizard
implements ExportWizardInterface {
    private Tree _parentFolder;
    private SoftwareComponent _bipService;
    private SimpleLogicalObjectInterface[] _logicalObjects;
    private PublicObjectContainerInterface _container;
    private List<PublicObjectInterface> _publicObjects;
    private ExportHandler _exportHandler;
    private ExportFinishPanel _finishPanel;
    private boolean _initialized = false;

    private ExportWizard(List<String> supportedTypes, String title) {
        super(supportedTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("ExportWizard.Title.txt");
        }
        this.setTitle(this._title);
    }

    public ExportWizard(PublicObjectContainerInterface container, List<String> supportedTypes, String title) {
        this(supportedTypes, title);
        this._container = container;
        this.initializePanels();
    }

    public ExportWizard(List<PublicObjectInterface> publicObjects, List<String> supportedTypes, String title) {
        this(supportedTypes, title);
        this._publicObjects = publicObjects;
        this.initializePanels();
    }

    public static ImageIcon getExportIcon() {
        return Images.getExportIcon();
    }

    @Override
    protected void initializePanels() {
        Workspace workspace = Workspace.getWorkspace();
        boolean exportingFolders = true;
        try {
            if (this._isOldStylePromotion) {
                this.convertToPublicObjectModel();
            }
            if (this._publicObjects != null) {
                exportingFolders = this.isExportingFolders(this._publicObjects);
            } else if (this._container != null && !SASFoldersUtil.isFolder((PublicObjectInterface)this._container)) {
                exportingFolders = false;
            }
            if (this._container != null) {
                this._exportHandler = new ExportHandler(this._container, (List<String>)this._supportedTypes, 0);
            } else if (this._publicObjects != null) {
                this._exportHandler = new ExportHandler(this._publicObjects, (List<String>)this._supportedTypes, 0);
            } else {
                return;
            }
            String value = System.getProperty("promotion.apply.locprop");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                this._exportHandler.getPropertiesManager().setProcessLocalizableProperties(true, true);
            }
            if (workspace.getWorkspaceFile() != null) {
                this._exportHandler.setProfileName(workspace.getWorkspaceFile().getFileName());
            }
            this._exportHandler.setSessionContext(workspace.getSessionContext(), true);
            this._log = Log.getInstance(ExportWizard.class.getName());
            this._logFileName = this._log.getLogFileName();
            this.addWizardData("LOGFILE", this._logFileName);
            LoggingUtil.logServerInformation(workspace.getUserContext(), this._log, true);
            this._initialized = true;
        }
        catch (ServiceException e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = RB.getStringResource("ExportWizard.InitializationError.txt");
            }
            if (this._log != null) {
                this._log.error(msg);
                this._log.debug((Object)"Initialization error", e);
            }
            MessageUtil.displayServiceExceptionMessage((ServiceException)e);
            return;
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = RB.getStringResource("ExportWizard.InitializationError.txt");
            }
            if (this._log != null) {
                this._log.error(msg);
                this._log.debug((Object)"Initialization error", e);
            }
            MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("Common.Error.txt"), (int)0, (int)-1);
            return;
        }
        ExportFilePanel filePanel = new ExportFilePanel(this);
        filePanel.setFoldersSelected(exportingFolders);
        this.addTab(ExportFilePanel.PANEL_TITLE, "FilePanel", (WAPropertyTab)filePanel, false);
        this.addTab(ExportTreePanel.PANEL_TITLE, "TreePanel", (WAPropertyTab)new ExportTreePanel(this), false);
        this.addTab(ExportSummaryPanel.PANEL_TITLE, "SummaryPanel", (WAPropertyTab)new ExportSummaryPanel(this), false);
        this.addTab(ExportExecutePanel.PANEL_TITLE, "ExecutePanel", (WAPropertyTab)new ExportExecutePanel(this), false);
        this._finishPanel = new ExportFinishPanel(this);
        this.addTab(ExportFinishPanel.PANEL_TITLE, "FinishPanel", (WAPropertyTab)this._finishPanel, true);
        this.setupTransitions();
    }

    private void convertToPublicObjectModel() throws ServiceException, RemoteException {
        Workspace workspace = Workspace.getWorkspace();
        OMIServer server = workspace.getConnectionManager().getMetadataServer();
        ObjectConverter converter = ObjectConverter.getInstance();
        if (this._logicalObjects != null) {
            PublicObjectInterface[] objects = converter.convertToPublicObjects(this._logicalObjects, (ServerInterface)server);
            this._publicObjects = Arrays.asList(objects);
        } else if (this._parentFolder != null) {
            String key = this._parentFolder.getId() + "/" + this._parentFolder.getCMetadataType();
            FolderInterface folder = (FolderInterface)server.fetch(key, true);
            if (folder == null) {
                throw new ServiceException("Unable to retrieve folder from the server.");
            }
            this._container = folder;
        } else if (this._bipService != null) {
            this._container = server.getRootFolder();
        }
    }

    @Override
    protected void setupTransitions() {
        String[][] transitions = new String[][]{{"FilePanel", "NEXT", "TreePanel"}, {"TreePanel", "NEXT", "SummaryPanel"}, {"SummaryPanel", "NEXT", "ExecutePanel"}, {"ExecutePanel", "NEXT", "FinishPanel"}};
        this._model.addTransitions(transitions);
    }

    @Override
    protected WAPanel getFinishPanel() {
        return this._finishPanel;
    }

    @Override
    protected void cleanUp(boolean cancelling) {
        if (cancelling) {
            this._log.info(RB.getStringResource("ImportWizard.Cancel.Log.txt"));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._exportHandler.dispose();
        this.m_wizardData.clear();
        if (Workspace.isDebug()) {
            try {
                MdFactory factory = Workspace.getMdFactory();
                factory.dumpDetailHashMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public ExportHandler getExportHandler() {
        return this._exportHandler;
    }

    public void setPackageFileName(String fileName) {
        this.addWizardData("PACKAGE_FILE_NAME", fileName);
    }

    public String getPackageFileName() {
        if (this._exportHandler == null) {
            return null;
        }
        File packageFile = this._exportHandler.getPackageFile();
        return packageFile == null ? null : packageFile.getAbsolutePath();
    }

    public void show() {
        if (this._exportHandler == null || !this._initialized) {
            return;
        }
        if (this.getDescription() == null) {
            this.setDescription(RB.getStringResource("ExportWizard.Desc.txt"));
        }
        super.show();
    }

    private boolean isExportingFolders(List<PublicObjectInterface> publicObjects) throws ServiceException, RemoteException {
        for (PublicObjectInterface publicObject : publicObjects) {
            TypeDescriptorInterface type = publicObject.getTypeDescriptor();
            if (type == null || !"Folder".equalsIgnoreCase(type.getTypeName())) continue;
            return true;
        }
        return false;
    }

    private ExportWizard(TypeInterface[] availableTypes, String title) {
        super(availableTypes, title);
        if (title == null) {
            this._title = RB.getStringResource("ExportWizard.Title.txt");
        }
        this.setTitle(this._title);
    }

    public ExportWizard(Tree parentFolder, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._parentFolder = parentFolder;
        this.initializePanels();
    }

    public ExportWizard(SoftwareComponent bipService, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._bipService = bipService;
        this.initializePanels();
    }

    public ExportWizard(SimpleLogicalObjectInterface[] logicalObjects, TypeInterface[] availableTypes, String title) {
        this(availableTypes, title);
        this._logicalObjects = logicalObjects;
        this.initializePanels();
    }
}

