/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.visuals.AbstractObjectOptionsPanel;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;

public class ExportObjectOptionsPanel
extends AbstractObjectOptionsPanel {
    private ExportOperationInterface _exportOperation;

    public ExportObjectOptionsPanel(ExportOperationInterface operation) {
        this._exportOperation = operation;
    }

    @Override
    public PromotionOptionsInterface getOptionsInterface(String publicType) {
        TransportableTypeInterface type = this._exportOperation.getTransportableType(publicType);
        ExportListener listener = (ExportListener)type.getExportListener();
        if (listener instanceof PromotionOptionsInterface) {
            return (PromotionOptionsInterface)((Object)listener);
        }
        return null;
    }

    private List<ExportItemInterface> getPromotionItems(TreeNodeInterface[] nodes) throws ServiceException, RemoteException {
        ArrayList<ExportItemInterface> exportItems = new ArrayList<ExportItemInterface>();
        for (int index = 0; index < nodes.length; ++index) {
            ExportItemInterface exportItem;
            ExportElementInterface exportElement;
            PublicObjectNodeInterface poNode;
            TreeNodeInterface treeNode = nodes[index];
            if (!(treeNode instanceof ExportTreeNodeInterface) || (poNode = ((ExportTreeNodeInterface)treeNode).getPublicObjectNode()) == null || (exportElement = (ExportElementInterface)poNode.getProcessorInterface("com.sas.metadata.promotion.model.ExportElementInterface")) == null || (exportItem = exportElement.getExportItem()) == null) continue;
            exportItems.add(exportItem);
        }
        return exportItems;
    }

    @Override
    public JPanel getOptionsPanel(PromotionOptionsInterface options, TreeNodeInterface[] nodes) throws ServiceException, RemoteException {
        List<ExportItemInterface> items = this.getPromotionItems(nodes);
        if (items == null || items.isEmpty()) {
            return null;
        }
        ExportItemInterface[] exportItems = items.toArray(new ExportItemInterface[items.size()]);
        return options.getOptionsPanel(exportItems, this._exportOperation);
    }
}

