/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.visuals.search.DateFilterComponent;
import com.sas.metadata.logical.visuals.search.DefaultAdvancedFilterDialog;
import com.sas.metadata.logical.visuals.search.DefaultFilterDialog;
import com.sas.metadata.logical.visuals.search.ExtendedAttributesFilterComponent;
import com.sas.metadata.logical.visuals.search.FilterComponentInterface;
import com.sas.metadata.logical.visuals.search.KeywordsFilterComponent;
import com.sas.metadata.logical.visuals.search.NameFilterComponent;
import com.sas.metadata.logical.visuals.search.NotesFilterComponent;
import com.sas.metadata.logical.visuals.search.PublicTypeFilterComponent;
import com.sas.metadata.logical.visuals.search.ResponsibilitiesFilterComponent;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.AbstractFilePanel;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.services.information.search.SearchFilter;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAWizardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ExportFilePanel
extends AbstractFilePanel {
    public static final String PANEL_NAME = "FilePanel";
    public static final String PANEL_TITLE = RB.getStringResource("ExportFilePanel.Title.txt");
    private static char[] INVALID_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '|'};
    String _packagePath;
    private JPanel _optionsPanel;
    private JPanel _filterPanel;
    private JCheckBox _dependenciesCheckBox;
    private JCheckBox _includeFoldersCheckBox;
    private JButton _filterButton;
    private WATextField _filterText;
    private JLabel _filterLabel;
    private DefaultFilterDialog _filterDialog;
    private String _previousFileNameValue = null;
    private boolean _previousDependenciesValue;
    private boolean _previousIncludeEmptyFolders;
    private List<SearchFilter> _previousFilterValue;

    public ExportFilePanel(ExportWizardInterface wizard) {
        super(wizard);
        this._wizard = wizard;
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public void initialize() {
        this.setHelpProduct("promotion");
        this.setHelpTopic("exp_pkgnamewin");
        this.setDescription(this._wizard.getDescription());
        this.setText(RB.getStringResource("ExportFilePanel.Label.txt"));
        super.initialize();
        this._optionsPanel = new JPanel();
        TitledBorder title = BorderFactory.createTitledBorder(RB.getStringResource("ExportFilePanel.BorderTitle.txt"));
        this._optionsPanel.setBorder(title);
        this._filterPanel = new JPanel();
        this._filterPanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("ExportFilePanel.Filter.BorderTitle.txt")));
        Font labelFont = UIManager.getFont("Label.font");
        this._dependenciesCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._dependenciesCheckBox, (String)RB.getStringResource("ExportFilePanel.DependenciesCheckBox.txt"));
        this._includeFoldersCheckBox = new JCheckBox();
        Util.configureMnemonicForButton((AbstractButton)this._includeFoldersCheckBox, (String)RB.getStringResource("ExportFilePanel.IncludeFolders.txt"));
        this._includeFoldersCheckBox.setSelected(false);
        this._filterText = new WATextField(RB.getStringResource("ExportFilePanel.NoFilters.txt"));
        this._filterText.setBehavior(2);
        this._filterLabel = new JLabel();
        this._filterLabel.setFont(labelFont);
        this._filterLabel.setText(RB.getStringResource("ExportFilePanel.FilterLabel.txt"));
        this._filterButton = new JButton();
        Util.configureMnemonicForButton((AbstractButton)this._filterButton, (String)RB.getStringResource("ExportFilePanel.FilterButton.txt"));
        this._filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportFilePanel.this.onOpenFilterDialog();
            }
        });
    }

    @Override
    public void layoutWidgets() {
        super.layoutWidgets();
        JPanel exportPanel = new JPanel();
        exportPanel.setLayout(new GridBagLayout());
        this._optionsPanel.setLayout(new GridBagLayout());
        this._optionsPanel.add((Component)this._includeFoldersCheckBox, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 0, LayoutConstants.EMPTY_INSETS, 0, 0));
        this._optionsPanel.add((Component)this._dependenciesCheckBox, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this._filterPanel.setLayout(new GridBagLayout());
        this._filterPanel.add((Component)this._filterText, new GridBagConstraints(0, 0, -1, 1, 1.0, 0.0, 18, 1, new Insets(5, 2, 5, 0), 0, 0));
        this._filterPanel.add((Component)this._filterButton, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        exportPanel.add((Component)this._optionsPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        exportPanel.add((Component)this._filterPanel, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 1, new Insets(5, 0, 5, 0), 0, 5));
        this.add(exportPanel);
        this.add(new JPanel());
    }

    public void setFoldersSelected(boolean exportingFolders) {
        if (!exportingFolders) {
            this._includeFoldersCheckBox.setEnabled(false);
            this._filterButton.setEnabled(false);
        }
    }

    @Override
    public void setText(String text) {
        this._labelText = text;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (!bSaveToModel) {
            this.setDescription(this._wizard.getDescription());
            this.setInitialFileName();
        }
        return true;
    }

    @Override
    protected void setInitialFileName() {
        String fileName = (String)this._wizard.getWizardData("PACKAGE_FILE_NAME");
        if (fileName != null) {
            this._fileText.setText(fileName);
        } else {
            fileName = this.getUniquePackageName();
            String previousFileName = ExportFilePanel.getPreviousFileName();
            if (fileName != null) {
                this._fileText.setText(fileName);
            } else if (previousFileName != null && previousFileName.length() > 0) {
                this._fileText.setText(previousFileName);
            }
        }
    }

    public boolean validateData() {
        String message;
        int stateOfDialog;
        String fileName = this.getSelectedFileName();
        try {
            PromotionUtil.validatePackageFileName(fileName, true);
        }
        catch (IllegalArgumentException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (String)RB.getStringResource("Common.Error.txt"), (int)0, (int)-1);
            this._fileText.requestFocus();
            return false;
        }
        File file = new File(fileName);
        if (file.exists() && ((stateOfDialog = MessageUtil.displayMessage((String)(message = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFilePanel.FileExists.txt", (Object)fileName)), (String)RB.getStringResource("Common.Overwrite.txt"), (int)2, (int)0)) == 1 || stateOfDialog == -1)) {
            this._fileText.requestFocus();
            return false;
        }
        this._fileName = fileName;
        this.setCurrentDirectory(this._fileName);
        ExportHandler handler = ((ExportWizardInterface)this._wizard).getExportHandler();
        handler.setExportFile(file);
        handler.setIncludeDependencies(this._dependenciesCheckBox.isSelected());
        Boolean selected = this._includeFoldersCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        this._wizard.addWizardData("INCLUDE_EMPTY_FOLDERS", selected);
        if (this.isModified()) {
            this.setPreviousValues();
            this._wizard.addWizardData("POPULATE_TREE_MODEL", Boolean.TRUE);
        } else {
            this._wizard.addWizardData("POPULATE_TREE_MODEL", Boolean.FALSE);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isModified() {
        if (this._previousFileNameValue == null) {
            return true;
        }
        if (this._previousIncludeEmptyFolders != this._includeFoldersCheckBox.isSelected()) {
            return true;
        }
        if (this._previousDependenciesValue != this._dependenciesCheckBox.isSelected()) {
            return true;
        }
        List filterList = (List)this._wizard.getWizardData("FILTERS");
        if (filterList != null && this._previousFilterValue != null) {
            if (filterList.size() != this._previousFilterValue.size()) return true;
            for (int index = 0; index < filterList.size(); ++index) {
                SearchFilter filter1 = (SearchFilter)filterList.get(index);
                SearchFilter filter2 = this._previousFilterValue.get(index);
                if (filter1 == null || filter1.equals((Object)filter2)) continue;
                return true;
            }
            return false;
        } else {
            if ((filterList != null || this._previousFilterValue == null || this._previousFilterValue.size() <= 0) && (filterList == null || filterList.size() <= 0 || this._previousFilterValue != null)) return false;
            return true;
        }
    }

    private void setPreviousValues() {
        this._previousFileNameValue = this._fileName;
        this._previousDependenciesValue = this._dependenciesCheckBox.isSelected();
        this._previousIncludeEmptyFolders = this._includeFoldersCheckBox.isSelected();
        List filterList = (List)this._wizard.getWizardData("FILTERS");
        this._previousFilterValue = filterList == null ? null : new ArrayList(filterList);
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    protected boolean validateFileName(String fileName) {
        for (int i = 0; i < INVALID_CHARACTERS.length; ++i) {
            if (fileName.indexOf(INVALID_CHARACTERS[i]) == -1) continue;
            return false;
        }
        return true;
    }

    protected String getUniquePackageName() {
        int index = 1;
        String fileName = null;
        File packageFile = null;
        while (packageFile == null || packageFile.exists()) {
            String name = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFilePanel.PackageFileName.txt", (Object)index);
            fileName = this.getAbsoluteFileName(name);
            packageFile = new File(fileName);
            if (++index <= 999) continue;
            break;
        }
        return fileName;
    }

    private String getAbsoluteFileName(String name) {
        StringBuffer sb = new StringBuffer();
        if (this._currentDirectory != null && this._currentDirectory.length() > 0) {
            sb.append(this._currentDirectory);
            if (!this._currentDirectory.endsWith(FILE_SEPARATOR)) {
                sb.append(FILE_SEPARATOR);
            }
        }
        sb.append(name);
        return sb.toString();
    }

    @Override
    protected String getProperFileName(String path) {
        if (path.endsWith(".spk") || path.endsWith(".spk".toUpperCase())) {
            return path;
        }
        return path + ".spk";
    }

    private void onOpenFilterDialog() {
        try {
            if (this._filterDialog == null) {
                this._filterDialog = new DefaultFilterDialog(RB.getStringResource("ExportFilePanel.FilterTitle.txt"), (Dialog)((WAWizardDialog)this._wizard));
                this._filterDialog.setHelpProduct("promotion");
                this._filterDialog.setHelpTopic("exp_filterwin");
                this._filterDialog.addFilterPanel((FilterComponentInterface)new NameFilterComponent());
                PublicTypeFilterComponent typeFilter = new PublicTypeFilterComponent();
                typeFilter.configurePublicTypes(PromotionUtil.getSupportedTypeValues(((ExportWizardInterface)this._wizard).getExportHandler()));
                this._filterDialog.addFilterPanel((FilterComponentInterface)typeFilter);
                this._filterDialog.addFilterPanel((FilterComponentInterface)new DateFilterComponent());
                DefaultAdvancedFilterDialog advancedDialog = new DefaultAdvancedFilterDialog(RB.getStringResource("ExportFilePanel.AdvancedFilterTitle.txt"), (Dialog)this._filterDialog);
                advancedDialog.setHelpProduct("promotion");
                advancedDialog.setHelpTopic("exp_advfilterwin");
                advancedDialog.addFilterPanel((FilterComponentInterface)new KeywordsFilterComponent());
                advancedDialog.addFilterPanel((FilterComponentInterface)new NotesFilterComponent());
                advancedDialog.addFilterPanel((FilterComponentInterface)new ExtendedAttributesFilterComponent());
                advancedDialog.addFilterPanel((FilterComponentInterface)new ResponsibilitiesFilterComponent());
                this._filterDialog.setDisplayAdvancedFilters(advancedDialog);
            }
            this._filterDialog.show();
            this._filterDialog.dispose();
            List filters = this._filterDialog.getFilters();
            if (filters != null && filters.size() > 0) {
                int space = 32;
                StringBuffer sb = new StringBuffer();
                int length = filters.size();
                for (int index = 0; index < length; ++index) {
                    if (index > 0) {
                        if (index == length - 1) {
                            sb.append(' ').append(RB.getStringResource("ExportFilePanel.And.txt")).append(' ');
                        } else {
                            sb.append(RB.getStringResource("ExportFilePanel.Comma.txt")).append(' ');
                        }
                    }
                    SearchFilter filter = (SearchFilter)filters.get(index);
                    sb.append(filter.getFilterType());
                }
                String label = Message.format((ResourceBundle)RB.getResources(), (String)"ExportFilePanel.Filters.txt", (Object)sb.toString());
                this._filterText.setText(label);
                this._filterText.setCaretPosition(0);
            } else {
                this._filterText.setText(RB.getStringResource("ExportFilePanel.NoFilters.txt"));
            }
            this._wizard.addWizardData("FILTERS", filters);
        }
        catch (Exception e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }
}

