/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.visuals.AbstractExecutePanel;
import com.sas.metadata.promotion.visuals.ExportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.services.TransportException;
import com.sas.text.Message;
import java.io.IOException;
import java.util.ResourceBundle;

public class ExportExecutePanel
extends AbstractExecutePanel {
    public static final String PANEL_TITLE = RB.getStringResource("ExportExecutePanel.Title.txt");
    private static final String STATUS_EXPORTING_METADATA = RB.getStringResource("ExportExecutePanel.ExportingMetadata.txt");
    private static final String STATUS_EXPORTING_CONTENT = RB.getStringResource("ExportExecutePanel.ExportingContent.txt");
    private static final String STATUS_ANALYZING_CONNECTIONS = RB.getStringResource("ExportExecutePanel.AnalyzingConnections.txt");
    private static final String STATUS_CREATING_PACKAGE = RB.getStringResource("ExportExecutePanel.CreatingPackage.txt");

    public ExportExecutePanel(ExportWizardInterface wizard) {
        super(wizard, wizard.getExportHandler());
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public void initialize() {
        this.setHelpTopic("exportexecutepanel");
        this.setDescription(RB.getStringResource("ExportExecutePanel.Desc.txt"));
        this.addStatusEntry(105, STATUS_EXPORTING_METADATA);
        this.addStatusEntry(110, STATUS_EXPORTING_CONTENT);
        this.addStatusEntry(120, STATUS_ANALYZING_CONNECTIONS);
        this.addStatusEntry(130, STATUS_CREATING_PACKAGE);
        super.initialize();
        this._executionLabel.setText(RB.getStringResource("ExportExecutePanel.Exporting.txt"));
    }

    @Override
    public String getPanelTitle() {
        return PANEL_TITLE;
    }

    @Override
    public AbstractExecutePanel.ExecutionThread createExecutionThread() {
        return new ExportThread();
    }

    class ExportThread
    extends AbstractExecutePanel.ExecutionThread {
        ExportThread() {
        }

        @Override
        public void launchOperation() {
            try {
                String packageFile = ExportExecutePanel.this._operation.getPackageFile().getAbsolutePath();
                VisualsUtil.setPreviousPackageFileName(packageFile);
                this._rc |= ((ExportHandler)ExportExecutePanel.this._operation).runExport();
            }
            catch (MetadataPromotionException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ExportExecutePanel.MetadataError.fmt.txt", (Object)msg));
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"MetadataException", (Throwable)((Object)e));
                }
            }
            catch (TransportException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ExportExecutePanel.ExportContentError.fmt.txt", (Object)msg));
                }
            }
            catch (IOException e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ExportExecutePanel.ExportContentError.fmt.txt", (Object)msg));
                }
            }
            catch (OutOfMemoryError e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    this._log.error(RB.getStringResource("ExportExecutePanel.MemoryError.txt"));
                }
            }
            catch (Exception e) {
                this._rc |= 8;
                if (this._log.isErrorEnabled()) {
                    String msg = e.getMessage() == null ? e.toString() : e.getMessage();
                    this._log.error(Message.format((ResourceBundle)RB.getResources(), (String)"ExportExecutePanel.GenericError.fmt.txt", (Object)msg));
                }
                this._log.debug((Object)"GenericException", e);
            }
            finally {
                if (this._log.isInfoEnabled()) {
                    if ((this._rc & 8) > 0) {
                        this._log.info(RB.getStringResource("ExportExecutePanel.FinishedError.txt"));
                    } else if ((this._rc & 4) > 0) {
                        this._log.info(RB.getStringResource("ExportExecutePanel.FinishedWarning.txt"));
                    } else {
                        this._log.info(RB.getStringResource("ExportExecutePanel.FinishedSuccess.txt"));
                    }
                }
            }
        }
    }
}

