/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;

class ErrorTrackingManager {
    public static final int NOT_FOUND = -1;
    public static final Pattern DEFAULT_ERROR_PATTERN = Pattern.compile("^" + Level.ERROR.toString() + "\\s+");
    public static final Pattern DEFAULT_WARNING_PATTERN = Pattern.compile("^" + Level.WARN.toString() + "\\s+");
    private static final String TIMESTAMP_REGEX = "^((19|20|21)\\d\\d)-((0?[1-9])|(1[0-2]))-((0?[1-9])|(1\\d)|(2\\d)|(3[0-1])) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\s";
    private static final String ERROR_REGEX_WITH_TIMESTAMPS = "^((19|20|21)\\d\\d)-((0?[1-9])|(1[0-2]))-((0?[1-9])|(1\\d)|(2\\d)|(3[0-1])) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\s" + Level.ERROR.toString() + "\\s+";
    private static final String WARNING_REGEX_WITH_TIMESTAMPS = "^((19|20|21)\\d\\d)-((0?[1-9])|(1[0-2]))-((0?[1-9])|(1\\d)|(2\\d)|(3[0-1])) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]\\s" + Level.WARN.toString() + "\\s+";
    public static final Pattern ERROR_PATTERN_WITH_TIMESTAMPS = Pattern.compile(ERROR_REGEX_WITH_TIMESTAMPS);
    public static final Pattern WARNING_PATTERN_WITH_TIMESTAMPS = Pattern.compile(WARNING_REGEX_WITH_TIMESTAMPS);
    private Pattern _errorPattern = DEFAULT_ERROR_PATTERN;
    private Pattern _warningPattern = DEFAULT_WARNING_PATTERN;
    private List<Integer> _indexList;

    ErrorTrackingManager() {
    }

    public void setErrorMessageRegex(Pattern pattern) {
        this._errorPattern = pattern;
    }

    public void setWarningMessageRegex(Pattern pattern) {
        this._warningPattern = pattern;
    }

    public int getNextErrorOrWarning(int currentPos) {
        if (this._indexList != null && !this._indexList.isEmpty()) {
            for (Integer index : this._indexList) {
                if (currentPos >= index || currentPos >= index) continue;
                return index;
            }
        }
        return -1;
    }

    public int getPreviousErrorOrWarning(int currentPos) {
        if (this._indexList != null && !this._indexList.isEmpty()) {
            for (int i = this._indexList.size() - 1; i >= 0; --i) {
                Integer index = this._indexList.get(i);
                if (currentPos <= index || currentPos <= index) continue;
                return index;
            }
        }
        return -1;
    }

    public int getTotalCount() {
        return this._indexList != null ? this._indexList.size() : 0;
    }

    protected boolean isErrorMessage(String text, int pos) {
        Matcher m;
        if (this._errorPattern != null && (m = this._errorPattern.matcher(text)).find()) {
            if (this._indexList == null) {
                this._indexList = new ArrayList<Integer>();
            }
            this._indexList.add(pos);
            return true;
        }
        return false;
    }

    protected boolean isWarningMessage(String text, int pos) {
        Matcher m;
        if (this._warningPattern != null && (m = this._warningPattern.matcher(text)).find()) {
            if (this._indexList == null) {
                this._indexList = new ArrayList<Integer>();
            }
            this._indexList.add(pos);
            return true;
        }
        return false;
    }

    public static enum Direction {
        UP,
        DOWN;

    }
}

