/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.ProgressBarLauncher;
import com.sas.metadata.promotion.visuals.ProgressReturnCode;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.workspace.MessageUtil;

public class DependencyAnalyzer
extends ProgressBarLauncher {
    public DependencyAnalyzer(ImportWizardInterface wizard) {
        super(wizard, wizard.getImportHandler());
    }

    @Override
    public String getMessage() {
        return RB.getStringResource("DependencyAnalyzer.Message.txt");
    }

    @Override
    public String getTitle() {
        return RB.getStringResource("DependencyAnalyzer.TitleBar.txt");
    }

    @Override
    protected String getMessagePrefix() {
        return "";
    }

    public boolean analyze() {
        this.launch(new DependencyRunnable());
        String errorMessage = this.getReturnCode().getErrorMessage();
        if (errorMessage != null) {
            MessageUtil.displayMessage((String)errorMessage, (String)RB.getStringResource("ImportWizard.Error.txt"), (int)0, (int)-1);
            return false;
        }
        int code = this.getReturnCode().getReturnCode();
        if ((code & 4) > 0 || (code & 8) > 0) {
            String message;
            String string = message = code == 4 ? RB.getStringResource("DependencyAnalyzer.WarningsBeforeImport.txt") : RB.getStringResource("DependencyAnalyzer.ErrorsBeforeImport.txt");
            if (!this.displayDetailsMessage(message)) {
                return false;
            }
        }
        return true;
    }

    class DependencyRunnable
    implements Runnable {
        DependencyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProgressReturnCode rc = DependencyAnalyzer.this.getReturnCode();
            try {
                int returnCode = ((ImportHandler)DependencyAnalyzer.this._promotionHandler).fireAnalyzeObjects();
                rc.setReturnCode(returnCode);
                DependencyAnalyzer.this._wizard.replaceWizardData("STATUS", new Integer(returnCode));
            }
            catch (MetadataPromotionException e) {
                rc.setErrorMessage(e.getMessage());
                DependencyAnalyzer.this._log.debug((Object)"AnalyzeObjects", (Throwable)((Object)e));
            }
            catch (Exception e) {
                String msg = RB.getStringResource("ImportTreePanel.GenericError.txt") + e.getLocalizedMessage();
                if (DependencyAnalyzer.this._log.isErrorEnabled()) {
                    DependencyAnalyzer.this._log.error(msg);
                }
                rc.setErrorMessage(msg);
                DependencyAnalyzer.this._log.debug((Object)"AnalyzeObjects", e);
            }
            finally {
                DependencyAnalyzer.this.displayMessage(null);
            }
        }
    }
}

