/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.visuals.properties.AbstractPropertiesModel;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.remote.MdException;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;

public class DefaultExportPropertiesModel
extends AbstractPropertiesModel {
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(2, 2);
    protected static final int ROOT_PROPERTIES_COUNT = 6;
    protected int _indexType;
    protected int _indexName;
    protected int _indexDesc;
    protected int _indexPath;
    protected int _indexUpdated;
    protected int _indexCreated;
    protected Object[] _tempValues;
    protected PublicObjectNodeInterface _node;

    public DefaultExportPropertiesModel(PublicObjectNodeInterface node) {
        this._node = node;
        this._tempValues = new Object[this.getNumberOfProperties()];
    }

    protected void initializePropertyIndexes() {
        this._indexType = 0;
        this._indexName = 1;
        this._indexDesc = 2;
        this._indexPath = 3;
        this._indexUpdated = 4;
        this._indexCreated = 5;
    }

    protected void initializeProperties() {
        this.setProperty(this._indexType, RB.getStringResource("DefaultExportPropertiesModel.Type.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexName, RB.getStringResource("DefaultExportPropertiesModel.Name.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexDesc, RB.getStringResource("DefaultExportPropertiesModel.Description.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexPath, RB.getStringResource("DefaultExportPropertiesModel.Folder.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexUpdated, RB.getStringResource("DefaultExportPropertiesModel.DateUpdated.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
        this.setProperty(this._indexCreated, RB.getStringResource("DefaultExportPropertiesModel.DateCreated.txt"), null, DefaultExportPropertiesModel.getDefaultRenderer());
    }

    public int getNumberOfProperties() {
        return 6;
    }

    public void populate() throws MdException, RemoteException {
    }

    public void loadPropertyValues() throws MdException, RemoteException {
        if (this._node != null) {
            try {
                this._tempValues[this._indexType] = this._node.getTypeDescriptor() == null ? "" : this._node.getTypeDescriptor().getType();
                this._tempValues[this._indexPath] = this._node.getDisplayPath();
                DetailsProcessorInterface details = (DetailsProcessorInterface)this._node.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
                if (details != null) {
                    Date createdDate;
                    this._tempValues[this._indexName] = details.getDisplayName();
                    this._tempValues[this._indexDesc] = details.getDescription();
                    Date modifiedDate = details.getModifyDate();
                    if (modifiedDate != null) {
                        this._tempValues[this._indexUpdated] = DATE_FORMAT.format(modifiedDate);
                    }
                    if ((createdDate = details.getCreateDate()) != null) {
                        this._tempValues[this._indexCreated] = DATE_FORMAT.format(createdDate);
                    }
                } else {
                    this._tempValues[this._indexName] = this._node.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updatePropertyValues() throws MdException, RemoteException {
        for (int i = 0; i < this.getNumberOfProperties(); ++i) {
            this.setPropertyValue(i, this._tempValues[i]);
        }
    }
}

