/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableType2Interface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.ObjectConverter;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.model.ExportModelConfiguration;
import com.sas.metadata.promotion.model.ModelFactory;
import com.sas.metadata.promotion.visuals.CopyListListener;
import com.sas.metadata.promotion.visuals.ErrorTrackingManager;
import com.sas.metadata.promotion.visuals.LogViewerDialog;
import com.sas.metadata.promotion.visuals.PasteSpecialWizard;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.ReturnCode;
import com.sas.metadata.remote.MdFactory;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.Workspace;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class CopyPasteUtil {
    private static List _copyList = new ArrayList();
    private static List _copyListListeners = new ArrayList();
    private static Map<String, String> _objectsImportedMap;
    private static String _logFileName;
    private static boolean _isDebugEnabled;

    public static void copy(SimpleLogicalObjectInterface[] logicalObjects) {
        Workspace workspace = Workspace.getWorkspace();
        workspace.setCursor(Cursor.getPredefinedCursor(3));
        if (CopyPasteUtil.isCopyAllowed(logicalObjects)) {
            _copyList.clear();
            int length = logicalObjects.length;
            for (int i = 0; i < length; ++i) {
                _copyList.add(logicalObjects[i]);
            }
            CopyPasteUtil.fireCopyListChanged();
        }
        workspace.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static boolean isCopyAllowed(SimpleLogicalObjectInterface[] logicalObjects) {
        if (logicalObjects == null || logicalObjects.length == 0) {
            return false;
        }
        for (SimpleLogicalObjectInterface item : logicalObjects) {
            if (item instanceof FolderInterface) continue;
            TypeInterface type = item.getTypeInterface();
            if (type == null) {
                return false;
            }
            if (type instanceof TransportableType2Interface && !((TransportableType2Interface)type).isCopyAllowed()) {
                return false;
            }
            if (type instanceof TransportableTypeInterface) continue;
            return false;
        }
        return true;
    }

    public static void clearCopyList() {
        _copyList.clear();
        CopyPasteUtil.fireCopyListChanged();
    }

    public static List getCopyList() {
        return Collections.unmodifiableList(_copyList);
    }

    public static void removeItemFromCopyList(SimpleLogicalObjectInterface logicalObject) {
        if (_copyList.contains(logicalObject)) {
            _copyList.remove(logicalObject);
            CopyPasteUtil.fireCopyListChanged();
        }
    }

    public static void addCopyListListener(CopyListListener lsnr) {
        if (!_copyListListeners.contains(lsnr)) {
            _copyListListeners.add(lsnr);
        }
    }

    public static void removeCopyListListener(CopyListListener lsnr) {
        if (_copyListListeners.contains(lsnr)) {
            _copyListListeners.remove(lsnr);
        }
    }

    public static Map<String, String> getObjectsPasted() {
        return _objectsImportedMap;
    }

    public static boolean objectsWerePasted() {
        return _objectsImportedMap != null && _objectsImportedMap.size() > 0;
    }

    public static boolean isPasteAllowed() {
        return _copyList != null && _copyList.size() != 0;
    }

    public static void pasteSpecial(FolderInterface targetFolder) {
        CopyPasteUtil.pasteSpecialInternal(targetFolder, null, null);
    }

    public static void pasteSpecial(FolderInterface targetFolder, TypeInterface[] availableTypes) {
        CopyPasteUtil.pasteSpecialInternal(targetFolder, availableTypes, null);
    }

    public static void pasteSpecial(FolderInterface targetFolder, TypeInterface[] availableTypes, String reposID) {
        CopyPasteUtil.pasteSpecialInternal(targetFolder, availableTypes, reposID);
    }

    private static void pasteSpecialInternal(FolderInterface targetDestination, TypeInterface[] availableTypes, String reposID) {
        if (CopyPasteUtil.isPasteAllowed()) {
            _objectsImportedMap = null;
            SimpleLogicalObjectInterface[] selectedObjects = _copyList.toArray(new SimpleLogicalObjectInterface[0]);
            try {
                MdFactory factory = Workspace.getMdFactory();
                if (reposID == null && targetDestination != null && !targetDestination.isRoot()) {
                    PromotionUtil.isFolderWriteAuthorized(factory, targetDestination.getID());
                }
                CopyPasteUtil.importObjectsIntoRootCheck((SimpleLogicalObjectInterface)targetDestination, selectedObjects);
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                CopyPasteUtil.displayErrorDialogNoDetails(msg, 0);
                return;
            }
            PasteSpecialWizard wizard = new PasteSpecialWizard(targetDestination, selectedObjects, availableTypes, RB.getStringResource("PasteSpecialWizard.Title.txt"));
            if (reposID != null) {
                wizard.changeRepositoryID(reposID);
            }
            wizard.show();
            _objectsImportedMap = wizard.getTargetObjectIDs();
        }
    }

    public static void paste(FolderInterface targetFolder) {
        CopyPasteUtil.pasteInternal(targetFolder, null, null);
    }

    public static void paste(FolderInterface targetFolder, TypeInterface[] availableTypes) {
        CopyPasteUtil.pasteInternal(targetFolder, availableTypes, null);
    }

    public static void paste(FolderInterface targetFolder, TypeInterface[] availableTypes, String reposID) {
        CopyPasteUtil.pasteInternal(targetFolder, availableTypes, reposID);
    }

    private static void pasteInternal(final FolderInterface targetDestination, final TypeInterface[] availableTypes, final String reposID) {
        if (CopyPasteUtil.isPasteAllowed()) {
            _objectsImportedMap = null;
            String message = CopyPasteUtil.isRootFolder((SimpleLogicalObjectInterface)targetDestination) ? RB.getStringResource("CopyPasteUtil.CopyingObjects.txt") : Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.ProgressCopyToFolder.txt", (Object)targetDestination.getName());
            final Workspace workspace = Workspace.getWorkspace();
            OpRequestUI request = new OpRequestUI((Frame)workspace, message, RB.getStringResource("CopyPasteUtil.ProgressCopyTitle.txt"));
            request.setMessagePreferredSize(new Dimension(250, 20));
            request.setDelayBeforeProgressCancelDialog(1000);
            final ReturnCode rc = new ReturnCode();
            Runnable pasteRunnable = new Runnable(){

                @Override
                public void run() {
                    CopyPasteUtil.runPaste(workspace, targetDestination, availableTypes, reposID, rc);
                }
            };
            request.execute(pasteRunnable);
            String error = rc.getErrorMessage();
            if (error != null) {
                if (rc.getDisplayDetails()) {
                    CopyPasteUtil.displayErrorDialog(error, rc.getReturnCode(), _logFileName);
                } else {
                    CopyPasteUtil.displayErrorDialogNoDetails(error, rc.getReturnCode());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runPaste(Workspace workspace, FolderInterface targetDestination, TypeInterface[] availableTypes, String reposID, ReturnCode rc) {
        File packageFile = null;
        _logFileName = null;
        try {
            MdFactory factory = Workspace.getMdFactory();
            if (reposID == null && targetDestination != null && !targetDestination.isRoot()) {
                PromotionUtil.isFolderWriteAuthorized(factory, targetDestination.getID());
            }
            SimpleLogicalObjectInterface[] selectedObjects = _copyList.toArray(new SimpleLogicalObjectInterface[0]);
            CopyPasteUtil.importObjectsIntoRootCheck((SimpleLogicalObjectInterface)targetDestination, selectedObjects);
            packageFile = File.createTempFile("CopyPaste", ".spk");
            Map exportedObjects = CopyPasteUtil.runExport(factory, selectedObjects, availableTypes, packageFile, rc);
            if (exportedObjects != null && exportedObjects.size() > 0) {
                CopyPasteUtil.runImport(factory, targetDestination, availableTypes, packageFile, reposID, rc);
            }
            String message = null;
            int returnCode = rc.getReturnCode();
            if ((returnCode & 8) > 0) {
                message = RB.getStringResource("CopyPasteUtil.ErrorsOccurred.txt");
            } else if ((returnCode & 4) > 0) {
                message = RB.getStringResource("CopyPasteUtil.WarningsOccurred.txt");
            }
            if (message != null) {
                rc.setErrorMessage(message);
                rc.setDisplayDetails(true);
            }
        }
        catch (Exception e) {
            String message = null;
            if (packageFile != null) {
                rc.setDisplayDetails(true);
                message = Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.GenericErrorWithDetails.fmt.txt", (Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            } else {
                message = Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.GenericError.fmt.txt", (Object)(e.getMessage() == null ? e.toString() : e.getMessage()));
            }
            rc.setErrorMessage(message);
            rc.setReturnCode(8);
        }
        finally {
            if (packageFile != null) {
                packageFile.delete();
            }
        }
    }

    private static Map runExport(MdFactory factory, SimpleLogicalObjectInterface[] selectedObjects, TypeInterface[] availableTypes, File packageFile, ReturnCode rc) throws Exception {
        ExportHandler exportHandler = new ExportHandler(factory, selectedObjects, 2, availableTypes);
        PropertiesManager propManager = exportHandler.getPropertiesManager();
        propManager.setProcessLocalizableProperties(false, false);
        propManager.setProcessSubstitutionProperties(false, false);
        exportHandler.setExportFile(packageFile);
        int returnCode = rc.getReturnCode();
        _logFileName = exportHandler.getLogger().getLogFileName();
        _isDebugEnabled = exportHandler.getLogger().isDebugEnabled();
        boolean exceptionOccurred = false;
        try {
            LinkedHashMap items;
            exportHandler.setSessionContext(UtilPlatformServices.getSessionContext(), true);
            Log log = exportHandler.getLogger();
            log.info(RB.getStringResource("CopyPasteUtil.Begin.txt"));
            ExportFolderModelInterface model = ModelFactory.createExportFolderModel(exportHandler);
            ExportModelConfiguration config = (ExportModelConfiguration)model.getConfiguration();
            config.setDisplayEmptyFolders(true);
            config.setAllowFolderExport(false);
            config.setDisplayUnknownObjects(false);
            ObjectConverter converter = ObjectConverter.getInstance();
            PublicObjectInterface[] publicObjects = converter.convertToPublicObjects(selectedObjects, exportHandler.getServer());
            exportHandler.loadObjectsToExport(publicObjects, null, model);
            exportHandler.runExport();
            LinkedHashMap linkedHashMap = items = new LinkedHashMap(exportHandler.getExportItems());
            return linkedHashMap;
        }
        catch (Exception e) {
            exceptionOccurred = true;
            returnCode |= 8;
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            Log log = exportHandler.getLogger();
            log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.CopyError.txt", (Object)message));
            throw e;
        }
        finally {
            Log log = exportHandler.getLogger();
            if (log.isInfoEnabled()) {
                if ((returnCode & 8) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportError.txt"));
                } else if ((returnCode & 4) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportWarning.txt"));
                } else {
                    log.info(RB.getStringResource("CopyPasteUtil.ExportSuccess.txt"));
                }
            }
            exportHandler.dispose();
            if (exceptionOccurred && (log = exportHandler.getLogger()) != null) {
                log.destroy();
            }
            rc.setReturnCode(returnCode);
        }
    }

    private static void runImport(MdFactory factory, FolderInterface targetDestination, TypeInterface[] availableTypes, File packageFile, String reposID, ReturnCode rc) throws Exception {
        ImportHandler importHandler = new ImportHandler(factory, targetDestination, 2, availableTypes);
        PropertiesManager propManager = importHandler.getPropertiesManager();
        propManager.setProcessLocalizableProperties(false, false);
        propManager.setProcessSubstitutionProperties(false, false);
        if (reposID != null) {
            importHandler.changeRepositoryID(reposID);
        }
        int returnCode = rc.getReturnCode();
        try {
            importHandler.setSessionContext(UtilPlatformServices.getSessionContext(), true);
            importHandler.loadExportPackage(packageFile);
            if (importHandler.isProjectRepository()) {
                importHandler.importSecurityMetadata(false);
            } else {
                importHandler.importSecurityMetadata(true);
            }
            importHandler.loadObjectsToImport(false);
            returnCode |= importHandler.fireAnalyzeObjects();
            returnCode |= importHandler.runImport(1);
        }
        catch (Exception e) {
            returnCode |= 8;
            String message = e.getMessage() == null ? e.toString() : e.getMessage();
            Log log = importHandler.getLogger();
            if (CopyPasteUtil.isRootFolder((SimpleLogicalObjectInterface)targetDestination)) {
                log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.PasteErrorRepos.txt", (Object)message));
            } else {
                log.error(Message.format((ResourceBundle)RB.getResources(), (String)"CopyPasteUtil.PasteError.txt", (Object)targetDestination.getName(), (Object)message));
            }
            throw e;
        }
        finally {
            Log log = importHandler.getLogger();
            if (log.isInfoEnabled()) {
                if ((returnCode & 8) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportError.txt"));
                } else if ((returnCode & 4) > 0) {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportWarning.txt"));
                } else {
                    log.info(RB.getStringResource("CopyPasteUtil.ImportSuccess.txt"));
                }
            }
            _objectsImportedMap = importHandler.getTargetObjectIDs();
            importHandler.dispose();
            rc.setReturnCode(returnCode);
        }
    }

    private static void fireCopyListChanged() {
        for (int i = 0; i < _copyListListeners.size(); ++i) {
            ((CopyListListener)_copyListListeners.get(i)).copyListChanged();
        }
    }

    protected static void displayErrorDialog(final String message, final int status, String fileName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int type;
                String title = status == 4 ? RB.getStringResource("Common.Warning.txt") : RB.getStringResource("Common.Error.txt");
                int option = MessageUtil.displayMessage((String)message, (String)title, (int)(type = status == 4 ? 2 : 0), (int)0);
                if (option == 0) {
                    CopyPasteUtil.displayLog();
                }
            }
        });
    }

    private static void displayLog() {
        if (_logFileName != null) {
            LogViewerDialog viewer = new LogViewerDialog(RB.getStringResource("CopyPasteUtil.LogTitle.txt"), _logFileName, (Frame)Workspace.getWorkspace());
            viewer.setErrorTrackingSupported(true);
            ErrorTrackingManager errorTracking = viewer.getErrorTrackingManager();
            if (_isDebugEnabled) {
                errorTracking.setErrorMessageRegex(ErrorTrackingManager.ERROR_PATTERN_WITH_TIMESTAMPS);
                errorTracking.setWarningMessageRegex(ErrorTrackingManager.WARNING_PATTERN_WITH_TIMESTAMPS);
            }
            viewer.setVisible(true);
        }
    }

    protected static void displayErrorDialogNoDetails(final String message, final int status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String title = status == 4 ? RB.getStringResource("Common.Warning.txt") : RB.getStringResource("Common.Error.txt");
                int type = status == 4 ? 2 : 0;
                MessageUtil.displayMessage((String)message, (String)title, (int)type, (int)-1);
            }
        });
    }

    protected static void importObjectsIntoRootCheck(SimpleLogicalObjectInterface targetDestination, SimpleLogicalObjectInterface[] selectedObjects) throws IllegalStateException {
        if (CopyPasteUtil.isRootFolder(targetDestination)) {
            for (SimpleLogicalObjectInterface logicalObject : selectedObjects) {
                if (logicalObject instanceof FolderInterface) continue;
                throw new IllegalStateException(RB.getStringResource("CopyPasteUtil.ObjectsUnderRoot.txt"));
            }
        }
    }

    private static boolean isRootFolder(SimpleLogicalObjectInterface targetFolder) {
        if (targetFolder instanceof FolderInterface) {
            return ((FolderInterface)targetFolder).isRoot();
        }
        return false;
    }

    static {
        _isDebugEnabled = false;
    }
}

