/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromptingTypeInterface;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.metadata.promotion.connections.MissingResourceConnectionType;
import com.sas.metadata.promotion.connections.SecurityConnectionType;
import com.sas.metadata.promotion.visuals.ImportWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.WizardModel;
import com.sas.metadata.promotion.visuals.WizardPanelInterface;
import com.sas.metadata.promotion.visuals.connections.ConnectionPanelInterface;
import com.sas.metadata.promotion.visuals.connections.PromptingPanelInterface;
import com.sas.metadata.promotion.visuals.connections.SubstitutionPanelInterface;
import com.sas.text.Message;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAWizardDialog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

class ConnectionTransitionHandler {
    private static Map _panelClassMap = new HashMap(5);
    private static Class[] CONNECTION_CONSTRUCTOR_ARGS = new Class[]{ImportOperationInterface.class, ConnectionTypeInterface.class};
    private static Class[] CONNECTION_CONSTRUCTOR_ARGS_DEPTYPE = new Class[]{ImportOperationInterface.class, DependentConnectionTypeInterface.class, Integer.class};
    private static Class[] SUBSTITUTION_CONSTRUCTOR_ARGS = new Class[]{ImportOperationInterface.class, SubstitutionTypeInterface.class, List.class};
    private ImportOperationInterface _importOperation;
    private Log _log;
    private ImportWizardInterface _wizard;
    private WizardModel _model;
    private WizardPanelInterface _startingPanel;
    private PromptingPanelInterface _previousPanel = null;
    private List<PromptingPanelInterface> _panelList;
    private Set<PromptingTypeInterface> _panelNameSet;

    public ConnectionTransitionHandler(ImportWizardInterface wizard) {
        this._wizard = wizard;
        this._importOperation = wizard.getImportHandler();
        this._model = (WizardModel)wizard.getWizardModel();
        this._panelList = new ArrayList<PromptingPanelInterface>();
        this._panelNameSet = new LinkedHashSet<PromptingTypeInterface>();
        this._log = Log.getInstance(ConnectionTransitionHandler.class.getName());
    }

    void setStartingPanel(WizardPanelInterface panel) {
        this._startingPanel = panel;
    }

    public void setTransitions() {
        this.resetTransitions();
        ArrayList<ConnectionTypeInterface> typesList = new ArrayList<ConnectionTypeInterface>();
        try {
            Map<SubstitutionTypeInterface, List<SubstitutionInterface>> typeMap;
            PropertiesManager propManager;
            SecurityConnectionType securityType = ((ImportHandler)this._importOperation).getSecurityConnectionType();
            if (securityType != null && SecurityConnectionType.isConnectionMappingNeeded(this._importOperation)) {
                typesList.add(securityType);
            }
            typesList.add(new MissingResourceConnectionType(this._importOperation));
            if (this._log.isDebugEnabled()) {
                this._log.debug("Checking for connection panels");
            }
            typesList.addAll(this._importOperation.getConnectionTypes());
            for (ConnectionTypeInterface type : typesList) {
                if (type == null || type.getPanelName() == null) continue;
                PromptingPanelInterface panel = null;
                if (type instanceof DependentConnectionTypeInterface) {
                    List connections;
                    DependentConnectionTypeInterface depType = (DependentConnectionTypeInterface)type;
                    DependentConnectionMapping map = depType.getDependentConnectionMapping();
                    if (map == null || (connections = map.getDependentConnections()) == null || connections.size() <= 0) continue;
                    int size = connections.size();
                    for (int index = 0; index < size; ++index) {
                        panel = this.createPanel(depType, index);
                        if (panel == null) continue;
                        this.addPanelToWizard(panel, depType);
                    }
                    continue;
                }
                List<SourceConnectionInterface> connectionPoints = type.getSourceConnections();
                if (connectionPoints == null || connectionPoints.size() <= 0 || (panel = this.createPanel(type)) == null) continue;
                this.addPanelToWizard(panel, type);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("Checking for substitution panels");
            }
            if ((propManager = ((ImportHandler)this._importOperation).getPropertiesManager()) != null && (typeMap = propManager.getSubstitutions()) != null && typeMap.size() > 0) {
                Iterator<SubstitutionTypeInterface> iter = typeMap.keySet().iterator();
                while (iter.hasNext()) {
                    PromptingPanelInterface panel = null;
                    SubstitutionTypeInterface type = iter.next();
                    List<SubstitutionInterface> substitutions = typeMap.get(type);
                    if (substitutions == null || substitutions.size() <= 0 || (panel = this.createPanel(type, substitutions)) == null) continue;
                    this.addPanelToWizard(panel, type);
                }
            }
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ConnectionTransitionHandler.FailureLoadingPanels.fmt.txt", (Object)e.getMessage());
            this._log.error(msg);
            this._log.debug((Object)"Connection Panels", e);
            return;
        }
        if (this._panelList.size() == 0) {
            ((WAPropertyTab)this._startingPanel).setConditionState("FINISH");
            if (this._log.isDebugEnabled()) {
                this._log.debug("No connection or substitution panels to display.");
            }
        } else if (this._previousPanel != null) {
            this._model.removeTransition(this._previousPanel.getPanelName(), "NEXT");
            this._model.addTransition(this._previousPanel.getPanelName(), "NEXT", "ImportSummary");
        }
        this._wizard.replaceWizardData("CONNECTION_PANELS", new ArrayList<PromptingTypeInterface>(this._panelNameSet));
    }

    private void addPanelToWizard(PromptingPanelInterface panel, PromptingTypeInterface type) {
        this._panelList.add(panel);
        this._panelNameSet.add(type);
        ((WAWizardDialog)this._wizard).addTab(panel.getPanelTitle(), panel.getPanelName(), (WAPropertyTab)panel, false);
        if (this._panelList.size() == 1) {
            ((WAPropertyTab)this._startingPanel).setConditionState("CONNECTIONS");
            this._model.removeTransition("ConnectionIntroPanel", "NEXT");
            this._model.addTransition("ConnectionIntroPanel", "NEXT", panel.getPanelName());
        }
        if (this._previousPanel != null) {
            this._model.removeTransition(this._previousPanel.getPanelName(), "NEXT");
            this._model.addTransition(this._previousPanel.getPanelName(), "NEXT", panel.getPanelName());
        }
        this._previousPanel = panel;
    }

    private PromptingPanelInterface createPanel(ConnectionTypeInterface type) throws Exception {
        Class c = this.getPanelClass(type);
        if (c == null) {
            return null;
        }
        Constructor cons = c.getConstructor(CONNECTION_CONSTRUCTOR_ARGS);
        ConnectionPanelInterface panel = (ConnectionPanelInterface)cons.newInstance(this._importOperation, type);
        return panel;
    }

    private PromptingPanelInterface createPanel(DependentConnectionTypeInterface type, int panelIndex) throws Exception {
        Class c = this.getPanelClass(type);
        if (c == null) {
            return null;
        }
        Constructor cons = c.getConstructor(CONNECTION_CONSTRUCTOR_ARGS_DEPTYPE);
        ConnectionPanelInterface panel = (ConnectionPanelInterface)cons.newInstance(this._importOperation, type, panelIndex);
        return panel;
    }

    private PromptingPanelInterface createPanel(SubstitutionTypeInterface type, List substitutions) throws Exception {
        Class c = this.getPanelClass(type);
        if (c == null) {
            return null;
        }
        Constructor cons = c.getConstructor(SUBSTITUTION_CONSTRUCTOR_ARGS);
        SubstitutionPanelInterface panel = (SubstitutionPanelInterface)cons.newInstance(this._importOperation, type, substitutions);
        return panel;
    }

    private Class getPanelClass(PromptingTypeInterface type) throws ClassNotFoundException {
        String panelName = type.getPanelName();
        if (panelName == null) {
            return null;
        }
        Class<?> c = (Class<?>)_panelClassMap.get(panelName);
        if (c == null) {
            c = Class.forName(panelName, true, type.getClass().getClassLoader());
            _panelClassMap.put(panelName, c);
        }
        return c;
    }

    private void resetTransitions() {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Resetting transitions for connection/substitution panels");
        }
        this._model.removeTransition(this._startingPanel.getPanelName(), "NEXT");
        this._model.addTransition(this._startingPanel.getPanelName(), "NEXT", "");
        int len = this._panelList.size();
        for (int i = 0; i < len; ++i) {
            PromptingPanelInterface panel = this._panelList.get(i);
            this._model.removeTransition(panel.getPanelName(), "NEXT");
            this._model.removePanel(panel.getPanelName());
        }
        this._panelList.clear();
        this._panelNameSet.clear();
    }
}

