/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.visuals.PromotionWizardInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.VisualsUtil;
import com.sas.metadata.promotion.visuals.WizardModel;
import com.sas.swing.visuals.util.LayoutConstants;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;

public abstract class AbstractPromotionWizard
extends WAWizardDialog
implements PromotionWizardInterface {
    protected TypeInterface[] _availableTypes;
    protected boolean _isOldStylePromotion = false;
    protected String _title;
    protected String _description;
    protected List<String> _supportedTypes;
    protected WizardModel _model;
    protected Log _log;
    protected String _logFileName = null;
    private boolean _closeable = true;
    private boolean _promptedToClose = false;

    private AbstractPromotionWizard(String title) {
        super((Frame)Workspace.getWorkspace(), null, true, null, false);
        this._title = title;
        this.setHelpProduct("promotion");
        if (!AbstractPromotionWizard.isUsingNewStyle()) {
            Component cmpMain = this.m_pnlWizard.getComponent(1);
            Component cmpSep = this.m_pnlWizard.getComponent(2);
            for (int i = this.m_pnlWizard.getComponentCount() - 1; i >= 0; --i) {
                this.m_pnlWizard.remove(this.m_pnlWizard.getComponent(i));
            }
            this.m_pnlWizard.add(cmpMain, (Object)new GridBagConstraints(1, 0, 3, 3, 1.0, 1.0, 18, 1, LayoutConstants.EMPTY_INSETS, 0, 0));
            this.m_pnlWizard.add(cmpSep, (Object)new GridBagConstraints(0, 3, 4, 1, 1.0, 0.0, 16, 1, new Insets(15, 0, 0, 0), 0, 0));
        }
        this._initialize();
    }

    public AbstractPromotionWizard(List<String> supportedTypes, String title) {
        this(title);
        this._supportedTypes = supportedTypes;
    }

    public AbstractPromotionWizard(TypeInterface[] availableTypes, String title) {
        this(title);
        this._isOldStylePromotion = true;
        this._availableTypes = availableTypes;
        if (availableTypes != null) {
            this._supportedTypes = new ArrayList<String>();
            for (int index = 0; index < this._availableTypes.length; ++index) {
                this._supportedTypes.add(availableTypes[index].getPublicType());
            }
        }
    }

    protected abstract void initializePanels();

    protected abstract void setupTransitions();

    protected abstract void cleanUp(boolean var1);

    protected abstract WAPanel getFinishPanel();

    private void _initialize() {
        this._model = new WizardModel();
        this.setWizardModel((WAWizardModel)this._model);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new DialogWindowListener());
    }

    public List<String> getSupportedTypes() {
        if (this._supportedTypes != null) {
            return new ArrayList<String>(this._supportedTypes);
        }
        return null;
    }

    public TypeInterface[] getAvailableTypes() {
        return this._availableTypes;
    }

    public String getLogFileName() {
        return this._logFileName;
    }

    public void setPreferredSize(Dimension dimension) {
        this.getMainPanel().setPreferredSize(dimension);
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public boolean isCloseable() {
        return this._closeable;
    }

    @Override
    public void setCloseable(boolean closeable) {
        this._closeable = closeable;
    }

    public boolean validateData() {
        return true;
    }

    protected boolean onCancel() {
        try {
            if (!this.isCloseable() || !super.onCancel()) {
                if (this._promptedToClose) {
                    this.setCloseable(true);
                }
                boolean bl = false;
                return bl;
            }
            this.cleanUp(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this._promptedToClose = false;
        }
    }

    protected boolean onFinish() {
        super.setMainPanel(this.getFinishPanel());
        if (!super.onFinish()) {
            return false;
        }
        this.cleanUp(false);
        return true;
    }

    @Override
    public JButton getNextButton() {
        return this.m_btnNext;
    }

    @Override
    public JButton getBackButton() {
        return this.m_btnBack;
    }

    @Override
    public JButton getCancelButton() {
        return this.m_btnCancel;
    }

    @Override
    public JButton getHelpButton() {
        return this.m_btnHelp;
    }

    protected class DialogWindowListener
    extends WindowAdapter {
        protected DialogWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (AbstractPromotionWizard.this.isCloseable()) {
                AbstractPromotionWizard.this._promptedToClose = true;
                int result = VisualsUtil.displayConfirmationDialog(AbstractPromotionWizard.this._title, RB.getStringResource("AbstractPromotionWizard.ExitPrompt.txt"), 3);
                if (result == 0) {
                    AbstractPromotionWizard.this.setCloseable(true);
                } else {
                    AbstractPromotionWizard.this.setCloseable(false);
                }
            }
        }
    }
}

