/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.promotion.visuals.PromotionTreeNodeInterface;
import com.sas.metadata.promotion.visuals.RB;
import com.sas.metadata.promotion.visuals.TreeNodeInterface;
import com.sas.services.ServiceException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AbstractObjectOptionsPanel
extends AbstractPromotionPanel
implements AncestorListener {
    private static final String SELECT_ITEM_LABEL = RB.getStringResource("OptionsPanel.SelectItem.txt");
    private static final String NOT_AVAILABLE_LABEL = RB.getStringResource("OptionsPanel.NotAvailable.txt");
    private JLabel _label;
    private PromotionOptionsInterface _optionsCurrentlyDisplayed;

    public AbstractObjectOptionsPanel() {
        this.initialize();
        this.layoutWidgets();
    }

    public abstract PromotionOptionsInterface getOptionsInterface(String var1);

    public abstract JPanel getOptionsPanel(PromotionOptionsInterface var1, TreeNodeInterface[] var2) throws ServiceException, RemoteException;

    private void initialize() {
        this.addAncestorListener(this);
        this._label = new JLabel();
        Border border = BorderFactory.createEmptyBorder(8, 8, 0, 0);
        this._label.setBorder(border);
    }

    private void layoutWidgets() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public String getLabel() {
        return RB.getStringResource("OptionsPanel.Label.txt");
    }

    @Override
    public void loadComponent(Object sourceData, Object targetData) {
        TreeNodeInterface[] nodes;
        int length;
        this.saveSettings(this._optionsCurrentlyDisplayed);
        boolean itemsSelected = false;
        if (this.getComponentCount() > 0) {
            this.removeAll();
        }
        if (sourceData instanceof TreeNodeInterface[] && (length = (nodes = (TreeNodeInterface[])sourceData).length) > 0) {
            itemsSelected = true;
            try {
                JPanel panel;
                PromotionOptionsInterface options;
                String publicType = this.verifySelectedPublicTypes(nodes);
                if (publicType != null && (options = this.getOptionsInterface(publicType)) != null && (panel = this.getOptionsPanel(options, nodes)) != null) {
                    this.add(panel);
                    this.validate();
                    this.repaint();
                    this._optionsCurrentlyDisplayed = options;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.displayLabel(itemsSelected);
        this.validate();
        this.repaint();
        this._optionsCurrentlyDisplayed = null;
    }

    private void displayLabel(boolean itemsSelected) {
        this._label.setText(itemsSelected ? NOT_AVAILABLE_LABEL : SELECT_ITEM_LABEL);
        this.add((Component)this._label, "North");
    }

    private String verifySelectedPublicTypes(TreeNodeInterface[] nodes) throws ServiceException, RemoteException {
        String previousPublicType = null;
        int len = nodes.length;
        for (int index = 0; index < len; ++index) {
            TreeNodeInterface node = nodes[index];
            if (!(node instanceof PromotionTreeNodeInterface)) continue;
            PromotionTreeNodeInterface ptn = (PromotionTreeNodeInterface)node;
            if (index == 0) {
                previousPublicType = ptn.getObjectType();
                continue;
            }
            if (previousPublicType.equalsIgnoreCase(ptn.getObjectType())) continue;
            previousPublicType = null;
            break;
        }
        return previousPublicType;
    }

    private void saveSettings(PromotionOptionsInterface options) {
        if (options != null) {
            options.saveSettings();
        }
    }

    protected void saveSettings(TreeNodeInterface[] nodes) {
        int length = nodes.length;
        if (length > 0) {
            try {
                PromotionOptionsInterface options;
                String type = this.verifySelectedPublicTypes(nodes);
                if (type != null && (options = this.getOptionsInterface(type)) != null) {
                    this.saveSettings(options);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.saveSettings(this._optionsCurrentlyDisplayed);
    }
}

