/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.visuals;

import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.model.ExportElementInterface;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.visuals.ExportTree;
import com.sas.metadata.promotion.visuals.ExportTreeModelInterface;
import com.sas.metadata.promotion.visuals.ExportTreeNodeInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractExportProcessor
implements Runnable {
    protected ExportTree _tree;

    public AbstractExportProcessor(ExportTree tree) {
        this._tree = tree;
    }

    protected Map<String, List<ExportItemInterface>> processSelectedExportItems(ExportTreeModelInterface treeModel, Object[] selectedItems) throws ServiceException, RemoteException {
        ExportFolderModelInterface model = null;
        if (treeModel instanceof ExportTreeModelInterface) {
            model = treeModel.getExportModel();
        }
        if (model == null) {
            return null;
        }
        LinkedHashMap<String, List<ExportItemInterface>> exportMap = new LinkedHashMap<String, List<ExportItemInterface>>();
        for (Object obj : selectedItems) {
            ExportItemInterface exportItem;
            ExportTreeNodeInterface visualNode;
            PublicObjectNodeInterface node;
            if (!(obj instanceof ExportTreeNodeInterface) || (node = (visualNode = (ExportTreeNodeInterface)obj).getPublicObjectNode()) == null) continue;
            ExportElementInterface exportElement = model.getExportElement((PublicObjectInterface)node);
            if (exportElement != null && (exportItem = exportElement.getExportItem()) != null) {
                this.addExportItem(exportMap, exportItem);
            }
            if (!(node instanceof ContainerNodeInterface)) continue;
            this.populateContainer((ContainerNodeInterface)node, model, exportMap);
        }
        return exportMap;
    }

    protected void populateContainer(ContainerNodeInterface container, ExportFolderModelInterface model, Map<String, List<ExportItemInterface>> exportMap) throws ServiceException, RemoteException {
        if (container != null && !container.isPopulated()) {
            List children = container.getChildren();
            for (PublicObjectNodeInterface child : children) {
                ExportItemInterface exportItem;
                ExportElementInterface exportElement = model.getExportElement((PublicObjectInterface)child);
                if (exportElement != null && (exportItem = exportElement.getExportItem()) != null) {
                    this.addExportItem(exportMap, exportItem);
                }
                if (!(child instanceof ContainerNodeInterface)) continue;
                this.populateContainer((ContainerNodeInterface)child, model, exportMap);
            }
        }
    }

    protected void addExportItem(Map<String, List<ExportItemInterface>> exportMap, ExportItemInterface exportItem) {
        String publicType = exportItem.getTypeInterface().getPublicType();
        List<ExportItemInterface> items = exportMap.get(publicType);
        if (items == null) {
            items = new ArrayList<ExportItemInterface>();
            exportMap.put(publicType, items);
            items.add(exportItem);
        } else if (!items.contains(exportItem)) {
            items.add(exportItem);
        }
    }

    protected List<ExportItemInterface> getExternalDependencies(ExportTreeModelInterface treeModel) throws ServiceException, RemoteException {
        List<ExportTreeNodeInterface> dependentObjectNodes = treeModel.getExternalDependencies();
        if (dependentObjectNodes != null) {
            ArrayList<ExportItemInterface> dependencies = new ArrayList<ExportItemInterface>(dependentObjectNodes.size());
            for (ExportTreeNodeInterface node : dependentObjectNodes) {
                ExportItemInterface exportItem;
                ExportElementInterface exportNode;
                PublicObjectNodeInterface poNode = node.getPublicObjectNode();
                if (poNode == null || (exportNode = (ExportElementInterface)poNode.getProcessorInterface("com.sas.metadata.promotion.model.ExportElementInterface")) == null || (exportItem = exportNode.getExportItem()) == null) continue;
                dependencies.add(exportItem);
            }
            return dependencies;
        }
        return null;
    }
}

