/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.persistence.FinishedParsingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TransportMetadataParser
extends DefaultHandler {
    private static final int OBJECT_LEVEL = 1;
    private Map<String, Map> _mappedObjects;
    private Map<String, PromotionItemInterface> _processingCache;
    private Stack<BaseElement> _elementStack;
    private Document _template;
    private Node _currentTemplateNode;
    private String _currentObjectID = null;
    private int _currentLevel = 0;

    public TransportMetadataParser(List<PromotionItemInterface> importItems, Document template) {
        this._template = template;
        this._elementStack = new Stack();
        this._processingCache = new HashMap<String, PromotionItemInterface>(importItems.size());
        for (PromotionItemInterface item : importItems) {
            this._processingCache.put(item.getID(), item);
        }
        this._mappedObjects = new LinkedHashMap<String, Map>();
    }

    public Map getObjectMap() {
        return new LinkedHashMap<String, Map>(this._mappedObjects);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this._currentLevel == 1) {
            String metadataType;
            this._currentObjectID = null;
            String objectID = attributes.getValue("Id");
            PromotionItemInterface importItem = this._processingCache.get(objectID);
            if (importItem != null && qName.equalsIgnoreCase(metadataType = importItem.getTypeInterface().getMetadataType())) {
                this._currentObjectID = objectID;
                this.processTopLevelObject(importItem, attributes);
            }
        } else if (this._currentLevel > 1 && this._currentObjectID != null) {
            if (attributes == null || attributes.getLength() == 0) {
                this.processAssociation(qName);
            } else {
                this.processObject(qName, attributes);
            }
        }
        ++this._currentLevel;
    }

    private void processAssociation(String nodeName) {
        BaseElement parent = this._elementStack.peek();
        AssocElement element = new AssocElement(nodeName, parent);
        this._elementStack.add(element);
        if (!parent.isContainedInTemplate()) {
            return;
        }
        String elementName = element.getName();
        NodeList childNodes = this._currentTemplateNode.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            for (int index = 0; index < childNodes.getLength(); ++index) {
                Node node = childNodes.item(index);
                if (node.getNodeType() != 1 || !elementName.equalsIgnoreCase(node.getNodeName())) continue;
                element.setContainedInTemplate(true);
                this._currentTemplateNode = node;
                return;
            }
        }
    }

    private void processObject(String nodeName, Attributes objectAttributes) {
        BaseElement parent = this._elementStack.peek();
        ObjectElement element = new ObjectElement(nodeName, parent);
        this._elementStack.add(element);
        if (!parent.isContainedInTemplate()) {
            return;
        }
        String elementName = element.getName();
        NodeList childNodes = this._currentTemplateNode.getChildNodes();
        if (childNodes != null) {
            if (childNodes.getLength() == 0) {
                if (parent instanceof AssocElement) {
                    String id = objectAttributes.getValue("Id");
                    if (id == null) {
                        id = objectAttributes.getValue("ObjRef");
                    }
                    String name = objectAttributes.getValue("Name");
                    Map objectMap = this.createObject(id, name, nodeName);
                    element.setObjectMap(objectMap);
                    ((AssocElement)parent).addObjectMap(objectMap);
                }
            } else {
                for (int index = 0; index < childNodes.getLength(); ++index) {
                    Node node = childNodes.item(index);
                    if (node.getNodeType() != 1 || !elementName.equalsIgnoreCase(node.getNodeName())) continue;
                    element.setContainedInTemplate(true);
                    this._currentTemplateNode = node;
                    if (parent instanceof AssocElement) {
                        String id = objectAttributes.getValue("Id");
                        if (id == null) {
                            id = objectAttributes.getValue("ObjRef");
                        }
                        String name = objectAttributes.getValue("Name");
                        Map objectMap = this.createObject(id, name, nodeName);
                        element.setObjectMap(objectMap);
                        this.processObjectAttributes(objectAttributes, objectMap);
                        ((AssocElement)parent).addObjectMap(objectMap);
                    }
                    return;
                }
            }
        }
    }

    private void processTopLevelObject(PromotionItemInterface importItem, Attributes objectAttributes) {
        Map objectMap = this.createObject(importItem.getID(), importItem.getName(), importItem.getTypeInterface().getMetadataType());
        this._mappedObjects.put(importItem.getID(), objectMap);
        Node node = this._template.getFirstChild();
        if (node == null) {
            throw new IllegalStateException("Invalid object template.");
        }
        this._currentTemplateNode = node.getFirstChild();
        this.processObjectAttributes(objectAttributes, objectMap);
        ObjectElement element = new ObjectElement(importItem.getTypeInterface().getMetadataType(), null);
        element.setObjectMap(objectMap);
        element.setContainedInTemplate(true);
        this._elementStack.push(element);
    }

    private void processObjectAttributes(Attributes objectAttributes, Map objectMap) {
        NamedNodeMap templateAttrs = this._currentTemplateNode.getAttributes();
        if (templateAttrs != null && templateAttrs.getLength() > 0) {
            int length = templateAttrs.getLength();
            for (int index = 0; index < length; ++index) {
                Node templateAttr = templateAttrs.item(index);
                String attrName = templateAttr.getNodeName();
                String attrValue = objectAttributes.getValue(attrName);
                if (attrValue != null) {
                    objectMap.put(attrName, attrValue);
                    continue;
                }
                objectMap.put(attrName, "");
            }
        }
    }

    private Map createObject(String id, String name, String type) {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("MetadataObjectType", type);
        objectMap.put("Id", id);
        objectMap.put("Name", name);
        return objectMap;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        BaseElement element;
        --this._currentLevel;
        if (this._currentLevel == 1) {
            if (this._currentObjectID != null) {
                this._processingCache.remove(this._currentObjectID);
                BaseElement element2 = this._elementStack.pop();
                if (element2 != null && element2.getParent() == null) {
                    this.addMissingAssociations(element2);
                }
            }
            this._elementStack.clear();
            if (this._processingCache.isEmpty()) {
                throw new FinishedParsingException();
            }
        } else if (this._currentLevel > 1 && this._currentObjectID != null && !this._elementStack.isEmpty() && (element = this._elementStack.pop()).isContainedInTemplate()) {
            if (element instanceof AssocElement) {
                BaseElement parent;
                List assocList = ((AssocElement)element).getObjectList();
                if (assocList != null && (parent = element.getParent()) instanceof ObjectElement) {
                    ((ObjectElement)parent).addAssociation(element.getName(), assocList);
                }
            } else if (element instanceof ObjectElement) {
                this.addMissingAssociations(element);
            }
            this._currentTemplateNode = this._currentTemplateNode.getParentNode();
        }
    }

    private void addMissingAssociations(BaseElement element) {
        if (this._currentTemplateNode != null && element.getName().equals(this._currentTemplateNode.getNodeName())) {
            ObjectElement objElement = (ObjectElement)element;
            NodeList childNodes = this._currentTemplateNode.getChildNodes();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                String nodeName;
                Node childNode = childNodes.item(index);
                if (childNode.getNodeType() != 1 || objElement.containsAssociation(nodeName = childNode.getNodeName())) continue;
                objElement.addAssociation(nodeName, Collections.emptyList());
            }
        }
    }

    private class BaseElement {
        protected String _name;
        protected boolean _contained = false;
        protected BaseElement _parent;

        public BaseElement(String name, BaseElement parentElement) {
            this._name = name;
            this._parent = parentElement;
        }

        public String getName() {
            return this._name;
        }

        public boolean isContainedInTemplate() {
            return this._contained;
        }

        public void setContainedInTemplate(boolean contained) {
            this._contained = contained;
        }

        public BaseElement getParent() {
            return this._parent;
        }

        public int getLevel() {
            int level = 0;
            for (BaseElement parent = this.getParent(); parent != null; parent = parent.getParent()) {
                ++level;
            }
            return level;
        }
    }

    private class AssocElement
    extends BaseElement {
        private List _objectList;

        public AssocElement(String name, BaseElement parentElement) {
            super(name, parentElement);
        }

        public List getObjectList() {
            return this._objectList;
        }

        public void addObjectMap(Map objectMap) {
            if (this._objectList == null) {
                this._objectList = new ArrayList();
            }
            this._objectList.add(objectMap);
        }

        public String toString() {
            return "Association: " + this.getName();
        }
    }

    private class ObjectElement
    extends BaseElement {
        protected Map _objectMap;

        public ObjectElement(String name, BaseElement parentElement) {
            super(name, parentElement);
        }

        public void setObjectMap(Map objectMap) {
            this._objectMap = objectMap;
        }

        public Map getObjectMap() {
            return this._objectMap;
        }

        public void addAssociation(String associationName, List objectList) {
            if (this._objectMap != null) {
                this._objectMap.put(associationName, objectList);
            }
        }

        public boolean containsAssociation(String associationName) {
            return this._objectMap == null ? false : this._objectMap.containsKey(associationName);
        }

        public String toString() {
            return "Object: " + this.getName();
        }
    }
}

