/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TemplateParser
extends DefaultHandler {
    String _extractXML = null;
    List _connectionsList = null;
    Map<String, Integer> _objectIDMap = null;
    Map<String, List<Integer>> _predIDMap = null;
    Map<String, List<Integer>> _succIDMap = null;
    int _assocSearchBegin;
    int _assocSearchEnd;
    static final String TEMPLATE = "Template";
    List _assocStackList = null;
    List _objectStackList = null;
    int _level = 0;
    List _promotionItemsList = null;
    int _numObjects = 0;
    int _numParents = 0;
    Map _mappedObjects;
    boolean _process = false;

    public TemplateParser(List promotionItems, String extractXML, List connections) {
        this._extractXML = extractXML;
        this._connectionsList = connections;
        this._mappedObjects = new LinkedHashMap(this._numObjects);
        this._promotionItemsList = promotionItems;
        this._numObjects = this._promotionItemsList == null ? 0 : this._promotionItemsList.size();
        this._assocStackList = new ArrayList(this._numObjects);
        this._objectStackList = new ArrayList(this._numObjects);
        for (int i = 0; i < this._numObjects; ++i) {
            Stack stack = new Stack();
            this._assocStackList.add(stack);
            ArrayList objects = new ArrayList();
            this._objectStackList.add(objects);
        }
        this._assocSearchBegin = this._extractXML.indexOf("<MdAssoc", 0);
        this._assocSearchEnd = this._extractXML.lastIndexOf("</TransportXml>", this._extractXML.length());
        this._objectIDMap = new HashMap<String, Integer>();
        this.loadObjectsInExtractFile();
        this._predIDMap = new HashMap<String, List<Integer>>();
        this._succIDMap = new HashMap<String, List<Integer>>();
        this.loadAssociationsInExtractFile();
    }

    public void dispose() {
        this._extractXML = null;
        if (this._predIDMap != null) {
            this._predIDMap.clear();
            this._predIDMap = null;
        }
        if (this._succIDMap != null) {
            this._succIDMap.clear();
            this._succIDMap = null;
        }
        if (this._assocStackList != null) {
            this._assocStackList.clear();
            this._assocStackList = null;
        }
        if (this._objectStackList != null) {
            this._objectStackList.clear();
            this._objectStackList = null;
        }
    }

    public Map getObjectMap() {
        return this._mappedObjects;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this._process && qName.equalsIgnoreCase(TEMPLATE)) {
            this._process = true;
            return;
        }
        if (this._process) {
            if (this._level < 0) {
                return;
            }
            if (!this.isEven(this._level)) {
                this.processAssociation(qName);
            } else {
                this.processObject(qName, attributes);
            }
            ++this._level;
        }
    }

    private void processAssociation(String qName) {
        for (int i = 0; i < this._numObjects; ++i) {
            Object stackObj;
            List objects = (List)this._objectStackList.get(i);
            if (objects.size() <= 0 || !((stackObj = objects.get(objects.size() - 1)) instanceof List)) continue;
            List list = (List)stackObj;
            int count = list.size();
            ArrayList<StackAssocProperty> assocsToAddToStack = new ArrayList<StackAssocProperty>(count);
            for (int j = 0; j < count; ++j) {
                Object obj = list.get(j);
                StackAssocProperty prop = null;
                if (obj instanceof List) {
                    prop = new StackAssocProperty(qName, (List)obj, this._level);
                } else if (obj instanceof Map) {
                    prop = new StackAssocProperty(qName, (Map)obj, this._level);
                }
                if (prop == null) continue;
                assocsToAddToStack.add(prop);
            }
            ((Stack)this._assocStackList.get(i)).push(assocsToAddToStack);
        }
    }

    private void processObject(String qName, Attributes attributes) {
        if (this._level == 0) {
            String[] attributesToFind = this.getAttributeNames(attributes);
            for (int i = 0; i < this._numObjects; ++i) {
                PromotionItemInterface item = (PromotionItemInterface)this._promotionItemsList.get(i);
                if (item == null || item.getTypeInterface() == null) continue;
                Map objectMap = this.createObject(item.getTypeInterface().getMetadataType(), item.getID(), item.getName());
                if (attributesToFind != null) {
                    this.getAttributesForObject(objectMap, attributesToFind);
                }
                this._mappedObjects.put(item.getID(), objectMap);
                ArrayList<Map> itemsToAddToStack = new ArrayList<Map>(1);
                itemsToAddToStack.add(objectMap);
                this.addObjectToStack(itemsToAddToStack, i);
            }
        } else {
            String[] attributesToFind = this.getAttributeNames(attributes);
            for (int i = 0; i < this._numObjects; ++i) {
                Stack stack = (Stack)this._assocStackList.get(i);
                if (stack.size() <= 0) continue;
                List assocs = (List)stack.get(stack.size() - 1);
                int assocSize = assocs.size();
                ArrayList<List> itemsToAddToStack = new ArrayList<List>(assocSize);
                for (int assocIndex = 0; assocIndex < assocSize; ++assocIndex) {
                    StackAssocProperty prop = (StackAssocProperty)assocs.get(assocIndex);
                    if (prop == null) continue;
                    prop.setEmpty(false);
                    Map parent = prop.getParentMap();
                    if (parent != null) {
                        List objects = this.getAssociationsInExtractFile(prop.getAssocName(), (String)parent.get("Id"), attributesToFind, qName);
                        String assocName = prop.getAssocName();
                        if (parent.containsKey(assocName)) {
                            List existingObjects = (List)parent.get(assocName);
                            existingObjects.addAll(objects);
                        } else {
                            parent.put(prop.getAssocName(), objects);
                        }
                        itemsToAddToStack.add(objects);
                        continue;
                    }
                    List parents = prop.getParentObjectList();
                    int parentsSize = parents.size();
                    for (int j = 0; j < parentsSize; ++j) {
                        List objects;
                        String assocName;
                        parent = (Map)parents.get(j);
                        if (parent.containsKey(assocName = prop.getAssocName())) {
                            objects = this.getAssociationsInExtractFile(assocName, (String)parent.get("Id"), attributesToFind, qName);
                            List items = (List)parent.get(assocName);
                            items.addAll(objects);
                        } else {
                            objects = this.getAssociationsInExtractFile(assocName, (String)parent.get("Id"), attributesToFind, qName);
                            parent.put(assocName, objects);
                        }
                        itemsToAddToStack.add(objects);
                    }
                }
                this.addObjectToStack(itemsToAddToStack, i);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._level == 0) {
            if (this._process && qName.equalsIgnoreCase(TEMPLATE)) {
                this._process = false;
                return;
            }
        } else {
            if (this.isEven(this._level)) {
                for (int i = 0; i < this._numObjects; ++i) {
                    Stack stack = (Stack)this._assocStackList.get(i);
                    if (stack.size() <= 0) continue;
                    List list = (List)stack.pop();
                    for (int index = 0; index < list.size(); ++index) {
                        StackAssocProperty prop = (StackAssocProperty)list.get(index);
                        if (!prop.isEmpty()) continue;
                        Map parent = prop.getParentMap();
                        if (parent != null) {
                            List objects = this.getAssociationsInExtractFile(prop.getAssocName(), (String)parent.get("Id"), null, null);
                            parent.put(prop.getAssocName(), objects);
                            continue;
                        }
                        List parents = prop.getParentObjectList();
                        for (int j = 0; j < parents.size(); ++j) {
                            parent = (Map)parents.get(j);
                            List objects = this.getAssociationsInExtractFile(prop.getAssocName(), (String)parent.get("Id"), null, null);
                            parent.put(prop.getAssocName(), objects);
                        }
                    }
                }
            } else {
                for (int i = 0; i < this._numObjects; ++i) {
                    List objects = (List)this._objectStackList.get(i);
                    int size = objects.size();
                    if (size <= 0 || this._level <= size) continue;
                    objects.remove(size - 1);
                }
            }
            --this._level;
        }
    }

    private String[] getAttributeNames(Attributes attributes) {
        int attrLength = attributes.getLength();
        if (attrLength > 0) {
            String[] attributesToFind = new String[attrLength];
            for (int i = 0; i < attrLength; ++i) {
                attributesToFind[i] = attributes.getQName(i);
            }
            return attributesToFind;
        }
        return null;
    }

    private void getAttributesForObject(Map objectMap, String[] attributesToFind) {
        String id = (String)objectMap.get("Id");
        Integer index = this._objectIDMap.get(id);
        if (index != null) {
            int lineBegin = index;
            int lineEnd = this._extractXML.indexOf(62, lineBegin);
            String line = this._extractXML.substring(lineBegin, lineEnd);
            int typeEnd = line.indexOf(32, 0);
            String type = line.substring(1, typeEnd);
            String objectType = (String)objectMap.get("Type");
            if (objectType != null && !type.equalsIgnoreCase(objectType)) {
                return;
            }
            if (attributesToFind != null && attributesToFind.length > 0) {
                for (int i = 0; i < attributesToFind.length; ++i) {
                    String attrName = attributesToFind[i];
                    int attrStart = line.indexOf(" " + attrName + "=\"", 0);
                    if (attrStart > -1 && attrStart < line.length()) {
                        int offset = attrName.length() + 3;
                        int attrEnd = line.indexOf(34, attrStart + offset);
                        String attrValue = line.substring(attrStart + offset, attrEnd);
                        objectMap.put(attrName, attrValue);
                        continue;
                    }
                    objectMap.put(attrName, "");
                }
            }
        }
    }

    protected void addObjectToStack(Object input, int num) {
        List list = (List)this._objectStackList.get(num);
        if (list != null) {
            if (list.size() <= this._level) {
                list.add(input);
            } else {
                list.set(this._level, input);
            }
        }
    }

    private boolean isEven(int number) {
        return number % 2 == 0;
    }

    private List getAssociationsInExtractFile(String associationType, String associatedObjectID, String[] attributes, String objectType) {
        List<Integer> succIndex;
        ArrayList<Map> objectsList = new ArrayList<Map>();
        String searchString = this._extractXML.substring(this._assocSearchBegin, this._assocSearchEnd);
        List<Integer> predIndex = this._predIDMap.get(associatedObjectID);
        if (predIndex != null) {
            int size = predIndex.size();
            for (int i = 0; i < size; ++i) {
                int endIndex;
                int index = predIndex.get(i);
                String assoc = null;
                int startIndex = searchString.indexOf("SuccRole=\"", index) + 10;
                assoc = searchString.substring(startIndex, endIndex = searchString.indexOf(34, startIndex));
                if (assoc == null || !assoc.equalsIgnoreCase(associationType)) continue;
                String oppositeID = null;
                startIndex = searchString.indexOf("SuccId=\"", index) + 8;
                oppositeID = searchString.substring(startIndex, endIndex = searchString.indexOf(34, startIndex));
                Map map = this.getObjectInExtractFile(oppositeID, attributes, objectType);
                if (map == null) continue;
                objectsList.add(map);
            }
        }
        if ((succIndex = this._succIDMap.get(associatedObjectID)) != null) {
            int size = succIndex.size();
            for (int i = 0; i < size; ++i) {
                int endIndex;
                int index = succIndex.get(i);
                String assoc = null;
                int startIndex = searchString.indexOf("PredRole=\"", index) + 10;
                assoc = searchString.substring(startIndex, endIndex = searchString.indexOf(34, startIndex));
                if (assoc == null || !assoc.equalsIgnoreCase(associationType)) continue;
                String oppositeID = null;
                startIndex = searchString.indexOf("PredId=\"", index) + 8;
                oppositeID = searchString.substring(startIndex, endIndex = searchString.indexOf(34, startIndex));
                Map map = this.getObjectInExtractFile(oppositeID, attributes, objectType);
                if (map == null) continue;
                objectsList.add(map);
            }
        }
        return objectsList;
    }

    private void loadAssociationsInExtractFile() {
        String searchString = this._extractXML.substring(this._assocSearchBegin, this._assocSearchEnd);
        int index = -1;
        int lineStart = 0;
        while ((index = searchString.indexOf("\" ", lineStart)) > -1) {
            int predEnd;
            Integer start = new Integer(lineStart);
            int predStart = searchString.indexOf(34, index + 1) + 1;
            String predID = searchString.substring(predStart, predEnd = searchString.indexOf(34, predStart + 1));
            List<Integer> value = this._predIDMap.get(predID);
            if (value == null) {
                value = new ArrayList<Integer>();
                value.add(start);
                this._predIDMap.put(predID, value);
            } else {
                value.add(start);
                this._predIDMap.put(predID, value);
            }
            int succStart = searchString.indexOf(34, predEnd + 1) + 1;
            int succEnd = searchString.indexOf(34, succStart + 1);
            String succID = searchString.substring(succStart, succEnd);
            value = this._succIDMap.get(succID);
            if (value == null) {
                value = new ArrayList<Integer>();
                value.add(start);
                this._succIDMap.put(succID, value);
            } else {
                value.add(start);
                this._succIDMap.put(succID, value);
            }
            if ((lineStart = searchString.indexOf(60, succEnd)) != -1) continue;
            break;
        }
    }

    private void loadObjectsInExtractFile() {
        String idSearchString = this._extractXML.substring(0, this._assocSearchBegin);
        int index = -1;
        int fromIndex = 0;
        while ((index = idSearchString.indexOf("Id=\"", fromIndex)) > -1) {
            int lineBegin = idSearchString.lastIndexOf(60, index);
            int idEnd = idSearchString.indexOf(34, index + 4);
            String id = idSearchString.substring(index + 4, idEnd);
            this._objectIDMap.put(id, new Integer(lineBegin));
            fromIndex = idSearchString.indexOf(62, index + 4);
        }
    }

    private Map getObjectInExtractFile(String id, String[] attributes, String objectType) {
        Map map;
        block4: {
            block5: {
                map = null;
                Integer index = this._objectIDMap.get(id);
                if (index == null) break block5;
                int lineBegin = index;
                int lineEnd = this._extractXML.indexOf(62, lineBegin);
                String line = this._extractXML.substring(lineBegin, lineEnd);
                int typeEnd = line.indexOf(32, 0);
                String type = line.substring(1, typeEnd);
                if (objectType != null && !type.equalsIgnoreCase(objectType)) {
                    return null;
                }
                int nameStart = line.indexOf(" Name=\"", typeEnd) + 7;
                int nameEnd = line.indexOf(34, nameStart);
                String name = line.substring(nameStart, nameEnd);
                map = this.createObject(type, id, name);
                if (attributes == null || attributes.length <= 0) break block4;
                for (int i = 0; i < attributes.length; ++i) {
                    String attrName = attributes[i];
                    int attrStart = line.indexOf(" " + attrName + "=\"", 0);
                    if (attrStart > -1 && attrStart < line.length()) {
                        int offset = attrName.length() + 3;
                        int attrEnd = line.indexOf(34, attrStart + offset);
                        String attrValue = line.substring(attrStart + offset, attrEnd);
                        map.put(attrName, attrValue);
                        continue;
                    }
                    map.put(attrName, "");
                }
                break block4;
            }
            int size = this._connectionsList.size();
            for (int i = 0; i < size; ++i) {
                ConnectionPointInterface pt = (ConnectionPointInterface)this._connectionsList.get(i);
                if (!id.equalsIgnoreCase(pt.getSourceID()) || objectType == null || !objectType.equalsIgnoreCase(pt.getMetadataType())) continue;
                map = this.createObject(pt.getMetadataType(), id, pt.getName());
                break;
            }
        }
        return map;
    }

    private Map createObject(String type, String id, String name) {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("MetadataObjectType", type);
        objectMap.put("Id", id);
        objectMap.put("Name", name);
        return objectMap;
    }

    private class StackAssocProperty {
        private boolean _isEmpty = true;
        private int _level = 0;
        private Map _parentMap = null;
        private List _parentObjectList = null;
        private String _assocName = null;

        public StackAssocProperty(String name, Map parent, int level) {
            this._assocName = name;
            this._parentMap = parent;
            this._level = level;
        }

        public StackAssocProperty(String name, List parent, int level) {
            this._assocName = name;
            this._parentObjectList = parent;
            this._level = level;
        }

        public int getLevel() {
            return this._level;
        }

        public String getAssocName() {
            return this._assocName;
        }

        public Map getParentMap() {
            return this._parentMap;
        }

        public List getParentObjectList() {
            return this._parentObjectList;
        }

        public void setEmpty(boolean b) {
            this._isEmpty = b;
        }

        public boolean isEmpty() {
            return this._isEmpty;
        }
    }
}

