/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandler;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedImportItemInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.persistence.AbstractImportMetadataManager;
import com.sas.metadata.promotion.persistence.ImportMetadataManagementInterface;
import com.sas.metadata.promotion.persistence.ParsingConstants;
import com.sas.metadata.promotion.persistence.PersistenceUtil;
import com.sas.metadata.promotion.persistence.RB;
import com.sas.metadata.promotion.persistence.TemplateParser;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.util.UsageVersion;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class ImportMetadataManager_920
extends AbstractImportMetadataManager
implements ImportMetadataManagementInterface {
    protected static final String METADATA_EXPORT_FILE_NAME = "MetadataExport.xml";
    private Document _deployMapDocument = null;
    private String _exportXML = null;
    private Set<String> _identityNameCache = null;

    public ImportMetadataManager_920(ImportOperationInterface operation) {
        super(operation);
    }

    @Override
    public void loadPackageMetadata() throws MetadataPromotionException {
        this.readDeployMap();
        this.processConnections();
    }

    protected void readDeployMap() throws MetadataPromotionException {
        try {
            Document deployMapDocument = this.getDeployMapDocument();
            if (deployMapDocument != null) {
                NodeList reposList = deployMapDocument.getElementsByTagName("ReposMap");
                this.loadRepositoryMap(reposList.item(0));
                NodeList objectsList = deployMapDocument.getElementsByTagName("Objects");
                this.readPublicObjects(objectsList.item(0));
                this.unloadDeployMapDocument();
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
    }

    private void readPublicObjects(Node objectNode) throws ServiceException, RemoteException {
        if (objectNode != null) {
            NodeList nodes = objectNode.getChildNodes();
            this._publicObjectMap = new HashMap();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                this.parsePublicObject(node, true);
            }
        }
    }

    private void loadRepositoryMap(Node reposNode) {
        if (reposNode != null) {
            NodeList nodes = reposNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                NamedNodeMap attributes;
                Node idNode;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || (idNode = (attributes = node.getAttributes()).getNamedItem("Id")) == null) continue;
                String reposID = idNode.getNodeValue();
                this._repositoryMap.put(reposID, null);
            }
        }
    }

    protected String getPublicTypeForObject(NamedNodeMap attributes) {
        Node publicTypeNode = attributes.getNamedItem("PublicType");
        return publicTypeNode == null ? null : publicTypeNode.getNodeValue();
    }

    private ImportItemInterface parsePublicObject(Node node, boolean isTopLevel) throws ServiceException, RemoteException {
        ImportItemInterface item;
        NamedNodeMap attributes = node.getAttributes();
        Node idNode = attributes.getNamedItem("Id");
        Node nameNode = attributes.getNamedItem("Name");
        if (idNode == null || nameNode == null) {
            return null;
        }
        String type = this.getPublicTypeForObject(attributes);
        if (type == null) {
            return null;
        }
        String id = idNode.getNodeValue();
        String name = nameNode.getNodeValue();
        ImportItemInterface importItemInterface = item = isTopLevel ? this.createImportItem(name, type, id) : this.createNestedItem(name, type, id);
        if (item != null && item instanceof DefaultImportItem) {
            Node indexNode;
            Node searchNode;
            Node descNode;
            Node versionNode;
            DefaultImportItem promotionItem = (DefaultImportItem)item;
            this.addPromotionItem(promotionItem);
            this.loadNestedItems(node, promotionItem);
            if (promotionItem.getUsageVersion() == null && (versionNode = attributes.getNamedItem("UsageVersion")) != null) {
                double ver = Double.parseDouble(versionNode.getNodeValue());
                promotionItem.setUsageVersion(UsageVersion.decode((double)ver));
            }
            if (promotionItem.getDescription() == null && (descNode = attributes.getNamedItem("Desc")) != null) {
                promotionItem.setDescription(descNode.getNodeValue());
            }
            if (isTopLevel && (promotionItem.getSourcePath() == null || promotionItem.getSourcePath().length == 0) && (searchNode = attributes.getNamedItem("Search")) != null) {
                String[] sourcePath = null;
                boolean isFolder = "Folder".equalsIgnoreCase(type);
                List<String> folderPath = BIPTreeUtil.getParentFolderList(searchNode.getNodeValue(), isFolder);
                if (folderPath.size() == 0 && !"Folder".equals(type)) {
                    if (PromotionUtil.isTypeContainedByFolder(type)) {
                        promotionItem.setOrphaned(true);
                        sourcePath = new String[]{"##ORPHANED_SOURCE_FOLDER##"};
                    } else if (SASFoldersUtil.isContainedByVirtualFolder((String)type, (ServerInterface)this._operation.getServer())) {
                        String defaultPath = VirtualFolderManager.getDefaultPath((String)type);
                        List<String> pathList = BIPTreeUtil.getFolderPathAsList(defaultPath);
                        sourcePath = pathList.toArray(new String[pathList.size()]);
                    }
                } else {
                    sourcePath = folderPath.toArray(new String[folderPath.size()]);
                }
                promotionItem.setSourcePath(sourcePath);
                if ("Folder".equalsIgnoreCase(type)) {
                    String parentFolder;
                    if (this._identityNameCache == null) {
                        this._identityNameCache = this._userFolderManager.getIdentityNamesOnServer();
                    }
                    if (this._identityNameCache.contains(name)) {
                        this._userFolderManager.cacheUserFolderInfo(id, "Home Folder", name);
                    } else if (sourcePath.length >= 2 && this._identityNameCache.contains(parentFolder = sourcePath[sourcePath.length - 1])) {
                        String myFolderName = this._userFolderManager.getUserFolderNameOnServer("My Folder", parentFolder);
                        if (myFolderName.equals(name)) {
                            this._userFolderManager.cacheUserFolderInfo(id, "My Folder", parentFolder);
                        } else {
                            String appDataFolderName = this._userFolderManager.getUserFolderNameOnServer("Application Data", parentFolder);
                            if (appDataFolderName.equals(name)) {
                                this._userFolderManager.cacheUserFolderInfo(id, "Application Data", parentFolder);
                            }
                        }
                    }
                }
            }
            if ((indexNode = attributes.getNamedItem("TLObjN")) != null) {
                String sID = indexNode.getNodeValue();
                this._publicObjectMap.put(sID, promotionItem);
            }
        } else if (isTopLevel) {
            this.addUnsupportedObject(id);
        }
        return item;
    }

    private void loadNestedItems(Node publicObjectNode, ImportItemInterface parentItem) throws ServiceException, RemoteException {
        NodeList nestedNodeList = publicObjectNode.getChildNodes();
        if (nestedNodeList != null && nestedNodeList.getLength() > 0) {
            int length = nestedNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nestedNodeList.item(i);
                if (node.getNodeType() != 1 || !"Nested".equalsIgnoreCase(node.getNodeName())) continue;
                NodeList nestedItems = node.getChildNodes();
                int nestedLength = nestedItems.getLength();
                for (int j = 0; j < nestedLength; ++j) {
                    ImportItemInterface childItem;
                    Node nestedItem = nestedItems.item(j);
                    if (nestedItem.getNodeType() != 1 || (childItem = this.parsePublicObject(nestedItem, false)) == null) continue;
                    this.setParentItem(parentItem, childItem);
                }
            }
        }
    }

    protected void processConnections() throws MetadataPromotionException {
        File connectionsFile = null;
        try {
            connectionsFile = this._operation.getContentHandler().getFileFromPackage("ConnectionMapping.xml");
            Document doc = XMLUtil.parseXML(connectionsFile);
            NodeList rootNodes = doc.getElementsByTagName("Connections");
            if (rootNodes == null || rootNodes.getLength() == 0) {
                throw new IllegalStateException(RB.getStringResource("ImportMetadataManager.InvalidConnectionsFile.txt"));
            }
            Node connectionsNode = rootNodes.item(0);
            if (connectionsNode == null) {
                throw new IllegalStateException(RB.getStringResource("ImportMetadataManager.InvalidConnectionsFile.txt"));
            }
            NodeList nodes = connectionsNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node directNode;
                Node autoMappedNode;
                Node descNode;
                Node pathNode;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                NamedNodeMap attributes = node.getAttributes();
                NodeList childNodes = node.getChildNodes();
                String metadataType = node.getNodeName();
                String id = attributes.getNamedItem("Id").getNodeValue();
                String name = attributes.getNamedItem("Name").getNodeValue();
                ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection(metadataType, id, name);
                Node typeNode = attributes.getNamedItem("PublicType");
                if (typeNode != null) {
                    pt.setPublicType(typeNode.getNodeValue());
                }
                if ((pathNode = attributes.getNamedItem("Path")) != null) {
                    pt.setSourcePath(pathNode.getNodeValue());
                }
                if ((descNode = attributes.getNamedItem("Desc")) != null) {
                    pt.setDescription(descNode.getNodeValue());
                }
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node keyNode;
                    Node childNode = childNodes.item(j);
                    if (childNode.getNodeType() != 1) continue;
                    String nodeName = childNode.getNodeName();
                    NamedNodeMap childAttrs = childNode.getAttributes();
                    Node valueNode = childAttrs.getNamedItem("Value");
                    if (valueNode == null) continue;
                    String value = valueNode.getNodeValue();
                    if ("Search".equalsIgnoreCase(nodeName)) {
                        pt.addSourceSearch(value);
                        continue;
                    }
                    if ("Objects".equalsIgnoreCase(nodeName)) {
                        pt.addAssociatedObjects(this.getAssociatedObjectsFromIDList(value));
                        continue;
                    }
                    if (!"UserProperty".equalsIgnoreCase(nodeName) || (keyNode = childAttrs.getNamedItem("Key")) == null) continue;
                    pt.addUserDefinedProperty(keyNode.getNodeValue(), value);
                }
                Node actionNode = attributes.getNamedItem("ConnectionAction");
                if (actionNode != null && actionNode.getNodeValue().length() > 0) {
                    char action = actionNode.getNodeValue().toLowerCase().charAt(0);
                    switch (action) {
                        case 'f': {
                            pt.setConnectionAction(2);
                            break;
                        }
                        case 'w': {
                            pt.setConnectionAction(1);
                            break;
                        }
                        default: {
                            pt.setConnectionAction(0);
                        }
                    }
                }
                if ((autoMappedNode = attributes.getNamedItem("AutoMap")) != null && autoMappedNode.getNodeValue().equalsIgnoreCase(ParsingConstants.VALUE_TRUE)) {
                    pt.setAutoMapped(true);
                } else {
                    Node conflictNode = attributes.getNamedItem("conflict");
                    if (conflictNode != null && conflictNode.getNodeValue().equalsIgnoreCase(ParsingConstants.VALUE_TRUE)) {
                        pt.setConflict(true);
                    }
                }
                Node activeNode = attributes.getNamedItem("Active");
                if (activeNode != null && activeNode.getNodeValue().equalsIgnoreCase(ParsingConstants.VALUE_FALSE)) {
                    pt.setActive(false);
                }
                if ((directNode = attributes.getNamedItem("Direct")) == null || !directNode.getNodeValue().equalsIgnoreCase(ParsingConstants.VALUE_FALSE)) continue;
                pt.setDirectConnection(false);
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            if (connectionsFile != null) {
                connectionsFile.delete();
            }
        }
    }

    @Override
    public Document getObjectDocument(PromotionItemInterface importItem) throws MetadataPromotionException {
        throw new UnsupportedOperationException("Not supported by package files created prior to 9.3");
    }

    @Override
    public Map<String, Document> getObjectDocuments(List<PromotionItemInterface> items) throws MetadataPromotionException {
        throw new UnsupportedOperationException("Not supported by package files created prior to 9.3");
    }

    @Override
    public Map<String, ?> getAssociationsForObject(PromotionItemInterface promotionItem, String template) throws MetadataPromotionException {
        ArrayList<PromotionItemInterface> list = new ArrayList<PromotionItemInterface>(1);
        list.add(promotionItem);
        return this.getAssociationsForObjects(list, template);
    }

    @Override
    public Map<String, ?> getAssociationsForObjects(List<PromotionItemInterface> promotionItems, String template) throws MetadataPromotionException {
        List<ConnectionPointInterface> connections = this._connectionManager.getConnections();
        TemplateParser parser = null;
        try {
            parser = new TemplateParser(promotionItems, this.getExportXML(), connections);
            XMLUtil.parseXML(template, (DefaultHandler)parser);
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            if (parser != null) {
                parser.dispose();
            }
        }
        return parser == null ? new HashMap() : parser.getObjectMap();
    }

    @Override
    public boolean isPackageValid() throws MetadataPromotionException {
        try {
            if (!this._contentHandler.containsFile(METADATA_EXPORT_FILE_NAME)) {
                return false;
            }
            if (!this._contentHandler.containsFile("ConnectionMapping.xml")) {
                return false;
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        return true;
    }

    @Override
    public void importMetadata() throws MetadataPromotionException {
        String inputRequest = null;
        String outputRequest = null;
        try {
            if (this._operation.getLogger().isDebugEnabled()) {
                this._operation.getLogger().debug("Submitting the import metadata request");
            }
            inputRequest = this.buildImportRequest();
            outputRequest = PersistenceUtil.doRequest(this._operation.getMetadataFactory(), inputRequest);
            this.processOutputRequest(outputRequest);
        }
        catch (MetadataPromotionException me) {
            throw me;
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        finally {
            inputRequest = null;
            outputRequest = null;
        }
    }

    private String buildImportRequest() throws MetadataPromotionException {
        String originalXML = this.getExportXML();
        StringBuilder sb = new StringBuilder(originalXML.length() + 300);
        sb.append(originalXML);
        originalXML = null;
        Document doc = this.getDeployMapDocument();
        this.unloadExportXML();
        this.updateFlags(sb);
        this.convertToDeployMetadata(sb);
        this.updateRepositoryID(sb);
        String s = this.getUpdatedDeployMap(doc);
        this.replaceDeployMap(sb, s);
        return sb.toString();
    }

    protected void unloadExportXML() {
        this._exportXML = null;
    }

    private void updateFlags(StringBuilder sb) {
        boolean checkForTemplateFlag;
        boolean checkForSecurityFlag = !((ImportOperationInterface)this._operation).isSecurityMetadataIncluded();
        boolean bl = checkForTemplateFlag = ((ImportOperationInterface)this._operation).getPackageFileVersion() < 9200;
        if (!checkForSecurityFlag && !checkForTemplateFlag) {
            return;
        }
        int index = sb.lastIndexOf("<Flags/>");
        if (index > -1) {
            if (checkForSecurityFlag) {
                int endIndex = index + 8;
                String newFlags = "<Flags>524288</Flags>";
                sb.replace(index, endIndex, newFlags);
            }
        } else {
            index = sb.lastIndexOf("<flags>");
            if (index == -1) {
                index = sb.lastIndexOf("<Flags>");
            }
            if (index > -1) {
                int startIndex = index + 7;
                int endIndex = sb.indexOf("</", index);
                String s = sb.substring(startIndex, endIndex);
                int flags = 0;
                if (s.length() > 0) {
                    try {
                        flags = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        return;
                    }
                }
                if (checkForSecurityFlag) {
                    flags |= 0x80000;
                }
                if (checkForTemplateFlag) {
                    flags ^= 4;
                }
                sb.replace(startIndex, endIndex, String.valueOf(flags));
            }
        }
    }

    private void convertToDeployMetadata(StringBuilder sb) {
        int index = sb.indexOf("ExtractMetadata");
        if (index > -1) {
            sb.replace(index, index + "ExtractMetadata".length(), "DeployMetadata");
            int lastIndex = sb.lastIndexOf("ExtractMetadata");
            if (lastIndex > index) {
                sb.replace(lastIndex, lastIndex + "ExtractMetadata".length(), "DeployMetadata");
            }
        }
    }

    private void updateRepositoryID(StringBuilder sb) {
        int index;
        String targetReposID = this._operation.getRepositoryID();
        ImportOperationInterface importOperation = (ImportOperationInterface)this._operation;
        if (importOperation.importIntoRoot() && importOperation.isPreservingPaths() && this._repositoryMap != null) {
            for (Map.Entry entry : this._repositoryMap.entrySet()) {
                String value = (String)entry.getValue();
                if (targetReposID.equals(value)) continue;
                targetReposID = value;
                break;
            }
        }
        if ((index = sb.lastIndexOf("<ReposId>")) > -1) {
            int endIndex = sb.indexOf("</ReposId>", index) + 10;
            String target = "<ToReposId>" + targetReposID + "</ToReposId>";
            sb.replace(index, endIndex, target);
        }
    }

    private void replaceDeployMap(StringBuilder sb, String updatedDeployMap) throws MetadataPromotionException {
        int startIndex = sb.lastIndexOf("<DeployMap>");
        int endIndex = sb.lastIndexOf("</DeployMap>");
        if (startIndex > -1 && endIndex > startIndex) {
            sb.delete(startIndex, endIndex + 12);
            sb.insert(startIndex, updatedDeployMap);
        }
    }

    private String getUpdatedDeployMap(Document doc) throws MetadataPromotionException {
        if (doc == null) {
            return "";
        }
        try {
            NodeList reposList = doc.getElementsByTagName("ReposMap");
            this.updateRepositories(reposList.item(0));
            NodeList objectsList = doc.getElementsByTagName("Objects");
            this.updateImportItems(objectsList.item(0));
            NodeList connectionsList = doc.getElementsByTagName("Connections");
            this.updateConnections(connectionsList.item(0));
            NodeList substitutionsList = doc.getElementsByTagName("Substitutions");
            this.updateServerSubstitutions(substitutionsList.item(0));
            Node deployMapNode = doc.getFirstChild();
            String xml = XMLUtil.convertNodeToString(deployMapNode);
            this.unloadDeployMapDocument();
            int index = xml.indexOf("<DeployMap>");
            if (index > 0) {
                xml = xml.substring(index);
            }
            return xml;
        }
        catch (TransformerException e) {
            throw new MetadataPromotionException(e);
        }
    }

    protected Document getDeployMapDocument() throws MetadataPromotionException {
        if (this._deployMapDocument == null) {
            this._deployMapDocument = this.parseDeployMap();
        }
        return this._deployMapDocument;
    }

    protected void unloadDeployMapDocument() {
        this._deployMapDocument = null;
    }

    private Document parseDeployMap() throws MetadataPromotionException {
        String deployMap = this.getDeployMapContents();
        if (deployMap != null) {
            try {
                return XMLUtil.parseXML(deployMap);
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        return null;
    }

    private String getDeployMapContents() throws MetadataPromotionException {
        String exportXML = this.getExportXML();
        if (exportXML != null) {
            int startIndex = exportXML.lastIndexOf("<DeployMap>");
            int endIndex = exportXML.lastIndexOf("</DeployMap>");
            if (startIndex > -1 && endIndex > startIndex) {
                return exportXML.substring(startIndex, endIndex + 12);
            }
        }
        return null;
    }

    protected String getExportXML() throws MetadataPromotionException {
        if (this._exportXML == null) {
            try {
                if (this._operation.getLogger().isDebugEnabled()) {
                    this._operation.getLogger().debug("Loading contents of MetadataExport file");
                }
                ContentHandler content = (ContentHandler)this._operation.getContentHandler();
                this._exportXML = content.getMetadataExportFileContents();
                if (this._exportXML == null) {
                    throw new IllegalStateException(RB.getStringResource("ImportMetadataManager.NoExportXML.txt"));
                }
            }
            catch (Exception e) {
                throw new MetadataPromotionException(e);
            }
        }
        return this._exportXML;
    }

    private void updateRepositories(Node node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int index = 0; index < length; ++index) {
            String targetID;
            String id;
            Node reposNode = list.item(index);
            if (reposNode == null || reposNode.getNodeType() != 1 || (id = ((Element)reposNode).getAttribute("Id")) == null || (targetID = (String)this._repositoryMap.get(id)) == null) continue;
            ((Element)reposNode).setAttribute("Deploy_Id", targetID);
        }
    }

    private void updateConnections(Node node) {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int index = 0; index < length; ++index) {
            ConnectionPointInterface pt;
            String id;
            Node connNode = list.item(index);
            if (connNode == null || connNode.getNodeType() != 1 || (id = ((Element)connNode).getAttribute("Id")) == null || (pt = this._connectionManager.getConnection(id)) == null) continue;
            String targetID = pt.getTargetID();
            if (targetID != null) {
                String attr;
                ((Element)connNode).setAttribute("Deploy_Id", targetID);
                if (pt.isActive() && "Ignore".equalsIgnoreCase(attr = ((Element)connNode).getAttribute("Deploy_Action"))) {
                    ((Element)connNode).removeAttribute("Deploy_Action");
                }
            }
            if (pt.getUserDefinedProperty("FRAMEWORK_CP_OVERRIDE") == null) continue;
            String OVERRIDE_VALUE = "Override";
            if (!Boolean.TRUE.toString().equals(pt.getUserDefinedProperty("FRAMEWORK_CP_OVERRIDE"))) continue;
            ((Element)connNode).setAttribute("Deploy_Action", "Override");
        }
    }

    private void updateImportItems(Node node) throws MetadataPromotionException {
        NodeList list = node.getChildNodes();
        int length = list.getLength();
        for (int index = 0; index < length; ++index) {
            String id;
            Node objectNode = list.item(index);
            if (objectNode == null || objectNode.getNodeType() != 1 || (id = ((Element)objectNode).getAttribute("Id")) == null) continue;
            ImportItemInterface importItem = (ImportItemInterface)this.getPromotionItem(id);
            if (importItem != null) {
                PathUrl newPath;
                if (importItem.getImportState() == 0) {
                    this.setNodeAction((Element)objectNode, "No", null);
                    if (!importItem.containsNestedItems()) continue;
                    for (NestedImportItemInterface nestedItem : importItem.getNestedItems()) {
                        if (nestedItem.getImportState() != 0) {
                            nestedItem.setImportState(0);
                        }
                        this.setNestedItemState(nestedItem, (Element)objectNode);
                    }
                    continue;
                }
                if (this._moveManager.isParentFolderModified(importItem.getID()) && (newPath = this._moveManager.getNewParentFolder(importItem.getID())) != null) {
                    try {
                        MetadataInterface mi = this._operation.getServer().getObjectByPath(newPath);
                        if (mi instanceof FolderInterface) {
                            if (this._operation.getLogger().isDebugEnabled()) {
                                this._operation.getLogger().debug("Setting new parent folder for \"" + importItem.toString() + "\" to \"" + mi.getName() + "\".");
                            }
                            ((Element)objectNode).setAttribute("NPF", mi.getIdentifier());
                        }
                    }
                    catch (Exception e) {
                        throw new MetadataPromotionException(e);
                    }
                }
                if (importItem.getImportState() != 2 || importItem.getTargetID() == null) continue;
                if (this.isMergingImportItem(importItem)) {
                    this.setNodeAction((Element)objectNode, "Merge", importItem.getTargetID());
                    this.setNestedItemsState(importItem, (Element)objectNode);
                    continue;
                }
                this.setNodeAction((Element)objectNode, "Update", importItem.getTargetID());
                continue;
            }
            if (this.isObjectSupported(id)) continue;
            this.setNodeAction((Element)objectNode, "No", null);
        }
    }

    private void setNestedItemsState(ImportItemInterface importItem, Element parentNode) throws MetadataPromotionException {
        HashSet<String> nodeCache = new HashSet<String>();
        NodeList nestedNodes = parentNode.getChildNodes();
        for (int nestedIndex = 0; nestedIndex < nestedNodes.getLength(); ++nestedIndex) {
            Node nestedNode = nestedNodes.item(nestedIndex);
            if (nestedNode == null || nestedNode.getNodeType() != 1) continue;
            NodeList objectNodes = nestedNode.getChildNodes();
            for (int objectIndex = 0; objectIndex < objectNodes.getLength(); ++objectIndex) {
                ImportItemInterface nestedItem;
                String id;
                Node objectNode = objectNodes.item(objectIndex);
                if (objectNode == null || objectNode.getNodeType() != 1 || (id = ((Element)objectNode).getAttribute("Id")) == null || !((nestedItem = (ImportItemInterface)this.getPromotionItem(id)) instanceof NestedImportItemInterface)) continue;
                this.setNestedItemState((NestedImportItemInterface)nestedItem, (Element)objectNode);
                nodeCache.add(id);
            }
        }
        if (importItem.containsNestedItems()) {
            for (NestedImportItemInterface nestedItem : importItem.getNestedItems()) {
                Element node;
                if (nodeCache.contains(nestedItem.getID()) || nestedItem.getImportState() != 3 || (node = this.addDeletedItem(nestedItem, parentNode)) == null) continue;
                this.setNestedItemState(nestedItem, node);
            }
        }
    }

    private Element addDeletedItem(NestedImportItemInterface nestedItem, Element parentNode) throws MetadataPromotionException {
        Element objectNode;
        Element deleteNode = this.getDeleteInTargetNode(parentNode);
        if (deleteNode != null && (objectNode = XMLUtil.createNode(this.getDeployMapDocument(), deleteNode, nestedItem.getTypeInterface().getMetadataType())).getNodeType() == 1) {
            String id = nestedItem.getID();
            objectNode.setAttribute("Id", id);
            String targetID = nestedItem.getTargetID();
            objectNode.setAttribute("Deploy_Id", targetID);
            String publicType = nestedItem.getTypeInterface().getPublicType();
            objectNode.setAttribute("PublicType", publicType);
        }
        return deleteNode;
    }

    private void setNestedItemState(NestedImportItemInterface nestedItem, Element objectNode) throws MetadataPromotionException {
        if (objectNode != null) {
            switch (nestedItem.getImportState()) {
                case 0: {
                    this.setNodeAction(objectNode, "No", null);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    this.setNodeAction(objectNode, "Update", nestedItem.getTargetID());
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (nestedItem.containsNestedItems()) {
                this.setNestedItemsState(nestedItem, objectNode);
            }
        }
    }

    private void setNodeAction(Element node, String actionType, String targetID) {
        node.setAttribute("Deploy_Action", actionType);
        if (targetID != null) {
            node.setAttribute("Deploy_Id", targetID);
        }
    }

    private Element getDeleteInTargetNode(Element parentNode) throws MetadataPromotionException {
        NodeList children = parentNode.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node nameNode;
            NamedNodeMap attrs;
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !"Nested".equalsIgnoreCase(node.getNodeName()) || (attrs = node.getAttributes()) == null || (nameNode = attrs.getNamedItem("Name")) == null || !"DeleteInTarget".equalsIgnoreCase(nameNode.getNodeValue())) continue;
            return (Element)node;
        }
        Element deleteNode = XMLUtil.createNode(this.getDeployMapDocument(), parentNode, "Nested");
        deleteNode.setAttribute("Name", "DeleteInTarget");
        return deleteNode;
    }

    private void updateServerSubstitutions(Node node) throws MetadataPromotionException {
        if (this._substitutionsList == null || this._substitutionsList.isEmpty()) {
            return;
        }
        HashMap<String, Node> preDefinedSubstitutions = null;
        if (node.hasChildNodes()) {
            preDefinedSubstitutions = new HashMap<String, Node>();
            NodeList subList = node.getChildNodes();
            for (int i = 0; i < subList.getLength(); ++i) {
                Node subNode = subList.item(i);
                if (subNode == null || subNode.getNodeType() != 1) continue;
                String id = ((Element)subNode).getAttribute("Id");
                String attrName = this.getSubstitutionAttributeName(subNode.getAttributes());
                if (attrName == null || id == null || !"Name".equalsIgnoreCase(attrName)) continue;
                preDefinedSubstitutions.put(id, subNode);
            }
        }
        for (AbstractImportMetadataManager.ServerSubstitution sub : this._substitutionsList) {
            Element element;
            ImportItemInterface importItem = sub.getImportItem();
            if (importItem == null) continue;
            String metadataType = importItem.getTypeInterface().getMetadataType();
            String id = importItem.getID();
            if (preDefinedSubstitutions != null && preDefinedSubstitutions.containsKey(id)) {
                element = (Element)preDefinedSubstitutions.get(id);
            } else {
                Document doc = this.getDeployMapDocument();
                element = doc.createElement(metadataType);
            }
            if (element == null) continue;
            element.setAttribute("Id", id);
            element.setAttribute(sub.getAttributeName(), sub.getAttributeValue());
            node.appendChild(element);
        }
    }

    private String getSubstitutionAttributeName(NamedNodeMap attributes) {
        int numAttributes = attributes.getLength();
        if (numAttributes == 3) {
            return "Name";
        }
        if (numAttributes > 3) {
            for (int j = numAttributes - 1; j >= 0; --j) {
                Node attr = attributes.item(j);
                String attrName = attr.getNodeName();
                if (attrName.equalsIgnoreCase("Id") || attrName.equalsIgnoreCase("Name") || attrName.equalsIgnoreCase("TLObjN")) continue;
                return attrName;
            }
        }
        return null;
    }

    @Override
    public void initializeRepositoryMappings() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Initializing repository mappings");
        }
        if (((ImportOperationInterface)this._operation).importIntoRoot() && this._operation.getPromotionType() == 1) {
            try {
                if (this._operation.isProjectRepository()) {
                    this.mapTargetRepository(this._operation.getRepositoryID());
                    return;
                }
                List<ImportElementInterface> importedTopLevelFolders = this.getImportedTopLevelFolders();
                if (importedTopLevelFolders.size() == 1) {
                    ImportElementInterface item = importedTopLevelFolders.get(0);
                    if (item.isNewObject()) {
                        this.mapTargetRepository(this._operation.getRepositoryID());
                    }
                    String id = item.getTargetID();
                    if (id == null) {
                        throw new IllegalStateException("Missing target id for folder");
                    }
                    this.mapTargetRepository("A0000001." + id.substring(0, 8));
                }
                if (importedTopLevelFolders.size() > 1) {
                    RootFolderInterface rootFolder = this._operation.getServer().getRootFolder();
                    List sasFolders = rootFolder.getSASFolders();
                    for (ImportElementInterface element : importedTopLevelFolders) {
                        String folderName = element.getPublicObject().getName();
                        for (FolderInterface folder : sasFolders) {
                            RepositoryInterface repos;
                            if (!folder.getName().equalsIgnoreCase(folderName) || !((repos = folder.getRepository()) instanceof OMIRepositoryInterface) || !"CUSTOM".equals(((OMIRepositoryInterface)repos).getRepositoryType())) continue;
                            String msg = RB.getStringResource("ImportMetadataManager.ReposStructure.Error.txt");
                            throw new MetadataPromotionException(msg);
                        }
                    }
                    this.mapTargetRepository(this._operation.getRepositoryID());
                }
                this.mapTargetRepository(this._operation.getRepositoryID());
            }
            catch (ServiceException e) {
                String error = RB.getStringResource("ImportHandler.LoadingRepositoriesError.txt");
                this._operation.getLogger().debug((Object)error, e);
                throw new MetadataPromotionException(error);
            }
            catch (RemoteException e) {
                String error = RB.getStringResource("ImportHandler.LoadingRepositoriesError.txt");
                this._operation.getLogger().debug((Object)error, e);
                throw new MetadataPromotionException(error);
            }
        } else {
            this.mapTargetRepository(this._operation.getRepositoryID());
        }
    }

    private void mapTargetRepository(String targetReposID) {
        if (this._repositoryMap == null) {
            return;
        }
        if (this._operation.getLogger().isDebugEnabled()) {
            String targetReposName = null;
            try {
                targetReposName = this._operation.getMetadataFactory().getRepositoryUtil().getRepositoryName(targetReposID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._operation.getLogger().debug("Mapping all repositories to \"" + targetReposName + "\" (" + targetReposID + ")");
        }
        for (String key : this._repositoryMap.keySet()) {
            this._repositoryMap.put(key, targetReposID);
        }
    }
}

