/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.UpgradeManager;
import com.sas.metadata.promotion.persistence.ImportMetadataManager_920;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportMetadataManager_913
extends ImportMetadataManager_920 {
    private Map<String, String> _publicTypeCache = null;
    private List<PromotionItemInterface> _objectList;

    public ImportMetadataManager_913(ImportOperationInterface operation) {
        super(operation);
    }

    @Override
    public int getPackageFileVersion() throws MetadataPromotionException {
        int endIndex;
        int version = super.getPackageFileVersion();
        if (version > 0) {
            return version;
        }
        String xml = this.getExportXML().substring(0, 150);
        String PLATFORM_VERSION = "PlatformVersion=\"";
        int index = xml.indexOf("PlatformVersion=\"");
        if (index > -1 && (endIndex = xml.indexOf("\"", index += "PlatformVersion=\"".length())) > index) {
            String sVersion = xml.substring(index, endIndex);
            StringBuffer sb = new StringBuffer(8);
            for (int i = 0; i < sVersion.length(); ++i) {
                char c = sVersion.charAt(i);
                if (c == '.') continue;
                sb.append(c);
            }
            try {
                version = Integer.parseInt(sb.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (version == 0) {
            version = 9130;
        }
        return version;
    }

    public boolean containsHotfix() throws MetadataPromotionException {
        String xml = this.getExportXML().substring(0, 150);
        return xml.indexOf(" SP4HF") > -1;
    }

    @Override
    public void loadPackageMetadata() throws MetadataPromotionException {
        super.loadPackageMetadata();
    }

    @Override
    public List<PromotionItemInterface> getPromotionItems() {
        if (this._objectList == null) {
            this._objectList = new ArrayList<PromotionItemInterface>();
            this._objectList.addAll(super.getPromotionItems());
            Collections.sort(this._objectList, new TopLevelObjectsSorter());
        }
        return this._objectList;
    }

    @Override
    protected void processConnections() throws MetadataPromotionException {
        try {
            NodeList connectionsList;
            Node connectionsNode;
            Document deployMapDocument = this.getDeployMapDocument();
            if (deployMapDocument != null && (connectionsNode = (connectionsList = deployMapDocument.getElementsByTagName("Connections")).item(0)) != null) {
                NodeList nodes = connectionsNode.getChildNodes();
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1) continue;
                    this.parseConnectionPoint(node);
                }
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
    }

    private void parseConnectionPoint(Node node) throws MetadataPromotionException {
        Node directConnectionsNode;
        Node topLevelNode;
        Node activeNode;
        Node targetIDNode;
        Node autoMappedNode;
        Node actionNode;
        Node searchNode;
        NamedNodeMap attributes = node.getAttributes();
        String metadataType = node.getNodeName();
        String id = attributes.getNamedItem("Id").getNodeValue();
        String name = attributes.getNamedItem("Name").getNodeValue();
        ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection(metadataType, id, name);
        Node typeNode = attributes.getNamedItem("PublicType");
        if (typeNode != null) {
            pt.setPublicType(typeNode.getNodeValue());
        } else {
            String publicType = UpgradeManager.getInstance().getPublicTypeFromMetadataType(metadataType);
            if (publicType != null) {
                pt.setPublicType(publicType);
            }
        }
        Node descNode = attributes.getNamedItem("Desc");
        if (descNode != null) {
            pt.setDescription(descNode.getNodeValue());
        }
        if ((searchNode = attributes.getNamedItem("Search")) != null) {
            pt.addSourceSearch(searchNode.getNodeValue());
        }
        if ((actionNode = attributes.getNamedItem("ConnectionAction")) != null && actionNode.getNodeValue().length() > 0) {
            char action = actionNode.getNodeValue().toLowerCase().charAt(0);
            switch (action) {
                case 'f': {
                    pt.setConnectionAction(2);
                    break;
                }
                case 'w': {
                    pt.setConnectionAction(1);
                    break;
                }
                default: {
                    pt.setConnectionAction(0);
                }
            }
        }
        if ((autoMappedNode = attributes.getNamedItem("AutoMap")) != null && autoMappedNode.getNodeValue().equalsIgnoreCase("Y")) {
            pt.setAutoMapped(true);
        }
        if ((targetIDNode = attributes.getNamedItem("Deploy_Id")) != null && targetIDNode.getNodeValue().length() > 0) {
            pt.setTargetID(targetIDNode.getNodeValue());
        }
        if ((activeNode = attributes.getNamedItem("Deploy_Action")) != null && activeNode.getNodeValue().equalsIgnoreCase("Ignore")) {
            pt.setActive(false);
        }
        if ((topLevelNode = attributes.getNamedItem("TLObjN")) != null && topLevelNode.getNodeValue().length() > 0) {
            pt.addAssociatedObjects(this.getAssociatedObjects(topLevelNode.getNodeValue()));
        }
        if ((directConnectionsNode = attributes.getNamedItem("DirTLObjN")) != null) {
            String nodeValue = directConnectionsNode.getNodeValue();
            List<PromotionItemInterface> associatedObjects = this.getAssociatedObjects(nodeValue);
            if (associatedObjects.size() == 0) {
                pt.setDirectConnection(false);
            } else {
                pt.setDirectConnection(true);
            }
        } else {
            pt.setDirectConnection(true);
        }
    }

    @Override
    protected String getPublicTypeForObject(NamedNodeMap attributes) {
        Node templateNode = attributes.getNamedItem("ExtractTemplate");
        if (templateNode == null) {
            return null;
        }
        String templateName = templateNode.getNodeValue();
        if (this._publicTypeCache != null && this._publicTypeCache.containsKey(templateName)) {
            return this._publicTypeCache.get(templateName);
        }
        try {
            if (this._publicTypeCache == null) {
                this._publicTypeCache = new HashMap<String, String>(5);
            }
            UpgradeManager manager = UpgradeManager.getInstance();
            String publicType = manager.getCurrentPublicType(templateName);
            this._publicTypeCache.put(templateName, publicType);
            return publicType;
        }
        catch (MetadataPromotionException e) {
            this._operation.getLogger().debug("Importing 9.1.3 package.  Unable to retrieve public type for " + templateName);
            return null;
        }
    }

    @Override
    public boolean isPackageValid() throws MetadataPromotionException {
        try {
            if (!this._contentHandler.containsFile("MetadataExport.xml")) {
                return false;
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e);
        }
        return true;
    }

    public String getUserDefinedData() throws MetadataPromotionException {
        Document doc = this.getDeployMapDocument();
        if (doc != null) {
            String userData = "UserData";
            Node parentNode = doc.getFirstChild();
            NodeList list = parentNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node childNode = list.item(i);
                if (!childNode.getNodeName().equalsIgnoreCase("UserData")) continue;
                NodeList nodes = childNode.getChildNodes();
                for (int j = 0; j < nodes.getLength(); ++j) {
                    Node dataNode = nodes.item(j);
                    if (dataNode == null || dataNode.getNodeType() != 4) continue;
                    return dataNode.getNodeValue();
                }
            }
        }
        return "";
    }

    class TopLevelObjectsSorter
    implements Comparator<PromotionItemInterface> {
        private Map<PromotionItemInterface, String> _objectMap = new HashMap<PromotionItemInterface, String>();

        public TopLevelObjectsSorter() {
            for (String key : ImportMetadataManager_913.this._publicObjectMap.keySet()) {
                PromotionItemInterface value = (PromotionItemInterface)ImportMetadataManager_913.this._publicObjectMap.get(key);
                if (this._objectMap.containsKey(value)) continue;
                this._objectMap.put(value, key);
            }
        }

        @Override
        public int compare(PromotionItemInterface obj1, PromotionItemInterface obj2) {
            String id1 = this._objectMap.get(obj1);
            if (id1 == null) {
                return -1;
            }
            String id2 = this._objectMap.get(obj2);
            if (id2 == null) {
                return 1;
            }
            try {
                int index1 = Integer.parseInt(id1);
                int index2 = Integer.parseInt(id2);
                if (index1 < index2) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return 0;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
    }
}

