/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.meta.SASOMI.IMetadataTransport;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ExportSummaryInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NestedExportItem;
import com.sas.metadata.promotion.NestedExportItemInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.model.ExportFolderModelInterface;
import com.sas.metadata.promotion.persistence.AbstractMetadataManager;
import com.sas.metadata.promotion.persistence.ParsingConstants;
import com.sas.metadata.promotion.persistence.PersistenceUtil;
import com.sas.metadata.promotion.persistence.RB;
import com.sas.metadata.remote.AccessControlEntry;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Permission;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.AccessControlEntryInterface;
import com.sas.services.information.metadata.AccessControlTemplateInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.PublicObjectFactory;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omg.CORBA.StringHolder;

public class ExportMetadataManager
extends AbstractMetadataManager {
    protected XMLEventFactory _eventFactory = null;
    protected XMLInputFactory _inputFactory = null;
    protected XMLOutputFactory _outputFactory = null;
    protected ExportSummaryInterface _summary;
    protected ExportFolderModelInterface _exportModel;
    private static String USER_FOLDER_TEMPLATE = "<Templates><Template TemplateName=\"Tree\"><Tree Name=\"\"><AssociatedIdentity/><ParentTree><Tree TemplateName=\"ParentTree\"/></ParentTree></Tree><Identity Name=\"\"/></Template><Template TemplateName=\"ParentTree\"><Tree Name=\"\"><AssociatedIdentity/></Tree><Identity Name=\"\"/></Template></Templates>";

    public ExportMetadataManager(ExportOperationInterface operation) {
        super(operation);
        this._summary = operation.getExportSummary();
        this._exportModel = operation.getExportModel();
        this._eventFactory = XMLEventFactory.newInstance();
        this._inputFactory = XMLInputFactory.newInstance();
        this._outputFactory = XMLOutputFactory.newInstance();
    }

    public List<PromotionItemInterface> getPromotionItems() {
        ArrayList<PromotionItemInterface> items = new ArrayList<PromotionItemInterface>();
        for (PromotionItemInterface item : this._promotionItems.values()) {
            if (item instanceof NestedExportItemInterface) continue;
            items.add(item);
        }
        return items;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportMetadata() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Submitting the export metadata request");
        }
        MdOMRConnection connection = null;
        IMetadataTransport transport = null;
        try {
            String inputRequest22 = this.createExportRequest();
            connection = this._operation.getMetadataFactory().getConnection();
            transport = connection.makeIMetadataTransportConnection(connection.getCMRHandle());
            if (this._operation.getLogger().isDebugEnabled() && this._operation.getMetadataFactory().getLoggingEnabled()) {
                StringBuilder sb = new StringBuilder(60 + inputRequest22.length());
                sb.append("<ExportMetadata>");
                sb.append("<Metadata>");
                sb.append(inputRequest22);
                sb.append("</Metadata>");
                sb.append("</ExportMetadata>");
                PersistenceUtil.logRequestInput(this._operation, sb.toString());
            }
            StringHolder outTransport = new StringHolder();
            StringHolder outDeployMap = new StringHolder();
            transport.ExportMetadata(inputRequest22, outTransport, outDeployMap, "SAS", 0, "");
            if (this._operation.getLogger().isDebugEnabled() && this._operation.getMetadataFactory().getLoggingEnabled()) {
                StringBuilder sb = new StringBuilder(20 + outTransport.value.length() + outDeployMap.value.length());
                sb.append("<Output>");
                sb.append(outTransport.value);
                sb.append(outDeployMap.value);
                sb.append("</Output>");
                PersistenceUtil.logRequestOutput(this._operation, sb.toString());
            }
            inputRequest22 = null;
            this.createPackageFile();
            this.processTransportMetadata(outTransport.value);
            outTransport = null;
            this.processDeployMap(outDeployMap.value);
            outDeployMap = null;
            if (transport == null) return;
            if (connection == null) return;
        }
        catch (Exception e) {
            try {
                throw new MetadataPromotionException(e, e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                if (transport == null) throw throwable;
                if (connection == null) throw throwable;
                try {
                    connection.closeIMetadataTransportConnection(transport);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            connection.closeIMetadataTransportConnection(transport);
            return;
        }
        catch (Exception inputRequest22) {
            return;
        }
    }

    private void createPackageFile() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Creating the package file");
        }
        try {
            this._contentHandler.createNewPackage(this._operation.getPackageFile(), 9300);
        }
        catch (IOException e) {
            throw new MetadataPromotionException(e, RB.getStringResource("ExportMetadataManager.Error.CreatePackage.txt"));
        }
    }

    private void processTransportMetadata(String value) throws IOException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Processing transport metadata");
        }
        File transportFile = this._contentHandler.createFile(value, "TransportMetadata.xml");
        this._contentHandler.deleteFileOnPublish(transportFile);
        this._contentHandler.addFileToPackage(transportFile, 1);
    }

    private void processDeployMap(String value) throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Processing deploy map");
        }
        this._publicObjectMap = new HashMap();
        OutputStream fileStream = null;
        XMLEventReader eventReader = null;
        XMLEventWriter eventWriter = null;
        try {
            File outputFile = this._contentHandler.createFile("DeployMap.xml");
            this._contentHandler.deleteFileOnPublish(outputFile);
            this._contentHandler.addFileToPackage(outputFile, 1);
            fileStream = new FileOutputStream(outputFile);
            eventWriter = this._outputFactory.createXMLEventWriter(fileStream, "UTF-8");
            eventReader = this._inputFactory.createXMLEventReader(new StringReader(value));
            int currentLevel = 0;
            boolean processingObject = false;
            boolean processingConnection = false;
            ExportItemInterface currentParentItem = null;
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                switch (e.getEventType()) {
                    case 7: {
                        eventWriter.add(this._eventFactory.createStartDocument());
                        eventWriter.add(this._eventFactory.createComment("IMPORTANT: This file should not be edited."));
                        break;
                    }
                    case 1: {
                        StartElement se = e.asStartElement();
                        eventWriter.add(this._eventFactory.createStartElement(se.getName(), se.getAttributes(), se.getNamespaces()));
                        if (currentLevel == 1) {
                            if ("Objects".equals(se.getName().getLocalPart())) {
                                processingObject = true;
                            } else if ("Connections".equals(se.getName().getLocalPart())) {
                                processingConnection = true;
                            }
                        } else if (currentLevel > 1) {
                            if (processingObject) {
                                boolean isTopLevel = currentLevel == 2;
                                ExportItemInterface exportItem = this.parsePublicObject(se, eventWriter, isTopLevel);
                                if (exportItem != null) {
                                    if (isTopLevel) {
                                        currentParentItem = exportItem;
                                    } else if (currentParentItem != null) {
                                        this.setParentItem(currentParentItem, exportItem);
                                    }
                                }
                            } else if (processingConnection) {
                                this.parseConnectionPoint(se);
                            }
                        }
                        ++currentLevel;
                        break;
                    }
                    case 2: {
                        EndElement ee;
                        if (--currentLevel == 1) {
                            ee = e.asEndElement();
                            if ("Objects".equals(ee.getName().getLocalPart())) {
                                processingObject = false;
                            } else if ("Connections".equals(ee.getName().getLocalPart())) {
                                processingConnection = true;
                            }
                        }
                        ee = e.asEndElement();
                        eventWriter.add(this._eventFactory.createEndElement(ee.getName(), ee.getNamespaces()));
                        break;
                    }
                    case 8: {
                        eventWriter.add(this._eventFactory.createEndDocument());
                    }
                }
            }
            eventWriter.flush();
        }
        catch (Exception e) {
            throw new MetadataPromotionException(e, RB.getStringResource("ExportMetadataManager.Error.ProcessDeployMap.txt"));
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (eventWriter != null) {
                    eventWriter.close();
                }
                if (eventReader != null) {
                    eventReader.close();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private String getObjectPath(ExportItemInterface exportItem) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this._exportModel.getObject(exportItem.getID(), exportItem.getTypeInterface().getPublicType());
        return node == null ? "" : node.getAbsolutePath();
    }

    private ExportItemInterface parsePublicObject(StartElement se, XMLEventWriter eventWriter, boolean isTopLevel) throws XMLStreamException, ServiceException, RemoteException {
        ExportItemInterface item;
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        if (idAttr == null) {
            return null;
        }
        Attribute nameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_NAME);
        Attribute typeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PUBLICTYPE);
        if (nameAttr == null || typeAttr == null) {
            return null;
        }
        String publicType = typeAttr.getValue();
        String id = idAttr.getValue();
        String name = nameAttr.getValue();
        ExportItemInterface exportItemInterface = item = isTopLevel ? this.createExportItem(name, publicType, id) : this.createNestedItem(name, publicType, id);
        if (item instanceof DefaultExportItem) {
            Attribute indexAttr;
            Attribute descAttr;
            Attribute versionAttr;
            DefaultExportItem exportItem = (DefaultExportItem)item;
            this.addPromotionItem(exportItem);
            if (exportItem.getUsageVersion() == null && (versionAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_USAGEVERSION)) != null) {
                double ver = Double.parseDouble(versionAttr.getValue());
                exportItem.setUsageVersion(UsageVersion.decode((double)ver));
            }
            if (exportItem.getDescription() == null && (descAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DESC)) != null) {
                exportItem.setDescription(descAttr.getValue());
            }
            if (isTopLevel) {
                this.createSummaryItem(exportItem);
                if (exportItem.getSourcePath() == null || exportItem.getSourcePath().length == 0) {
                    String[] sourcePath = null;
                    if (PromotionUtil.isTypeContainedByFolder(publicType)) {
                        PathUrl url;
                        MetadataInterface mi = PromotionUtil.getSmartObject(this._operation.getServer(), id, exportItem.getTypeInterface().getMetadataType());
                        if (mi != null && (url = mi.getPathUrl()) != null) {
                            List<String> pathList = BIPTreeUtil.getFolderPathAsList(VirtualFolderManager.getDefaultPath((String)publicType));
                            sourcePath = pathList.toArray(new String[pathList.size()]);
                        }
                        if (sourcePath == null) {
                            exportItem.setOrphaned(true);
                            sourcePath = new String[]{};
                        }
                    } else if (SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)this._operation.getServer())) {
                        List<String> pathList = BIPTreeUtil.getFolderPathAsList(VirtualFolderManager.getDefaultPath((String)publicType));
                        sourcePath = pathList.toArray(new String[pathList.size()]);
                    }
                    exportItem.setSourcePath(sourcePath);
                }
            }
            if ((indexAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PO)) != null) {
                String sID = indexAttr.getValue();
                this._publicObjectMap.put(sID, exportItem);
            }
            this.addObjectAttributes(exportItem, eventWriter, isTopLevel);
        }
        return item;
    }

    private void createSummaryItem(ExportItemInterface exportItem) throws ServiceException, RemoteException {
        PublicObjectInterface exportedObject = PublicObjectFactory.createPublicObject((ServerInterface)this._operation.getServer(), (String)exportItem.getID(), (String)exportItem.getName(), (String)exportItem.getTypeInterface().getPublicType());
        String path = this.getObjectPath(exportItem);
        if (path != null) {
            PublicObjectFactory.setPublicObjectPath((PublicObjectInterface)exportedObject, (String)path);
        }
        this._summary.addExportedObject(exportedObject);
    }

    private void addObjectAttributes(DefaultExportItem exportItem, XMLEventWriter eventWriter, boolean isTopLevel) throws XMLStreamException, ServiceException, RemoteException {
        if (isTopLevel) {
            eventWriter.add(this._eventFactory.createAttribute("Path", this.getObjectPath(exportItem)));
            if ("Folder".equals(exportItem.getTypeInterface().getPublicType())) {
                this.processUserFolderSettings(exportItem, eventWriter);
            }
        }
        if (exportItem.getDisplayName() != null && !exportItem.getDisplayName().equals(exportItem.getName())) {
            eventWriter.add(this._eventFactory.createAttribute("DisplayName", exportItem.getDisplayName()));
        }
    }

    private void processUserFolderSettings(ExportItemInterface exportItem, XMLEventWriter eventWriter) throws XMLStreamException, RemoteException {
        if (!"Tree".equalsIgnoreCase(exportItem.getTypeInterface().getMetadataType())) {
            return;
        }
        try {
            MdFactory factory = this._operation.getMetadataFactory();
            Tree tree = (Tree)factory.getOMIUtil().getMetadataAllDepths((MdStore)this._operation.getStore(), "Tree", exportItem.getID(), null, null, USER_FOLDER_TEMPLATE, 20);
            if (tree == null) {
                return;
            }
            Identity identity = tree.getAssociatedIdentity();
            if (identity != null) {
                eventWriter.add(this._eventFactory.createAttribute("UserFolder", "Home Folder"));
                eventWriter.add(this._eventFactory.createAttribute("UserFolderIdentity", identity.getName()));
            } else {
                Tree parent = tree.getParentTree();
                if (parent != null && (identity = parent.getAssociatedIdentity()) != null) {
                    String myFolderName = factory.getOMIUtil().getUserHomeFolderName(identity.getName(), "My Folder");
                    if (tree.getName().equals(myFolderName)) {
                        eventWriter.add(this._eventFactory.createAttribute("UserFolder", "My Folder"));
                        eventWriter.add(this._eventFactory.createAttribute("UserFolderIdentity", identity.getName()));
                    } else {
                        String appDataName = factory.getOMIUtil().getUserHomeFolderName(identity.getName(), "Application Data");
                        if (tree.getName().equals(appDataName)) {
                            eventWriter.add(this._eventFactory.createAttribute("UserFolder", "Application Data"));
                            eventWriter.add(this._eventFactory.createAttribute("UserFolderIdentity", identity.getName()));
                        }
                    }
                }
            }
        }
        catch (MdException e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ExportMetadataManager.UserFolderError.fmt.txt", (Object)exportItem.toString(), (Object)e.getLocalizedMessage());
            this._operation.getLogger().error(msg);
        }
    }

    private ExportItemInterface createExportItem(String name, String publicType, String id) {
        return ((ExportOperationInterface)this._operation).createExportItem(name, publicType, id);
    }

    private ExportItemInterface createNestedItem(String name, String publicType, String id) {
        TransportableTypeInterface type = this._operation.getTransportableType(publicType);
        if (type != null) {
            NestedExportItem nestedItem = new NestedExportItem(name, id, type);
            return nestedItem;
        }
        return null;
    }

    private void setParentItem(ExportItemInterface parent, ExportItemInterface child) {
        if (child instanceof NestedExportItemInterface) {
            ((NestedExportItemInterface)child).setParent(parent);
        }
    }

    private void parseConnectionPoint(StartElement se) throws ServiceException, RemoteException {
        MetadataInterface mi;
        Attribute directConnectAttr;
        Attribute topLevelAttr;
        Attribute activeAttr;
        Attribute autoMappedAttr;
        Attribute actionAttr;
        Attribute searchAttr;
        Attribute descAttr;
        String metadataType = se.getName().getLocalPart();
        Attribute idAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_ID);
        Attribute nameAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_NAME);
        if (metadataType == null || idAttr == null || nameAttr == null) {
            throw new IllegalStateException(RB.getStringResource("ExportMetadataManager.InvalidCP.txt"));
        }
        ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection(metadataType, idAttr.getValue(), nameAttr.getValue());
        pt.setInternalConnection(true);
        String publicType = null;
        Attribute typeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_PUBLICTYPE);
        if (typeAttr != null) {
            publicType = typeAttr.getValue();
            pt.setPublicType(publicType);
            if (SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)this._operation.getServer())) {
                PathUrl url;
                MetadataInterface mi2;
                String path = null;
                ExportItemInterface exportItem = (ExportItemInterface)this.getPromotionItem(idAttr.getValue());
                if (exportItem != null) {
                    path = this.getObjectPath(exportItem);
                }
                if (path == null && (mi2 = PromotionUtil.getSmartObject(this._operation.getServer(), idAttr.getValue(), metadataType)) != null && (url = mi2.getPathUrl()) != null) {
                    path = url.getAbsolutePath();
                }
                if (path != null) {
                    pt.setSourcePath(path);
                }
            }
        }
        if ((descAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DESC)) != null) {
            pt.setDescription(descAttr.getValue());
        }
        if ((searchAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_SEARCH)) != null) {
            pt.addSourceSearch(searchAttr.getValue());
        }
        if ((actionAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_CONNACTION)) != null && actionAttr.getValue().length() > 0) {
            char action = actionAttr.getValue().toLowerCase().charAt(0);
            switch (action) {
                case 'f': {
                    pt.setConnectionAction(2);
                    break;
                }
                case 'w': {
                    pt.setConnectionAction(1);
                    break;
                }
                default: {
                    pt.setConnectionAction(0);
                }
            }
        }
        if ((autoMappedAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_AUTOMAP)) != null) {
            if ("Y".equalsIgnoreCase(autoMappedAttr.getValue())) {
                pt.setAutoMapped(true);
            } else if ("conflict".equalsIgnoreCase(autoMappedAttr.getValue())) {
                pt.setAutoMapped(false);
                pt.setConflict(true);
            }
        }
        if ((activeAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DEPLOYACTION)) != null && "Ignore".equalsIgnoreCase(activeAttr.getValue())) {
            pt.setActive(false);
        }
        if ((topLevelAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_CPO)) != null && topLevelAttr.getValue().length() > 0) {
            pt.addAssociatedObjects(this.getAssociatedObjects(topLevelAttr.getValue()));
        }
        if ((directConnectAttr = se.getAttributeByName(ParsingConstants.ATTRIBUTE_QNAME_DCPO)) != null) {
            List<PromotionItemInterface> associatedObjects = this.getAssociatedObjects(directConnectAttr.getValue());
            if (associatedObjects.size() == 0) {
                pt.setDirectConnection(false);
            } else {
                pt.setDirectConnection(true);
            }
        } else {
            pt.setDirectConnection(true);
        }
        if ("ACT".equals(publicType) && (mi = PromotionUtil.getSmartObject(this._operation.getServer(), idAttr.getValue(), metadataType)) instanceof AccessControlTemplateInterface) {
            this.updateACTConnection(pt, mi);
        }
    }

    private String createExportRequest() {
        Map exportMap = ((ExportOperationInterface)this._operation).getExportItems();
        StringBuilder sb = new StringBuilder(400);
        for (String publicType : exportMap.keySet()) {
            TransportableTypeInterface typeInterface = this._operation.getTransportableType(publicType);
            if (typeInterface == null) continue;
            String metadataType = typeInterface.getMetadataType();
            List objects = (List)exportMap.get(publicType);
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                ExportItemInterface exportItem = (ExportItemInterface)objects.get(i);
                sb.append("<");
                sb.append(metadataType);
                sb.append(" Id=\"");
                sb.append(exportItem.getID());
                sb.append("\"/>");
            }
        }
        return sb.toString();
    }

    public void writeConnections() throws MetadataPromotionException {
        if (this._operation.getLogger().isDebugEnabled()) {
            this._operation.getLogger().debug("Writing connection mapping file.");
        }
        OutputStream fileStream = null;
        XMLStreamWriter writer = null;
        try {
            File connectionsFile = this._contentHandler.createFile("ConnectionMapping.xml");
            this._contentHandler.deleteFileOnPublish(connectionsFile);
            this._contentHandler.addFileToPackage(connectionsFile, 1);
            fileStream = new FileOutputStream(connectionsFile);
            writer = this._outputFactory.createXMLStreamWriter(fileStream, "UTF-8");
            writer.writeStartDocument();
            writer.writeComment("IMPORTANT: This file should not be edited.");
            writer.writeStartElement("ConnectionMapping");
            writer.writeStartElement("Connections");
            List<ConnectionPointInterface> connections = this._connectionManager.getConnections(true);
            for (ConnectionPointInterface pt : connections) {
                this.writeConnectionPoint(writer, pt);
            }
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (Throwable e) {
            throw new MetadataPromotionException(e, RB.getStringResource("ExportMetadataManager.Error.ConnectionFile.txt"));
        }
        finally {
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                this._operation.getLogger().debug("Unable to close input/output streams.");
            }
        }
    }

    private void writeConnectionPoint(XMLStreamWriter writer, ConnectionPointInterface pt) throws XMLStreamException {
        List<PromotionItemInterface> objects;
        List<String> searchList;
        writer.writeStartElement(pt.getMetadataType());
        writer.writeAttribute("Id", pt.getSourceID());
        writer.writeAttribute("Name", pt.getName());
        if (pt.getDescription() != null) {
            writer.writeAttribute("Desc", pt.getDescription());
        }
        if (pt.getPublicType() != null) {
            writer.writeAttribute("PublicType", pt.getPublicType());
        }
        if (pt.getSourcePath() != null) {
            writer.writeAttribute("Path", pt.getSourcePath());
        }
        if (!pt.isActive()) {
            writer.writeAttribute("Active", ParsingConstants.VALUE_FALSE);
        }
        if (pt.isAutoMapped()) {
            writer.writeAttribute("AutoMap", ParsingConstants.VALUE_TRUE);
        } else if (pt instanceof ConnectionPoint && ((ConnectionPoint)pt).hasConflict()) {
            writer.writeAttribute("conflict", ParsingConstants.VALUE_TRUE);
        }
        if (!pt.isDirectConnection()) {
            writer.writeAttribute("Direct", ParsingConstants.VALUE_FALSE);
        }
        if (pt.getConnectionAction() == 2) {
            writer.writeAttribute("ConnectionAction", "F");
        } else if (pt.getConnectionAction() == 1) {
            writer.writeAttribute("ConnectionAction", "W");
        }
        if (pt.getUserDefinedProperties() != null) {
            Map<String, String> props = pt.getUserDefinedProperties();
            for (String key : props.keySet()) {
                writer.writeStartElement("UserProperty");
                writer.writeAttribute("Key", key);
                writer.writeAttribute("Value", props.get(key));
                writer.writeEndElement();
            }
        }
        if ((searchList = pt.getSourceSearchList()) != null && searchList.size() > 0) {
            for (String searchString : searchList) {
                writer.writeStartElement("Search");
                writer.writeAttribute("Value", searchString);
                writer.writeEndElement();
            }
        }
        if ((objects = pt.getAssociatedObjects()) != null && !objects.isEmpty()) {
            int size = objects.size();
            StringBuilder sb = new StringBuilder(size * 18);
            for (int i = 0; i < size; ++i) {
                PromotionItemInterface item = objects.get(i);
                sb.append(item.getID());
                if (i >= size - 1) continue;
                sb.append(';');
            }
            writer.writeStartElement("Objects");
            writer.writeAttribute("Value", sb.toString());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void updateACTConnection(ConnectionPoint pt, MetadataInterface act) throws ServiceException, RemoteException {
        this._operation.getLogger().debug("Parsing ACT connection point: " + pt.getName());
        StringBuilder sb = new StringBuilder();
        sb.append("<AccessControlItems>");
        List items = ((AccessControlTemplateInterface)act).getAccessControlItems();
        for (MetadataInterface item : items) {
            if (!(item instanceof AccessControlEntryInterface)) continue;
            AccessControlEntryInterface ace = (AccessControlEntryInterface)item;
            sb.append("<AccessControlEntry>");
            sb.append("<Permissions>");
            this.addPermissions(ace, pt, sb);
            sb.append("</Permissions>");
            sb.append("<Identities>");
            this.addIdentities(ace, pt, sb);
            sb.append("</Identities>");
            sb.append("</AccessControlEntry>");
        }
        sb.append("</AccessControlItems>");
        pt.addUserDefinedProperty("accessControlItems", sb.toString());
    }

    private void addPermissions(AccessControlEntryInterface ace, ConnectionPoint actConnection, StringBuilder sb) throws ServiceException, RemoteException {
        try {
            AccessControlEntry entry = (AccessControlEntry)ace.getRepositoryEntity();
            AssociationList perms = entry.getPermissions();
            for (Permission perm : perms) {
                String id = perm.getId();
                sb.append("<Permission ObjRef=\"").append(id).append("\"/>");
                if (this._connectionManager.containsConnection(id)) continue;
                ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection("Permission", id, perm.getName());
                pt.setDirectConnection(false);
                pt.addAssociatedObjects(actConnection.getAssociatedObjects());
                StringBuilder search = new StringBuilder();
                search.append("*[@Name='").append(perm.getName()).append("' and @Type='").append(perm.getType()).append("']");
                pt.addSourceSearch(search.toString());
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
    }

    private void addIdentities(AccessControlEntryInterface ace, ConnectionPointInterface actConnection, StringBuilder sb) throws ServiceException, RemoteException {
        try {
            AccessControlEntry entry = (AccessControlEntry)ace.getRepositoryEntity();
            AssociationList identities = entry.getIdentities();
            for (Identity identity : identities) {
                String id = identity.getId();
                sb.append("<").append(identity.getCMetadataType()).append(" ObjRef=\"").append(id).append("\"/>");
                if (this._connectionManager.containsConnection(id)) continue;
                ConnectionPoint pt = (ConnectionPoint)this._connectionManager.createConnection(identity.getCMetadataType(), id, identity.getName());
                pt.setDirectConnection(false);
                pt.addAssociatedObjects(actConnection.getAssociatedObjects());
                pt.setPublicType(identity.getPublicType());
                StringBuilder search = new StringBuilder();
                search.append("*[@Name='").append(identity.getName()).append("']");
                pt.addSourceSearch(search.toString());
            }
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
    }
}

