/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.persistence.AbstractTransportMetadataParser;
import com.sas.metadata.promotion.persistence.MetadataManagementInterface;
import com.sas.metadata.promotion.persistence.RB;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DocumentTransportMetadataParser
extends AbstractTransportMetadataParser {
    protected MetadataManagementInterface _metaMgr = null;
    protected DocumentBuilderFactory _factory;
    protected Map<String, Document> _documentMap;
    private String _currentTopLevelObjectID = null;

    public DocumentTransportMetadataParser(MetadataManagementInterface mgr, List<PromotionItemInterface> importItems) {
        this(mgr, null, importItems);
    }

    public DocumentTransportMetadataParser(MetadataManagementInterface mgr, DocumentBuilderFactory factory, List<PromotionItemInterface> importItems) {
        super(importItems);
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        this._factory = factory;
        this._metaMgr = mgr;
        this._documentMap = new LinkedHashMap<String, Document>(importItems.size());
        for (PromotionItemInterface item : importItems) {
            this._documentMap.put(item.getID(), null);
        }
    }

    public Map<String, Document> getDocumentMap() {
        return this._documentMap;
    }

    @Override
    protected AbstractTransportMetadataParser.ObjectElement createNewObjectElement(String name, AbstractTransportMetadataParser.BaseElement parent) {
        return new DocumentObjectElement(name, parent);
    }

    @Override
    protected AbstractTransportMetadataParser.AssocElement createNewAssocElement(String name, AbstractTransportMetadataParser.BaseElement parent) {
        return new DocumentAssocElement(name, parent);
    }

    @Override
    protected void createTopLevelObject(AbstractTransportMetadataParser.ObjectElement element, String id, String name, String metadataType) throws SAXException {
        Document doc = null;
        try {
            doc = this.createObjectDocument();
            this._documentMap.put(id, doc);
            this._currentTopLevelObjectID = id;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        Node objectNode = this.createObjectNode(id, name, metadataType);
        doc.appendChild(objectNode);
        ((DocumentObjectElement)element).setObjectNode(objectNode);
    }

    private Document createObjectDocument() throws ParserConfigurationException {
        DocumentBuilder parser = this._factory.newDocumentBuilder();
        return parser.newDocument();
    }

    @Override
    protected void createSecondaryObject(AbstractTransportMetadataParser.ObjectElement element, String id, String name, String metadataType, boolean isObjRef) {
        ConnectionPointInterface pt;
        Node objectNode = this.createObjectNode(id, name, metadataType, isObjRef);
        ((DocumentObjectElement)element).setObjectNode(objectNode);
        AbstractTransportMetadataParser.AssocElement parent = (AbstractTransportMetadataParser.AssocElement)element.getParent();
        ((DocumentAssocElement)parent).addObjectNode(objectNode);
        if (isObjRef && (pt = this._metaMgr.getConnectionManager().getConnection(id)) != null) {
            String type;
            this.addObjectAttribute(element, "Name", pt.getName());
            String desc = pt.getDescription();
            if (desc != null && desc.length() > 0) {
                this.addObjectAttribute(element, "Desc", desc);
            }
            if ((type = pt.getPublicType()) != null && type.length() > 0) {
                this.addObjectAttribute(element, "PublicType", type);
            }
        }
    }

    @Override
    protected void addObjectAttribute(AbstractTransportMetadataParser.ObjectElement element, String attrName, String attrValue) {
        Node objectNode = ((DocumentObjectElement)element).getObjectNode();
        if (objectNode.getNodeType() == 1) {
            ((Element)objectNode).setAttribute(attrName, attrValue);
        }
    }

    private Node createObjectNode(String id, String name, String type) {
        return this.createObjectNode(id, name, type, false);
    }

    private Node createObjectNode(String id, String name, String type, boolean isObjRef) {
        Document doc = this._documentMap.get(this._currentTopLevelObjectID);
        if (doc == null) {
            throw new IllegalStateException(RB.getStringResource("DocumentTransportMetadataParser.NoDoc.txt"));
        }
        Element node = doc.createElement(type);
        if (node.getNodeType() == 1) {
            if (id != null) {
                node.setAttribute(isObjRef ? "ObjRef" : "Id", id);
            }
            if (name != null) {
                node.setAttribute("Name", name);
            }
        }
        return node;
    }

    private class DocumentObjectElement
    extends AbstractTransportMetadataParser.ObjectElement {
        protected Node _objectNode;

        public DocumentObjectElement(String name, AbstractTransportMetadataParser.BaseElement parentElement) {
            super(name, parentElement);
            this._objectNode = null;
        }

        public void setObjectNode(Node objectNode) {
            this._objectNode = objectNode;
        }

        public Node getObjectNode() {
            return this._objectNode;
        }

        @Override
        public void addAssociation(String associationName, List<?> objectList) {
            if (this._objectNode != null) {
                Document owningDoc = this._objectNode.getOwnerDocument();
                Element assocNode = owningDoc.createElement(associationName);
                this._objectNode.appendChild(assocNode);
                for (Node childNode : objectList) {
                    assocNode.appendChild(childNode);
                }
            }
        }

        @Override
        public boolean containsAssociation(String associationName) {
            if (this._objectNode == null) {
                return false;
            }
            NodeList nodes = this._objectNode.getChildNodes();
            if (nodes != null) {
                int length = nodes.getLength();
                for (int index = 0; index < length; ++index) {
                    Node childNode = nodes.item(index);
                    if (!associationName.equalsIgnoreCase(childNode.getNodeName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class DocumentAssocElement
    extends AbstractTransportMetadataParser.AssocElement {
        private List<Node> _nodeList;

        public DocumentAssocElement(String name, AbstractTransportMetadataParser.BaseElement parentElement) {
            super(name, parentElement);
        }

        @Override
        public List<?> getAssocList() {
            return this._nodeList;
        }

        public void addObjectNode(Node objectNode) {
            if (this._nodeList == null) {
                this._nodeList = new ArrayList<Node>();
            }
            this._nodeList.add(objectNode);
        }
    }
}

