/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.persistence;

import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.persistence.MetadataManagementInterface;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractMetadataManager
implements MetadataManagementInterface {
    protected static final String UTF8 = "UTF-8";
    protected static final String CONNECTIONS_FILE_NAME = "ConnectionMapping.xml";
    protected static final String TRANSPORT_FILE_NAME = "TransportMetadata.xml";
    protected static final String DEPLOY_MAP_FILE_NAME = "DeployMap.xml";
    protected static final char LIST_SEPARATOR = ';';
    public static final String ATTRIBUTE_PROPERTY = "PropertyTag";
    protected PromotionInterface _operation;
    protected ContentHandlerInterface _contentHandler;
    protected ConnectionManagerInterface _connectionManager;
    protected Map<String, PromotionItemInterface> _promotionItems = null;
    protected Map<String, PromotionItemInterface> _publicObjectMap = null;

    protected AbstractMetadataManager(PromotionInterface operation) {
        this._operation = operation;
        this._connectionManager = ConnectionManager.getNewInstance(operation);
        this._contentHandler = operation.getContentHandler();
        this._promotionItems = new LinkedHashMap<String, PromotionItemInterface>();
    }

    @Override
    public PromotionItemInterface getPromotionItem(String id) {
        return this._promotionItems.get(id);
    }

    protected void addPromotionItem(PromotionItemInterface item) {
        this._promotionItems.put(item.getID(), item);
    }

    @Override
    public ConnectionManagerInterface getConnectionManager() {
        return this._connectionManager;
    }

    public void dispose() {
        if (this._connectionManager != null) {
            ((ConnectionManager)this._connectionManager).dispose();
            this._connectionManager = null;
        }
        if (this._publicObjectMap != null) {
            this._publicObjectMap.clear();
            this._publicObjectMap = null;
        }
        if (this._promotionItems != null) {
            this._promotionItems.clear();
            this._promotionItems = null;
        }
    }

    protected List<PromotionItemInterface> getAssociatedObjects(String topLevelNumbers) {
        ArrayList<PromotionItemInterface> associatedObjects = new ArrayList<PromotionItemInterface>(5);
        if (topLevelNumbers == null) {
            return associatedObjects;
        }
        if (topLevelNumbers.indexOf(91) > -1) {
            String s = topLevelNumbers.substring(topLevelNumbers.indexOf(91) + 1, topLevelNumbers.indexOf(93));
            StringTokenizer st = new StringTokenizer(s, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                PromotionItemInterface item = this._publicObjectMap.get(token);
                if (item == null) continue;
                associatedObjects.add(item);
            }
        } else {
            PromotionItemInterface item = this._publicObjectMap.get(topLevelNumbers);
            if (item != null) {
                associatedObjects.add(item);
            }
        }
        return associatedObjects;
    }
}

