/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.model.ImportFolderUtil;
import com.sas.metadata.promotion.model.ImportObjectState;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelFactory;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ImportFolderModelComparison {
    private ImportOperationInterface _operation;
    private SASFoldersModelInterface _targetModel;
    private ImportFolderModelInterface _sourceModel;
    private Map<String, String> _topLevelFolderCache;
    private Map<PublicObjectContainerInterface, Boolean> parentFolderPermissionCache;

    public ImportFolderModelComparison(ImportOperationInterface operation, ImportFolderModelInterface sourceModel) {
        this._operation = operation;
        this._sourceModel = sourceModel;
        this.parentFolderPermissionCache = new HashMap<PublicObjectContainerInterface, Boolean>();
    }

    public void initialize(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        this._targetModel = FolderModelFactory.createSASFoldersModel((ServerInterface)this._operation.getServer());
        ModelConfiguration targetModelConfig = this._targetModel.getConfiguration();
        targetModelConfig.setFolderRefreshValue(-1L);
        targetModelConfig.setDisplaySystemFolders(true);
        targetModelConfig.setDisplayUsersHomeFolder(false);
        targetModelConfig.setDisplayUnknownObjects(false);
        PublicObjectNodeInterface container = this.getTargetContainerNode(targetContainer);
        if (container instanceof ContainerNodeInterface) {
            this._targetModel.populateContainer((ContainerNodeInterface)container);
        }
        this._topLevelFolderCache = new HashMap<String, String>();
        FolderNodeInterface targetRootFolder = this._targetModel.getRootFolder();
        List children = targetRootFolder.getChildren();
        for (PublicObjectNodeInterface child : children) {
            this._topLevelFolderCache.put(child.getIdentifier(), child.getName());
        }
    }

    private PublicObjectNodeInterface getTargetContainerNode(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        if (targetContainer instanceof VirtualFolderInterface) {
            PathUrl path = ((VirtualFolderInterface)targetContainer).getPathUrl();
            VirtualFolderNodeInterface virtualFolder = (VirtualFolderNodeInterface)this._targetModel.getObjectByPath(path);
            return virtualFolder;
        }
        if (targetContainer instanceof VirtualFolderNodeInterface) {
            PathUrl path = ((VirtualFolderNodeInterface)targetContainer).getPathUrl();
            VirtualFolderNodeInterface virtualFolder = (VirtualFolderNodeInterface)this._targetModel.getObjectByPath(path);
            return virtualFolder;
        }
        return this._targetModel.getObject(targetContainer.getIdentifier(), targetContainer.getTypeDescriptor().getTypeName());
    }

    public ImportObjectState getObjectState(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        FolderNodeInterface targetRootFolder = this._targetModel.getRootFolder();
        PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath((PublicObjectInterface)node);
        MetadataInterface targetObject = null;
        if (!this._operation.isProjectRepository()) {
            FolderNodeInterface targetContainer = null;
            int length = containers.length;
            for (int index = 0; index < length; ++index) {
                PublicObjectContainerInterface container = containers[index];
                if (index == 0) {
                    targetContainer = targetRootFolder;
                    if (this.compareObjects((PublicObjectInterface)container, (PublicObjectInterface)targetContainer)) continue;
                    targetContainer = null;
                    break;
                }
                PublicObjectInterface target = this.getMatchingTargetObject((PublicObjectInterface)container, (PublicObjectContainerInterface)targetContainer);
                if (target instanceof PublicObjectContainerInterface) {
                    targetContainer = (PublicObjectContainerInterface)target;
                    continue;
                }
                targetContainer = null;
                break;
            }
            if (targetContainer != null) {
                targetObject = this.getMatchingTargetObject((PublicObjectInterface)node, (PublicObjectContainerInterface)targetContainer);
            }
        } else {
            targetObject = this.searchForObject((PublicObjectInterface)node);
        }
        int state = -1;
        if (targetObject == null) {
            state = this.getNewObjectState((PublicObjectInterface)node);
            return new ImportObjectState(state);
        }
        state = this.getExistingObjectState((PublicObjectInterface)targetObject);
        return new ImportObjectState(state, targetObject.getIdentifier());
    }

    private PublicObjectInterface getMatchingTargetObject(PublicObjectInterface sourceObject, PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        List targetChildren = targetContainer.getChildren();
        for (PublicObjectInterface targetChild : targetChildren) {
            if (!this.compareObjects(sourceObject, targetChild)) continue;
            return targetChild;
        }
        return null;
    }

    private boolean compareObjects(PublicObjectInterface source, PublicObjectInterface target) throws ServiceException, RemoteException {
        if (source == null || target == null) {
            return false;
        }
        TypeDescriptorInterface sourceType = source.getTypeDescriptor();
        TypeDescriptorInterface targetType = target.getTypeDescriptor();
        if (sourceType == null || targetType == null) {
            return false;
        }
        if (!sourceType.getTypeName().equalsIgnoreCase(targetType.getTypeName())) {
            return false;
        }
        String sourceName = source.getName();
        String targetName = target.getName();
        return sourceName.equalsIgnoreCase(targetName);
    }

    private int getExistingObjectState(PublicObjectInterface targetObject) throws ServiceException, RemoteException {
        int state = 4;
        if (SASFoldersUtil.isFolder((PublicObjectInterface)targetObject)) {
            boolean hasWriteFolderPermission = ImportUtil.isFolderWriteAuthorized(targetObject, this._operation.getServer());
            if (!hasWriteFolderPermission) {
                state |= 0x40;
            }
        } else {
            boolean hasWritePermission = ImportUtil.isWriteAuthorized(targetObject, this._operation.getServer());
            if (!hasWritePermission) {
                state |= 0x20;
            }
        }
        return state;
    }

    private int getNewObjectState(PublicObjectInterface sourceObject) throws ServiceException, RemoteException {
        boolean hasWriteFolderPermission;
        boolean hasWriteFolderPermission2;
        PublicObjectContainerInterface parent;
        ImportElementInterface parentImportNode;
        if (this.doesObjectExist(sourceObject)) {
            return 12;
        }
        if (SASFoldersUtil.isFolder((PublicObjectInterface)sourceObject) ? ((parentImportNode = this._sourceModel.getImportElement((PublicObjectInterface)(parent = sourceObject.getContainer()))) != null ? parentImportNode.isWritePermissionDenied() : SASFoldersUtil.isFolder((PublicObjectInterface)parent) && !this._operation.isProjectRepository() && !(hasWriteFolderPermission2 = this.isWriteAuthorizedOnTargetFolder(parent))) : SASFoldersUtil.isFolder((PublicObjectInterface)(parent = sourceObject.getContainer())) && !this._operation.isProjectRepository() && !(hasWriteFolderPermission = this.isWriteAuthorizedOnTargetFolder(parent))) {
            return 66;
        }
        return 2;
    }

    private boolean isWriteAuthorizedOnTargetFolder(PublicObjectContainerInterface parent) throws ServiceException, RemoteException {
        if (this.parentFolderPermissionCache.containsKey(parent)) {
            return this.parentFolderPermissionCache.get(parent);
        }
        boolean isAuthorized = true;
        TypeDescriptorInterface parentType = parent.getTypeDescriptor();
        if (parentType != null) {
            ImportElementInterface parentImportElement = this._sourceModel.getImportElement((PublicObjectInterface)parent);
            if (parentImportElement != null && !"Folder.Virtual".equalsIgnoreCase(parentType.getTypeName())) {
                String targetId = parentImportElement.getTargetID();
                if (targetId != null) {
                    isAuthorized = ImportUtil.isFolderWriteAuthorized(targetId, this._operation.getServer());
                }
            } else {
                isAuthorized = ImportUtil.validateTargetContainerPermissions(parent, this._operation.getServer(), false);
            }
            this.parentFolderPermissionCache.put(parent, isAuthorized);
        }
        return isAuthorized;
    }

    private boolean doesObjectExist(PublicObjectInterface object) throws ServiceException, RemoteException {
        int objectCount = 0;
        String publicType = object.getTypeDescriptor().getTypeName();
        if ("Folder".equals(publicType)) {
            objectCount = this.searchForFolder_NoSecurity(object);
        } else {
            String parentPublicType;
            PublicObjectContainerInterface parent = object.getContainer();
            if (parent != null && "Folder".equals(parentPublicType = parent.getTypeDescriptor().getTypeName())) {
                objectCount = this.searchForObject_NoSecurity(object);
            }
        }
        return objectCount > 0;
    }

    private MetadataInterface searchForObject(PublicObjectInterface object) throws ServiceException, RemoteException {
        List results;
        FilterInterface filter = null;
        String publicType = object.getTypeDescriptor().getTypeName();
        filter = "Folder".equals(publicType) ? this.createFolderSearchFilter(object) : this.createObjectSearchFilter(object);
        if (filter != null && (results = this._operation.getServer().search(filter)) != null && !results.isEmpty()) {
            return (MetadataInterface)results.get(0);
        }
        return null;
    }

    private int searchForFolder_NoSecurity(PublicObjectInterface folder) throws ServiceException, RemoteException {
        ServerInterface server;
        FilterInterface filter = this.createFolderSearchFilter(folder);
        if (filter != null && (server = this._operation.getServer()) instanceof MetadataServerInterface) {
            return ((MetadataServerInterface)server).getCountNoSecurity((Filter)filter, null);
        }
        return 0;
    }

    private int searchForObject_NoSecurity(PublicObjectInterface object) throws ServiceException, RemoteException {
        ServerInterface server;
        FilterInterface filter = this.createObjectSearchFilter(object);
        if (filter != null && (server = this._operation.getServer()) instanceof MetadataServerInterface) {
            return ((MetadataServerInterface)server).getCountNoSecurity((Filter)filter, null);
        }
        return 0;
    }

    private FilterInterface createFolderSearchFilter(PublicObjectInterface folder) throws ServiceException, RemoteException {
        String reposID = null;
        StringBuilder sb = new StringBuilder(150);
        FolderNodeInterface sourceRoot = this._sourceModel.getRootFolder();
        PublicObjectContainerInterface parent = folder.getContainer();
        if (parent != null && parent.getIdentifier().equalsIgnoreCase(sourceRoot.getIdentifier())) {
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.cleanStringForXML(folder.getName()));
            sb.append("' and @PublicType='Folder'][");
            FolderNodeInterface rootFolder = this._targetModel.getRootFolder();
            sb.append("SoftwareComponents/SoftwareComponent[@Id='" + rootFolder.getIdentifier() + "']]");
            sb.append("\"/>");
            String topLevelFolderID = this.getTopLevelFolderID(folder.getName());
            reposID = ImportFolderUtil.getRepositoryToSearchWithin(this._operation, topLevelFolderID);
        } else {
            String[] path = SASFoldersUtil.getObjectPath((PublicObjectInterface)folder);
            String topLevelFolderID = this.getTopLevelFolderID(path[0]);
            if (topLevelFolderID != null) {
                reposID = ImportFolderUtil.getRepositoryToSearchWithin(this._operation, topLevelFolderID);
                int length = path.length;
                if (length == 1) {
                    sb.append("<XMLSelect search=\"*[@Name='");
                    sb.append(XMLUtil.cleanStringForXML(folder.getName()));
                    sb.append("' and @PublicType='Folder']");
                    sb.append("[ParentTree/Tree[@Id='" + topLevelFolderID + "']]\"/>");
                } else if (length > 1) {
                    sb.append("<XMLSelect search=\"*[@Name='");
                    sb.append(XMLUtil.cleanStringForXML(folder.getName()));
                    sb.append("' and @PublicType='Folder'][");
                    for (int i = length - 1; i > 0; --i) {
                        if (i != length - 1) {
                            sb.append("/");
                        }
                        String name = path[i];
                        sb.append("ParentTree/Tree[@Name='");
                        sb.append(XMLUtil.cleanStringForXML(name));
                        sb.append("' and @PublicType='Folder']");
                        if (i != 0) continue;
                        sb.append("/");
                    }
                    sb.append("/ParentTree/Tree[@Id='" + topLevelFolderID + "']]");
                    sb.append("\"/>");
                }
            }
        }
        return this.createFilter(folder, reposID, sb.toString());
    }

    private FilterInterface createObjectSearchFilter(PublicObjectInterface object) throws ServiceException, RemoteException {
        String reposID = null;
        StringBuilder sb = new StringBuilder(150);
        String[] path = SASFoldersUtil.getObjectPath((PublicObjectInterface)object);
        if (path == null || path.length < 1) {
            throw new IllegalArgumentException("Invalid object path: " + object);
        }
        String topLevelFolderID = this.getTopLevelFolderID(path[0]);
        if (topLevelFolderID != null) {
            String objectName = object.getName();
            sb.append("<XMLSelect search=\"*[@Name='");
            sb.append(XMLUtil.cleanStringForXML(objectName));
            sb.append("' and ");
            sb.append(BIPTreeUtil.buildPublicTypeXMLSelect(object.getTypeDescriptor().getTypeName()));
            sb.append("][");
            int length = path.length;
            if (length == 1) {
                sb.append("Trees/Tree[@Id='" + topLevelFolderID + "']]");
            } else {
                for (int i = length - 1; i > 0; --i) {
                    String name = path[i];
                    if (i != length - 1) {
                        sb.append("/ParentTree/Tree[@Name='");
                    } else {
                        sb.append("Trees/Tree[@Name='");
                    }
                    sb.append(XMLUtil.cleanStringForXML(name));
                    sb.append("' and @PublicType='Folder']");
                    if (i != 0) continue;
                    sb.append("/");
                }
                sb.append("/ParentTree/Tree[@Id='" + topLevelFolderID + "']]");
            }
            sb.append("\"/>");
            reposID = ImportFolderUtil.getRepositoryToSearchWithin(this._operation, topLevelFolderID);
        }
        return this.createFilter(object, reposID, sb.toString());
    }

    private FilterInterface createFilter(PublicObjectInterface object, String reposID, String xmlSelect) throws ServiceException, RemoteException {
        if (xmlSelect == null || xmlSelect.length() == 0) {
            return null;
        }
        Filter filter = new Filter();
        if (reposID != null) {
            filter.setOMRRepository(reposID);
        }
        if (this._operation.isProjectRepository()) {
            filter.setOMRFlags(8192);
        }
        filter.setType(object.getTypeDescriptor().getMetadataType());
        filter.setExplicitSearchString("omi", xmlSelect);
        return filter;
    }

    private String getTopLevelFolderID(String folderName) throws ServiceException, RemoteException {
        if (this._topLevelFolderCache != null && folderName != null) {
            for (Map.Entry<String, String> entry : this._topLevelFolderCache.entrySet()) {
                if (!folderName.equalsIgnoreCase(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        ServerInterface server = this._operation.getServer();
        RootFolderInterface rootFolder = server.getRootFolder();
        StringBuilder sb = new StringBuilder(150);
        sb.append("<XMLSelect search=\"*[@Name='");
        sb.append(XMLUtil.cleanStringForXML(folderName));
        sb.append("' and @PublicType='Folder'][SoftwareComponents/SoftwareComponent[@Id='");
        sb.append(rootFolder.getIdentifier());
        sb.append("']]\"/>");
        Filter filter = new Filter();
        filter.setOMRRepository(this._operation.getRepositoryID());
        if (this._operation.isProjectRepository()) {
            filter.setOMRFlags(8192);
        }
        filter.setType("Tree");
        filter.setExplicitSearchString("omi", sb.toString());
        List results = server.search((FilterInterface)filter);
        if (results != null && !results.isEmpty()) {
            FolderInterface folder = (FolderInterface)results.get(0);
            String id = folder.getIdentifier();
            if (this._topLevelFolderCache != null) {
                this._topLevelFolderCache.put(id, folder.getName());
            }
            return id;
        }
        return null;
    }
}

