/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.ImportUtil;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.NoObjectsToImportException;
import com.sas.metadata.promotion.ObjectMoveManager;
import com.sas.metadata.promotion.ObjectRenameManager;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.UserFolderManager;
import com.sas.metadata.promotion.model.ImportContainerNode;
import com.sas.metadata.promotion.model.ImportElement;
import com.sas.metadata.promotion.model.ImportElementInterface;
import com.sas.metadata.promotion.model.ImportFolderModelComparison;
import com.sas.metadata.promotion.model.ImportFolderModelInterface;
import com.sas.metadata.promotion.model.ImportFolderNode;
import com.sas.metadata.promotion.model.ImportFolderUtil;
import com.sas.metadata.promotion.model.ImportMemberNode;
import com.sas.metadata.promotion.model.ImportModelConfiguration;
import com.sas.metadata.promotion.model.ImportObjectState;
import com.sas.metadata.promotion.model.ImportVirtualFolderNode;
import com.sas.metadata.promotion.model.RB;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.FolderUtil;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.VirtualFolderInterface;
import com.sas.services.information.metadata.VirtualFolderManager;
import com.sas.services.information.publicobject.MutableContainerInterface;
import com.sas.services.information.publicobject.ProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.AbstractFolderModel2;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.FolderModelInterface;
import com.sas.services.information.sasfolders.FolderNodeInterface;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class ImportFolderModel
extends AbstractFolderModel2
implements ImportFolderModelInterface {
    public static final String PRESERVED_FOLDER_PREFIX = "PreservedFolder_";
    private static final String[] EMPTY_FOLDER_PATH = new String[0];
    protected ImportOperationInterface _operation;
    protected ImportFolderModelComparison _modelComparison;
    protected ObjectMoveManager _moveManager;
    protected UserFolderManager _userFolderManager;
    protected UserFolderManager.ImportLocationState _locationState = UserFolderManager.ImportLocationState.DEFAULT;
    protected ContainerNodeInterface _targetNode;
    protected List<String> _targetContainerPath;
    protected Map<String, PublicObjectNodeInterface> _nodeCache;
    private Map<String, ImportElementInterface> _importItems;
    private Set<ImportItemInterface> _renamedObjects;
    private Set<PublicObjectNodeInterface> _duplicateNamedObjects;
    private boolean _authorizedOnTarget = true;
    private boolean _importingIntoSameFolder = false;
    private boolean _importingIntoRoot = false;
    private int _preservePathFolderCount = 0;
    private Set<String> _dependentObjects;
    private Map<ImportElementInterface, Integer> _excludedItemsMap;
    private boolean _exportedFromRoot = false;
    private ExportState _exportState = ExportState.EXPORTED_SINGLE_FOLDER;
    private List<String> _exportedFolderPath;
    private List<List<String>> _exportedFolderPaths;

    public ImportFolderModel(ImportOperationInterface operation) throws ServiceException, RemoteException {
        super(operation.getServer());
        this._nodeCache = new HashMap<String, PublicObjectNodeInterface>();
        this._operation = operation;
        this._moveManager = ObjectMoveManager.getInstance(this._operation);
        this._userFolderManager = UserFolderManager.getInstance(this._operation);
        ObjectRenameManager.getNewInstance(this._operation);
    }

    protected ModelConfiguration createModelConfiguration() {
        return ImportModelConfiguration.getDefault();
    }

    @Override
    public ContainerNodeInterface getTargetContainer() throws ServiceException, RemoteException {
        return this._targetNode;
    }

    @Override
    public List<PublicObjectNodeInterface> getDuplicateNamedObjects() {
        return this._duplicateNamedObjects == null ? null : new ArrayList<PublicObjectNodeInterface>(this._duplicateNamedObjects);
    }

    @Override
    public List<ImportItemInterface> getRenamedObjects() {
        return this._renamedObjects == null ? null : new ArrayList<ImportItemInterface>(this._renamedObjects);
    }

    @Override
    public List<ImportElementInterface> getImportElements() {
        return new ArrayList<ImportElementInterface>(this._importItems.values());
    }

    @Override
    public ImportElementInterface getImportElement(String id) throws ServiceException, RemoteException {
        if (this._importItems == null) {
            return null;
        }
        return this._importItems.get(id);
    }

    @Override
    public ImportElementInterface getImportElement(PublicObjectInterface object) throws ServiceException, RemoteException {
        if (object == null) {
            return null;
        }
        return (ImportElementInterface)object.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
    }

    @Override
    public void includeNode(ImportElementInterface node) throws ServiceException, RemoteException {
        if (this._excludedItemsMap != null && this._excludedItemsMap.containsKey(node)) {
            Integer originalState = this._excludedItemsMap.get(node);
            ImportItemInterface item = node.getImportItem();
            if (item != null) {
                node.setObjectState(originalState, true);
                if (node.isNewObject()) {
                    item.setImportState(1);
                } else if (node.isStateSet(1)) {
                    item.setImportState(0);
                } else {
                    item.setImportState(2);
                }
            }
            this._excludedItemsMap.remove(node);
        }
    }

    @Override
    public void excludeNode(ImportElementInterface node) throws ServiceException, RemoteException {
        if (this._excludedItemsMap == null) {
            this._excludedItemsMap = new HashMap<ImportElementInterface, Integer>();
        } else if (this._excludedItemsMap.containsKey(node)) {
            return;
        }
        ImportItemInterface item = node.getImportItem();
        if (item != null) {
            this._excludedItemsMap.put(node, node.getObjectState());
            node.setObjectState(1);
            item.setImportState(0);
        }
    }

    @Override
    public boolean isAuthorizedToImportPackage() throws ServiceException, RemoteException {
        return this._authorizedOnTarget ? true : this.isAuthorized((MutableContainerInterface)this._rootFolder);
    }

    private boolean isAuthorized(MutableContainerInterface container) throws ServiceException, RemoteException {
        if (container.getChildCount() > 0) {
            List children = container.getChildren();
            for (PublicObjectInterface child : children) {
                ImportElementInterface importNode = (ImportElementInterface)child.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                if (importNode != null && importNode.isPermissionGranted()) {
                    return true;
                }
                if (!(child instanceof FolderNodeInterface) || !this.isAuthorized((MutableContainerInterface)((FolderNodeInterface)child))) continue;
                return true;
            }
        }
        return false;
    }

    private void initialize(PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        this._importItems = new LinkedHashMap<String, ImportElementInterface>();
        FolderNodeInterface root = this.getRootFolder();
        root.setPopulated(true);
        this.setExportState(targetContainer);
        this._modelComparison = new ImportFolderModelComparison(this._operation, this);
        this._modelComparison.initialize(targetContainer);
        this._targetNode = this.createTargetContainerNode(targetContainer);
    }

    public ContainerNodeInterface createTargetContainerNode(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        if (container == null) {
            throw new IllegalArgumentException("Invalid public object");
        }
        ContainerNodeInterface containerNode = this.getTargetContainer(container);
        if (containerNode != null) {
            this.setTargetContainerState(containerNode);
        }
        return containerNode;
    }

    private void setTargetContainerState(ContainerNodeInterface targetContainer) throws ServiceException, RemoteException {
        String type;
        if (!ImportUtil.validateTargetContainerPermissions((PublicObjectContainerInterface)targetContainer, this._operation, false)) {
            this._authorizedOnTarget = false;
        }
        if ("RootFolder".equals(type = targetContainer.getTypeDescriptor().getTypeName())) {
            this._locationState = UserFolderManager.ImportLocationState.ROOT_FOLDER;
            this._importingIntoRoot = true;
            this._targetContainerPath = Collections.emptyList();
        } else if (targetContainer instanceof FolderNodeInterface) {
            String exportFolderName;
            String userFoldersPath;
            PublicObjectContainerInterface[] containers = SASFoldersUtil.getContainerPath((PublicObjectInterface)targetContainer);
            int length = containers.length;
            this._targetContainerPath = new ArrayList<String>(containers.length + 1);
            if (length > 0) {
                for (int index = 1; index < containers.length; ++index) {
                    this._targetContainerPath.add(containers[index].getName());
                }
            }
            this._targetContainerPath.add(targetContainer.getName());
            if (this._operation.getPromotionType() == 1 && (userFoldersPath = this._userFolderManager.getUserFoldersPath()) != null) {
                List pathList = SASFoldersUtil.parseFolderPath((String)userFoldersPath);
                if (SASFoldersUtil.areFolderPathsEqual(this._targetContainerPath, (List)pathList)) {
                    this._locationState = UserFolderManager.ImportLocationState.USER_FOLDERS_ROOT;
                } else if (!ImportFolderModel.isVirtualFolder((PublicObjectContainerInterface)targetContainer) && this._userFolderManager.isUserHomeFolder((PublicObjectInterface)targetContainer)) {
                    this._locationState = UserFolderManager.ImportLocationState.USER_HOME_FOLDER;
                }
            }
            String string = exportFolderName = this._exportedFolderPath == null || this._exportedFolderPath.size() == 0 ? "" : this._exportedFolderPath.get(this._exportedFolderPath.size() - 1);
            if (this._operation.getPackageFileVersion() < 9200 && !Names.validateOMRObjectName((String)exportFolderName, (boolean)false)) {
                exportFolderName = Names.mapNameToOMRObjectName((String)exportFolderName);
            }
            this._importingIntoSameFolder = exportFolderName.equals(targetContainer.getName());
        }
    }

    private static boolean isVirtualFolder(PublicObjectContainerInterface container) {
        return container instanceof VirtualFolderNodeInterface || container instanceof VirtualFolderInterface;
    }

    private ContainerNodeInterface getTargetContainer(PublicObjectContainerInterface container) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node;
        FolderNodeInterface rootFolder;
        String id = container.getIdentifier();
        TypeDescriptorInterface type = container.getTypeDescriptor();
        if (id == null) {
            return null;
        }
        if (type == null) {
            throw new ServiceException("Invalid public type");
        }
        if ("RootFolder".equalsIgnoreCase(type.getTypeName()) && (rootFolder = this.getRootFolder()).getIdentifier().equalsIgnoreCase(id)) {
            return rootFolder;
        }
        String key = SASFoldersUtil.getISEntityKey((String)id, (TypeDescriptorInterface)type);
        MetadataInterface meta = this._server.fetch(key, true);
        if (meta != null && (node = this.getTargetNode(meta)) instanceof ContainerNodeInterface) {
            return (ContainerNodeInterface)node;
        }
        return null;
    }

    protected PublicObjectNodeInterface getObjectByPath(String path) throws ServiceException, RemoteException {
        PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)path);
        if (pathUrl.getType() == null) {
            pathUrl.setType("Folder");
        }
        return this.getObjectByPath(pathUrl);
    }

    protected PublicObjectNodeInterface getObjectByPath(PathUrl path) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = (PublicObjectNodeInterface)SASFoldersUtil.findNodeByPath((PathUrl)path, (FolderModelInterface)this);
        if (node != null) {
            return node;
        }
        MetadataInterface meta = this._server.getObjectByPath(path);
        if (meta != null && meta.getTypeDescriptor() != null) {
            return this.getTargetNode(meta);
        }
        return null;
    }

    private PublicObjectNodeInterface getTargetNode(MetadataInterface smartObject) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this.createTargetNode((PublicObjectInterface)smartObject);
        this.createParentStructure(node, (PublicObjectInterface)smartObject);
        return node;
    }

    private PublicObjectNodeInterface createTargetNode(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        if (publicObject instanceof VirtualFolderInterface) {
            return this.createVirtualFolderNode(publicObject.getName());
        }
        return this.createNode(publicObject.getIdentifier(), publicObject.getName(), publicObject.getTypeDescriptor());
    }

    private void createParentStructure(PublicObjectNodeInterface node, PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        PublicObjectContainerInterface container;
        if (node.getContainer() == null && (container = publicObject.getContainer()) != null) {
            PublicObjectInterface containerNode;
            PathUrl objectPath;
            MetadataInterface meta = SASFoldersUtil.getSmartObject((ServerInterface)this._server, (PublicObjectInterface)container);
            if (meta != null && (objectPath = meta.getPathUrl()) != null && (containerNode = SASFoldersUtil.findNodeByPath((PathUrl)objectPath, (FolderModelInterface)this)) != null && containerNode instanceof ContainerNodeInterface) {
                ((ContainerNodeInterface)containerNode).addChild((PublicObjectInterface)node);
                return;
            }
            PublicObjectNodeInterface parentNode = this.createTargetNode((PublicObjectInterface)container);
            if (parentNode instanceof ContainerNodeInterface) {
                ((ContainerNodeInterface)parentNode).addChild((PublicObjectInterface)node);
            }
            this.createParentStructure(parentNode, (PublicObjectInterface)container);
        }
    }

    protected void addChildNode(ContainerNodeInterface parentNode, PublicObjectNodeInterface childNode) throws ServiceException, RemoteException {
        parentNode.addChild((PublicObjectInterface)childNode);
    }

    @Override
    public void populateModel(List<ImportItemInterface> importContents, PublicObjectContainerInterface targetContainer) throws ServiceException, RemoteException {
        this.initialize(targetContainer);
        List<String> dependencies = this._operation.getExportedDependentObjects();
        if (dependencies != null) {
            this._dependentObjects = new HashSet<String>(dependencies);
        }
        ArrayList<ImportItemInterface> topLevelObjects = new ArrayList<ImportItemInterface>(importContents);
        int folderCount = 0;
        for (ImportItemInterface importItem : importContents) {
            if (!FolderUtil.isFolder((String)importItem.getTypeInterface().getPublicType())) continue;
            this.resetImportItem(importItem);
            this.populateFolder(importItem, folderCount++);
            topLevelObjects.remove(importItem);
        }
        for (ImportItemInterface importItem : topLevelObjects) {
            if (FolderUtil.isFolder((String)importItem.getTypeInterface().getPublicType())) continue;
            this.resetImportItem(importItem);
            String publicType = importItem.getTypeInterface().getPublicType();
            if (SASFoldersUtil.isContainedByFolder((String)publicType, (ServerInterface)this._server)) {
                this.populateFolderMember(importItem);
                continue;
            }
            if (SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)this._server)) {
                this.populateVirtualFolderMember(importItem);
                continue;
            }
            this.populateContainerMember(importItem, this._targetNode);
        }
        if (this._targetNode instanceof FolderNodeInterface && this._targetNode.getChildCount() == 0) {
            ContainerNodeInterface node = this._targetNode;
            ContainerNodeInterface parent = (ContainerNodeInterface)this._targetNode.getContainer();
            while (parent != null) {
                parent.removeChild((PublicObjectInterface)node);
                node = parent;
                if (node != null && node.getChildCount() > 0) break;
                parent = (ContainerNodeInterface)node.getContainer();
            }
            FolderNodeInterface rootFolder = this.getRootFolder();
            rootFolder.removeChild((PublicObjectInterface)this._targetNode);
        }
        if (this._operation.getImportType() == 1) {
            this._operation.getLogger().info(RB.getStringResource("ImportFolderModel.ImportingNewObjects.txt"));
            this.pruneTree((MutableContainerInterface)this._targetNode);
            if (this._targetNode.getChildCount() == 0) {
                throw new NoObjectsToImportException(RB.getStringResource("ImportFolderModel.NoNewObjects.txt"));
            }
        }
    }

    private void resetImportItem(ImportItemInterface importItem) {
        importItem.setTargetID(null);
        importItem.setImportState(1);
    }

    private boolean isOverwritingExistingObjects() {
        return this._config instanceof ImportModelConfiguration && ((ImportModelConfiguration)this._config).isAllowingObjectOverwrites();
    }

    private void populateFolder(ImportItemInterface importItem, int count) throws ServiceException, RemoteException {
        ContainerNodeInterface node = null;
        ImportElementInterface importElement = null;
        boolean canImport = true;
        if (count == 0 && this._importingIntoSameFolder && !this._moveManager.isTargetPathModified(this._targetNode.getIdentifier())) {
            node = this._targetNode;
            importElement = this.createImportElement(importItem, (PublicObjectNodeInterface)node);
            this.setObjectState(importElement, 1, this._targetNode.getIdentifier());
            if (!this._authorizedOnTarget) {
                importElement.setObjectState(32);
                canImport = false;
                String displayType = node.getTypeDescriptor().getType();
                PathUrl path = node.getPathUrl();
                this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.NoWritePermissionOnParentFolder.fmt.txt", (Object)displayType, (Object)node.getName(), (Object)path.getDisplayPath()));
            }
        } else {
            ContainerNodeInterface parentNode = this.getParentNodeForFolder(importItem);
            node = (ContainerNodeInterface)this.createNode(importItem, parentNode);
            if (node == null) {
                return;
            }
            importElement = this.createImportElement(importItem, (PublicObjectNodeInterface)node);
            if (importItem.isRenamed()) {
                this.renameNodeOnly(importElement, true);
            }
            this.setNodeState((PublicObjectNodeInterface)node);
            if (!this.isOverwritingExistingObjects()) {
                if (!importElement.isNewObject()) {
                    this.renameItem((PublicObjectNodeInterface)node);
                }
            } else if (this._operation.getImportType() == 1) {
                boolean isNew = importElement.isNewObject();
                if (!isNew) {
                    this.disableImportNode(importElement);
                } else if (!importElement.isPermissionGranted()) {
                    this.disableImportNode(importElement);
                    canImport = false;
                    if (importElement.isWritePermissionDenied()) {
                        String displayType = node.getTypeDescriptor().getType();
                        PathUrl path = node.getPathUrl();
                        this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.NoWritePermissionOnParentFolder.fmt.txt", (Object)displayType, (Object)node.getName(), (Object)path.getDisplayPath()));
                    }
                }
            } else if (!importElement.isPermissionGranted()) {
                this.disableImportNode(importElement);
                canImport = false;
                if (importElement.isNewObject()) {
                    if (importElement.isWritePermissionDenied()) {
                        String displayType = node.getTypeDescriptor().getType();
                        PathUrl path = node.getPathUrl();
                        this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.NoWritePermissionOnParentFolder.fmt.txt", (Object)displayType, (Object)node.getName(), (Object)path.getDisplayPath()));
                    }
                } else if (importElement.isReadPermissionDenied()) {
                    this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.FolderExistsNoPermission.fmt.txt", (Object)node.getDisplayPath()));
                }
            }
            if (canImport) {
                canImport = this.processUserFolder(node, importElement);
            }
        }
        if (canImport) {
            this._importItems.put(importItem.getID(), importElement);
        }
    }

    private boolean processUserFolder(ContainerNodeInterface node, ImportElementInterface importElement) throws ServiceException, RemoteException {
        String id = node.getIdentifier();
        if (!this._userFolderManager.isUserFolder(id)) {
            return true;
        }
        boolean canImport = true;
        switch (this._locationState) {
            case USER_FOLDERS_ROOT: {
                PublicObjectContainerInterface parent;
                String type = this._userFolderManager.getUserFolderType(id);
                if ("Home Folder".equalsIgnoreCase(type)) {
                    if (node.getContainer() != this._targetNode) break;
                    canImport = this.processHomeFolder(node, importElement, id);
                    break;
                }
                if (!"My Folder".equalsIgnoreCase(type) && !"Application Data".equalsIgnoreCase(type) || !this._userFolderManager.isUserFolder((parent = node.getContainer()).getIdentifier()) || !"Home Folder".equalsIgnoreCase(this._userFolderManager.getUserFolderType(parent.getIdentifier()))) break;
                this.processMyFolder(node, id, type);
                break;
            }
            case ROOT_FOLDER: {
                PublicObjectContainerInterface grandParent;
                PublicObjectContainerInterface parent;
                String type = this._userFolderManager.getUserFolderType(id);
                if ("Home Folder".equalsIgnoreCase(type)) {
                    PublicObjectContainerInterface parent2 = node.getContainer();
                    if (!this._userFolderManager.isUserFoldersRoot((PublicObjectInterface)parent2)) break;
                    canImport = this.processHomeFolder(node, importElement, id);
                    break;
                }
                if (!"My Folder".equalsIgnoreCase(type) && !"Application Data".equalsIgnoreCase(type) || (parent = node.getContainer()) == null || !this._userFolderManager.isUserFoldersRoot((PublicObjectInterface)(grandParent = parent.getContainer()))) break;
                if (this._userFolderManager.isUserFolder(parent.getIdentifier()) && "Home Folder".equalsIgnoreCase(this._userFolderManager.getUserFolderType(parent.getIdentifier()))) {
                    this.processMyFolder(node, id, type);
                    break;
                }
                if (!(parent instanceof ImportContainerNode)) break;
                ImportElementInterface parentElement = (ImportElementInterface)((ImportContainerNode)parent).getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                if (!parentElement.isNewObject()) {
                    String targetID = null;
                    ImportItemInterface item = parentElement.getImportItem();
                    if (item != null) {
                        targetID = item.getTargetID();
                    } else if (this._operation.isPreservingPaths()) {
                        targetID = parent.getIdentifier();
                    }
                    if (targetID == null || !this._userFolderManager.isUserHomeFolder((PublicObjectInterface)parent)) break;
                    this.processMyFolder(node, id, type);
                    break;
                }
                if (!this._operation.isPreservingPaths()) break;
                if (this._userFolderManager.doesIdentityExistOnServer(parent.getName())) {
                    this.processMyFolder(node, id, type);
                    if (parentElement.getImportItem() != null) break;
                    this._moveManager.removeObjectFromPreserveCache(id);
                    break;
                }
                this.invalidateContainer((ImportContainerNode)parent);
                this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.MissingIdentity.fmt.txt", (Object)parent.getName()));
                return false;
            }
            case USER_HOME_FOLDER: {
                String type = this._userFolderManager.getUserFolderType(id);
                if (!"My Folder".equalsIgnoreCase(type) && !"Application Data".equalsIgnoreCase(type)) break;
                this.processMyFolder(node, id, type);
                break;
            }
        }
        return canImport;
    }

    private boolean processHomeFolder(ContainerNodeInterface node, ImportElementInterface importElement, String id) throws ServiceException, RemoteException {
        String identity = this._userFolderManager.getUserFolderIdentity(id);
        FolderInterface userFolder = this._userFolderManager.getUserFolderOnServer("Home Folder", identity);
        if (userFolder != null) {
            if (!userFolder.getName().equals(node.getName())) {
                this.disableImportNode(importElement);
                importElement.setObjectState(128);
                this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.HomeFolderWarning.fmt.txt", (Object)identity));
                return false;
            }
        } else if (this._userFolderManager.doesIdentityExistOnServer(identity)) {
            this._userFolderManager.addUserFolder(id);
        } else {
            this.disableImportNode(importElement);
            importElement.setObjectState(128);
            this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.MissingIdentity.fmt.txt", (Object)identity));
            return false;
        }
        return true;
    }

    private void processMyFolder(ContainerNodeInterface node, String id, String type) throws ServiceException, RemoteException {
        String identity = this._userFolderManager.getUserFolderIdentity(id);
        if (!this._userFolderManager.doesUserFolderExistOnServer(type, identity) && node.getName().equals(this._userFolderManager.getUserFolderNameOnServer(type, identity))) {
            this._userFolderManager.addUserFolder(id);
        }
    }

    private void populateFolderMember(ImportItemInterface importItem) throws ServiceException, RemoteException {
        ContainerNodeInterface parentNode = this.getParentNodeForMember(importItem);
        this.populatePublicObject(importItem, parentNode);
    }

    private void populateVirtualFolderMember(ImportItemInterface importItem) throws ServiceException, RemoteException {
        String publicType = importItem.getTypeInterface().getPublicType();
        TypeDescriptorInterface typeDesc = this._server.getTypeDescriptor(publicType);
        if (typeDesc != null) {
            String[] sourcePathArray = importItem.getSourcePath();
            List<String> sourcePath = BIPTreeUtil.pathToList(sourcePathArray);
            ArrayList<String> targetPath = new ArrayList<String>(6);
            switch (this.getPathMode(importItem).ordinal()) {
                case 0: {
                    targetPath.addAll(this._targetContainerPath);
                    targetPath.addAll(sourcePath);
                    List defaultPath = SASFoldersUtil.parseFolderPath((String)VirtualFolderManager.getDefaultPath((String)publicType));
                    if (SASFoldersUtil.areFolderPathsEqual((List)defaultPath, targetPath)) break;
                    String topLevelFolder = (String)targetPath.get(0);
                    String topLevelFolderPath = "/" + topLevelFolder;
                    PathUrl pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)topLevelFolderPath);
                    pathUrl.setType("Folder");
                    FolderInterface folder = (FolderInterface)this._server.getObjectByPath(pathUrl);
                    if (folder == null) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.CannotPreserve.NoCustom.fmt.txt", (Object)typeDesc.getType(), (Object)topLevelFolder);
                        throw new ServiceException(msg);
                    }
                    RepositoryInterface ri = folder.getRepository();
                    if (!(ri instanceof OMIRepositoryInterface) || "CUSTOM".equals(((OMIRepositoryInterface)ri).getRepositoryType())) break;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.CannotPreserve.WrongReposType.fmt.txt", (Object)typeDesc.getType(), (Object)pathUrl.getDisplayPath());
                    throw new ServiceException(msg);
                }
                case 3: {
                    this.cleanPath(sourcePath);
                    if (this._importingIntoSameFolder && sourcePath.size() > 0) {
                        sourcePath.remove(0);
                    }
                    targetPath.addAll(this._targetContainerPath);
                    targetPath.addAll(sourcePath);
                    String reposName = this._operation.getRepositoryName();
                    OMIRepositoryInterface repos = (OMIRepositoryInterface)this._server.getRepository(reposName);
                    if (!VirtualFolderManager.isContainedByVirtualFolder((String)publicType, (OMIRepositoryInterface)repos)) {
                        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.CannotImportIntoCustom.fmt.txt", (Object)this._targetNode.getDisplayPath(), (Object)typeDesc.getType());
                        throw new ServiceException(msg);
                    }
                    List staticPath = SASFoldersUtil.parseFolderPath((String)VirtualFolderManager.getDefaultPath((String)publicType, (OMIRepositoryInterface)repos));
                    if (SASFoldersUtil.areFolderPathsEqual((List)staticPath, targetPath)) break;
                    String defaultLocation = VirtualFolderManager.getDefaultPath((String)publicType);
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.InvalidVirtualLocation.fmt.txt", (Object)this._targetNode.getDisplayPath(), (Object)importItem.getTypeInterface().getDisplayType(), (Object)defaultLocation);
                    throw new ServiceException(msg);
                }
            }
            FolderNodeInterface parentNode = this.getRootFolder();
            if (targetPath != null) {
                for (String folderName : targetPath) {
                    PublicObjectNodeInterface childNode = SASFoldersUtil.findChildNode((ContainerNodeInterface)parentNode, (String)folderName, (String)"Folder");
                    if (childNode == null) {
                        String parentPath = parentNode.getAbsolutePath();
                        PathUrl parentPathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._server, (String)parentPath);
                        PathUrl childPathUrl = new PathUrl(parentPathUrl, folderName);
                        childPathUrl.setType("Folder");
                        FolderInterface folder = (FolderInterface)this._server.getObjectByPath(childPathUrl);
                        if (folder == null) {
                            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.MissingFolder.fmt.txt", (Object)childPathUrl.getDisplayPath());
                            throw new ServiceException(msg);
                        }
                        childNode = folder instanceof VirtualFolderInterface ? this.createVirtualFolderNode(folderName, (ContainerNodeInterface)parentNode) : this.createNode(folder.getReposId(), folderName, folder.getTypeDescriptor(), (ContainerNodeInterface)parentNode);
                    }
                    if (!(childNode instanceof ContainerNodeInterface)) continue;
                    parentNode = (ContainerNodeInterface)childNode;
                }
            } else {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.NoTargetPath.fmt.txt", (Object)importItem.toString());
                throw new ServiceException(msg);
            }
            this.populatePublicObject(importItem, (ContainerNodeInterface)parentNode);
        }
    }

    private void populateContainerMember(ImportItemInterface importItem, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        this.populatePublicObject(importItem, parentNode);
    }

    private void populatePublicObject(ImportItemInterface importItem, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this.createNode(importItem, parentNode);
        if (node == null) {
            return;
        }
        ImportElementInterface importElement = this.createImportElement(importItem, node);
        this.setNodeState(node);
        boolean canImport = true;
        if (this.isOverwritingExistingObjects()) {
            boolean permissionGranted = importElement.isPermissionGranted();
            if (this._operation.getImportType() == 1) {
                if (!importElement.isNewObject() || !permissionGranted) {
                    this.disableImportNode(importElement);
                    canImport = false;
                    if (!importElement.isNewObject()) {
                        parentNode.removeChild((PublicObjectInterface)node);
                    }
                }
            } else if (!permissionGranted) {
                this.disableImportNode(importElement);
                canImport = false;
                if (!importElement.isNewObject()) {
                    if (importElement.isReadPermissionDenied()) {
                        String displayType = node.getTypeDescriptor().getType();
                        PathUrl path = node.getPathUrl();
                        this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.ObjectExistsNoReadPermission.fmt.txt", (Object)displayType, (Object)path.getDisplayPath()));
                    } else if (importElement.isWritePermissionDenied()) {
                        String displayType = node.getTypeDescriptor().getType();
                        PathUrl path = node.getPathUrl();
                        this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.ObjectExistsNoWritePermission.fmt.txt", (Object)displayType, (Object)path.getDisplayPath()));
                    }
                } else if (importElement.isWritePermissionDenied()) {
                    String displayType = node.getTypeDescriptor().getType();
                    String path = BIPTreeUtil.pathToString(SASFoldersUtil.getObjectPath((PublicObjectInterface)node));
                    this._operation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.NoWritePermissionOnParentFolder.fmt.txt", (Object)displayType, (Object)node.getName(), (Object)path));
                }
            }
        } else if (!importElement.isNewObject()) {
            Log log = this._operation.getLogger();
            if (log.isDebugEnabled()) {
                String displayType = node.getTypeDescriptor().getType();
                PathUrl path = node.getPathUrl();
                log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.RenameObject.fmt.txt", (Object)displayType, (Object)path.getDisplayPath()));
            }
            this.renameItem(node);
        }
        if (canImport) {
            this._importItems.put(importItem.getID(), importElement);
        }
    }

    private boolean isValidContainerType(ImportItemInterface importItem, ContainerNodeInterface container) throws ServiceException, RemoteException {
        String publicType = importItem.getTypeInterface().getPublicType();
        if (container instanceof VirtualFolderNodeInterface) {
            return SASFoldersUtil.isContainedByVirtualFolder((String)publicType, (ServerInterface)this._operation.getServer());
        }
        if ("Folder.SecuredData".equalsIgnoreCase(publicType)) {
            if ("Folder.SecuredData".equalsIgnoreCase(container.getTypeDescriptor().getTypeName())) {
                return true;
            }
            if (!ImportFolderUtil.isSystemFolder(container)) {
                return false;
            }
            ConnectionManagerInterface mgr = this._operation.getConnectionManager();
            ConnectionPointInterface cp = mgr.getFolderConnection(importItem);
            return cp == null || !"Folder.SecuredData".equalsIgnoreCase(cp.getPublicType());
        }
        TypeDescriptorInterface type = this._server.getTypeDescriptor(publicType);
        return SASFoldersUtil.isValidContainerForChild((TypeDescriptorInterface)type, (TypeDescriptorInterface)container.getTypeDescriptor());
    }

    private ContainerNodeInterface getParentNodeForFolder(ImportItemInterface importItem) throws ServiceException, RemoteException {
        List<String> sourcePath = BIPTreeUtil.pathToList(importItem.getSourcePath());
        FolderNodeInterface parentNode = null;
        ArrayList<String> targetPath = new ArrayList<String>(6);
        switch (this.getPathMode(importItem).ordinal()) {
            case 1: {
                String newTargetReposID;
                String originalTargetReposID;
                RepositoryInterface repos;
                MetadataInterface mi;
                PathUrl customPath = this._moveManager.getCustomTargetPath(importItem.getID());
                if (customPath == null) break;
                targetPath = ImportFolderUtil.parseFolderPath(customPath);
                PathUrl parentPath = ImportFolderUtil.constructFolderPathUrl(this._operation.getServer(), targetPath);
                if (this._operation.getPackageFileVersion() < 9300 && (mi = this._server.getObjectByPath(parentPath)) != null && (repos = mi.getRepository()) instanceof OMIRepositoryInterface && !(originalTargetReposID = this._operation.getRepositoryID()).equalsIgnoreCase(newTargetReposID = ((OMIRepositoryInterface)repos).getDefaultRepositoryId())) {
                    String msg = "The folder \"" + importItem.getName() + "\" cannot be moved to \"" + parentPath.getDisplayPath() + "\".";
                    throw new ServiceException(msg);
                }
                parentNode = this.createFolderPath(parentPath);
                break;
            }
            case 0: {
                targetPath.addAll(this._targetContainerPath);
                targetPath.addAll(sourcePath);
                parentNode = this.preserveFolderPath(targetPath);
                ArrayList<String> folderPathList = new ArrayList<String>(targetPath);
                folderPathList.add(importItem.getName());
                if (!this.canFolderBeMoved(folderPathList)) break;
                this._moveManager.preserveFolderPath(importItem.getID(), (ContainerNodeInterface)parentNode);
                break;
            }
            case 3: {
                this.cleanPath(sourcePath);
                targetPath.addAll(this._targetContainerPath);
                targetPath.addAll(sourcePath);
                parentNode = this.getParentNodeForItem(targetPath, sourcePath, this._targetNode);
            }
        }
        return parentNode;
    }

    private ContainerNodeInterface getParentNodeForMember(ImportItemInterface importItem) throws ServiceException, RemoteException {
        ContainerNodeInterface parentNode;
        block19: {
            List<String> sourcePath;
            block18: {
                String[] sourcePathArray = importItem.getSourcePath();
                boolean preservingPaths = this._operation.isPreservingPaths();
                if (importItem.isOrphaned()) {
                    if (preservingPaths) {
                        String message = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.CannotPreserveOrphan.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName());
                        throw new IllegalStateException(message);
                    }
                    sourcePathArray = EMPTY_FOLDER_PATH;
                    if (this._targetNode instanceof FolderNodeInterface) {
                        this._moveManager.addOrphanedObject(importItem.getID());
                    }
                }
                sourcePath = BIPTreeUtil.pathToList(sourcePathArray);
                parentNode = null;
                if (!this.isExternalDependency(importItem.getID())) break block18;
                ArrayList<String> targetPath = new ArrayList(6);
                switch (this.getPathMode(importItem).ordinal()) {
                    case 1: {
                        PathUrl customPath = this._moveManager.getCustomTargetPath(importItem.getID());
                        if (customPath == null) break;
                        targetPath = ImportFolderUtil.parseFolderPath(customPath);
                        PathUrl parentPath = ImportFolderUtil.constructFolderPathUrl(this._operation.getServer(), targetPath);
                        parentNode = this.createFolderPath(parentPath);
                        if (PromotionUtil.isRootFolder((PublicObjectInterface)parentNode)) {
                            throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.InvalidTargetPath.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName()));
                        }
                        break block19;
                    }
                    case 0: {
                        if (sourcePath == null || sourcePath.isEmpty()) {
                            parentNode = this._targetNode;
                            break;
                        }
                        if (!this.isMoveAllowed(importItem)) {
                            String message = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.CannotPreserve.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)BIPTreeUtil.pathToString(sourcePathArray, importItem.getName()));
                            throw new IllegalStateException(message);
                        }
                        PathUrl path = ImportFolderUtil.constructFolderPathUrl(this._operation.getServer(), sourcePath);
                        parentNode = (FolderNodeInterface)SASFoldersUtil.findNodeByPath((PathUrl)path, (FolderModelInterface)this);
                        if (parentNode == null) {
                            parentNode = this.preserveFolderPath(sourcePath, this.getRootFolder());
                        }
                        this._moveManager.preserveFolderPath(importItem.getID(), parentNode);
                        break;
                    }
                    case 3: {
                        parentNode = this._targetNode;
                        if (!this._importingIntoRoot) break;
                        this._operation.getLogger().error(RB.getStringResource("ImportFolderModel.DependentObjectsFound.txt"));
                    }
                }
                break block19;
            }
            ArrayList<String> targetPath = new ArrayList<String>(6);
            switch (this.getPathMode(importItem).ordinal()) {
                case 1: {
                    PathUrl customPath = this._moveManager.getCustomTargetPath(importItem.getID());
                    if (customPath == null) break;
                    targetPath = ImportFolderUtil.parseFolderPath(customPath);
                    PathUrl parentPath = ImportFolderUtil.constructFolderPathUrl(this._operation.getServer(), targetPath);
                    parentNode = this.createFolderPath(parentPath);
                    if (!PromotionUtil.isRootFolder((PublicObjectInterface)parentNode)) break;
                    throw new IllegalStateException(Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.InvalidTargetPath.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName()));
                }
                case 0: {
                    targetPath.addAll(this._targetContainerPath);
                    targetPath.addAll(sourcePath);
                    parentNode = this.preserveFolderPath(targetPath);
                    if (!this.canObjectBeMoved(targetPath)) break;
                    this._moveManager.preserveFolderPath(importItem.getID(), parentNode);
                    break;
                }
                case 3: {
                    this.cleanPath(sourcePath);
                    targetPath.addAll(this._targetContainerPath);
                    targetPath.addAll(sourcePath);
                    parentNode = this.getParentNodeForItem(targetPath, sourcePath, this._targetNode);
                }
            }
        }
        if (this._importingIntoRoot && PromotionUtil.isRootFolder((PublicObjectInterface)parentNode)) {
            throw new IllegalStateException(RB.getStringResource("ImportFolderModel.ObjectsUnderRoot.txt"));
        }
        return parentNode;
    }

    private ObjectPathMode getPathMode(ImportItemInterface importItem) {
        if (this._moveManager.isTargetPathModified(importItem.getID())) {
            return ObjectPathMode.CUSTOM_PATH;
        }
        if (this._operation.isPreservingPaths()) {
            return ObjectPathMode.PRESERVE_SOURCE_PATH;
        }
        return ObjectPathMode.DEFAULT;
    }

    private void disableImportNode(ImportElementInterface importNode) throws ServiceException, RemoteException {
        if (importNode == null) {
            return;
        }
        ImportItemInterface importItem = importNode.getImportItem();
        if (importItem != null) {
            importItem.setImportState(0);
        }
    }

    private void invalidateContainer(ImportContainerNode container) throws ServiceException, RemoteException {
        ImportElementInterface element = (ImportElementInterface)container.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
        if (element != null) {
            this.disableImportNode(element);
            element.setObjectState(128);
            List<PublicObjectNodeInterface> children = container.getChildren();
            for (PublicObjectNodeInterface child : children) {
                if (child instanceof ImportContainerNode) {
                    this.invalidateContainer((ImportContainerNode)child);
                    continue;
                }
                ImportElementInterface childElement = (ImportElementInterface)child.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                if (childElement == null) continue;
                this.disableImportNode(childElement);
                childElement.setObjectState(128);
            }
        }
    }

    protected PublicObjectNodeInterface createNode(ImportItemInterface importItem, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        String id;
        PublicObjectNodeInterface node;
        if (!this.validateImportItem(importItem, parentNode)) {
            return null;
        }
        TypeInterface logicalType = importItem.getTypeInterface();
        String publicType = logicalType.getPublicType();
        TypeDescriptorInterface type = this._operation.getServer().getTypeDescriptor(publicType);
        boolean isUnique = true;
        if (!this._nodeCache.containsKey(importItem.getID())) {
            isUnique = SASFoldersUtil.isUnique((PublicObjectContainerInterface)parentNode, (String)importItem.getName(), (String)publicType);
        }
        if ((node = this.createNode(id = importItem.getID(), importItem.getName(), type, parentNode)) != null) {
            if (id != null) {
                this._nodeCache.put(id, node);
            }
            this.createImportElement(importItem, node);
            if (!isUnique) {
                ImportElementInterface element;
                PublicObjectNodeInterface originalNode;
                if (this._duplicateNamedObjects == null) {
                    this._duplicateNamedObjects = new HashSet<PublicObjectNodeInterface>();
                }
                if ((originalNode = SASFoldersUtil.findChildNode((ContainerNodeInterface)parentNode, (String)importItem.getName(), (String)importItem.getTypeInterface().getPublicType())) != null && (element = (ImportElementInterface)originalNode.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface")) != null) {
                    this._duplicateNamedObjects.add(originalNode);
                }
                this._duplicateNamedObjects.add(node);
            }
        }
        return node;
    }

    private PublicObjectNodeInterface createNode(String id, String name, TypeDescriptorInterface type) throws ServiceException, RemoteException {
        Object node = null;
        if (type != null) {
            String publicType = type.getTypeName();
            node = FolderUtil.isFolder((String)publicType) ? (id == null || id.length() == 0 ? this.createVirtualFolderNode(name) : new ImportFolderNode(id, name, type)) : ("RootFolder".equalsIgnoreCase(publicType) ? this.getRootFolder() : (this.isContainerType(type) ? new ImportContainerNode(id, name, type) : new ImportMemberNode(id, name, type)));
            node.setFolderModel((FolderModelInterface)this);
        }
        return node;
    }

    protected boolean isContainerType(TypeDescriptorInterface type) throws ServiceException, RemoteException {
        if (type == null) {
            return false;
        }
        return FolderUtil.isFolder((String)type.getTypeName());
    }

    private PublicObjectNodeInterface createNode(String id, String name, TypeDescriptorInterface type, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        PublicObjectNodeInterface node = this.createNode(id, name, type);
        if (node != null) {
            this.addChildNode(parentNode, node);
        }
        return node;
    }

    private PublicObjectNodeInterface createVirtualFolderNode(String name) throws ServiceException, RemoteException {
        ImportVirtualFolderNode virtualFolder = new ImportVirtualFolderNode(name);
        virtualFolder.setFolderModel(this);
        virtualFolder.setServer(this._server);
        return virtualFolder;
    }

    private PublicObjectNodeInterface createVirtualFolderNode(String name, ContainerNodeInterface parentNode) throws ServiceException, RemoteException {
        PublicObjectNodeInterface virtualFolder = this.createVirtualFolderNode(name);
        this.addChildNode(parentNode, virtualFolder);
        return virtualFolder;
    }

    protected ImportElementInterface createImportElement(ImportItemInterface importItem, PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        ImportElement importElement;
        if (importItem instanceof DefaultImportItem) {
            String[] path = SASFoldersUtil.getObjectPath((PublicObjectInterface)node);
            ((DefaultImportItem)importItem).setTargetPath(path);
        }
        if ((importElement = (ImportElement)this.getImportElement((PublicObjectInterface)node)) == null) {
            importElement = new ImportElement((PublicObjectInterface)node);
            importElement.setImportItem(importItem);
            node.addProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface", (ProcessorInterface)importElement);
        }
        return importElement;
    }

    private FolderNodeInterface createFolderPath(PathUrl path) throws ServiceException, RemoteException {
        return (FolderNodeInterface)this.getObjectByPath(path);
    }

    private FolderNodeInterface preserveFolderPath(List<String> folderPath) throws ServiceException, RemoteException {
        return this.preserveFolderPath(folderPath, this.getRootFolder());
    }

    private FolderNodeInterface preserveFolderPath(List<String> folderPath, FolderNodeInterface targetNode) throws ServiceException, RemoteException {
        FolderNodeInterface parentNode = targetNode;
        ArrayList<String> currentPath = new ArrayList<String>(folderPath.size());
        for (String folderName : folderPath) {
            currentPath.add(folderName);
            PathUrl path = ImportFolderUtil.constructFolderPathUrl(this._operation.getServer(), currentPath);
            FolderNodeInterface childNode = (FolderNodeInterface)SASFoldersUtil.findNodeByPath((PathUrl)path, (FolderModelInterface)this);
            if (childNode == null) {
                TypeDescriptorInterface folderType;
                String folderID = null;
                FolderInterface folder = (FolderInterface)this._operation.getServer().getObjectByPath(path);
                if (folder == null) {
                    folderID = PRESERVED_FOLDER_PREFIX + this._preservePathFolderCount++;
                    folderType = SASFoldersUtil.isRootFolder((PublicObjectInterface)parentNode) ? this._operation.getServer().getTypeDescriptor("Folder") : parentNode.getTypeDescriptor();
                } else {
                    folderID = folder.getIdentifier();
                    folderType = folder.getTypeDescriptor();
                }
                childNode = (FolderNodeInterface)this.createNode(folderID, folderName, folderType, (ContainerNodeInterface)parentNode);
                if (childNode == null) {
                    throw new ServiceException("Unable to create node");
                }
                ImportElement importElement = (ImportElement)this.getImportElement((PublicObjectInterface)childNode);
                if (importElement == null) {
                    importElement = new ImportElement((PublicObjectInterface)childNode);
                    childNode.addProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface", (ProcessorInterface)importElement);
                    this.setNodeState((PublicObjectNodeInterface)childNode);
                }
            }
            parentNode = childNode;
        }
        return parentNode;
    }

    private boolean validateImportItem(ImportItemInterface importItem, ContainerNodeInterface container) throws ServiceException, RemoteException {
        String objectName;
        if (!this.isValidContainerType(importItem, container)) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.InvalidContainerType.fmt.txt", (Object)container.getTypeDescriptor().getType(), (Object)container.getPathUrl().getDisplayPath());
            throw new ServiceException(msg);
        }
        if (!ImportFolderUtil.isVirtualFolder(container) && !Names.validateOMRObjectName((String)(objectName = importItem.getName()), (boolean)false)) {
            ObjectRenameManager renameManager = ObjectRenameManager.getInstance(this._operation);
            String newName = Names.mapNameToOMRObjectName((String)objectName);
            renameManager.renameItem(importItem, newName);
            this.markItemForRename(importItem);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"ImportFolderModel.RenameInvalidObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem, (Object)objectName);
            this._operation.getLogger().warn(msg);
        }
        return true;
    }

    private void markItemForRename(ImportItemInterface importItem) {
        if (this._renamedObjects == null) {
            this._renamedObjects = new HashSet<ImportItemInterface>();
        }
        if (!this._renamedObjects.contains(importItem)) {
            this._renamedObjects.add(importItem);
        }
    }

    private void renameItem(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        ImportElementInterface importNode = (ImportElementInterface)node.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
        if (importNode == null) {
            return;
        }
        ImportItemInterface importItem = importNode.getImportItem();
        ObjectRenameManager renameManager = ObjectRenameManager.getInstance(this._operation);
        HashSet<String> names = new HashSet<String>();
        TypeDescriptorInterface type = node.getTypeDescriptor();
        PublicObjectContainerInterface parentNode = node.getContainer();
        for (PublicObjectInterface child : parentNode.getChildren()) {
            if (node == child || !type.equals((Object)child.getTypeDescriptor())) continue;
            names.add(child.getName());
        }
        try {
            boolean renamed = renameManager.generateNewName(importItem, names);
            if (renamed) {
                this.renameNodeOnly(importNode, false);
            }
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void renameNodeOnly(ImportElementInterface importNode, boolean setOriginalName) throws ServiceException, RemoteException {
        ImportItemInterface importItem = importNode.getImportItem();
        if (setOriginalName) {
            importNode.setOriginalName(importItem.getOriginalName());
        } else {
            importNode.rename(importItem.getName());
        }
        this.markItemForRename(importItem);
    }

    private void setExportState(PublicObjectContainerInterface targetContainer) throws RemoteException {
        List path = this._operation.getExportedFolderPath();
        if (path != null) {
            this._exportState = ExportState.EXPORTED_SINGLE_FOLDER;
            this._exportedFolderPath = path;
            if (this._exportedFolderPath.size() == 0) {
                this._exportedFromRoot = true;
            }
        } else {
            this._exportState = ExportState.EXPORTED_MULTIPLE_FOLDERS;
            List paths = this._operation.getExportedFolderPaths();
            if (paths != null) {
                this._exportedFolderPaths = paths;
            } else if (this._operation.getPackageFileVersion() < 9200) {
                this.loadExportedFoldersIn913Package();
            } else {
                this._exportedFolderPaths = Collections.emptyList();
            }
        }
    }

    private void loadExportedFoldersIn913Package() {
        boolean containsSubFolder = false;
        ArrayList<List<String>> pathCache = new ArrayList<List<String>>();
        List<ImportItemInterface> folders = this._operation.getFoldersImporting();
        for (ImportItemInterface folder : folders) {
            String[] pathArray = folder.getSourcePath();
            List<String> pathList = BIPTreeUtil.pathToList(pathArray);
            pathList.add(folder.getName());
            boolean contains = false;
            for (List list : pathCache) {
                if (!SASFoldersUtil.isChildOf(pathList, (List)list)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            pathCache.add(pathList);
            if (pathArray.length <= 0) continue;
            containsSubFolder = true;
        }
        if (pathCache.size() > 0) {
            if (!containsSubFolder) {
                this._exportedFolderPath = Collections.emptyList();
                this._exportedFromRoot = true;
                this._exportState = ExportState.EXPORTED_SINGLE_FOLDER;
            } else {
                this._exportedFolderPaths = new ArrayList<List<String>>(pathCache);
            }
        } else {
            this._exportedFolderPaths = Collections.emptyList();
        }
    }

    private void cleanPath(List<String> objectPath) {
        if (objectPath.size() == 0) {
            return;
        }
        switch (this._exportState.ordinal()) {
            case 0: {
                ArrayList<String> exportFolderPath = new ArrayList<String>(this._exportedFolderPath);
                if (!this._importingIntoRoot && exportFolderPath.size() > 0) {
                    exportFolderPath.remove(exportFolderPath.get(exportFolderPath.size() - 1));
                }
                this.cleanPath(objectPath, exportFolderPath);
                break;
            }
            case 1: {
                boolean found = false;
                int len = this._exportedFolderPaths.size();
                for (int i = 0; i < len; ++i) {
                    ArrayList<String> path = new ArrayList<String>((Collection)this._exportedFolderPaths.get(i));
                    if (path.size() > 0) {
                        path.remove(path.size() - 1);
                    }
                    if (!SASFoldersUtil.isChildOf(objectPath, path)) continue;
                    this.cleanPath(objectPath, path);
                    found = true;
                    break;
                }
                if (found || this._exportedFromRoot) break;
                objectPath.clear();
                break;
            }
        }
    }

    private void cleanPath(List<String> objectPath, List<String> folderPath) {
        if (folderPath == null) {
            return;
        }
        int length = folderPath.size();
        if (length > 0) {
            for (int i = 0; i < (this._importingIntoRoot && this._exportState != ExportState.EXPORTED_MULTIPLE_FOLDERS ? length - 1 : length); ++i) {
                if (!folderPath.get(i).equals(objectPath.get(0))) {
                    return;
                }
                objectPath.remove(0);
            }
        }
    }

    private ContainerNodeInterface getParentNodeForItem(List<String> absoluteTargetPath, List<String> relativeFolderPathList, ContainerNodeInterface rootNode) throws ServiceException, RemoteException {
        ContainerNodeInterface parentNode = null;
        if (this._importingIntoSameFolder) {
            if (absoluteTargetPath == null || absoluteTargetPath.isEmpty()) {
                parentNode = rootNode;
            } else {
                if (relativeFolderPathList.size() > 0) {
                    relativeFolderPathList.remove(0);
                }
                parentNode = this.getParentNode(relativeFolderPathList, rootNode);
            }
        } else {
            parentNode = relativeFolderPathList.size() == 0 ? rootNode : this.getParentNode(relativeFolderPathList, rootNode);
        }
        if (parentNode == null) {
            parentNode = rootNode;
        }
        return parentNode;
    }

    private ContainerNodeInterface getParentNode(List<String> folderPath, ContainerNodeInterface rootNode) throws ServiceException, RemoteException {
        String[] path = folderPath.toArray(new String[folderPath.size()]);
        PublicObjectInterface node = ImportFolderUtil.findNodeByOriginalPath(path, (PublicObjectContainerInterface)rootNode);
        if (node instanceof ContainerNodeInterface) {
            return (ContainerNodeInterface)node;
        }
        return null;
    }

    private boolean isParentRenamed(PublicObjectNodeInterface parentNode) throws ServiceException, RemoteException {
        ImportElementInterface importNode;
        PublicObjectNodeInterface parent = parentNode;
        if (parent instanceof PublicObjectNodeInterface && (importNode = (ImportElementInterface)parent.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface")) != null) {
            if (importNode.isRenamed()) {
                return true;
            }
            if (parent.getContainer() != null && this.isParentRenamed((PublicObjectNodeInterface)parent.getContainer())) {
                return true;
            }
        }
        return false;
    }

    private boolean isMoveAllowed(ImportItemInterface importItem) {
        ConnectionPointInterface pt = this._operation.getConnectionManager().getFolderConnection(importItem);
        return pt != null;
    }

    private boolean canFolderBeMoved(List<String> folderPath) {
        if (this._exportState == ExportState.EXPORTED_SINGLE_FOLDER) {
            return SASFoldersUtil.areFolderPathsEqual(folderPath, this._exportedFolderPath);
        }
        if (this._exportedFolderPaths != null) {
            for (int i = 0; i < this._exportedFolderPaths.size(); ++i) {
                List<String> exportedFolderPath = this._exportedFolderPaths.get(i);
                if (!SASFoldersUtil.areFolderPathsEqual(folderPath, exportedFolderPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canObjectBeMoved(List<String> objectPath) {
        if (this._exportState == ExportState.EXPORTED_SINGLE_FOLDER) {
            return !SASFoldersUtil.isChildOf(objectPath, this._exportedFolderPath);
        }
        if (this._exportedFolderPaths != null) {
            for (int i = 0; i < this._exportedFolderPaths.size(); ++i) {
                List<String> exportedFolderPath = this._exportedFolderPaths.get(i);
                if (!SASFoldersUtil.isChildOf(objectPath, exportedFolderPath)) continue;
                return false;
            }
        }
        return true;
    }

    private void pruneTree(MutableContainerInterface container) throws ServiceException, RemoteException {
        if (container.getChildCount() > 0) {
            ArrayList<PublicObjectInterface> items = null;
            List children = container.getChildren();
            for (PublicObjectInterface child : children) {
                ImportElementInterface importNode;
                boolean canRemove = false;
                if (child instanceof FolderNodeInterface && ((importNode = (ImportElementInterface)child.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface")) == null || !importNode.isNewObject())) {
                    FolderNodeInterface folder = (FolderNodeInterface)child;
                    this.pruneTree((MutableContainerInterface)folder);
                    if (folder.getChildCount() == 0) {
                        canRemove = true;
                    }
                }
                if (!canRemove) continue;
                if (items == null) {
                    items = new ArrayList<PublicObjectInterface>();
                }
                items.add(child);
            }
            if (items != null) {
                for (PublicObjectInterface child : items) {
                    container.removeChild(child);
                }
            }
        }
    }

    private boolean isExternalDependency(String objectID) {
        return this._dependentObjects != null && this._dependentObjects.contains(objectID);
    }

    public void setNodeState(PublicObjectNodeInterface node) throws ServiceException, RemoteException {
        int state = -1;
        ImportElementInterface importNode = (ImportElementInterface)node.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
        if (importNode != null) {
            if (importNode.getObjectState() != -1) {
                return;
            }
            String targetID = null;
            ContainerNodeInterface parentNode = (ContainerNodeInterface)node.getContainer();
            if (parentNode != null) {
                if (parentNode == this._targetNode) {
                    ImportObjectState objState = this._modelComparison.getObjectState(node);
                    state = objState.getState();
                    targetID = objState.getTargetID();
                    if (targetID == null && !this._authorizedOnTarget) {
                        state |= 0x40;
                    }
                } else {
                    ImportElementInterface parentImportNode = (ImportElementInterface)parentNode.getProcessorInterface("com.sas.metadata.promotion.model.ImportElementInterface");
                    if (parentImportNode != null) {
                        boolean isParentNew = parentImportNode.isNewObject();
                        if (parentImportNode.isStateSet(128)) {
                            state = 128;
                        } else if (isParentNew && parentImportNode.isPermissionGranted()) {
                            state = 2;
                        } else if (parentImportNode.isStateSet(8) || parentImportNode.isStateSet(16)) {
                            state = 16;
                            if (isParentNew) {
                                state |= 2;
                            }
                        } else if (!SASFoldersUtil.isFolder((PublicObjectInterface)node) && parentImportNode.isStateSet(64)) {
                            state = 64;
                            if (isParentNew) {
                                state |= 2;
                            }
                        } else {
                            ImportObjectState objState = this._modelComparison.getObjectState(node);
                            state = objState.getState();
                            targetID = objState.getTargetID();
                        }
                    } else {
                        ImportObjectState objState = this._modelComparison.getObjectState(node);
                        state = objState.getState();
                        targetID = objState.getTargetID();
                    }
                }
                this.setObjectState(importNode, state, targetID);
            }
        }
    }

    private void setObjectState(ImportElementInterface importNode, int state, String targetID) throws ServiceException, RemoteException {
        ImportItemInterface importItem;
        importNode.setObjectState(state);
        if (targetID != null && this.isOverwritingExistingObjects() && (importItem = importNode.getImportItem()) != null) {
            importItem.setTargetID(targetID);
            importItem.setImportState(SASFoldersUtil.isFolder((PublicObjectInterface)importNode.getPublicObject()) ? 0 : 2);
        }
    }

    public void populateContainer(ContainerNodeInterface container) throws ServiceException, RemoteException {
    }

    public void populateFolder(FolderNodeInterface folder) throws ServiceException, RemoteException {
    }

    private static enum ExportState {
        EXPORTED_SINGLE_FOLDER,
        EXPORTED_MULTIPLE_FOLDERS;

    }

    private static enum ObjectPathMode {
        PRESERVE_SOURCE_PATH,
        CUSTOM_PATH,
        TARGET_FOLDER,
        DEFAULT;

    }
}

