/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion.model;

import com.sas.metadata.promotion.model.AbstractImportNode;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.PublicObjectContainerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.ContainerNodeInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.VirtualFolderNodeInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ImportContainerNode
extends AbstractImportNode
implements ContainerNodeInterface {
    protected List<PublicObjectNodeInterface> _children;

    public ImportContainerNode(String id, String name, TypeDescriptorInterface type) {
        super(id, name, type);
    }

    public void addChild(PublicObjectInterface newChild) throws ServiceException, RemoteException {
        this.insertChild(newChild, this.getChildCount());
    }

    public List<PublicObjectNodeInterface> getChildren() throws ServiceException, RemoteException {
        if (this._children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._children);
    }

    public PublicObjectNodeInterface getChildAt(int index) throws ServiceException, RemoteException {
        if (this._children == null || this._children.size() == 0) {
            throw new ArrayIndexOutOfBoundsException("The container has no children");
        }
        return this._children.get(index);
    }

    public int getChildCount() throws ServiceException, RemoteException {
        return this._children == null ? 0 : this._children.size();
    }

    public void insertChild(PublicObjectInterface child, int index) throws ServiceException, RemoteException {
        if (child == null) {
            throw new IllegalArgumentException("Child item is null");
        }
        if (this._children == null) {
            this._children = new ArrayList<PublicObjectNodeInterface>();
        }
        if (!this._children.contains(child) && child instanceof PublicObjectNodeInterface) {
            ((PublicObjectNodeInterface)child).setContainer((PublicObjectContainerInterface)this);
            this._children.add(index, (PublicObjectNodeInterface)child);
        }
    }

    public void removeChild(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child == null) {
            throw new IllegalArgumentException("Child item is null");
        }
        int index = this.getChildIndex(child);
        if (index > -1) {
            this._children.remove(index);
        }
    }

    public boolean isPopulated() {
        return true;
    }

    public void setPopulated(boolean populated) {
    }

    public PublicObjectInterface newChild(String type, String name) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    public List<?> getChildren(String type) throws ServiceException, RemoteException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    protected int getChildIndex(PublicObjectInterface child) throws ServiceException, RemoteException {
        if (child != null) {
            String objectID = child.getIdentifier();
            if (this._children != null && !this._children.isEmpty()) {
                int len = this._children.size();
                for (int index = 0; index < len; ++index) {
                    PublicObjectInterface childItem = (PublicObjectInterface)this._children.get(index);
                    if (!(objectID.length() == 0 && child instanceof VirtualFolderNodeInterface ? child.equals((Object)childItem) : objectID.equalsIgnoreCase(childItem.getIdentifier()))) continue;
                    return index;
                }
            }
        }
        return -1;
    }
}

