/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.DependentObjectsProviderInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionPropertyValue;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Substitution
implements SubstitutionInterface,
DependentObjectsProviderInterface {
    private Map<PromotionItemInterface, List<SubstitutionPropertyValue>> _associatedObjectsMap = null;
    private Map<Integer, Object> _optionCache = null;
    private String _contextValue = null;
    private String _targetContextValue = null;
    private String _sourceValue = null;
    private String _targetValue = null;
    private SubstitutionTypeInterface _type = null;

    protected Substitution(SubstitutionTypeInterface type, String value) {
        this(type, value, null);
    }

    protected Substitution(SubstitutionTypeInterface type, String value, String contextValue) {
        this._type = type;
        this._sourceValue = value;
        this._contextValue = contextValue;
        this._associatedObjectsMap = new LinkedHashMap<PromotionItemInterface, List<SubstitutionPropertyValue>>();
    }

    @Override
    public void addAssociatedObject(PromotionItemInterface item, SubstitutionPropertyValue value) {
        if (this._associatedObjectsMap.containsKey(item)) {
            List<SubstitutionPropertyValue> values = this._associatedObjectsMap.get(item);
            if (values == null) {
                values = new ArrayList<SubstitutionPropertyValue>();
            }
            values.add(value);
        } else {
            ArrayList<SubstitutionPropertyValue> values = new ArrayList<SubstitutionPropertyValue>();
            values.add(value);
            this._associatedObjectsMap.put(item, values);
        }
        if (item instanceof DefaultImportItem) {
            ((DefaultImportItem)item).addSubstitution(this);
        }
    }

    @Override
    public Collection getAssociatedObjects() {
        return this._associatedObjectsMap.keySet();
    }

    @Override
    public Collection<SubstitutionPropertyValue> getAssociatedPropertyValues() {
        ArrayList<SubstitutionPropertyValue> values = new ArrayList<SubstitutionPropertyValue>(this._associatedObjectsMap.size());
        for (Map.Entry<PromotionItemInterface, List<SubstitutionPropertyValue>> entry : this._associatedObjectsMap.entrySet()) {
            values.addAll((Collection<SubstitutionPropertyValue>)entry.getValue());
        }
        return values;
    }

    @Override
    public String getSourceValue() {
        return this._sourceValue;
    }

    @Override
    public SubstitutionTypeInterface getSubstitutionType() {
        return this._type;
    }

    @Override
    public String getTargetValue() {
        return this._targetValue;
    }

    @Override
    public void setTargetValue(String target) {
        this._targetValue = target;
    }

    @Override
    public String getContextValue() {
        return this._contextValue;
    }

    @Override
    public String getTargetContextValue() {
        return this._targetContextValue;
    }

    @Override
    public void setTargetContextValue(String context) {
        this._targetContextValue = context;
    }

    public String toString() {
        return this._sourceValue == null || this._sourceValue.length() == 0 ? "<none>" : this._sourceValue;
    }

    @Override
    public List<ImportItemInterface> getDependentObjects() {
        HashSet<ImportItemInterface> set = new HashSet<ImportItemInterface>();
        Collection objects = this.getAssociatedObjects();
        for (Object obj : objects) {
            ImportItemInterface importItem;
            if (!(obj instanceof ImportItemInterface) || (importItem = (ImportItemInterface)obj).getImportState() == 0) continue;
            set.add(importItem);
        }
        return new ArrayList<ImportItemInterface>(set);
    }

    @Override
    public Object getOption(int option) {
        return this._optionCache == null ? null : this._optionCache.get(option);
    }

    @Override
    public void setOption(int option, Object value) {
        if (this._optionCache == null) {
            this._optionCache = new HashMap<Integer, Object>(5);
        }
        this._optionCache.put(option, value);
    }
}

