/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.SourceConnectionInterface;

public class SearchCriteria {
    public static final int SEARCH_BY_PATH = 0;
    public static final int SEARCH_BY_PATH_THEN_XMLSELECT = 1;
    public static final int SEARCH_BY_XMLSELECT_ONLY = 2;
    private SourceConnectionInterface _connection;
    private int _type = 0;
    private String _metadataType;
    private String _search;
    private boolean _includeSubTypes = false;

    public SearchCriteria(SourceConnectionInterface sourceConnection) {
        this._connection = sourceConnection;
    }

    public SearchCriteria(SourceConnectionInterface sourceConnection, int searchType) {
        this._connection = sourceConnection;
        this.setSearchType(searchType);
    }

    public SourceConnectionInterface getSourceConnection() {
        return this._connection;
    }

    public void setSearchType(int type) {
        if (this._type != 0 && this._type != 1 && this._type != 2) {
            throw new IllegalArgumentException("Invalid search type");
        }
        this._type = type;
    }

    public boolean isSearchingByPath() {
        return this._type == 0 || this._type == 1;
    }

    public boolean isSearchingByXMLSelect() {
        return this._type == 1 || this._type == 2;
    }

    public void setMetadataType(String metadataType) {
        this._metadataType = metadataType;
    }

    public void setSearchString(String search) {
        this._search = search;
    }

    public void setIncludeSubTypes(boolean includeSubTypes) {
        this._includeSubTypes = includeSubTypes;
    }

    public String getMetadataType() {
        return this._metadataType;
    }

    public String getSearchString() {
        return this._search;
    }

    public boolean isIncludingSubTypes() {
        return this._includeSubTypes;
    }
}

