/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPropertiesHandler;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.SubstitutionInterface;
import com.sas.metadata.promotion.SubstitutionPropertiesHandler;
import com.sas.metadata.promotion.SubstitutionTypeInterface;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.SectionedPropertyList;
import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.text.Message;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesManager {
    private static final String LOCALIZABLE_PROPERTIES_FILE = "LocalizedProperties.locprop";
    private static final String SUBSTITUTION_PROPERTIES_FILE = "SubstitutionProperties.subprop";
    private Log _log;
    private PromotionInterface _operation;
    private boolean _useMultiLocaleProperties = false;
    private SectionedPropertyMap _localizedPropertyMap = null;
    private SectionedPropertyList _localizedPropertyList;
    private Map<Locale, SectionedPropertyMap> _multiLocaleProperties = null;
    private SectionedPropertyMap _substitutionPropertyMap = null;
    private SectionedPropertyList _substitutionPropertyList;
    private boolean _processLocalizableProperties = false;
    private boolean _processSubstitutionProperties = true;
    private boolean _useDefaultLocalizableProperties = true;
    private boolean _useDefaultSubstitutionProperties = true;
    private String _substitutionPropertiesFileName = null;
    private String _localizablePropertiesDirName = null;
    private boolean _prompting = false;
    private ConnectionPropertiesHandler _connectionHandler = null;
    private SubstitutionPropertiesHandler _substitutionHandler = null;

    public PropertiesManager(PromotionInterface operation) {
        this._operation = operation;
        this._log = this._operation.getLogger();
    }

    public PromotionInterface getPromotionOperation() {
        return this._operation;
    }

    protected boolean loadedSubstitutionProperties() {
        return this._substitutionPropertyMap != null;
    }

    protected void clearPropertyLists() {
        this._localizedPropertyList = null;
        this._substitutionPropertyList = null;
    }

    protected void readConnections() throws MetadataPromotionException {
        if (this._substitutionPropertyMap != null) {
            this.getConnectionHandler().readConnectionsFromPropertyList(this._substitutionPropertyMap);
        }
    }

    protected void writeConnections() throws MetadataPromotionException {
        if (this.isProcessingSubstitutionProperties()) {
            this.initializePropertyLists();
            this.getConnectionHandler().writeConnectionsToPropertyList(this._substitutionPropertyList);
        }
    }

    protected void exportSubstitutions() {
        if (this.isProcessingLocalizableProperties() || this.isProcessingSubstitutionProperties()) {
            this.initializePropertyLists();
            this.getSubstitutionHandler().exportSubstitutions(this._localizedPropertyList, this._substitutionPropertyList);
        }
    }

    protected int importSubstitutions() {
        int rc = 0;
        if (this.isProcessingLocalizableProperties() || this.isProcessingSubstitutionProperties()) {
            rc = this.getSubstitutionHandler().importSubstitutions(this._localizedPropertyMap, this._substitutionPropertyMap, this._multiLocaleProperties);
        }
        return rc;
    }

    protected int validateSubstitutions() {
        int rc = 0;
        if (this.isProcessingSubstitutionProperties()) {
            rc = this.getSubstitutionHandler().validateSubstitutions(this._substitutionPropertyMap);
        }
        return rc;
    }

    public Map<SubstitutionTypeInterface, List<SubstitutionInterface>> getSubstitutions() throws MetadataPromotionException {
        if (this._substitutionPropertyMap == null || !this.isProcessingSubstitutionProperties()) {
            return null;
        }
        return this.getSubstitutionHandler().getRegisteredSubstitutions(this._substitutionPropertyMap);
    }

    protected void addCustomDefinedSubstitutions() throws MetadataPromotionException {
        this.getSubstitutionHandler().addCustomDefinedSubstitutions();
    }

    public List<SubstitutionInterface> getSubstitutions(SubstitutionTypeInterface type) throws MetadataPromotionException {
        List<SubstitutionInterface> values = null;
        Map<SubstitutionTypeInterface, List<SubstitutionInterface>> substitutionMap = this.getSubstitutions();
        if (substitutionMap != null) {
            values = substitutionMap.get(type);
        }
        if (values == null) {
            return Collections.emptyList();
        }
        return new ArrayList<SubstitutionInterface>(values);
    }

    public void createSubstitutionProperty(ImportItemInterface importItem, String propertyName, String propertyValue) {
        if (this.isProcessingSubstitutionProperties() && this._substitutionPropertyMap != null) {
            this.getSubstitutionHandler().createSubstitutionProperty(this._substitutionPropertyMap, importItem, propertyName, propertyValue);
        }
    }

    public String getSubstitutionPropertyValue(ImportItemInterface importItem, String propertyName) {
        if (this.isProcessingSubstitutionProperties() && this._substitutionPropertyMap != null) {
            return this.getSubstitutionHandler().getSubstitutionPropertyValue(this._substitutionPropertyMap, importItem, propertyName);
        }
        return null;
    }

    public void removeSubstitutionProperty(ImportItemInterface importItem, String propertyName) {
        if (this.isProcessingSubstitutionProperties() && this._substitutionPropertyMap != null) {
            this.getSubstitutionHandler().removeSubstitutionProperty(this._substitutionPropertyMap, importItem, propertyName);
        }
    }

    protected void applyInitialSubstitutions(List importItems) throws MetadataPromotionException {
        if (this.isProcessingSubstitutionProperties() && this._substitutionPropertyMap != null) {
            this.getSubstitutionHandler().applyFrameworkSubstitutions(this._substitutionPropertyMap, importItems);
        }
        if (this.isProcessingLocalizableProperties() && this._localizedPropertyMap != null) {
            this.getSubstitutionHandler().applyNameLocalizationChanges(this._localizedPropertyMap, importItems);
        }
    }

    public void setProcessLocalizableProperties(boolean process, boolean externalPropFile) {
        this._processLocalizableProperties = process;
        this._useDefaultLocalizableProperties = !externalPropFile;
    }

    public boolean isProcessingLocalizableProperties() {
        return this._processLocalizableProperties;
    }

    public void setProcessSubstitutionProperties(boolean process, boolean externalPropFile) {
        this._processSubstitutionProperties = process;
        this._useDefaultSubstitutionProperties = !externalPropFile;
    }

    public boolean isProcessingSubstitutionProperties() {
        return this._processSubstitutionProperties;
    }

    protected void setUserDefinedSubstitutionFile(String fileName) {
        this._substitutionPropertiesFileName = fileName;
    }

    protected void setUserDefinedLocalizablePropertiesDirectory(String dir) {
        this._localizablePropertiesDirName = dir;
    }

    public void setUseMultiLocaleProperties(boolean flag) {
        this._useMultiLocaleProperties = flag;
        this._multiLocaleProperties = flag ? new HashMap<Locale, SectionedPropertyMap>() : null;
    }

    public void setPromptForSubstitutions(boolean prompt) {
        this._prompting = prompt;
    }

    public boolean isPromptingForSubstitutions() {
        return this._prompting;
    }

    public PropertyMap getLocalizablePropertyMap(PromotionItemInterface promotionItem) {
        return this.getPropertyMap(this._localizedPropertyMap, promotionItem);
    }

    public PropertyMap getSubstitutionPropertyMap(PromotionItemInterface promotionItem) {
        return this.getPropertyMap(this._substitutionPropertyMap, promotionItem);
    }

    private PropertyMap getPropertyMap(SectionedPropertyMap sectionedMap, PromotionItemInterface promotionItem) {
        Collection sections;
        if (sectionedMap != null && promotionItem != null && (sections = sectionedMap.getSections()).size() > 0) {
            String name = promotionItem instanceof ImportItemInterface ? ((ImportItemInterface)promotionItem).getOriginalName() : promotionItem.getName();
            String objectPath = BIPTreeUtil.pathToString(promotionItem.getSourcePath(), name, promotionItem.getTypeInterface().getPublicType());
            return sectionedMap.getSection(objectPath);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readProperties() {
        int rc = 0;
        if (this.isProcessingLocalizableProperties() && !this._useDefaultLocalizableProperties) {
            this._log.info(RB.getStringResource("PropertiesManager.LoadingLocalizableProperties.txt"));
            File localizablePropertiesFile = null;
            if (this._localizablePropertiesDirName != null) {
                String packageName = this._operation.getPackageFile().getName();
                if (packageName.endsWith(".spk")) {
                    packageName = packageName.substring(0, packageName.length() - ".spk".length());
                }
                localizablePropertiesFile = PromotionUtil.createPromotionFile(packageName, this._localizablePropertiesDirName, ".locprop");
            } else {
                localizablePropertiesFile = PromotionUtil.createPromotionFile(null, ".locprop", this._operation.getPackageFile().getPath(), false);
            }
            if (localizablePropertiesFile != null) {
                String propFilename;
                String baseName;
                File localeDir = localizablePropertiesFile.getParentFile();
                if (localeDir == null) {
                    localeDir = new File(System.getProperty("user.dir"));
                }
                if ((baseName = localizablePropertiesFile.getName()).endsWith(".locprop")) {
                    baseName = baseName.substring(0, baseName.length() - ".locprop".length());
                }
                String defaultPropFilename = null;
                ArrayList<File> propFiles = new ArrayList<File>(2);
                Locale locale = Locale.getDefault();
                if (locale.getLanguage().length() > 0) {
                    if (locale.getCountry().length() > 0) {
                        propFilename = baseName + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".locprop";
                        propFiles.add(new File(localeDir, propFilename));
                    }
                    propFilename = baseName + "_" + locale.getLanguage() + ".locprop";
                    propFiles.add(new File(localeDir, propFilename));
                } else {
                    propFilename = baseName + ".locprop";
                    propFiles.add(new File(localeDir, propFilename));
                }
                InputStreamReader rdr = null;
                this._localizedPropertyMap = null;
                for (File propFile : propFiles) {
                    try {
                        rdr = new InputStreamReader((InputStream)new FileInputStream(propFile), Charset.forName("US-ASCII"));
                        this._localizedPropertyMap = new SectionedPropertyMap();
                        this._localizedPropertyMap.load((Reader)rdr);
                        ((Reader)rdr).close();
                        defaultPropFilename = propFile.getName();
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.LoadLocalizableProperties.fmt.txt", (Object)propFile.getPath()));
                        rc |= this.validatePackageProperties(this._localizedPropertyMap, defaultPropFilename);
                        break;
                    }
                    catch (FileNotFoundException e) {
                        this._log.debug("Unable to find localizable properties file: " + propFile.getAbsolutePath());
                    }
                    catch (IOException e) {
                        this._localizedPropertyMap = null;
                        this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.fmt.txt", (Object)propFile.getName()));
                        rc |= 4;
                        break;
                    }
                    catch (SecurityException e) {
                        this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.fmt.txt", (Object)propFile.getName()));
                        rc |= 4;
                        break;
                    }
                }
                if (this._localizedPropertyMap == null) {
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.NoLocalizableProperties.txt", (Object)Locale.getDefault().toString()));
                }
                if (this._useMultiLocaleProperties) {
                    String[] files = localeDir.list();
                    Pattern pattern = Pattern.compile("\\Q" + baseName + "\\E_(\\p{Alpha}{2})(_(\\p{Alpha}{2}))?\\Q" + ".locprop" + "\\E");
                    for (int i = 0; i < files.length; ++i) {
                        Matcher m;
                        if (defaultPropFilename != null && files[i].equalsIgnoreCase(defaultPropFilename) || !(m = pattern.matcher(files[i])).matches()) continue;
                        String language = m.group(1).toLowerCase();
                        String country = m.group(3);
                        Locale fileLocale = country == null ? new Locale(language) : new Locale(language, country.toUpperCase());
                        if (fileLocale == null) break;
                        try {
                            File propFile = new File(localeDir, files[i]);
                            rdr = new InputStreamReader((InputStream)new FileInputStream(propFile), Charset.forName("US-ASCII"));
                            SectionedPropertyMap localeMap = new SectionedPropertyMap();
                            localeMap.load((Reader)rdr);
                            ((Reader)rdr).close();
                            this._multiLocaleProperties.put(fileLocale, localeMap);
                            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.LoadLocalizableProperties.fmt.txt", (Object)propFile.getPath()));
                            rc |= this.validatePackageProperties(localeMap, files[i]);
                            continue;
                        }
                        catch (IOException e) {
                            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.fmt.txt", (Object)files[i]));
                            rc |= 4;
                            break;
                        }
                        catch (SecurityException e) {
                            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.fmt.txt", (Object)files[i]));
                            rc |= 4;
                            break;
                        }
                    }
                }
            }
        }
        if (this.isProcessingSubstitutionProperties()) {
            this._log.info(RB.getStringResource("PropertiesManager.LoadingSubstitutionProperties.txt"));
            this.getSubstitutionHandler().reInitialize();
            this._substitutionPropertyMap = null;
            InputStreamReader rdr = null;
            File substitutionPropertiesFile = null;
            boolean loadedFromPackage = false;
            if (this._useDefaultSubstitutionProperties) {
                try {
                    substitutionPropertiesFile = this._operation.getContentHandler().getFileFromPackage(SUBSTITUTION_PROPERTIES_FILE);
                }
                catch (Exception e) {
                    this._log.debug("Unable to load subsititution properties file from package");
                }
                finally {
                    loadedFromPackage = true;
                }
            } else {
                substitutionPropertiesFile = this._substitutionPropertiesFileName != null ? PromotionUtil.createPromotionFile(this._substitutionPropertiesFileName, ".subprop", this._operation.getPackageFile().getPath(), false) : PromotionUtil.createPromotionFile(null, ".subprop", this._operation.getPackageFile().getPath(), false);
            }
            if (substitutionPropertiesFile != null) {
                try {
                    rdr = loadedFromPackage ? new InputStreamReader((InputStream)new FileInputStream(substitutionPropertiesFile), Charset.forName("US-ASCII")) : new FileReader(substitutionPropertiesFile);
                    this._substitutionPropertyMap = new SectionedPropertyMap();
                    this._substitutionPropertyMap.load((Reader)rdr);
                    ((Reader)rdr).close();
                    if (loadedFromPackage) {
                        this._log.info(RB.getStringResource("PropertiesManager.LoadSubstitutionPropertiesFromPackage.txt"));
                    } else {
                        this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.LoadSubstitutionProperties.fmt.txt", (Object)substitutionPropertiesFile.getPath()));
                    }
                    rc |= this.validatePackageProperties(this._substitutionPropertyMap, substitutionPropertiesFile.getName());
                }
                catch (FileNotFoundException e) {
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"ImportHandler.FileNotFound.fmt.txt", (Object)substitutionPropertiesFile.toString()));
                    rc |= 4;
                }
                catch (SecurityException e) {
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.txt", (Object)substitutionPropertiesFile.toString()));
                    rc |= 4;
                }
                catch (Exception e) {
                    this._substitutionPropertyMap = null;
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.FileReadError.txt", (Object)substitutionPropertiesFile.toString()));
                    rc |= 4;
                }
                finally {
                    if (loadedFromPackage && substitutionPropertiesFile != null) {
                        substitutionPropertiesFile.delete();
                    }
                }
            } else if (loadedFromPackage) {
                this._substitutionPropertyMap = new SectionedPropertyMap();
            }
            if (this._substitutionPropertyMap == null) {
                this._log.warn(RB.getStringResource("PropertiesManager.NoSubstitutionProperties.txt"));
                rc |= 4;
            }
        }
        return rc;
    }

    private int validatePackageProperties(SectionedPropertyMap loadedProperties, String filename) {
        int rc = 0;
        PromotionPropertiesFile packageProperties = this._operation.getPropertiesFile();
        PropertyMap map = loadedProperties.getSection("");
        if (packageProperties != null && map != null && packageProperties.containsKey("PackageUUID") && map.containsProperty("PackageUUID") && !packageProperties.getProperty("PackageUUID").equals(map.getProperty("PackageUUID"))) {
            this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.UUIDMismatch.fmt.txt", (Object)filename));
            rc = 4;
        }
        return rc;
    }

    protected void writeProperties() throws IOException {
        FileOutputStream os;
        if (this.isProcessingLocalizableProperties() && this._localizedPropertyList != null) {
            this._log.info(RB.getStringResource("PropertiesManager.GeneratingLocalizableProperties.txt"));
            if (!this._useDefaultLocalizableProperties) {
                File localizablePropertiesFile = this.getExternalLocalizablePropertiesFile();
                os = new FileOutputStream(localizablePropertiesFile);
                this._localizedPropertyList.save((OutputStream)os, Charset.forName("US-ASCII"));
                ((OutputStream)os).close();
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.CreatedLocalizableProperties.fmt.txt", (Object)localizablePropertiesFile.toString()));
            }
            this.addPropertiesFileToPackage(LOCALIZABLE_PROPERTIES_FILE, this._localizedPropertyList);
        }
        if (this.isProcessingSubstitutionProperties() && this._substitutionPropertyList != null) {
            this._log.info(RB.getStringResource("PropertiesManager.GeneratingSubstitutionProperties.txt"));
            if (!this._useDefaultSubstitutionProperties) {
                File substitutionPropertiesFile = this.getExternalSubstitutionPropertiesFile();
                os = new FileOutputStream(substitutionPropertiesFile);
                this._substitutionPropertyList.save((OutputStream)os, Charset.defaultCharset());
                ((OutputStream)os).close();
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"PropertiesManager.CreatedSubstitutionProperties.fmt.txt", (Object)substitutionPropertiesFile.toString()));
            }
            this.addPropertiesFileToPackage(SUBSTITUTION_PROPERTIES_FILE, this._substitutionPropertyList);
        }
    }

    private void addPropertiesFileToPackage(String fileName, SectionedPropertyList propertyList) throws IOException {
        ContentHandlerInterface contentHandler = this._operation.getContentHandler();
        File connectionsFile = contentHandler.createFile(fileName);
        contentHandler.deleteFileOnPublish(connectionsFile);
        FileOutputStream os = new FileOutputStream(connectionsFile);
        propertyList.save((OutputStream)os, Charset.forName("US-ASCII"));
        ((OutputStream)os).close();
        contentHandler.addFileToPackage(connectionsFile, 1);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Adding properties file to package: " + fileName);
        }
    }

    private ConnectionPropertiesHandler getConnectionHandler() {
        if (this._connectionHandler == null) {
            this._connectionHandler = new ConnectionPropertiesHandler(this);
        }
        return this._connectionHandler;
    }

    private SubstitutionPropertiesHandler getSubstitutionHandler() {
        if (this._substitutionHandler == null) {
            this._substitutionHandler = new SubstitutionPropertiesHandler(this);
        }
        return this._substitutionHandler;
    }

    private void initializePropertyLists() {
        if (this._localizedPropertyList == null || this._substitutionPropertyList == null) {
            PropertyList packagePropertyList;
            if (this._localizedPropertyList == null) {
                packagePropertyList = this.getPackageProperties();
                this._localizedPropertyList = new SectionedPropertyList("SAS package localizable properties");
                SubstitutionPropertiesHandler.generateLocpropInstructions(packagePropertyList);
                this._localizedPropertyList.addSection("", packagePropertyList);
            }
            if (this._substitutionPropertyList == null) {
                packagePropertyList = this.getPackageProperties();
                this._substitutionPropertyList = new SectionedPropertyList(RB.getStringResource("PropertiesManager.SubstitutionPropertiesComment.txt"));
                SubstitutionPropertiesHandler.generateSubpropInstructions(packagePropertyList);
                this._substitutionPropertyList.addSection("", packagePropertyList);
            }
        }
    }

    private PropertyList getPackageProperties() {
        PropertyList packagePropertyList = new PropertyList();
        PromotionPropertiesFile properties = this._operation.getPropertiesFile();
        if (properties != null) {
            String[] keys = new String[]{"PackageName", "PackageUUID", "ExportTime"};
            for (int i = 0; i < keys.length; ++i) {
                if (!properties.containsKey(keys[i])) continue;
                packagePropertyList.addProperty(keys[i], properties.getProperty(keys[i]));
            }
        }
        return packagePropertyList;
    }

    private File getExternalLocalizablePropertiesFile() {
        return PromotionUtil.createPromotionFile(null, ".locprop", this._operation.getPackageFile().getPath(), false);
    }

    private File getExternalSubstitutionPropertiesFile() {
        return PromotionUtil.createPromotionFile(null, ".subprop", this._operation.getPackageFile().getPath(), false);
    }
}

