/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionManager;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ConnectionTypeSorter;
import com.sas.metadata.promotion.ContentHandler;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportHandler;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ImportHandler;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.NotificationEvent;
import com.sas.metadata.promotion.NotificationListener;
import com.sas.metadata.promotion.ObjectsSelectedListener;
import com.sas.metadata.promotion.PromotionConfiguration;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionListener;
import com.sas.metadata.promotion.PromotionPropertiesFile;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.StatusListener;
import com.sas.metadata.promotion.connections.SecurityConnectionType;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdRepositoryUtil;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.io.File;
import java.lang.reflect.Constructor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PromotionHandler
implements PromotionInterface {
    private static Class<?>[] CONSTRUCTOR_ARGS = new Class[]{PromotionInterface.class};
    private PromotionConfiguration _config;
    protected SecurityConnectionType _securityType;
    protected PropertiesManager _propManager;
    protected Log _log;
    protected ContentHandler _contentHandler;
    protected int _promotionType;
    protected MdFactory _factory;
    protected ISecurity _iSecurity;
    protected MdObjectStore _store;
    private boolean _createdPrivateStore = false;
    protected String _profile;
    protected SessionContextInterface _session;
    protected ServerInterface _server;
    protected UserContextInterface _user;
    protected String _foundationReposID;
    protected String _reposID;
    protected String _reposName;
    protected String _reposType;
    protected PromotionPropertiesFile _propertiesFile;
    protected Map<Object, Object> _promotionCache;
    protected List<ConnectionTypeInterface> _connectionTypes;
    protected File _packageFile;
    protected int _packageVersion = -1;
    protected int _serverVersion;
    protected List<String> _supportedTypes;
    private Map<String, TypeInterface> _allTypesMap;
    protected Map<String, TypeInterface> _supportedTypesMap;
    private Integer _initialTreeRefreshValue = null;
    private Integer _initialSubFolderRefreshValue = null;
    private Integer _initialFolderItemRefreshValue = null;
    protected Map _selectedObjects;
    private Map<String, PromotionItemInterface> _objectIDCache;
    private List<ObjectsSelectedListener> _objectsListenerList = new ArrayList<ObjectsSelectedListener>(2);
    private List<NotificationListener> _notificationListenerList = null;
    private List<StatusListener> _statusListenerList = null;

    public PromotionHandler(List<String> supportedTypes, int type) throws RemoteException {
        this._supportedTypes = supportedTypes;
        this._promotionType = type;
    }

    public PromotionHandler(MdFactory factory, int promotionType, TypeInterface[] availableTypes) throws RemoteException {
        this._promotionType = promotionType;
        this._factory = factory;
        if (availableTypes != null) {
            this._supportedTypes = new ArrayList<String>();
            for (int index = 0; index > availableTypes.length; ++index) {
                this._supportedTypes.add(availableTypes[index].getPublicType());
            }
        }
    }

    protected abstract boolean isSecurityIncluded();

    protected void initialize() {
        this._config = new PromotionConfiguration();
        this.configureLogger();
        this._contentHandler = new ContentHandler();
        this._propManager = new PropertiesManager(this);
        this.createPropertiesFile();
    }

    private void configureLogger() {
        this._log = Log.getInstance("com.sas.metadata.promotion");
        if (!this._log.isPreviouslyConfigured()) {
            boolean includeTimestamp = true;
            String filePrefix = null;
            if (this._promotionType == 0) {
                filePrefix = "Export";
            } else if (this._promotionType == 1) {
                filePrefix = "Import";
            } else if (this._promotionType == 2 || this._promotionType == 3) {
                filePrefix = "CopyPaste";
                includeTimestamp = false;
            }
            this._log.initializeLogger(filePrefix, includeTimestamp);
            this._log.info(RB.getStringResource("PromotionHandler.LogCreated.txt") + this._log.getLogFileName());
        }
    }

    public PromotionConfiguration getPromotionConfiguration() {
        return this._config;
    }

    public void setPromotionConfiguration(PromotionConfiguration config) {
        this._config = config;
    }

    @Override
    public boolean isBatchProcess() {
        return this._config.isBatchProcess();
    }

    @Override
    public boolean isInstallProcess() {
        return this._config.isInstallProcess();
    }

    public void setProfileName(String profile) {
        this._profile = profile;
    }

    @Override
    public String getProfileName() {
        return this._profile;
    }

    @Override
    public ConnectionManagerInterface getConnectionManager() {
        return ConnectionManager.getInstance(this);
    }

    @Override
    public PropertiesManager getPropertiesManager() {
        return this._propManager;
    }

    @Override
    public ContentHandlerInterface getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public int getPackageFileVersion() {
        if (this._packageVersion == -1) {
            try {
                this._packageVersion = this._contentHandler.getPackageVersion();
            }
            catch (TransportException e) {
                if (this._log != null) {
                    this._log.error(e.getMessage());
                }
                return -1;
            }
        }
        return this._packageVersion;
    }

    @Override
    public File getPackageFile() {
        return this._packageFile;
    }

    @Override
    public int getPromotionType() {
        return this._promotionType;
    }

    @Override
    public void addObjectToCache(Object key, Object value) {
        if (this._promotionCache == null) {
            this._promotionCache = new HashMap<Object, Object>();
        }
        this._promotionCache.put(key, value);
    }

    @Override
    public Object getObjectFromCache(Object key) {
        return this._promotionCache == null ? null : this._promotionCache.get(key);
    }

    @Override
    public void removeObjectFromCache(Object key) {
        if (this._promotionCache != null) {
            this._promotionCache.remove(key);
        }
    }

    protected void setPromotionItems(Map selectedObjects) {
        this._selectedObjects = selectedObjects;
        List allObjects = this.getAllPromotionItems();
        this._objectIDCache = new HashMap<String, PromotionItemInterface>(allObjects.size());
        for (PromotionItemInterface item : allObjects) {
            this._objectIDCache.put(item.getID(), item);
        }
    }

    protected void clearPromotionItems() {
        if (this._selectedObjects != null) {
            this._selectedObjects.clear();
        }
        if (this._objectIDCache != null) {
            this._objectIDCache.clear();
        }
    }

    @Override
    public List<String> getSupportedPublicTypes() {
        if (this._supportedTypes == null) {
            return null;
        }
        return new ArrayList<String>(this._supportedTypes);
    }

    @Override
    public TypeInterface[] getUserDefinedSupportedTypes() {
        if (this._supportedTypes == null) {
            return null;
        }
        Factory factory = Factory.getInstance();
        TypeInterface[] types = new TypeInterface[this._supportedTypes.size()];
        int index = 0;
        try {
            for (String publicType : this._supportedTypes) {
                TypeInterface type;
                types[index] = type = factory.getTypeInterface(publicType);
                ++index;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve public type instances.");
        }
        return types;
    }

    @Override
    public Map<String, TypeInterface> getTypes() {
        return this._supportedTypesMap;
    }

    @Override
    public MdObjectStore getStore() {
        return this._store;
    }

    @Override
    public MdFactory getMetadataFactory() {
        return this._factory;
    }

    @Override
    public ISecurity getISecurity() throws MdException, RemoteException {
        if (this._iSecurity == null) {
            this._iSecurity = this._factory.getConnection().MakeISecurityConnection();
        }
        return this._iSecurity;
    }

    @Override
    public UserContextInterface getUserContext() throws ServiceException, RemoteException {
        SessionContextInterface session;
        if (this._user == null && (session = this.getSessionContext()) != null) {
            this._user = session.getUserContext();
        }
        return this._user;
    }

    @Override
    public SessionContextInterface getSessionContext() throws ServiceException, RemoteException {
        return this._session;
    }

    @Override
    public ServerInterface getServer() throws ServiceException, RemoteException {
        UserContextInterface user;
        SessionContextInterface session;
        if (this._server == null && (session = this.getSessionContext()) != null && (user = session.getUserContext()) != null) {
            this._server = user.getAuthServer();
        }
        return this._server;
    }

    public void setSessionContext(SessionContextInterface session) throws ServiceException, RemoteException {
        this.setSessionContext(session, false);
    }

    public void setSessionContext(SessionContextInterface session, boolean createDetachedTransaction) throws ServiceException, RemoteException {
        if (session == null) {
            throw new IllegalArgumentException("Invalid session context");
        }
        this._session = session;
        this._user = session.getUserContext();
        if (this._user != null) {
            if (createDetachedTransaction) {
                if (this._log != null && this._log.isDebugEnabled()) {
                    this._log.debug("Starting isolated transaction");
                }
                ServerInterface parentServer = this._user.getAuthServer();
                this._server = ((OMIServer)parentServer).newChild(true);
            } else {
                this._server = this._user.getAuthServer();
            }
            InformationServiceInterface informationSvc = CorePlatformServices.getInformationService();
            if (informationSvc != null) {
                this._initialTreeRefreshValue = (Integer)informationSvc.getOption(0);
                this._initialFolderItemRefreshValue = (Integer)informationSvc.getOption(1);
                this._initialSubFolderRefreshValue = (Integer)informationSvc.getOption(2);
                Integer value = new Integer(10000);
                informationSvc.setOption(0, (Object)value);
                informationSvc.setOption(1, (Object)value);
                informationSvc.setOption(2, (Object)value);
            }
            if (this._server instanceof OMIServer) {
                this._factory = ((OMIServer)this._server).getMdFactory();
                this._store = ((OMIServer)this._server).getObjectStore();
            }
        }
        if (this._store == null) {
            this._store = this._factory.createObjectStore(null, "PromotionStore");
            this._createdPrivateStore = true;
        }
        try {
            this._serverVersion = PromotionUtil.getServerVersion(this._factory);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
    }

    @Override
    public String getFoundationRepositoryID() throws MdException, RemoteException {
        if (this._foundationReposID == null) {
            this._foundationReposID = this._factory.getOMIUtil().getFoundationReposID();
        }
        return this._foundationReposID;
    }

    @Override
    public String getRepositoryID() {
        return this._reposID;
    }

    @Override
    public String getRepositoryName() {
        if (this._reposName == null) {
            this.loadRepositoryName();
        }
        return this._reposName;
    }

    @Override
    public boolean isProjectRepository() {
        if (this._reposType == null) {
            try {
                MdRepositoryUtil reposUtil = this._factory.getRepositoryUtil();
                this._reposType = reposUtil.getRepositoryType(this._reposID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "PROJECT".equalsIgnoreCase(this._reposType);
    }

    public void dispose() {
        block21: {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Disposing promotion operation");
            }
            if (this._contentHandler != null) {
                this._contentHandler.dispose();
            }
            if (this._createdPrivateStore) {
                try {
                    if (this._store != null) {
                        this._store.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this._statusListenerList != null) {
                this._statusListenerList.clear();
                this._statusListenerList = null;
            }
            if (this._objectsListenerList != null) {
                this._objectsListenerList.clear();
                this._objectsListenerList = null;
            }
            if (this._notificationListenerList != null) {
                this._notificationListenerList.clear();
                this._notificationListenerList = null;
            }
            if (this._selectedObjects != null) {
                this._selectedObjects.clear();
                this._selectedObjects = null;
            }
            if (this._connectionTypes != null) {
                this._connectionTypes.clear();
                this._connectionTypes = null;
            }
            if (this._supportedTypesMap != null) {
                this._supportedTypesMap.clear();
                this._supportedTypesMap = null;
            }
            if (this._allTypesMap != null) {
                this._allTypesMap.clear();
                this._allTypesMap = null;
            }
            if (this._objectIDCache != null) {
                this._objectIDCache.clear();
                this._objectIDCache = null;
            }
            try {
                InformationServiceInterface informationSvc = CorePlatformServices.getInformationService();
                if (informationSvc != null) {
                    if (this._initialTreeRefreshValue != null) {
                        informationSvc.setOption(0, (Object)this._initialTreeRefreshValue);
                    }
                    if (this._initialFolderItemRefreshValue != null) {
                        informationSvc.setOption(1, (Object)this._initialFolderItemRefreshValue);
                    }
                    if (this._initialSubFolderRefreshValue != null) {
                        informationSvc.setOption(2, (Object)this._initialSubFolderRefreshValue);
                    }
                }
                if (this._server instanceof ChildServerInterface) {
                    this._server.destroy();
                }
            }
            catch (Exception e) {
                if (this._log == null || !this._log.isDebugEnabled()) break block21;
                this._log.debug("Error destroying server reference");
            }
        }
    }

    @Override
    public Log getLogger() {
        return this._log;
    }

    @Override
    public PromotionPropertiesFile getPropertiesFile() {
        return this._propertiesFile;
    }

    protected void createPropertiesFile() {
        this._propertiesFile = new PromotionPropertiesFile();
    }

    private void loadRepositoryName() {
        try {
            this._reposName = PromotionUtil.getRepositoryName(this._factory, this._reposID);
        }
        catch (Exception e) {
            this._log.debug((Object)"Unable to retrieve repository name", e);
            this._reposName = "";
        }
    }

    @Override
    public boolean isSupportedServerVersion() {
        return this._serverVersion >= 9200;
    }

    @Override
    public int getServerVersion() {
        return this._serverVersion;
    }

    public final String getStatusMessages(int statusCode) {
        return "";
    }

    public final List getStatusMessages() {
        return new ArrayList();
    }

    public final void addStatusListener(StatusListener listener) {
        if (this._statusListenerList != null) {
            this._statusListenerList = new ArrayList<StatusListener>();
        }
        this._statusListenerList.add(listener);
    }

    public final void removeStatusListener(StatusListener listener) {
        if (this._statusListenerList != null) {
            this._statusListenerList.remove(listener);
        }
    }

    public final void fireUpdateStatus(int statusCode) {
        if (this._statusListenerList != null && this._statusListenerList.size() > 0) {
            for (StatusListener listener : this._statusListenerList) {
                listener.updateStatus(statusCode);
            }
        }
    }

    protected void fireDisplayMessageForListener(PromotionListener listener, String message) {
        if (listener instanceof AbstractPromotionListener) {
            ((AbstractPromotionListener)listener).fireDisplayMessage(message);
        }
    }

    @Override
    public final void addObjectsSelectedListener(ObjectsSelectedListener listener) {
        this._objectsListenerList.add(listener);
    }

    @Override
    public final void removeObjectsSelectedListener(ObjectsSelectedListener listener) {
        this._objectsListenerList.remove(listener);
    }

    public final void fireObjectsSelected(Map selectedObjects) {
        if (this._objectsListenerList.size() > 0) {
            for (ObjectsSelectedListener listener : this._objectsListenerList) {
                listener.objectsSelected(selectedObjects);
            }
        }
    }

    @Override
    public final void addNotificationListener(NotificationListener listener) {
        if (this._notificationListenerList == null) {
            this._notificationListenerList = new ArrayList<NotificationListener>(5);
        }
        this._notificationListenerList.add(listener);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener) {
        if (this._notificationListenerList != null) {
            this._notificationListenerList.remove(listener);
        }
    }

    @Override
    public final void fireNotification(NotificationEvent event) {
        if (this._notificationListenerList != null && this._notificationListenerList.size() > 0) {
            for (NotificationListener listener : this._notificationListenerList) {
                listener.notify(event);
            }
        }
    }

    public SecurityConnectionType getSecurityConnectionType() {
        if (this._securityType == null) {
            this._securityType = new SecurityConnectionType(this);
        }
        return this._securityType;
    }

    @Override
    public ConnectionTypeInterface getConnectionType(String connectionTypeName) {
        if (this._connectionTypes != null && connectionTypeName != null) {
            for (ConnectionTypeInterface type : this._connectionTypes) {
                String className = type.getClass().getName();
                if (!connectionTypeName.equals(className)) continue;
                return type;
            }
        }
        return null;
    }

    @Override
    public List<ConnectionTypeInterface> getConnectionTypes() throws MetadataPromotionException {
        if (this._connectionTypes != null) {
            return this._connectionTypes;
        }
        LinkedHashMap<String, ConnectionTypeInterface> connectionTypeMap = new LinkedHashMap<String, ConnectionTypeInterface>();
        this._connectionTypes = new ArrayList<ConnectionTypeInterface>();
        HashSet<String> classNameSet = new HashSet<String>();
        if (this.isSecurityIncluded()) {
            SecurityConnectionType secType = this.getSecurityConnectionType();
            this._connectionTypes.addAll(secType.getSecurityConnectionTypes());
        }
        ArrayList<ConnectionTypeInterface> customTypes = new ArrayList<ConnectionTypeInterface>();
        for (String publicType : this._selectedObjects.keySet()) {
            Class[] connectionTypes;
            TransportableTypeInterface type = this.getTransportableType(publicType);
            if (type == null) continue;
            PromotionListener listener = null;
            if (this instanceof ExportHandler) {
                listener = (ExportListener)type.getExportListener();
            } else if (this instanceof ImportHandler) {
                listener = (ImportListener)type.getImportListener();
            }
            if (listener == null || (connectionTypes = listener.getConnectionTypes()) == null) continue;
            for (int index = 0; index < connectionTypes.length; ++index) {
                Class c = connectionTypes[index];
                String className = c.getName();
                if (classNameSet.contains(className)) continue;
                ConnectionTypeInterface connectionType = (ConnectionTypeInterface)connectionTypeMap.get(className);
                if (connectionType == null) {
                    try {
                        Constructor cons = c.getConstructor(CONSTRUCTOR_ARGS);
                        connectionType = (ConnectionTypeInterface)cons.newInstance(this);
                        connectionTypeMap.put(className, connectionType);
                    }
                    catch (Exception e) {
                        throw new MetadataPromotionException(e, "Unable to load connection type class");
                    }
                }
                customTypes.add(connectionType);
                classNameSet.add(className);
            }
        }
        if (customTypes.size() > 0) {
            Collections.sort(customTypes, new ConnectionTypeSorter());
            this._connectionTypes.addAll(customTypes);
        }
        return this._connectionTypes;
    }

    @Override
    public Map getPromotionItems() {
        return this._selectedObjects == null ? new HashMap() : this._selectedObjects;
    }

    @Override
    public List getPromotionItems(String publicType) {
        if (this._selectedObjects == null) {
            return Collections.EMPTY_LIST;
        }
        List items = (List)this._selectedObjects.get(publicType);
        if (items == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(items);
    }

    @Override
    public List getAllPromotionItems() {
        ArrayList allObjects = new ArrayList();
        if (this._selectedObjects != null) {
            Collection coll = this._selectedObjects.values();
            Iterator iter = coll.iterator();
            while (iter.hasNext()) {
                allObjects.addAll((Collection)iter.next());
            }
        }
        return allObjects;
    }

    @Override
    public PromotionItemInterface getPromotionItem(String id) {
        if (this._objectIDCache == null || id == null) {
            return null;
        }
        return this._objectIDCache.get(id);
    }

    @Override
    public PromotionItemInterface getPromotionItem(String publicType, String id) {
        return this.getPromotionItem(id);
    }

    @Override
    public PromotionItemInterface getPromotionItem(PathUrl path) {
        return this.getPromotionItem(path, false);
    }

    @Override
    public PromotionItemInterface getPromotionItem(PathUrl path, boolean includeSubTypes) {
        List itemsByType;
        if (this._selectedObjects == null || path == null) {
            return null;
        }
        String type = path.getType();
        if (type == null) {
            type = "Folder";
        }
        if ((itemsByType = this.getObjectsByType(type, includeSubTypes)) != null && itemsByType.size() > 0) {
            String objectName = path.getName();
            if (objectName == null && "Folder".equals(type)) {
                objectName = path.getRootTree();
            }
            if (objectName != null) {
                int folderSlash = 47;
                for (PromotionItemInterface item : itemsByType) {
                    String objectPath;
                    String promotionItemPath;
                    boolean nameContainsSlashes;
                    String promotionItemName = this.getOriginalObjectName(item);
                    boolean bl = nameContainsSlashes = promotionItemName.indexOf(47) > -1;
                    if (!nameContainsSlashes && !objectName.equalsIgnoreCase(promotionItemName) || !(promotionItemPath = BIPTreeUtil.pathToString(item.getSourcePath(), promotionItemName, item.getTypeInterface().getPublicType())).equalsIgnoreCase(objectPath = path.getAbsolutePath())) continue;
                    return item;
                }
            }
        }
        return null;
    }

    protected List getObjectsByType(String type, boolean includeSubTypes) {
        List itemsByType = new ArrayList();
        if (type == null) {
            return itemsByType;
        }
        if (includeSubTypes) {
            if (type.indexOf(46) > -1) {
                itemsByType = (List)this._selectedObjects.get(type);
            } else {
                if (this._selectedObjects.containsKey(type)) {
                    itemsByType.addAll((List)this._selectedObjects.get(type));
                }
                for (String key : this._selectedObjects.keySet()) {
                    String s;
                    int index;
                    if (type.equalsIgnoreCase(key) || (index = key.indexOf(46)) <= -1 || !type.equals(s = key.substring(0, index))) continue;
                    itemsByType.addAll((List)this._selectedObjects.get(key));
                }
            }
        } else {
            itemsByType = (List)this._selectedObjects.get(type);
        }
        return itemsByType;
    }

    protected String getOriginalObjectName(PromotionItemInterface item) {
        return item.getName();
    }

    @Override
    public boolean isObjectBeingPromoted(String publicType, String id) {
        if (this._objectIDCache == null || id == null) {
            return false;
        }
        return this._objectIDCache.containsKey(id);
    }

    @Override
    public boolean isTypeSupported(String logicalType) {
        return this.getTransportableType(logicalType) != null;
    }

    @Override
    public TransportableTypeInterface getTransportableType(String logicalType) {
        block9: {
            if (logicalType == null || logicalType.length() == 0) {
                return null;
            }
            if (this._allTypesMap.containsKey(logicalType)) {
                return (TransportableTypeInterface)this._allTypesMap.get(logicalType);
            }
            try {
                TypeInterface ti = Factory.getInstance().getTypeInterface(logicalType);
                if (ti != null) {
                    if (this._supportedTypes != null && this._supportedTypes.size() > 0) {
                        boolean supported = false;
                        for (String type : this._supportedTypes) {
                            if (!type.equalsIgnoreCase(ti.getPublicType()) || !(ti instanceof TransportableTypeInterface)) continue;
                            supported = true;
                            break;
                        }
                        if (!supported) {
                            this._allTypesMap.put(logicalType, null);
                            return null;
                        }
                    }
                    if (ti instanceof TransportableTypeInterface) {
                        this._allTypesMap.put(logicalType, ti);
                        this._supportedTypesMap.put(logicalType, ti);
                        return (TransportableTypeInterface)ti;
                    }
                    break block9;
                }
                this._allTypesMap.put(logicalType, null);
                return null;
            }
            catch (Exception e) {
                if (!this._log.isDebugEnabled()) break block9;
                this._log.debug("Unable to load logical type class for type:" + logicalType);
            }
        }
        return null;
    }

    protected void addRegisteredType(String publicType) throws Exception {
        Factory factory;
        TypeInterface type;
        if (!this._supportedTypesMap.containsKey(publicType) && (type = (factory = Factory.getInstance()).getTypeInterface(publicType)) instanceof TransportableTypeInterface) {
            this._allTypesMap.put(publicType, type);
            this._supportedTypesMap.put(publicType, type);
        }
    }

    protected void registerTypes() {
        this._allTypesMap = new LinkedHashMap<String, TypeInterface>();
        this._supportedTypesMap = new LinkedHashMap<String, TypeInterface>();
        try {
            this.addRegisteredType("Folder");
        }
        catch (Exception e) {
            throw new IllegalStateException(RB.getStringResource("PromotionHandler.FolderTypeError.txt"));
        }
    }
}

