/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.RB;
import com.sas.text.Message;
import java.util.ResourceBundle;

@SASScope
public class ObjectTypeFilter
implements MetadataFilterInterface {
    private TypeInterface[] _supportedTypes = null;
    private boolean _includeEmptyFolders = false;
    private boolean _appDefined = false;

    public ObjectTypeFilter(TypeInterface[] types) {
        this._supportedTypes = types;
    }

    public ObjectTypeFilter(TypeInterface[] types, boolean applicationDefined) {
        this._supportedTypes = types;
        this._appDefined = applicationDefined;
    }

    public TypeInterface[] getTypes() {
        return this._supportedTypes;
    }

    public boolean isApplicationDefined() {
        return this._appDefined;
    }

    public void setIncludeEmptyFolders(boolean include) {
        this._includeEmptyFolders = include;
    }

    public boolean isIncludingEmptyFolders() {
        return this._includeEmptyFolders;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("ObjectTypeFilter.FilterName.txt");
    }

    @Override
    public String getFilterString() {
        StringBuffer sb = new StringBuffer();
        if (this._supportedTypes != null) {
            int length = this._supportedTypes.length;
            for (int i = 0; i < length; ++i) {
                TypeInterface type = this._supportedTypes[i];
                String publicType = type.getPublicType();
                sb.append("@PublicType='");
                sb.append(publicType);
                sb.append("'");
                if (i == length - 1) continue;
                sb.append(" OR ");
            }
        }
        return sb.toString();
    }

    @Override
    public String getFilterDescription() {
        if (!this._appDefined && this._supportedTypes != null && this._supportedTypes.length > 0) {
            return Message.format((ResourceBundle)RB.getResources(), (String)"ObjectTypeFilter.FilterDesc.fmt.txt", (Object)this.getTypesToDisplay());
        }
        return null;
    }

    private String getTypesToDisplay() {
        String sep = RB.getStringResource("ObjectTypeFilter.TypeSeparator.txt");
        StringBuilder sb = new StringBuilder();
        for (TypeInterface type : this._supportedTypes) {
            if ("Folder".equalsIgnoreCase(type.getPublicType()) || "RootFolder".equalsIgnoreCase(type.getPublicType())) continue;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(type.getDisplayType());
        }
        if (sb.length() == 0) {
            sb.append(RB.getStringResource("ObjectTypeFilter.Empty.txt"));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ObjectTypeFilter) {
            ObjectTypeFilter filter = (ObjectTypeFilter)obj;
            return this._includeEmptyFolders == filter.isIncludingEmptyFolders() && this.typesEqual(this._supportedTypes, filter.getTypes());
        }
        return false;
    }

    private boolean typesEqual(TypeInterface[] types1, TypeInterface[] types2) {
        if (types1 == null && types2 == null) {
            return true;
        }
        if (types1 == null && types2 != null || types1 != null && types2 == null) {
            return false;
        }
        if (types1.length != types2.length) {
            return false;
        }
        int length = types1.length;
        for (int index = 0; index < length; ++index) {
            TypeInterface t1 = types1[index];
            TypeInterface t2 = types2[index];
            if (t1 == null || t2 == null || t1.getPublicType().equalsIgnoreCase(t2.getPublicType())) continue;
            return false;
        }
        return true;
    }
}

