/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.MetadataFilterInterface;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.promotion.XMLUtil;
import com.sas.text.Message;
import java.util.ResourceBundle;

@SASScope
public class ObjectNameFilter
implements MetadataFilterInterface {
    private String _name = null;
    private boolean _includeDescription = false;

    public ObjectNameFilter(String name, boolean includeDescription) {
        this._name = name;
        this._includeDescription = includeDescription;
    }

    public String getName() {
        return this._name;
    }

    public boolean isIncludingDescription() {
        return this._includeDescription;
    }

    @Override
    public String getFilterType() {
        return RB.getStringResource("ObjectNameFilter.FilterName.txt");
    }

    @Override
    public String getFilterString() {
        if (this._name != null && this._name.length() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("@Name CONTAINS '");
            sb.append(XMLUtil.cleanStringForXML(this._name));
            sb.append("'");
            if (this._includeDescription) {
                sb.append(" OR @Desc CONTAINS '");
                sb.append(XMLUtil.cleanStringForXML(this._name));
                sb.append("'");
            }
            return sb.toString();
        }
        return "";
    }

    @Override
    public String getFilterDescription() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ObjectNameFilter.FilterDesc.fmt.txt", (Object)this._name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof ObjectNameFilter) {
            ObjectNameFilter filter = (ObjectNameFilter)obj;
            return this._name != null && this._name.equals(filter.getName()) && this._includeDescription == filter.isIncludingDescription();
        }
        return false;
    }
}

