/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.SASFoldersUtil;
import java.rmi.RemoteException;

public class ObjectConverter {
    private static ObjectConverter _instance = null;

    private ObjectConverter() {
    }

    public static synchronized ObjectConverter getInstance() {
        if (_instance == null) {
            _instance = new ObjectConverter();
        }
        return _instance;
    }

    public PublicObjectInterface[] convertToPublicObjects(SimpleLogicalObjectInterface[] logicalObjects, ServerInterface server) throws ServiceException, RemoteException {
        PublicObjectInterface[] publicObjects = new PublicObjectInterface[logicalObjects.length];
        for (int index = 0; index < logicalObjects.length; ++index) {
            SimpleLogicalObjectInterface lo = logicalObjects[index];
            publicObjects[index] = this.convertToPublicObject(lo, server);
        }
        return publicObjects;
    }

    public PublicObjectInterface convertToPublicObject(SimpleLogicalObjectInterface logicalObject, ServerInterface server) throws ServiceException, RemoteException {
        if (server == null) {
            throw new IllegalStateException("Invalid server instance");
        }
        String publicType = logicalObject.getTypeInterface().getPublicType();
        TypeDescriptorInterface type = server.getTypeDescriptor(publicType);
        if (type == null) {
            throw new IllegalArgumentException("Invalid public type definition");
        }
        String objectKey = SASFoldersUtil.getISEntityKey((String)logicalObject.getID(), (String)type.getMetadataType());
        return server.fetch(objectKey, true);
    }

    public PublicObjectInterface convertToTargetPublicObject(ImportItemInterface logicalObject, ServerInterface server) throws ServiceException, RemoteException {
        if (server == null) {
            throw new IllegalStateException("Invalid server instance");
        }
        String publicType = logicalObject.getTypeInterface().getPublicType();
        TypeDescriptorInterface type = server.getTypeDescriptor(publicType);
        if (type == null) {
            throw new IllegalArgumentException("Invalid public type definition");
        }
        if (logicalObject.getTargetID() != null) {
            String objectKey = SASFoldersUtil.getISEntityKey((String)logicalObject.getTargetID(), (String)type.getMetadataType());
            return server.fetch(objectKey, true);
        }
        return null;
    }

    public SimpleLogicalObjectInterface[] convertToLogicalObjects(PublicObjectInterface[] publicObjects) throws ServiceException, RemoteException {
        SimpleLogicalObjectInterface[] logicalObjects = new SimpleLogicalObjectInterface[publicObjects.length];
        for (int index = 0; index < publicObjects.length; ++index) {
            PublicObjectInterface po = publicObjects[index];
            logicalObjects[index] = this.convertToLogicalObject(po);
        }
        return logicalObjects;
    }

    public SimpleLogicalObjectInterface convertToLogicalObject(PublicObjectInterface publicObject) throws ServiceException, RemoteException {
        TypeInterface logicalType;
        TypeDescriptorInterface type = publicObject.getTypeDescriptor();
        if (type == null) {
            throw new IllegalArgumentException("Invalid public type definition");
        }
        try {
            logicalType = Factory.getInstance().getTypeInterface(type.getTypeName());
            if (logicalType == null) {
                throw new IllegalArgumentException("Invalid logical type definition");
            }
        }
        catch (LogicalTypeException e) {
            throw new ServiceException((Throwable)e, e.getLocalizedMessage());
        }
        return new SimpleLogicalObject(publicObject.getName(), publicObject.getIdentifier(), logicalType);
    }
}

