/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.ContentHelper;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NormalizeTextContentHandler
implements ContentHandler {
    private static final Logger log = Logger.getLogger(ContentHelper.class.getName());
    private List urlList = new ArrayList();
    private boolean isUrlValue = false;
    CharArrayWriter text = new CharArrayWriter();

    public List getListOfSBIPUrls() throws IOException {
        return this.urlList;
    }

    private void completeTextNode() throws SAXException {
        this.text.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.text.write(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.completeTextNode();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.isUrlValue) {
            this.urlList.add(this.text.toString());
            log.fine("<URLValue>" + this.text.toString());
            this.isUrlValue = false;
        }
        this.completeTextNode();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.completeTextNode();
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.completeTextNode();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.completeTextNode();
    }

    @Override
    public void startDocument() throws SAXException {
        this.completeTextNode();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String attr;
        this.completeTextNode();
        this.isUrlValue = false;
        if ("URLValue".equals(localName)) {
            this.isUrlValue = true;
        }
        if ("InformationMap".equals(localName)) {
            attr = atts.getValue("absolutePathLocation");
            if (attr != null) {
                this.urlList.add(attr);
                log.fine("<InformationMap absolutePathLocation=" + attr.toString());
            }
            if ((attr = atts.getValue("location")) != null) {
                this.urlList.add(attr);
                log.fine("<InformationMap location=" + attr.toString());
            }
        }
        if ("Image".equals(localName) && (attr = atts.getValue("file")) != null) {
            this.urlList.add(attr);
            log.fine("<Image file=" + attr.toString());
        }
        if ("Graph".equals(localName) && (attr = atts.getValue("altImage")) != null) {
            this.urlList.add(attr);
            log.fine("<Graph altImage=" + attr.toString());
        }
        if ("SASProcessSection".equals(localName) && (attr = atts.getValue("file")) != null) {
            this.urlList.add(attr);
            log.fine("<SASProcessSection file=" + attr.toString());
        }
        if ("SASProcessContainer".equals(localName) && (attr = atts.getValue("file")) != null) {
            this.urlList.add(attr);
            log.fine("<SASProcessContainer file=" + attr.toString());
        }
        if ("BusinessModelReferenceInformation".equals(localName) && (attr = atts.getValue("location")) != null) {
            this.urlList.add(attr);
            log.fine("<BusinessModelReferenceInformation location=" + attr.toString());
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.completeTextNode();
    }
}

