/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.metadata.promotion.MetadataImportNodeInterface;
import com.sas.metadata.promotion.MetadataNodeInterface;
import java.util.List;

public class MetadataTreeUtil {
    public static boolean arePathsEqual(String[] path1, String[] path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.length != path2.length) {
            return false;
        }
        int len = path1.length;
        for (int index = 0; index < len; ++index) {
            String folder1 = path1[index];
            String folder2 = path2[index];
            if (folder1 == null || folder1.equalsIgnoreCase(folder2)) continue;
            return false;
        }
        return true;
    }

    public static boolean arePathsEqual(List path1, List path2) {
        if (path1 == null || path2 == null) {
            return false;
        }
        if (path1.size() != path2.size()) {
            return false;
        }
        int len = path1.size();
        for (int index = 0; index < len; ++index) {
            String folder1 = (String)path1.get(index);
            String folder2 = (String)path2.get(index);
            if (folder1 == null || folder1.equalsIgnoreCase(folder2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isChildOf(List childPath, List parentPath) {
        if (childPath == null || parentPath == null) {
            return false;
        }
        int length = parentPath.size();
        if (length == 0) {
            return true;
        }
        if (length > childPath.size()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (parentPath.get(i).equals(childPath.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnique(MetadataNodeInterface parentNode, String name, String publicType) {
        if (parentNode == null || !parentNode.isFolder()) {
            return true;
        }
        if (parentNode.getChildCount() > 0) {
            for (MetadataNodeInterface child : parentNode.getChildren()) {
                if (!child.getType().equalsIgnoreCase(publicType) || !child.getName().equalsIgnoreCase(name)) continue;
                return false;
            }
        }
        return true;
    }

    public static MetadataNodeInterface findNodeByPath(String[] path, MetadataNodeInterface rootNode) {
        MetadataNodeInterface node = rootNode;
        for (String nodeName : path) {
            MetadataNodeInterface childNode = MetadataTreeUtil.findChildNode(node, nodeName);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        return node;
    }

    private static MetadataNodeInterface findChildNode(MetadataNodeInterface parentNode, String nodeName) {
        List children;
        if (parentNode != null && nodeName != null && (children = parentNode.getChildren()) != null && children.size() > 0) {
            for (MetadataNodeInterface node : children) {
                if (!nodeName.equalsIgnoreCase(node.getName())) continue;
                return node;
            }
        }
        return null;
    }

    public static MetadataNodeInterface findNodeByOriginalPath(String[] path, MetadataNodeInterface rootNode) {
        MetadataNodeInterface node = rootNode;
        for (String nodeName : path) {
            MetadataNodeInterface childNode = MetadataTreeUtil.findOriginalChildNode(node, nodeName);
            if (childNode == null) {
                return null;
            }
            node = childNode;
        }
        return node;
    }

    private static MetadataNodeInterface findOriginalChildNode(MetadataNodeInterface parentNode, String nodeName) {
        List children;
        if (parentNode != null && nodeName != null && (children = parentNode.getChildren()) != null && children.size() > 0) {
            for (MetadataNodeInterface node : children) {
                if (!(node instanceof MetadataImportNodeInterface ? nodeName.equalsIgnoreCase(((MetadataImportNodeInterface)node).getOriginalName()) : nodeName.equalsIgnoreCase(node.getName()))) continue;
                return node;
            }
        }
        return null;
    }
}

