/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.MetadataNodeInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class MetadataNode
implements MetadataNodeInterface {
    protected MetadataNodeInterface _parentNode;
    protected PromotionItemInterface _promotionItem;
    protected String _publicType;
    protected String _name;
    protected boolean _isRoot = false;
    protected String[] _rootNodePath;
    protected List _children;

    public MetadataNode(String name, String[] path) {
        this._name = name;
        this._publicType = "Folder";
        this._rootNodePath = path;
        this._isRoot = true;
        this._children = new ArrayList();
    }

    public MetadataNode(String name, String publicType, String id) {
        this._name = name;
        this._publicType = publicType;
        if (this.isFolder()) {
            this._children = new ArrayList();
        }
    }

    @Override
    public void addChild(MetadataNodeInterface childNode) {
        if ((this.isFolder() || this._isRoot) && !this._children.contains(childNode) && childNode.getPromotionItem() != null) {
            ((MetadataNode)childNode).setParentNode(this);
            this._children.add(childNode);
        }
    }

    @Override
    public void removeChild(MetadataNodeInterface childNode) {
        if (this._children != null) {
            Object[] children = this._children.toArray();
            int len = children.length;
            for (int i = 0; i < len; ++i) {
                MetadataNodeInterface child = (MetadataNodeInterface)children[i];
                if (!child.getObjectID().equals(childNode.getObjectID())) continue;
                this._children.remove(i);
                break;
            }
        }
    }

    @Override
    public int getChildCount() {
        return this._children == null ? 0 : this._children.size();
    }

    @Override
    public List getChildren() {
        return this._children;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getObjectID() {
        return this._promotionItem == null ? null : this._promotionItem.getID();
    }

    @Override
    public MetadataNodeInterface getParent() {
        return this._parentNode;
    }

    @Override
    public String[] getPath() {
        return this._promotionItem == null ? this._rootNodePath : new String[]{};
    }

    @Override
    public String[] getAbsolutePath() {
        String[] path = this.getPath();
        String[] objectPath = new String[path.length + 1];
        System.arraycopy(path, 0, objectPath, 0, path.length);
        objectPath[path.length] = this._name;
        return objectPath;
    }

    @Override
    public int getLevel() {
        String[] path = this.getPath();
        return path.length;
    }

    @Override
    public PromotionItemInterface getPromotionItem() {
        return this._promotionItem;
    }

    @Override
    public String getType() {
        return this._promotionItem == null ? null : this._promotionItem.getTypeInterface().getPublicType();
    }

    @Override
    public boolean isSASFoldersRoot() {
        return this._isRoot && "SAS Folders".equalsIgnoreCase(this._name);
    }

    @Override
    public boolean isBeingPromoted() {
        return this._promotionItem != null;
    }

    @Override
    public boolean isFolder() {
        return "Folder".equalsIgnoreCase(this._publicType);
    }

    @Override
    public boolean isLeaf() {
        if (this.isFolder()) {
            return this._children == null ? false : this._children.size() == 0;
        }
        return true;
    }

    protected void setParentNode(MetadataNodeInterface parentNode) {
        this._parentNode = parentNode;
    }

    public String toString() {
        if (this.isSASFoldersRoot()) {
            return "/";
        }
        return this._promotionItem == null ? BIPTreeUtil.pathToString(this._rootNodePath, this._name) : this._promotionItem.toString();
    }
}

