/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.promotion;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.promotion.BIPTreeUtil;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.DefaultPromotionItem;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataImportNodeInterface;
import com.sas.metadata.promotion.MetadataNode;
import com.sas.metadata.promotion.MetadataNodeInterface;
import com.sas.metadata.promotion.MetadataTreeInterface;
import com.sas.metadata.promotion.MetadataTreeUtil;
import com.sas.metadata.promotion.NoObjectsToImportException;
import com.sas.metadata.promotion.ObjectRenameManager;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.RB;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdSecurityUtil;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.util.Names;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@SASScope
public class MetadataImportTree
implements MetadataTreeInterface {
    private static final int MOVE_OBJECTS_TARGET_FOLDER = 0;
    private static final int MOVE_OBJECTS_PRESERVED_FOLDER = 1;
    private static final int EXPORTED_SINGLE_FOLDER = 0;
    private static final int EXPORTED_MULTIPLE_FOLDERS = 1;
    private static final String[] EMPTY_FOLDER_PATH = new String[0];
    private MetadataNodeInterface _rootNode;
    private ImportOperationInterface _importOperation;
    private String _rootFolderID;
    private String _targetFolderID;
    private boolean _importingIntoSameFolder = false;
    private boolean _importingIntoRoot = false;
    private boolean _overwriteExisting = true;
    private boolean _exportedFromRoot = false;
    private int _folderCount = 0;
    private int _preservePathFolderCount = 0;
    private int _exportState = 0;
    private List _exportedFolderPath;
    private List _exportedFolderPaths;
    private List _dependentObjects;
    private List _renamedObjects;
    private List _itemsToMoveList;
    private List _itemsToPreserveList;
    private Map _excludedItemsMap;
    private Map _nodeCache;
    private Map _selectedObjects;
    private Map _duplicateNameMap;
    private Map _rootFoldersMap;

    public MetadataImportTree(ImportOperationInterface importOperation) {
        this._importOperation = importOperation;
        this._selectedObjects = new LinkedHashMap();
        this._nodeCache = new HashMap();
    }

    @Override
    public Map getPromotionItems() {
        return this._selectedObjects;
    }

    @Override
    public MetadataNodeInterface getRootNode() {
        return this._rootNode;
    }

    public Map getDuplicateObjectMap() {
        return this._duplicateNameMap;
    }

    public List getItemsToMoveToTargetFolder() {
        return this._itemsToMoveList;
    }

    public List getItemsToPreserve() {
        return this._itemsToPreserveList;
    }

    public void includeNode(MetadataImportNodeInterface node) {
        if (this._excludedItemsMap != null && this._excludedItemsMap.containsKey(node)) {
            Integer originalState = (Integer)this._excludedItemsMap.get(node);
            ImportItemInterface item = (ImportItemInterface)node.getPromotionItem();
            if (item != null) {
                item.setImportState(originalState);
            }
            this._excludedItemsMap.remove(node);
        }
    }

    public void excludeNode(ImportItemInterface importItem) {
        MetadataImportNodeInterface node = (MetadataImportNodeInterface)this._nodeCache.get(importItem);
        if (node != null) {
            this.excludeNode(node);
        }
    }

    public void excludeNode(MetadataImportNodeInterface node) {
        if (this._excludedItemsMap == null) {
            this._excludedItemsMap = new HashMap();
        } else if (this._excludedItemsMap.containsKey(node)) {
            return;
        }
        ImportItemInterface item = (ImportItemInterface)node.getPromotionItem();
        if (item != null) {
            this._excludedItemsMap.put(node, item.getImportState());
            ((DefaultImportItem)item).setImportState(0);
        }
    }

    public void overwriteExistingObjects(boolean overwrite) {
        this._overwriteExisting = overwrite;
    }

    public List getRenamedObjectsList() {
        return this._renamedObjects;
    }

    public boolean containsRenamedObjects() {
        return this._renamedObjects == null ? false : this._renamedObjects.size() > 0;
    }

    public void populateTree(List itemsToImportList, SoftwareComponent target) throws NoObjectsToImportException, MdException, RemoteException {
        this.setExportState();
        this._importingIntoRoot = true;
        ArrayList targetFolderPath = new ArrayList(0);
        this._rootNode = new MetadataImportNode("SAS Folders", null);
        this.setRootNodeState((MetadataImportNode)this._rootNode);
        this.createTree(itemsToImportList, targetFolderPath, this._rootNode);
    }

    public void populateTree(List itemsToImportList, Tree targetFolder) throws NoObjectsToImportException, MdException, RemoteException {
        List<String> targetFolderPath;
        ArrayList<String> rootNodePath;
        this._targetFolderID = targetFolder.getId();
        this.setExportState();
        if (this._exportState == 0) {
            String exportFolderName;
            String string = exportFolderName = this._exportedFolderPath == null || this._exportedFolderPath.size() == 0 ? "" : (String)this._exportedFolderPath.remove(this._exportedFolderPath.size() - 1);
            if (this._importOperation.getPackageFileVersion() < 9200 && !Names.validateOMRObjectName((String)exportFolderName, (boolean)false)) {
                exportFolderName = Names.mapNameToOMRObjectName((String)exportFolderName);
            }
            this._importingIntoSameFolder = exportFolderName.equals(targetFolder.getName());
        }
        if ((rootNodePath = new ArrayList<String>(targetFolderPath = this._importingIntoSameFolder ? BIPTreeUtil.getParentOnlyTreePath(targetFolder) : BIPTreeUtil.getParentTreePath(targetFolder))).size() > 0 && !this._importingIntoSameFolder) {
            rootNodePath.remove(rootNodePath.size() - 1);
        }
        String[] rootPath = rootNodePath.toArray(new String[rootNodePath.size()]);
        MetadataImportNode targetNode = new MetadataImportNode(targetFolder.getName(), rootPath);
        if (!this._importOperation.isPreservingPaths()) {
            this._rootNode = targetNode;
            Tree rootFolder = BIPTreeUtil.getRootFolder(targetFolder);
            this._rootFolderID = rootFolder.getId();
        } else {
            this._rootNode = new MetadataImportNode("SAS Folders", null);
            this.attachTargetFolderToRoot(this._rootNode, targetNode, rootPath);
        }
        this.setRootNodeState(targetNode);
        this.createTree(itemsToImportList, targetFolderPath, targetNode);
    }

    private void attachTargetFolderToRoot(MetadataNodeInterface rootNode, MetadataNodeInterface targetNode, String[] path) {
        MetadataNodeInterface child = rootNode;
        for (int index = 0; index < path.length; ++index) {
            String[] thisPath = new String[index];
            System.arraycopy(path, 0, thisPath, 0, index);
            String folderName = path[index];
            MetadataImportNode node = new MetadataImportNode(folderName, thisPath);
            child.addChild(node);
            child = node;
        }
        child.addChild(targetNode);
    }

    private void setRootNodeState(MetadataImportNode root) throws MdException, RemoteException {
        boolean hasWriteFolderPermission;
        int state = 4;
        if (!(this._importingIntoRoot || this._targetFolderID == null || this._importOperation.isProjectRepository() || (hasWriteFolderPermission = PromotionUtil.isFolderWriteAuthorized(this._importOperation.getMetadataFactory(), this._targetFolderID, false)))) {
            state |= 0x40;
        }
        root.setObjectState(state);
    }

    private void createTree(List itemsToImportList, List targetFolderPath, MetadataNodeInterface targetNode) throws NoObjectsToImportException, MdException, RemoteException {
        this._rootFoldersMap = BIPTreeUtil.getMapOfRootFolders(this._importOperation.getMetadataFactory());
        if (this._rootFoldersMap == null) {
            throw new MdException("Failure loading root folders");
        }
        this._dependentObjects = this._importOperation.getExportedDependentObjects();
        ArrayList topLevelObjects = new ArrayList(itemsToImportList);
        for (ImportItemInterface importItem : itemsToImportList) {
            if (!BIPTreeUtil.isFolder(importItem)) continue;
            ++this._folderCount;
            this.populateFolder(importItem, targetFolderPath, targetNode);
            topLevelObjects.remove(importItem);
        }
        for (ImportItemInterface importItem : topLevelObjects) {
            if (BIPTreeUtil.isFolder(importItem)) continue;
            this.populateFolderMember(importItem, targetFolderPath, targetNode);
        }
        if (this._importOperation.getImportType() == 1) {
            this._importOperation.getLogger().info(RB.getStringResource("MetadataImportTree.ImportingNewObjects.txt"));
            this.pruneTree(targetNode);
            if (targetNode.getChildCount() == 0) {
                throw new NoObjectsToImportException(RB.getStringResource("MetadataImportTree.NoNewObjects.txt"));
            }
        }
    }

    private boolean canFolderBeMoved(List folderPath) {
        if (this._exportState == 0) {
            return MetadataTreeUtil.arePathsEqual(folderPath, this._exportedFolderPath);
        }
        if (this._exportedFolderPaths != null) {
            for (int i = 0; i < this._exportedFolderPaths.size(); ++i) {
                List exportedFolderPath = (List)this._exportedFolderPaths.get(i);
                if (!MetadataTreeUtil.arePathsEqual(folderPath, exportedFolderPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canObjectBeMoved(List objectPath) {
        if (this._exportState == 0) {
            return !MetadataTreeUtil.isChildOf(objectPath, this._exportedFolderPath);
        }
        if (this._exportedFolderPaths != null) {
            for (int i = 0; i < this._exportedFolderPaths.size(); ++i) {
                List exportedFolderPath = (List)this._exportedFolderPaths.get(i);
                if (!MetadataTreeUtil.isChildOf(objectPath, exportedFolderPath)) continue;
                return false;
            }
        }
        return true;
    }

    private void populateFolder(ImportItemInterface importItem, List targetFolderPath, MetadataNodeInterface rootNode) throws MdException, RemoteException {
        String[] sourcePath = importItem.getSourcePath();
        List<String> relativeFolderPathList = BIPTreeUtil.pathToList(sourcePath);
        boolean preservingPaths = this._importOperation.isPreservingPaths();
        if (!preservingPaths) {
            this.cleanPath(relativeFolderPathList, true);
        }
        MetadataNodeInterface node = null;
        boolean canImport = true;
        if (this._folderCount == 1 && this._importingIntoSameFolder) {
            node = rootNode;
            String[] targetPath = node.getPath();
            ((MetadataImportNode)node).setPromotionItem(importItem, targetPath);
            ((MetadataImportNode)node).setObjectExistsOnTarget(this._targetFolderID);
        } else {
            ArrayList<String> targetPathList = new ArrayList<String>();
            targetPathList.addAll(targetFolderPath);
            targetPathList.addAll(relativeFolderPathList);
            String[] absoluteTargetPath = targetPathList.toArray(new String[targetPathList.size()]);
            MetadataNodeInterface parentNode = null;
            if (preservingPaths) {
                parentNode = this.preserveFolderPath(absoluteTargetPath, this.getRootNode());
                ArrayList<String> folderPathList = new ArrayList<String>(targetPathList);
                folderPathList.add(importItem.getName());
                if (this.canFolderBeMoved(folderPathList)) {
                    this.moveItemToFolder(importItem, 1);
                }
            } else {
                parentNode = this.getParentNodeForItem(absoluteTargetPath, relativeFolderPathList, rootNode);
                if (this.isParentRenamed(parentNode)) {
                    absoluteTargetPath = parentNode.getAbsolutePath();
                }
            }
            this.setTargetPath(importItem, absoluteTargetPath);
            if (!this.validateImportItem(importItem, parentNode)) {
                return;
            }
            node = new MetadataImportNode(importItem);
            parentNode.addChild(node);
            if (importItem.isRenamed()) {
                this.renameNodeOnly((MetadataImportNodeInterface)node, true);
            }
            ((MetadataImportNode)node).setObjectState();
            MetadataImportNodeInterface importNode = (MetadataImportNodeInterface)node;
            if (!this._overwriteExisting) {
                if (importNode.objectExistsOnTarget()) {
                    this.renameItem(importNode);
                }
            } else if (this._importOperation.getImportType() == 1) {
                boolean isNew = importNode.isObjectNew();
                if (!isNew) {
                    ((MetadataImportNode)node).setUnableToImportObject();
                } else if (!importNode.isPermissionGranted()) {
                    ((MetadataImportNode)node).setUnableToImportObject();
                    canImport = false;
                    if (importNode.isWritePermissionDenied()) {
                        String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                        this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.NoWritePermissionOnParentFolder.txt", (Object)displayType, (Object)node.getName(), (Object)BIPTreeUtil.pathToString(node.getPath())));
                    }
                }
            } else if (importNode.getPromotionItem() != null && !importNode.isPermissionGranted()) {
                ((MetadataImportNode)importNode).setUnableToImportObject();
                canImport = false;
                if (importNode.objectExistsOnTarget()) {
                    if (importNode.isReadPermissionDenied()) {
                        this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.FolderExistsNoPermission.txt", (Object)node.toString()));
                    }
                } else if (importNode.isWritePermissionDenied()) {
                    String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                    this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.NoWritePermissionOnParentFolder.txt", (Object)displayType, (Object)node.getName(), (Object)BIPTreeUtil.pathToString(node.getPath())));
                }
            }
        }
        if (node.getPromotionItem() != null && canImport) {
            this.addObjectToMap(node.getPromotionItem());
            this._nodeCache.put(node.getPromotionItem(), node);
        }
    }

    private void populateFolderMember(ImportItemInterface importItem, List targetFolderPath, MetadataNodeInterface rootNode) throws MdException, RemoteException {
        String[] sourcePath = importItem.getSourcePath();
        boolean preservingPaths = this._importOperation.isPreservingPaths();
        if (importItem.isOrphaned()) {
            if (preservingPaths) {
                String message = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.CannotPreserveOrphan.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem.getName());
                throw new IllegalStateException(message);
            }
            sourcePath = EMPTY_FOLDER_PATH;
            this.moveItemToFolder(importItem, 0);
        }
        List<String> relativeFolderPathList = BIPTreeUtil.pathToList(sourcePath);
        MetadataNodeInterface parentNode = null;
        String[] absoluteTargetPath = null;
        if (this.isDependentObject(importItem.getID())) {
            if (preservingPaths) {
                absoluteTargetPath = sourcePath;
                if (sourcePath == null || sourcePath.length == 0) {
                    absoluteTargetPath = targetFolderPath.toArray(new String[targetFolderPath.size()]);
                    parentNode = rootNode;
                } else {
                    if (!this.isMoveAllowed(importItem)) {
                        String message = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.CannotPreserve.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)BIPTreeUtil.pathToString(sourcePath, importItem.getName()));
                        throw new IllegalStateException(message);
                    }
                    parentNode = MetadataTreeUtil.findNodeByPath(absoluteTargetPath, this.getRootNode());
                    if (parentNode == null) {
                        parentNode = this.preserveFolderPath(absoluteTargetPath, this.getRootNode());
                    }
                    this.moveItemToFolder(importItem, 1);
                }
            } else {
                parentNode = rootNode;
                if (this._importingIntoSameFolder) {
                    ArrayList<String> adjustedPath = new ArrayList<String>(targetFolderPath);
                    adjustedPath.add(parentNode.getName());
                    absoluteTargetPath = adjustedPath.toArray(new String[adjustedPath.size()]);
                } else {
                    absoluteTargetPath = targetFolderPath.toArray(new String[targetFolderPath.size()]);
                }
                if (this._importingIntoRoot) {
                    this._importOperation.getLogger().error(RB.getStringResource("MetadataImportTree.DependentObjectsFound.txt"));
                }
            }
        } else {
            if (!preservingPaths) {
                this.cleanPath(relativeFolderPathList, false);
            }
            ArrayList<String> targetPathList = new ArrayList<String>();
            targetPathList.addAll(targetFolderPath);
            targetPathList.addAll(relativeFolderPathList);
            absoluteTargetPath = targetPathList.toArray(new String[targetPathList.size()]);
            if (preservingPaths) {
                parentNode = this.preserveFolderPath(absoluteTargetPath, this.getRootNode());
                if (this.canObjectBeMoved(targetPathList)) {
                    this.moveItemToFolder(importItem, 1);
                }
            } else {
                parentNode = this.getParentNodeForItem(absoluteTargetPath, relativeFolderPathList, rootNode);
                if (this.isParentRenamed(parentNode)) {
                    absoluteTargetPath = parentNode.getAbsolutePath();
                }
            }
        }
        if (this._importingIntoRoot && absoluteTargetPath.length == 0) {
            throw new IllegalStateException(RB.getStringResource("MetadataImportTree.ObjectsUnderRoot.txt"));
        }
        this.setTargetPath(importItem, absoluteTargetPath);
        if (!this.validateImportItem(importItem, parentNode)) {
            return;
        }
        MetadataImportNode node = new MetadataImportNode(importItem);
        parentNode.addChild(node);
        node.setObjectState();
        boolean includeInImport = true;
        if (this._overwriteExisting) {
            boolean permissionGranted = node.isPermissionGranted();
            if (this._importOperation.getImportType() == 1) {
                if (!node.isObjectNew() || !permissionGranted) {
                    node.setUnableToImportObject();
                    includeInImport = false;
                    if (!node.isObjectNew()) {
                        ((MetadataImportNode)parentNode).removeChild(node);
                    }
                }
            } else if (node.getPromotionItem() != null && !permissionGranted) {
                node.setUnableToImportObject();
                includeInImport = false;
                if (node.objectExistsOnTarget()) {
                    if (node.isReadPermissionDenied()) {
                        String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                        this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.ObjectExistsNoReadPermission.txt", (Object)displayType, (Object)((Object)node).toString()));
                    } else if (node.isWritePermissionDenied()) {
                        String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                        this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.ObjectExistsNoWritePermission.txt", (Object)displayType, (Object)((Object)node).toString()));
                    }
                } else if (node.isWritePermissionDenied()) {
                    String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                    this._importOperation.getLogger().warn(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.NoWritePermissionOnParentFolder.txt", (Object)displayType, (Object)node.getName(), (Object)BIPTreeUtil.pathToString(node.getPath())));
                }
            }
        } else if (node.objectExistsOnTarget()) {
            Log log = this._importOperation.getLogger();
            if (log.isDebugEnabled()) {
                String displayType = node.getPromotionItem().getTypeInterface().getDisplayType();
                log.debug(Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.RenameObject.txt", (Object)displayType, (Object)((Object)node).toString()));
            }
            this.renameItem(node);
        }
        if (node.getPromotionItem() != null && includeInImport) {
            this.addObjectToMap(node.getPromotionItem());
            this._nodeCache.put(node.getPromotionItem(), node);
        }
    }

    private void setTargetPath(ImportItemInterface importItem, String[] targetPath) {
        if (importItem instanceof DefaultImportItem) {
            ((DefaultImportItem)importItem).setTargetPath(targetPath);
        }
    }

    private boolean validateImportItem(ImportItemInterface importItem, MetadataNodeInterface parentNode) {
        boolean isValid = true;
        String objectName = importItem.getName();
        if (!Names.validateOMRObjectName((String)objectName, (boolean)false)) {
            ObjectRenameManager renameManager = ObjectRenameManager.getInstance(this._importOperation);
            String newName = Names.mapNameToOMRObjectName((String)objectName);
            renameManager.renameItem(importItem, newName);
            this.markItemForRename(importItem);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.RenameInvalidObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem, (Object)objectName);
            this._importOperation.getLogger().warn(msg);
        }
        if (!MetadataTreeUtil.isUnique(parentNode, importItem.getName(), importItem.getTypeInterface().getPublicType())) {
            if (this._duplicateNameMap == null) {
                this._duplicateNameMap = new LinkedHashMap();
            }
            importItem.setImportState(0);
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"MetadataImportTree.DuplicateNamedObject.fmt.txt", (Object)importItem.getTypeInterface().getDisplayType(), (Object)importItem);
            this._importOperation.getLogger().warn(msg);
            this._duplicateNameMap.put(importItem.getID(), importItem);
            return false;
        }
        return isValid;
    }

    private void renameItem(MetadataImportNodeInterface node) throws RemoteException, MdException {
        ImportItemInterface importItem = (ImportItemInterface)node.getPromotionItem();
        ObjectRenameManager renameManager = ObjectRenameManager.getInstance(this._importOperation);
        HashSet<String> names = new HashSet<String>();
        String type = importItem.getTypeInterface().getPublicType();
        MetadataNodeInterface parentNode = node.getParent();
        for (MetadataNodeInterface child : parentNode.getChildren()) {
            if (node == child || !type.equalsIgnoreCase(child.getType())) continue;
            names.add(child.getName());
        }
        boolean renamed = renameManager.generateNewName(importItem, names);
        if (renamed) {
            this.renameNodeOnly(node, false);
        }
    }

    private void renameNodeOnly(MetadataImportNodeInterface node, boolean setOriginalName) throws RemoteException, MdException {
        ImportItemInterface importItem = (ImportItemInterface)node.getPromotionItem();
        if (importItem != null) {
            if (setOriginalName) {
                ((MetadataImportNode)node).setOriginalName(importItem.getOriginalName());
            } else {
                node.rename(importItem.getName());
            }
            this.markItemForRename(importItem);
        }
    }

    private void markItemForRename(ImportItemInterface importItem) {
        if (this._renamedObjects == null) {
            this._renamedObjects = new ArrayList();
        }
        if (!this._renamedObjects.contains(importItem)) {
            this._renamedObjects.add(importItem);
        }
    }

    private boolean isParentRenamed(MetadataNodeInterface parentNode) {
        MetadataNodeInterface parent = parentNode;
        if (parent instanceof MetadataImportNodeInterface) {
            boolean renamed = ((MetadataImportNodeInterface)parent).isRenamed();
            if (renamed) {
                return true;
            }
            if (parent.getParent() != null && this.isParentRenamed(parent.getParent())) {
                return true;
            }
        }
        return false;
    }

    private boolean isMoveAllowed(ImportItemInterface importItem) {
        ConnectionPointInterface pt = this._importOperation.getConnectionManager().getFolderConnection(importItem);
        return pt != null;
    }

    private void moveItemToFolder(ImportItemInterface importItem, int state) {
        if (state == 1) {
            if (this._itemsToPreserveList == null) {
                this._itemsToPreserveList = new ArrayList();
            }
            this._itemsToPreserveList.add(importItem);
        } else if (state == 0) {
            if (this._itemsToMoveList == null) {
                this._itemsToMoveList = new ArrayList();
            }
            this._itemsToMoveList.add(importItem);
        }
    }

    private MetadataNodeInterface getParentNodeForItem(String[] absoluteTargetPath, List relativeFolderPathList, MetadataNodeInterface rootNode) {
        MetadataNodeInterface parentNode = null;
        if (this._importingIntoSameFolder) {
            if (absoluteTargetPath.length == 0) {
                parentNode = rootNode;
            } else {
                if (relativeFolderPathList.size() > 0) {
                    relativeFolderPathList.remove(0);
                }
                parentNode = this.getParentNode(relativeFolderPathList, rootNode);
            }
        } else {
            parentNode = relativeFolderPathList.size() == 0 ? rootNode : this.getParentNode(relativeFolderPathList, rootNode);
        }
        if (parentNode == null) {
            parentNode = rootNode;
        }
        return parentNode;
    }

    private MetadataNodeInterface getParentNode(List folderPath, MetadataNodeInterface rootNode) {
        String[] path = folderPath.toArray(new String[folderPath.size()]);
        if (this.containsRenamedObjects()) {
            return MetadataTreeUtil.findNodeByOriginalPath(path, rootNode);
        }
        return MetadataTreeUtil.findNodeByPath(path, rootNode);
    }

    private void cleanPath(List objectPath, boolean isFolder) {
        if (objectPath.size() == 0) {
            return;
        }
        if (this._exportState == 0) {
            this.cleanPath(objectPath, this._exportedFolderPath);
        } else if (this._exportState == 1) {
            boolean found = false;
            int len = this._exportedFolderPaths.size();
            for (int i = 0; i < len; ++i) {
                ArrayList path = new ArrayList((List)this._exportedFolderPaths.get(i));
                if (path.size() > 0) {
                    path.remove(path.size() - 1);
                }
                if (!MetadataTreeUtil.isChildOf(objectPath, path)) continue;
                this.cleanPath(objectPath, path);
                found = true;
                break;
            }
            if (!found && !this._exportedFromRoot) {
                objectPath.clear();
            }
        }
    }

    private void cleanPath(List objectPath, List folderPath) {
        if (folderPath == null) {
            return;
        }
        int length = folderPath.size();
        if (length > 0) {
            for (int i = 0; i < (this._importingIntoRoot && this._exportState != 1 ? length - 1 : length); ++i) {
                if (!folderPath.get(i).equals(objectPath.get(0))) {
                    return;
                }
                objectPath.remove(0);
            }
        }
    }

    private MetadataNodeInterface preserveFolderPath(String[] folderPath, MetadataNodeInterface rootNode) throws RemoteException, MdException {
        MetadataNodeInterface parentNode = rootNode;
        int length = folderPath == null ? 0 : folderPath.length;
        for (int index = 0; index < length; ++index) {
            ImportItemInterface importItem;
            String[] targetPath;
            String[] thisPath = new String[index + 1];
            System.arraycopy(folderPath, 0, thisPath, 0, index + 1);
            MetadataNodeInterface childNode = MetadataTreeUtil.findNodeByPath(thisPath, rootNode);
            if (childNode == null) {
                targetPath = new String[index];
                System.arraycopy(folderPath, 0, targetPath, 0, index);
                importItem = this.createNewPreservedFolder(folderPath[index], targetPath);
                childNode = new MetadataImportNode(importItem);
                parentNode.addChild(childNode);
                ((MetadataImportNode)childNode).setObjectState();
            } else if (childNode.getPromotionItem() == null) {
                targetPath = new String[index];
                System.arraycopy(folderPath, 0, targetPath, 0, index);
                importItem = this.createNewPreservedFolder(folderPath[index], targetPath);
                ((MetadataImportNode)childNode).setPromotionItem(importItem, targetPath);
            }
            parentNode = childNode;
        }
        return parentNode;
    }

    private ImportItemInterface createNewPreservedFolder(String folderName, String[] path) {
        String id = "PreservedFolder_" + this._preservePathFolderCount;
        ImportItemInterface importItem = this._importOperation.createImportItem(folderName, "Folder", id);
        ((DefaultPromotionItem)((Object)importItem)).setSourcePath(path);
        this.setTargetPath(importItem, path);
        return importItem;
    }

    private void setExportState() {
        List path = this._importOperation.getExportedFolderPath();
        if (path != null) {
            this._exportState = 0;
            this._exportedFolderPath = path;
            if (this._exportedFolderPath.size() == 0) {
                this._exportedFromRoot = true;
            }
        } else {
            this._exportState = 1;
            path = this._importOperation.getExportedFolderPaths();
            if (path != null) {
                this._exportedFolderPaths = path;
            } else {
                this._exportedFolderPaths = new ArrayList(0);
                if (this._importOperation.getPackageFileVersion() < 9200) {
                    this.loadExportedFoldersIn913Package();
                }
            }
        }
    }

    private void loadExportedFoldersIn913Package() {
        boolean containsSubFolder = false;
        ArrayList<List<String>> pathCache = new ArrayList<List<String>>();
        List<ImportItemInterface> folders = this._importOperation.getFoldersImporting();
        for (ImportItemInterface folder : folders) {
            String[] pathArray = folder.getSourcePath();
            List<String> pathList = BIPTreeUtil.pathToList(pathArray);
            pathList.add(folder.getName());
            boolean contains = false;
            for (List list : pathCache) {
                if (!MetadataTreeUtil.isChildOf(pathList, list)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            pathCache.add(pathList);
            if (pathArray.length <= 0) continue;
            containsSubFolder = true;
        }
        if (pathCache.size() > 0) {
            if (!containsSubFolder) {
                this._exportedFromRoot = true;
            } else {
                this._exportedFolderPaths.addAll(pathCache);
            }
        }
    }

    private void addObjectToMap(SimpleLogicalObjectInterface logicalObject) {
        String logicalType = logicalObject.getTypeInterface().getPublicType();
        ArrayList<SimpleLogicalObjectInterface> items = (ArrayList<SimpleLogicalObjectInterface>)this._selectedObjects.get(logicalType);
        if (items == null) {
            items = new ArrayList<SimpleLogicalObjectInterface>();
            this._selectedObjects.put(logicalType, items);
        }
        items.add(logicalObject);
    }

    private String getRootFolderID(String folderName) {
        if (this._rootFoldersMap == null) {
            return null;
        }
        for (Map.Entry entry : this._rootFoldersMap.entrySet()) {
            String name = (String)entry.getValue();
            if (!name.equalsIgnoreCase(folderName)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private boolean isDependentObject(String objectID) {
        return this._dependentObjects != null && this._dependentObjects.contains(objectID);
    }

    private void pruneTree(MetadataNodeInterface parentFolder) {
        if (parentFolder.getChildCount() > 0) {
            List children = parentFolder.getChildren();
            ArrayList<MetadataNodeInterface> items = null;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                boolean canRemove = false;
                MetadataNodeInterface child = (MetadataNodeInterface)iter.next();
                if (child.isFolder() && child instanceof MetadataImportNodeInterface && !((MetadataImportNodeInterface)child).isObjectNew()) {
                    this.pruneTree(child);
                    if (child.getChildCount() == 0) {
                        canRemove = true;
                    }
                }
                if (!canRemove) continue;
                if (items == null) {
                    items = new ArrayList<MetadataNodeInterface>();
                }
                items.add(child);
            }
            int size = items == null ? 0 : items.size();
            for (int i = 0; i < size; ++i) {
                parentFolder.removeChild((MetadataNodeInterface)items.get(i));
            }
        }
    }

    @SASScope
    class MetadataImportNode
    extends MetadataNode
    implements MetadataImportNodeInterface {
        private int _importState;
        private List _targetFolderMemberCache;
        private boolean _searchedFolder;
        private String _originalName;

        public MetadataImportNode(String name, String[] path) {
            super(name, path);
            this._importState = -1;
            this._searchedFolder = false;
            this._originalName = null;
        }

        public MetadataImportNode(ImportItemInterface importItem) {
            super(importItem.getName(), importItem.getTypeInterface().getPublicType(), importItem.getID());
            this._importState = -1;
            this._searchedFolder = false;
            this._originalName = null;
            this._promotionItem = importItem;
        }

        @Override
        public void rename(String newName) {
            if (!this._name.equalsIgnoreCase(newName)) {
                this.setOriginalName(this._name);
                this._name = newName;
                this.setObjectState(2);
            }
        }

        @Override
        public boolean isRenamed() {
            return this._originalName == null ? false : !this._originalName.equalsIgnoreCase(this._name);
        }

        @Override
        public String getOriginalName() {
            return this._originalName == null ? this.getName() : this._originalName;
        }

        protected void setOriginalName(String orig) {
            this._originalName = orig;
        }

        @Override
        public String[] getPath() {
            return this._promotionItem == null ? this._rootNodePath : ((ImportItemInterface)this._promotionItem).getTargetPath();
        }

        @Override
        public int getObjectState() throws MdException, RemoteException {
            if (this._importState == -1) {
                this.setObjectState();
            }
            return this._importState;
        }

        @Override
        public boolean canImportObject() {
            return this._promotionItem != null && this.isPermissionGranted();
        }

        @Override
        public boolean isPermissionGranted() {
            return !this.isReadPermissionDenied() && !this.isWritePermissionDenied();
        }

        @Override
        public boolean isReadPermissionDenied() {
            return this.isStateSet(this._importState, 24);
        }

        @Override
        public boolean isWritePermissionDenied() {
            return this.isStateSet(this._importState, 96);
        }

        @Override
        public boolean isObjectNew() {
            return this.isStateSet(this._importState, 2);
        }

        @Override
        public boolean isObjectOverwritable() {
            return this.objectExistsOnTarget() && this.isPermissionGranted();
        }

        private boolean isStateSet(int state, int stateToCheck) {
            return state != -1 && (state & stateToCheck) > 0;
        }

        @Override
        public boolean objectExistsOnTarget() {
            return this.isStateSet(this._importState, 4);
        }

        protected void setPromotionItem(ImportItemInterface importItem, String[] targetPath) {
            this._promotionItem = importItem;
            if (this._promotionItem instanceof DefaultImportItem) {
                ((DefaultImportItem)this._promotionItem).setTargetPath(targetPath);
            }
        }

        protected List getTargetFolderMemberCache() {
            return this._targetFolderMemberCache;
        }

        protected boolean getSearchedForFolder() {
            return this._searchedFolder;
        }

        protected void setObjectState(int state) {
            this._importState = state;
        }

        protected void setObjectState() throws MdException, RemoteException {
            if (this._parentNode != null && this._parentNode instanceof MetadataImportNodeInterface) {
                MetadataImportNodeInterface parent = (MetadataImportNodeInterface)this._parentNode;
                boolean isParentNew = parent.isObjectNew();
                int parentState = parent.getObjectState();
                if (isParentNew && parent.isPermissionGranted()) {
                    this._importState = 2;
                } else if (this.isStateSet(parentState, 8) || this.isStateSet(parentState, 16)) {
                    this._importState = 16;
                    if (isParentNew) {
                        this._importState |= 2;
                    }
                } else if (!this.isFolder() && this.isStateSet(parentState, 64)) {
                    this._importState = 64;
                    if (isParentNew) {
                        this._importState |= 2;
                    }
                } else {
                    this._importState = this.isFolder() ? this.getStateOfFolder() : this.getStateOfFolderMember();
                }
            }
        }

        private int getStateOfFolder() throws MdException, RemoteException {
            String rootFolderID = this.getRootFolderIDForNode();
            if (rootFolderID == null) {
                return this.getStateForNewObject();
            }
            String[] folderPath = this.getAbsolutePath();
            String reposID = this.getReposID(rootFolderID);
            String xmlSelect = BIPTreeUtil.buildXMLSelectForFolder(folderPath, rootFolderID);
            MdFactory factory = MetadataImportTree.this._importOperation.getMetadataFactory();
            Map folderMap = BIPTreeUtil.searchForFolder(factory, xmlSelect, reposID, MetadataImportTree.this._importOperation.getUserDefinedSupportedTypes(), MetadataImportTree.this._importOperation.isProjectRepository());
            if (folderMap != null) {
                String targetID = (String)folderMap.get("Id");
                this._searchedFolder = true;
                this._targetFolderMemberCache = (List)folderMap.get("Members");
                return this.getStateForExistingObject(targetID);
            }
            MdSecurityUtil securityUtil = factory.getSecurityUtil();
            int objectCount = securityUtil.getCountNoSecurity(reposID, xmlSelect, "Tree");
            return this.getStateForNewObject(objectCount);
        }

        private int getStateOfFolderMember() throws MdException, RemoteException {
            List memberList = ((MetadataImportNode)this._parentNode).getTargetFolderMemberCache();
            if (memberList != null) {
                int typeIndex = this._publicType.indexOf(46);
                String objectType = typeIndex > -1 ? this._publicType.substring(0, typeIndex) : this._publicType;
                for (Map objectMap : memberList) {
                    String name = (String)objectMap.get("Name");
                    String publicType = (String)objectMap.get("PublicType");
                    int index = publicType.indexOf(46);
                    if (index > -1) {
                        publicType = publicType.substring(0, index);
                    }
                    if (!this._name.equalsIgnoreCase(name) || !objectType.equals(publicType)) continue;
                    String targetID = (String)objectMap.get("Id");
                    return this.getStateForExistingObject(targetID);
                }
            } else {
                boolean searchedForParentFolder = ((MetadataImportNode)this._parentNode).getSearchedForFolder();
                if (searchedForParentFolder) {
                    return 2;
                }
                String rootFolderID = this.getRootFolderIDForNode();
                if (rootFolderID == null) {
                    return 2;
                }
                String[] objectPath = this.getAbsolutePath();
                String reposID = this.getReposID(rootFolderID);
                String xmlSelect = BIPTreeUtil.buildXMLSelectForObject(objectPath, this._publicType, rootFolderID);
                MdFactory factory = MetadataImportTree.this._importOperation.getMetadataFactory();
                Map objectMap = BIPTreeUtil.searchForObject(factory, xmlSelect, reposID, this._promotionItem.getTypeInterface().getMetadataType(), MetadataImportTree.this._importOperation.isProjectRepository());
                if (objectMap != null) {
                    String targetID = (String)objectMap.get("Id");
                    return this.getStateForExistingObject(targetID);
                }
            }
            return this.getStateForNewObject();
        }

        private int getStateForExistingObject(String targetID) throws MdException, RemoteException {
            this.setObjectExistsOnTarget(targetID);
            MdSecurityUtil securityUtil = MetadataImportTree.this._importOperation.getMetadataFactory().getSecurityUtil();
            if (this.isFolder()) {
                boolean hasWriteFolderPermission = securityUtil.isFolderWriteAuthorized(targetID);
                return hasWriteFolderPermission ? 4 : 68;
            }
            String metadataType = this._promotionItem.getTypeInterface().getMetadataType();
            boolean hasWritePermission = securityUtil.isWriteAuthorized(metadataType, targetID);
            return hasWritePermission ? 4 : 36;
        }

        private int getStateForNewObject() throws MdException, RemoteException {
            int objectCount = this.getCountNoSecurityForNode();
            return this.getStateForNewObject(objectCount);
        }

        private int getStateForNewObject(int objectCount) throws MdException, RemoteException {
            MetadataImportNodeInterface parent;
            if (objectCount > 0) {
                return 12;
            }
            if (this.isFolder() && this._parentNode instanceof MetadataImportNodeInterface && this.isStateSet((parent = (MetadataImportNodeInterface)this._parentNode).getObjectState(), 64)) {
                return 66;
            }
            return 2;
        }

        private int getCountNoSecurityForNode() throws MdException, RemoteException {
            return this.getCountNoSecurityForNode(this._name);
        }

        private int getCountNoSecurityForNode(String nodeName) throws MdException, RemoteException {
            if (this.getPath().length == 0) {
                String reposID = MetadataImportTree.this._importOperation.getFoundationRepositoryID();
                SoftwareComponent sc = BIPTreeUtil.getBIPService(MetadataImportTree.this._importOperation.getMetadataFactory(), MetadataImportTree.this._importOperation.getStore(), reposID);
                String xmlSelect = BIPTreeUtil.buildXMLSelectForRootFolder(nodeName, sc.getId());
                return this.getCountNoSecurityForNode(xmlSelect, reposID);
            }
            String rootFolderID = this.getRootFolderIDForNode();
            if (rootFolderID == null) {
                return 2;
            }
            String[] objectPath = this.getAbsolutePath();
            String reposID = "A0000001." + rootFolderID.substring(0, 8);
            String xmlSelect = this.isFolder() ? BIPTreeUtil.buildXMLSelectForFolder(objectPath, rootFolderID) : BIPTreeUtil.buildXMLSelectForObject(objectPath, this._publicType, rootFolderID);
            return this.getCountNoSecurityForNode(xmlSelect, reposID);
        }

        private int getCountNoSecurityForNode(String xmlSelect, String reposID) throws MdException, RemoteException {
            MdSecurityUtil securityUtil = MetadataImportTree.this._importOperation.getMetadataFactory().getSecurityUtil();
            return securityUtil.getCountNoSecurity(reposID, xmlSelect, this._promotionItem.getTypeInterface().getMetadataType());
        }

        private String getReposID(String rootFolderID) {
            return MetadataImportTree.this._importOperation.isProjectRepository() ? MetadataImportTree.this._importOperation.getRepositoryID() : "A0000001." + rootFolderID.substring(0, 8);
        }

        private String getRootFolderIDForNode() {
            if (MetadataImportTree.this._rootFolderID != null) {
                return MetadataImportTree.this._rootFolderID;
            }
            String[] path = this.getPath();
            if (path != null && path.length > 0) {
                String rootFolderName = path[0];
                return MetadataImportTree.this.getRootFolderID(rootFolderName);
            }
            return MetadataImportTree.this.getRootFolderID(this._name);
        }

        private void setObjectExistsOnTarget(String targetID) {
            if (targetID == null || !MetadataImportTree.this._overwriteExisting) {
                return;
            }
            if (this._promotionItem != null) {
                ((ImportItemInterface)this._promotionItem).setTargetID(targetID);
                ((ImportItemInterface)this._promotionItem).setImportState(this.isFolder() ? 0 : 2);
            }
        }

        private void setUnableToImportObject() {
            if (!MetadataImportTree.this._overwriteExisting) {
                return;
            }
            ((ImportItemInterface)this._promotionItem).setImportState(0);
        }
    }
}

